<?php
/**
 * @brief		4.6.6 Upgrade Code
 * @author		<a href='https://www.invisioncommunity.com'>Invision Power Services, Inc.</a>
 * @copyright	(c) Invision Power Services, Inc.
 * @license		https://www.invisioncommunity.com/legal/standards/
 * @package		Invision Community

 * @since		05 Aug 2021
 */

namespace IPS\core\setup\upg_106132;

/* To prevent PHP errors (extending class does not exist) revealing path */

use IPS\core\AdminNotification;
use function defined;

if ( !defined( '\IPS\SUITE_UNIQUE_KEY' ) )
{
	header( ( $_SERVER['SERVER_PROTOCOL'] ?? 'HTTP/1.0' ) . ' 403 Forbidden' );
	exit;
}

/**
 * 4.6.6 Upgrade Code
 */
class Upgrade
{
	/**
	 * Remove test bulletin
	 *
	 * @return	array	If returns TRUE, upgrader will proceed to next step. If it returns any other value, it will set this as the value of the 'extra' GET parameter and rerun this step (useful for loops)
	 */
	public function step1()
	{
		AdminNotification::remove( 'core', 'Bulletin', '1' );

		return TRUE;
	}
	
}