;(function($,_){"use strict";ips.controller.register('ips.core.badgepreview',{preview:undefined,badgetype:'custombadge',initialize(){this.preview=this.elem.querySelector('[data-role="preview"]')
if('badgetype'in this.elem.dataset){this.badgetype=this.elem.dataset.badgetype;}
const _debounced=_.throttle(async()=>{await this.updateImage();},200,{trailing:true});for(const id of['icon','shape','foreground','background','border','sides','rotation','number_overlay','icon_size'].map(i=>`${this.badgetype}_${i}`)){const config={attributes:true,childList:false,subtree:false}
this.getForm().querySelectorAll(`#${id} input`).forEach(element=>{if(id.endsWith('rotation')){element.oninput=()=>this.updateRotation();}else if(id.match(/_number_overlay$/)){element.oninput=()=>this.updateNumberOverlay();}else if(!id.match(/_(foreground|border|background)$/)){element.oninput=_debounced;}
const observer=new MutationObserver(mutationList=>{for(const mutationRecord of mutationList){if(mutationRecord.type==='attributes'&&['value','style'].includes(mutationRecord.attributeName)){if(id.endsWith('rotation')){this.updateRotation();}else if(id.match(/_(foreground|background|border)$/)){this.updateColor();}else if(id.match(/_number_overlay$/)){this.updateNumberOverlay();}else{_debounced();}
break}}})
observer.observe(element,config)})}},async updateImage(){let url=ipsSettings.baseURL+`/admin/?app=core&module=achievements&controller=badges&do=badgePreview`;const contents=await ips.fetch(url,{method:"POST",data:{shape:this.getShape(),icon:JSON.stringify(this.getIcon()),foreground:this.getForeground(),background:this.getBackground(),border:this.getBorder(),rotation:this.getRotation(),sides:this.getSides(),numberoverlay:this.getNumberOverlay(),iconsize:this.getIconSize()}});if(contents.querySelector('svg')){this.preview.innerHTML='';this.preview.appendChild(contents.querySelector('svg'));this.updateNumberOverlay();}},updateColor(){const foreground=this.getForeground();const background=this.getBackground();const border=this.getBorder();const svgElement=this.preview.querySelector('svg');const attrMap={foreground:['fgcolor',foreground],background:['bgcolor',background],border:['bordercolor',border]}
for(const colorField in attrMap){svgElement?.querySelectorAll(`[data-${attrMap[colorField][0]}-placeholder]`).forEach(el=>{el.dataset[attrMap[colorField][0]+"Placeholder"].split(',').forEach(attr=>{el.setAttribute(attr,attrMap[colorField][1]);});})}
svgElement?.querySelectorAll('[data-embedded-fg-color][href]').forEach(img=>{const href=img.getAttribute('href');const url=new URL(href);if(url.protocol.toLowerCase()==='data:'&&url.pathname.startsWith('image/svg+xml,')){const data=decodeURIComponent(url.pathname.split(',',2)[1]);const embeddedXML=(new DOMParser()).parseFromString(data,'text/xml');let changed=false;for(const colorField in attrMap){embeddedXML.querySelectorAll(`[data-${attrMap[colorField][0]}-placeholder]`).forEach(el=>{el.getAttribute(`data-${attrMap[colorField][0]}-placeholder`).split(",").forEach(attr=>{changed=true;el.setAttribute(attr,attrMap[colorField][1]);})});}
if(changed){const encoded=`data:image/svg+xml,${encodeURIComponent(embeddedXML.documentElement.outerHTML)}`
img.setAttribute('href',encoded);}}})},updateNumberOverlay(){const svgElement=this.preview.querySelector('svg');const numberInput=this.getNumberOverlay();if(svgElement){if(numberInput){svgElement.querySelectorAll('.svg__text_overlay').forEach(overlay=>{overlay.innerHTML=`${numberInput}`});svgElement.querySelectorAll('[data-number-overlay]').forEach(overlay=>{overlay.style.display=''})}else{svgElement.querySelectorAll('[data-number-overlay]').forEach(overlay=>{overlay.style.display='none'})}}},isSquare:false,updateRotation(){const rotation=this.getRotation();const shape=this.getShape();if(shape==='ngon'&&rotation===45&&this.getSides()===4){this.updateImage();this.isSquare=true;}else if(this.isSquare){this.updateImage();this.isSquare=false;}else{if(['ngon','star','flower'].includes(shape)){this.preview.querySelectorAll('[transform]').forEach(node=>{if(node.getAttribute('transform').includes('rotate')){node.setAttribute('transform',`rotate(${rotation})`)}})}}},getForm(){return this.elem.closest('form')},getShape(){for(const input of this.getForm().querySelectorAll(`#${this.badgetype}_shape input[type="radio"][name="${this.badgetype}_shape"]`)){if(input.checked){return input.value}}
return'circle'},getIcon(){const value=JSON.parse(this.getForm().querySelector(`input[name="${this.badgetype}_icon"]`)?.value||'null')||null;if(Array.isArray(value)&&value.length){return value[0]}
return null},getForeground(){return this.getForm().querySelector(`input[name="${this.badgetype}_foreground"]`)?.value||"#ffffff";},getBackground(){return this.getForm().querySelector(`input[name="${this.badgetype}_background"]`)?.value||"#eeb95f";},getBorder(){return this.getForm().querySelector(`input[name="${this.badgetype}_border"]`)?.value||"#f7d36f";},getSides(){return parseInt(this.getForm().querySelector(`input[name="${this.badgetype}_sides"]`)?.value||"5");},getRotation(){return parseInt(this.getForm().querySelector(`input[name="${this.badgetype}_rotation"]`)?.value||"0");},getNumberOverlay(){if(this.getForm().querySelector(`input[type="checkbox"][name="${this.badgetype}_number_overlay"][data-control="unlimited"]`)?.checked){return 0;}
const value=parseInt(this.getForm().querySelector(`input[type="number"][name="${this.badgetype}_number_overlay"]`)?.value||this.getForm().querySelector(`input[type="number"][name="${this.badgetype}_number_overlay"]`)?.dataset.previousvalue||"0");return Math.min(Math.max(0,value),999)},getIconSize(){return Math.min(5,Math.max(1,parseInt(this.getForm().querySelector(`input[name="${this.badgetype}_icon_size"][type="range"]`)?.value)||3));}})}(jQuery,_));