;(function($,_,undefined){"use strict";ips.controller.register('core.front.core.notifications',{initialize:function(){this.on(document,'menuOpened',this.menuOpened);this.on(document,'permissionDenied.notifications',this.hideNotice);this.on(document,'subscribePending.notifications',this.subscribePending);this.on(document,'subscribeSuccess.notifications',this.subscribeSuccess);this.on(document,'subscribeFail.notifications',this.subscribeFail);this.on('click','[data-action=browserNotificationPrompt]',this.requestPermission);this.on('click','[data-role=dismissNotification]',this.dismissNotification);this.on('click','[data-action="rejectPush"]',this.rejectPush);if(ips.getSetting('memberID')&&ips.utils.notification.supported&&ips.utils.serviceWorker.supported){this.setup();}},setup:function(){this._timeout=null;this._buttonText='';this._missingSubscription=false;if(ips.utils.notification.needsPermission()&&_.isUndefined(ips.utils.cookie.get('browserNotificationDismiss'))){this.scope.html(ips.templates.render('core.browserNotification.prompt')).hide();}else if(ips.utils.notification.hasPermission()&&_.isUndefined(ips.utils.cookie.get('notificationPushRejected'))){ips.utils.notification.getSubscription().then(subscription=>{if(subscription){return;}
this._missingSubscription=true;this.scope.html(ips.templates.render('core.browserNotification.missingSubscription')).hide();}).catch(err=>{Debug.log("getSubscription failed - browser may not support pushManager");Debug.log(err);return;});}},destroy:function(){clearTimeout(this._timeout);},menuOpened:function(e,data=e.detail){let date;const showPrompt=()=>{this._timeout=setTimeout(()=>{this.scope.slideDown('fast');ips.utils.cookie.unset('notificationMenuShown');},750);};if(data.elemID==='elFullNotifications'){if(this._missingSubscription){showPrompt();}else{if(ips.utils.cookie.get('notificationMenuShown')===undefined){date=parseInt(ips.utils.cookie.get('notificationMenuShown'));if(date&&Date.now()>=date){showPrompt();}}else{date=new Date();date.setDate(date.getDate()+2);ips.utils.cookie.set('notificationMenuShown',date.getTime(),true);}}}},subscribePending:function(e,data){const button=this.scope.find('[data-action="browserNotificationPrompt"]');this._buttonText=button.text();button.prop('disabled',true).text(ips.getString('notificationsEnabling'));},subscribeSuccess:function(e,data){const button=this.scope.find('[data-action="browserNotificationPrompt"]');button.prop('disabled',true).text(ips.getString('notificationsSubscribed'));},subscribeFail:function(e,data){this.scope.find('[data-action="browserNotificationPrompt"]').prop('disabled',false).text(this._buttonText);this.scope.find('[data-role="promptMessage"]').text(ips.getString('notificationsSubscribeFailed')).slideDown();},requestPermission:function(){this.scope.find('[data-role="promptMessage"]').text(ips.getString('notificationsAllowPrompt')).slideDown();$(document).trigger('requestPermission.notifications');},rejectPush:function(e){e.preventDefault();ips.utils.cookie.set('notificationPushRejected',true,true);this.hideNotice();},hideNotice:function(){this.scope.slideUp('fast');},dismissNotification:function(e){if(e){e.preventDefault();}
var date=new Date();date.setDate(date.getDate()+100);ips.utils.cookie.set('browserNotificationDismiss',true,date.toUTCString());this.scope.slideUp({duration:400,complete:function(){$(this).remove();}});}});}(jQuery,_));;
;(function($,_,undefined){"use strict";ips.controller.register('core.front.core.notificationsMenu',{initialize:function(){this.on(document,'menuOpened',this.menuOpened);},menuOpened:function(e,data){ips.utils.notification.clearBadgeCount();}});}(jQuery,_));;
;(function($,_,undefined){"use strict";ips.controller.register('core.front.core.poll',{initialize:function(){this.on('submit','form',this.submitPoll);this.on('click','[data-action="viewResults"]',this.viewResults);},viewResults:function(e){e.preventDefault();var url=$(e.currentTarget).attr('href')+'&fetchPoll=1&viewResults=1';if($(e.currentTarget).attr('data-viewResults-confirm')){var self=this;ips.ui.alert.show({type:'confirm',icon:'warn',message:ips.getString('generic_confirm'),subText:ips.getString('warn_allow_result_view'),callbacks:{ok:function(){self._viewResults(url+'&nullVote=1');}}});}else{this._viewResults(url);}},_viewResults:function(url){var self=this;self._setContentsLoading();ips.getAjax()(url).done(function(response){self.cleanContents();self.scope.html(response);$(document).trigger('contentChange',[self.scope]);});},_setContentsLoading:function(){var container=this.scope.find('[data-role="pollContents"]');var height=container.outerHeight();container.css({height:height+'px'}).html('').addClass('ipsLoading');},submitPoll:function(e){var form=$(e.currentTarget);if(form.attr('data-bypassAjax')){return}
e.preventDefault();var url=form.attr('action');var self=this;this.scope.find('button[type="submit"]').prop('disabled',true).text(ips.getString('votingNow'));if(url.match(/\?/)){url+='&';}else{url+='?';}
ips.getAjax()(url+'fetchPoll=1',{data:form.serialize(),type:'POST'}).done(function(response){self.cleanContents();self.scope.html(response);$(document).trigger('contentChange',[self.scope]);ips.ui.flashMsg.show(ips.getString('thanksForVoting'));}).fail(function(){form.attr('data-bypassAjax',true).submit();});}});}(jQuery,_));;
;(function($,_,undefined){"use strict";ips.controller.register('core.front.core.pollEditor',{initialize:function(){this.on('click','[data-action="removeChoice"]',this.removeChoice);this.on('click','[data-action="addChoice"]',this.addChoice);this.on('click','[data-action="addQuestion"]',this.addQuestion);this.on('click','[data-action="removeQuestion"]',this.removeQuestion);this.setup();},setup:function(){this._maxQuestions=this.scope.attr('data-maxQuestions');this._maxChoices=this.scope.attr('data-maxChoices');this._name=this.scope.attr('data-pollName');var pollData=ips.getSetting('pollData');if(_.isArray(pollData)&&pollData.length){for(var i=0;i<pollData.length;i++){this._buildQuestion(pollData[i],i+1);}}else if(_.isObject(pollData)&&!_.isEmpty(pollData)){for(var i in pollData){this._buildQuestion(pollData[i],i);}}else{this._addQuestion(1);this._checkQuestionButton();this._checkChoiceButton(this.scope.find('[data-questionID="1"]'));}},addQuestion:function(e){e.preventDefault();var maxQid=_.max(this.scope.find('[data-questionID]'),function(item){return parseInt($(item).attr('data-questionID'));});maxQid=parseInt($(maxQid).attr('data-questionID'));if(!_.isNumber(maxQid)||_.isNaN(maxQid)){maxQid=0;}
var questions=this.scope.find('[data-questionID]');if(questions.length>=this._maxQuestions){ips.ui.alert.show({type:'alert',icon:'warn',message:ips.getString('noMoreQuestionsMlord'),callbacks:{ok:$.noop}});return;}
this._addQuestion(maxQid+1);ips.utils.anim.go('fadeIn',this.scope.find('[data-questionID="'+(maxQid+1)+'"]'));this._checkQuestionButton();},removeQuestion:function(e){e.preventDefault();var self=this;var question=$(e.currentTarget).closest('[data-questionid]');var removeQuestion=function(){question.remove();self._checkQuestionButton();};if(question.find('[data-role="questionTitle"]').val()!==''){ips.ui.alert.show({type:'confirm',icon:'question',message:ips.getString('removeQuestionConfirm'),callbacks:{ok:removeQuestion}});}else{removeQuestion();}},addChoice:function(e){e.preventDefault();var question=$(e.currentTarget).closest('[data-questionID]');var maxCid=_.max(question.find('[data-choiceID]'),function(item){return parseInt($(item).attr('data-choiceID'));});maxCid=parseInt($(maxCid).attr('data-choiceID'));if(!_.isNumber(maxCid)||_.isNaN(maxCid)){maxCid=0;}
if(maxCid>=this._maxChoices){ips.ui.alert.show({type:'alert',icon:'warn',message:ips.getString('noMoreChoices'),callbacks:{ok:$.noop}});return;}
this._addChoice(question,maxCid+1);ips.utils.anim.go('fadeIn',question.find('[data-choiceID="'+(maxCid+1)+'"]'));this._checkChoiceButton(question);},removeChoice:function(e){e.preventDefault();var self=this;var choice=$(e.currentTarget).closest('[data-choiceID]');var question=choice.closest('[data-questionID]');if(question.find('[data-choiceID]').length<=2){ips.ui.alert.show({type:'alert',icon:'warn',message:ips.getString('cantRemoveOnlyChoice'),callbacks:{ok:$.noop}});return;}
choice.animationComplete(function(){choice.remove();_.each(question.find('[data-choiceID]'),function(item,idx){$(item).attr('data-choiceID',idx+1).find('[data-role="choiceNumber"]').text(idx+1);});self._checkChoiceButton(question);});ips.utils.anim.go('fadeOut fast',choice);},_buildQuestion:function(data,qid){var choices=[];if(_.isArray(data.choices)&&data.choices.length){for(var i=0;i<data.choices.length;i++){choices.push(this._getChoiceHTML(i+1,qid,data.choices[i].title));}}else if(_.isObject(data.choices)){for(var i in data.choices){choices.push(this._getChoiceHTML(i,qid,data.choices[i].title));}}
this.scope.find('[data-role="pollContainer"]').append(ips.templates.render('core.pollEditor.question',{pollName:this._name,multiChoice:data.multiChoice,questionID:qid,question:data.title,choices:choices.join(''),removeQuestion:!(qid===1)}));},_addQuestion:function(qid){var choices=[];choices.push(this._getChoiceHTML(1,qid));choices.push(this._getChoiceHTML(2,qid));this.scope.find('[data-role="pollContainer"]').append(ips.templates.render('core.pollEditor.question',{pollName:this._name,questionTitle:ips.getString('questionTitle',{id:qid}),questionID:qid,choices:choices.join(''),removeQuestion:!(qid===1)}));},_addChoice:function(question,cid){var html=this._getChoiceHTML(cid,question.attr('data-questionID'),'');question.find('[data-role="choices"]').append(html);},_getChoiceHTML:function(cid,qid,name){return ips.templates.render('core.pollEditor.choice',{choiceID:cid,questionID:qid,pollName:this._name,choiceTitle:name});},_checkQuestionButton:function(){var questions=this.scope.find('[data-questionID]');this.scope.find('[data-action="addQuestion"]').toggleClass('ipsButton--disabled',(questions.length>=this._maxQuestions));},_checkChoiceButton:function(questionScope){var choices=questionScope.find('[data-choiceID]');questionScope.find('[data-action="addChoice"]').toggleClass('ipsButton--disabled',(choices.length>=this._maxChoices));questionScope.find('[data-choiceID] [data-action="removeChoice"]').toggleClass('ipsButton--disabled',(choices.length===2));}});}(jQuery,_));;
;(function($,_,undefined){"use strict";ips.controller.register('core.front.core.profileCompletion',{initialize:function(){this.on('click','[data-role="dismissProfile"]',this.dismissProfile);},dismissProfile:function(e){e.preventDefault();var self=this;ips.getAjax()(ips.getSetting('baseURL')+'index.php?app=core&module=system&controller=settings&do=dismissProfile').done(function(response){self.scope.animate({opacity:"0"},'fast',function(){self.scope.hide();});});}});}(jQuery,_));;
;(function($,_,undefined){"use strict";ips.controller.register('core.front.core.reviewForm',{initialize:function(){this.on('click','[data-action="writeReview"]',this.toggleReview);},toggleReview:function(e){this.scope.find('[data-role="reviewIntro"]').attr('hidden','');this.scope.find('[data-role="reviewForm"]').removeAttr('hidden');}});}(jQuery,_));;
;(function($,_,undefined){"use strict";ips.controller.register('core.front.core.tagEditor',{_minTags:null,_maxTags:null,_count:0,_tagEditID:'',initialize:function(){this.on('click','[data-action="removeTag"]',this.removeTag);this.on(document,'tagsUpdated',this.tagsUpdated);this.setup();},setup:function(){this._tagEditID=this.scope.attr('data-tagEditID');this._minTags=this.scope.attr('data-minTags')||null;this._maxTags=this.scope.attr('data-maxTags')||null;this._setCount();this._checkMinMax();},_destroy:function(){if($('#elTagEditor_'+this._tagEditID+'_menu').length){$('#elTagEditor_'+this._tagEditID+'_menu').remove();}},tagsUpdated:function(e,data){if(data.tagEditID!==this._tagEditID){return;}
this.scope.find('.ipsTags__item:not(.ipsTags__item--edit)').remove();this.scope.prepend(data.tags);var editablePrefix=$('body').find('[data-editablePrefix]');if(editablePrefix.length){if(data.prefix){editablePrefix.html(data.prefix).removeClass('ipsHide');}else{editablePrefix.html('').addClass('ipsHide');}}else if(data.prefix.length){this.scope.prepend(data.prefix);}
this._setCount();this._checkMinMax();if(data.tagsChanged==1){ips.ui.flashMsg.show(ips.getString('tagsUpdated'));}},removeTag:function(e){e.preventDefault();var self=this;var remove=$(e.currentTarget);var url=remove.attr('href');var tagContainer=remove.closest('.ipsTags__item');var tag=tagContainer.find('.ipsTags__tag');tagContainer.fadeOut('fast');this._count--;this._checkMinMax();ips.getAjax()(url,{bypassRedirect:true}).done(function(){ips.ui.flashMsg.show(ips.getString('tagRemoved'));setTimeout(function(){tagContainer.remove();},200);}).fail(function(jqXHR,textStatus,errorThrown){tagContainer.stop().show().css({opacity:"1"});self._count++;if(jqXHR.responseJSON){ips.ui.alert.show({type:'alert',icon:'warn',message:jqXHR.responseJSON,callbacks:{}});}});},_checkMinMax:function(){var allowRemove=!(this._minTags&&this._count<=this._minTags);this.scope.find('[data-action="removeTag"]').toggle(allowRemove).end().find('.ipsTags__item--deletable').toggleClass('ipsTags__item--deletable',allowRemove);this.scope.find('.ipsTags__item--edit').toggle(!(this._maxTags&&this._count>=this._maxTags));},_setCount:function(){var prefix=this._getPrefix();var count=this.scope.find('.ipsTags__item').length;if(prefix.length&&prefix.is(':visible')){count++;}
this._count=count;},_getPrefix:function(){return $('body').find('[data-editablePrefix]');}});}(jQuery,_));;
;(function($,_,undefined){"use strict";ips.controller.register('core.front.core.tagEditorForm',{_placeholder:null,_menuID:'',_tagEditID:'',initialize:function(){this.on(document,'menuOpened',this.menuOpened);this.on(document,'menuClosed',this.menuClosed);this.on('submit','form',this.submitForm);this.setup();},setup:function(){this._menuID=this.scope.closest('i-dropdown').attr('id').replace('_menu','');this._tagEditID=this._menuID.replace('elTagEditor_','');},menuClosed:function(e,data=e.detail){if(data.elemID!==this._menuID){return;}
ips.cleanContentsOf(this.elem);this.scope.html(ips.templates.render('core.edittags.default'));this._buildPlaceholder();},menuOpened:function(e,data=e.detail){if(data.elemID!=this._menuID){return;}
var self=this;var url=$(e.target).attr('data-href');ips.getAjax()(url).done(function(response){self._setLoading(false);self.scope.html(response);$(document).trigger('contentChange',[self.scope]);}).fail(function(){window.location=url;});},submitForm:function(e){e.preventDefault();var self=this;var form=$(e.currentTarget);var autoComplete=this.scope.find('[data-ipsAutocomplete]');autoComplete.trigger('blur');setTimeout(function(){if(ips.ui.autocomplete.getObj(autoComplete).hasErrors()){e.preventDefault();return;}
self._setLoading(true);ips.getAjax()(form.attr('action'),{type:'post',data:form.serialize(),dataType:'json'}).done(function(response){self.scope.trigger('tagsUpdated',{tagEditID:self._tagEditID,tags:response.tags,prefix:response.prefix,tagsChanged:response.tagsChanged});self.scope[0].closest("[popover]")?.hidePopover();}).fail(function(jqXHR,textStatus,errorThrown){if(jqXHR.responseJSON){ips.ui.alert.show({type:'alert',icon:'warn',message:jqXHR.responseJSON,callbacks:{}});}});},500);},_setLoading:function(loading){if(loading){if(!this._placeholder){this._buildPlaceholder();}
var width=this.scope.outerWidth();var height=this.scope.outerHeight();this.scope.hide();this._placeholder.show().css({width:width+'px',height:height+'px'});}else{if(this._placeholder){this._placeholder.hide();this.scope.show();}}},_buildPlaceholder:function(){this._placeholder?.remove?.();this._placeholder=$('<div/>').addClass('ipsLoading').hide();this.scope.after(this._placeholder);}});}(jQuery,_));;
;(function($,_,undefined){"use strict";ips.controller.register('core.front.core.announcementBanner',{initialize:function(){this.setup();this.on('click','[data-role="dismissAnnouncement"]',this.dismissAnnouncement);},setup:function(){this.scope.find('[data-announcementId]').each(function(){var announcement=$(this);if(ips.utils.cookie.get('announcement_'+announcement.attr('data-announcementId'))){announcement.attr('hidden',true);}});},dismissAnnouncement:function(e){var element=$(e.target).closest('[data-announcementId]');var id=element.attr('data-announcementId');var date=new Date();date.setTime(date.getTime()+(7*86400000));ips.utils.cookie.set('announcement_'+id,true,date.toUTCString());element.slideUp({duration:400,complete:function(){$(this).remove();}});}});}(jQuery,_));;
;(function($,_,undefined){"use strict";ips.controller.register('core.front.core.articlePages',{_currentPage:1,_pages:null,_articleID:'',initialize(){this.on('paginationClicked',this.paginationClicked);this.setup();},setup(){this._articleID=this._getArticleID();this.on(window,`historychange:article-${this._articleID}`,this.stateChange);this._setupPages();},stateChange(){if(!(('article-'+this._articleID)in ips.utils.history.getState())){return;}
const state=ips.utils.history.getState(`article-${this._articleID}`)
const newPage=parseInt(state?.['page'+this._articleID]);if(!Number.isInteger(newPage)||this._pages[newPage-1]===undefined){return;}
this._pages.hide();this._currentPage=newPage;ips.utils.anim.go('fadeIn',$(this._pages[newPage-1]));this._checkButtons();},paginationClicked(e,data){if(data.originalEvent){data.originalEvent.preventDefault();data.originalEvent.stopPropagation();}
e.stopPropagation();const urlData={controller:'article-'+this._articleID};if(data.pageNo=='next'){urlData['page'+this._articleID]=this._currentPage+1;}else{urlData['page'+this._articleID]=this._currentPage-1;}
const url=this._buildURL(urlData['page'+this._articleID]);ips.utils.history.pushState(urlData,`article-${this._articleID}`,url);},_getArticleID(){if(this.scope.attr('data-articleID')){return this.scope.attr('data-articleID');}else if(this.scope.closest('[data-commentID]')){return'comment'+this.scope.closest('[data-commentID]').attr('data-commentID');}else{return this.scope.identify().attr('id');}},_buildURL(pageNo){var urlObj=ips.utils.url.getURIObject();var url=urlObj.protocol+'://'+urlObj.host+(urlObj.port?(':'+urlObj.port):'')+urlObj.path+'?';urlObj.queryKey['page'+this._articleID]=pageNo;var params=_.clone(urlObj.queryKey);if(urlObj.file=='index.php'){_.each(params,function(val,key){if(key.startsWith('/')){url+=key;delete params[key];}});url+='&';}
if(!_.isEmpty(params)){url+=$.param(params);}
return url;},_checkButtons(){const indexedPage=this._currentPage-1;this.scope.find('.ipsPagination__prev').toggle(!(indexedPage<=0));this.scope.find('.ipsPagination__next').toggle(!(indexedPage>=(this._pages.length-1)));},_setupPages(){this._pages=this.scope.find('[data-role="contentPage"]');if(this._pages.length<2){return;}
this.scope.prepend(ips.templates.render('core.pagination'));this.scope.append(ips.templates.render('core.pagination'));this._pages.hide();if(!_.isUndefined(ips.utils.url.getParam('page'+this._articleID))){this._currentPage=parseInt(ips.utils.url.getParam('page'+this._articleID));}
$(this._pages[this._currentPage-1]).show();this._checkButtons();this.scope.find('[data-role="contentPageBreak"]').hide();$(document).trigger('contentChange',[this.scope]);}});}(jQuery,_));;
;(function($,_,undefined){"use strict";ips.controller.register('core.front.core.guestTerms',{initialize:function(){this.setup();this.on('click','[data-action="dismissTerms"]',this.dismissTerms);},setup:function(){let hide=false;if(this.scope.attr('data-role')=='cookieConsentBar'&&ips.utils.cookie.get('cookie_consent')){hide=true;}
else if(this.scope.attr('data-role')=='guestTermsBar'&&ips.utils.cookie.get('guestTermsDismissed')){hide=true;}
if(this.scope.attr('data-role')=='cookieConsentBar'&&(!ips.getSetting('memberID')&&!ips.utils.cookie.get('cookie_consent_optional'))){$('#elNavTheme').hide();}
if(this.scope.attr('data-role')=='cookieConsentBar'&&!ips.utils.cookie.get('cookie_consent_optional')){$('[data-role="dismissAnnouncement"]').hide();}
this.scope.toggle(!hide);$('body').toggleClass('cWithGuestTerms',!hide);},dismissTerms:function(e){e.preventDefault();ips.utils.cookie.set('guestTermsDismissed',1);this.hideGuestBar();},hideGuestBar:function(){this.scope.toggle(false);$('body').toggleClass('cWithGuestTerms',false);}});}(jQuery,_));;
;(function($,_,undefined){"use strict";ips.controller.register('core.front.core.followForm',{initialize:function(){this.on('submit',this.submitForm);this.on('click','[data-action="unfollow"]',this.unfollow);this.on('click','[data-action="followSettings"]',this.notificationSettings);this.setup();},setup:function(){this._app=this.scope.attr('data-followApp');this._area=this.scope.attr('data-followArea');this._id=this.scope.attr('data-followID');},notificationSettings:function(e){$(this.scope.parents('.ipsHovercard')[0]).hide();},unfollow:function(e){e.preventDefault();this._doFollowAction($(e.currentTarget).attr('href'),{},true);},submitForm:function(e){e.preventDefault();this._doFollowAction(this.scope.attr('action'),this.scope.serialize(),false);},_doFollowAction:function(url,data,unfollow){var self=this;var dims=ips.utils.position.getElemDims(this.scope.parent('div'));this.scope.hide().parent('div').css({width:dims.outerWidth+'px',height:dims.outerHeight+'px'}).addClass('ipsLoading');ips.getAjax()(url,{data:data,type:'post'}).done(function(response){if(unfollow){self.trigger('followingItem',{feedID:self._area+'-'+self._id,unfollow:true});}else{self.trigger('followingItem',{feedID:self._area+'-'+self._id,notificationType:self.scope.find('[name="follow_type"]:checked').val(),anonymous:!self.scope.find('[name="follow_public_checkbox"]').is(':checked')});}
ips.ui.flashMsg.show(ips.getString('followUpdated'));}).fail(function(jqXHR,textStatus,errorThrown){window.location=url;}).always(function(){self.scope.parents('.ipsHovercard').remove();});}});}(jQuery,_));;
;(function($,_,undefined){"use strict";ips.controller.register('core.front.core.followButton',{initialize:function(){this.setup();this.on(document,'followingItem',this.followingItemChange);},setup:function(){this._app=this.scope.attr('data-followApp');this._area=this.scope.attr('data-followArea');this._id=this.scope.attr('data-followID');this._feedID=this._area+'-'+this._id;this._button=this.scope.find('[data-role="followButton"]');},followingItemChange:function(e,data){if(data.feedID===this._feedID){this._reloadButton();}},_reloadButton:function(){this._button.addClass('i-opacity_3');var self=this;var pos=ips.utils.position.getElemPosition(this._button);var dims=ips.utils.position.getElemDims(this._button);this.scope.append(ips.templates.render('core.follow.loading'));this.scope.find('.ipsLoading').css({width:dims.outerWidth+'px',height:dims.outerHeight+'px',top:"0",left:"0",position:'absolute',zIndex:ips.ui.zIndex()});ips.getAjax()(ips.getSetting('baseURL')+'index.php?app=core&module=system&controller=notifications&do=button',{data:_.extend({follow_app:this._app,follow_area:this._area,follow_id:this._id,},(this.scope.attr('data-buttonType'))?{button_type:this.scope.attr('data-buttonType')}:{},(this.scope.attr('data-buttonSize'))?{button_size:this.scope.attr('data-buttonSize')}:{})}).done(function(response){self.scope.html(response);$(document).trigger('contentChange',[self.scope]);if($('input[data-toggle-id="auto_follow_toggle"]').length){var val=self.scope.find('[data-role="followButton"]').attr('data-following');if(val=='false'&&$('input[data-toggle-id="auto_follow_toggle"]').is(':checked')){$('input[data-toggle-id="auto_follow_toggle"]').prop('checked',false).change();}else if(val=='true'&&!$('input[data-toggle-id="auto_follow_toggle"]').is(':checked')){$('input[data-toggle-id="auto_follow_toggle"]').prop('checked',true).change();}}}).fail(function(){self._button.removeClass('i-opacity_3');}).always(function(){self.scope.find('.ipsLoading').remove();});}});}(jQuery,_));;
;(function($,_,undefined){"use strict";ips.controller.register('core.front.core.dataLayer',{eventHandlers:[],propertiesHandlers:[],initialize:function(){if(this.verify()){this.on('ipsDataLayer',this.handleEvent);this.on('ipsDataLayerProperties',this.handleProperties);this.setup();Debug.log('Pushing events to the dataLayer');}},setup:function(){for(let i in IpsDataLayerEventHandlers){let handler=IpsDataLayerEventHandlers[i];if(handler instanceof Function){try{let callback=handler();if(callback instanceof Function){this.eventHandlers.push(callback);}else{Debug.error(`Invalid Handler Callback Found: Returned value of type '${typeof (callback || undefined)}', expected a callback Function!`);}}catch(e){Debug.error(e);}}}
for(let i in IpsDataLayerPropertiesHandlers){let handler=IpsDataLayerPropertiesHandlers[i];if(handler instanceof Function){try{let callback=handler();if(callback instanceof Function){this.propertiesHandlers.push(callback);}else{Debug.error(`Invalid Handler Callback Found: Returned value of type '${typeof (callback || undefined)}', expected a callback Function!`);}}catch(e){Debug.error(e);}}}
this.unsetOldUniqueKeys();setTimeout(_.bind(this.loginLogout,this),200);setTimeout(_.bind(this.handleInitialEvents,this),202);this.on('ipsDataLayerSync',this.remoteFetchEvents);this.scope.find('[data-datalayer-postfetch]').on('click',function(e){setTimeout(function(){$(e.currentTarget).trigger('ipsDataLayerSync');},1500);});},handleEvent:function(evt,event){let Events=IpsDataLayerConfig._events;let Properties=IpsDataLayerConfig._properties;let PII=IpsDataLayerConfig._pii;if(!Object.keys(Events).length||!this.eventHandlers.length){return;}
try{if(event._key&&event._properties instanceof Object){if(!Events[event._key]||!Events[event._key].enabled)return;if(event._uniquekeys&&event._uniquekeys instanceof Object){try{let same=true;let saved=ips.utils.db.get('ipsDataLayer',event._key)||{};saved.exp=saved.exp||0;event._uniquekeys.exp=event._uniquekeys.exp||(Math.floor(Date.now()/1000)+300);if((saved.exp)<=Math.floor(Date.now()/1000)){same=false;}
if(same){for(let savedKey in saved){if(savedKey==='exp'){continue;}
if(saved[savedKey]!==event._uniquekeys[savedKey]){same=false;break;}}}
if(same){saved.exp=Math.max(event._uniquekeys.exp,saved.exp);ips.utils.db.set('ipsDataLayer',event._key,saved,false);return;}
ips.utils.db.set('ipsDataLayer',event._key,event._uniquekeys,false);}catch(e){Debug.error(e);}}
let _event={'_key':Events[event._key].formatted_name,'_properties':{}};for(let propertyKey in Properties){let property=Properties[propertyKey];if(property.enabled&&!(!PII&&property.pii)){let validForEvent=false;for(let j in property.event_keys){let pattern=property.event_keys[j].replaceAll('*','.*');if(event._key.match(pattern)){validForEvent=true;break;}}
if(!validForEvent){continue;}
let formatted=property.formatted_name;let value='';if(propertyKey==='ips_key'){value=this.uniqueId();}else if(Object.keys(event._properties).includes(propertyKey)){value=event._properties[propertyKey];}else if(property.custom){value=(property.value===null||property.value===undefined)?undefined:property.value;}else if(propertyKey==='ips_time'){value=Math.floor(Date.now()/1000);}else if(IpsDataLayerContext[formatted]){value=IpsDataLayerContext[formatted];}else{value=property.default||undefined;}
if(value!==null&&value!==undefined){let types=property.type.toLowerCase().split(' ');if(types.includes('number')){try{if(!isNaN(value)){value=Number(value);}}catch(e){}}
if(typeof value==='object'&&Object.keys(value).length===0&&Object.getPrototypeOf(value)===Object.prototype&&types.includes('array')){value=[];}else if(!((types.includes('array')&&value instanceof Array)||types.includes(typeof value))){Debug.error(`Invalid Data Layer Property Type: Event property "${propertyKey}" was overridden to undefined because it could not be cast from "${typeof value}" to an allowed type`);value=undefined;}}else{value=undefined;}
_event._properties[formatted]=value;}}
Debug.log('Pushing an event to the Data Layer Event Handlers');Debug.log(_event)
for(let i in this.eventHandlers){try{this.eventHandlers[i](_event);}catch(e){Debug.error('Bad Data Layer Event Handler: An event handler failed to handle an event!');}}}}catch(e){Debug.log(e);}},handleProperties:function(evt,event){let Properties=IpsDataLayerConfig._properties;let PII=IpsDataLayerConfig._pii;if(this.propertiesHandlers.length&&event._properties instanceof Object){let properties={};for(let propertyKey in event._properties){let property=Properties[propertyKey];if(!(property||property===null)||!property.enabled||!property.page_level||(!PII&&property.pii)){continue;}
let value=event._properties[propertyKey];if(value!==null&&value!==undefined){let types=property.type.toLowerCase().split(' ');if(types.includes('number')){try{if(!isNaN(value)){value=Number(value);}}catch(e){}}
if(typeof value==='object'&&Object.keys(value).length===0&&Object.getPrototypeOf(value)===Object.prototype&&types.includes('array')){value=[];}else if(!((types.includes('array')&&value instanceof Array)||types.includes(typeof value))){Debug.error(`Invalid Data Layer Property Type: Property "${propertyKey}" was overridden to undefined because it could not be cast from "${typeof value}" to an allowed type`);value=undefined;}}else{value=undefined;}
properties[propertyKey]=value;}
if(Object.keys(properties).length){Debug.log('Pushing properties to the Data Layer Properties Handlers');Debug.log(properties);for(let i in this.propertiesHandlers){try{this.propertiesHandlers[i](properties);}catch(e){Debug.error('Bad Data Layer Properties Handler: A properties handler failed to handle a collection (object) of properties');}}}}},handleInitialEvents:function(){let self=this;IpsDataLayerEvents.forEach(function(event){self.handleEvent({},event);});},verify:function(){try{return((!window.IpsDataLayerContext&&IpsDataLayerContext)&&(!window.IpsDataLayerConfig&&IpsDataLayerConfig)&&(!window.IpsDataLayerEventHandlers&&IpsDataLayerEventHandlers)&&(!window.IpsDataLayerPropertiesHandlers&&IpsDataLayerPropertiesHandlers)&&IpsDataLayerContext instanceof Object&&IpsDataLayerEvents instanceof Array&&IpsDataLayerEventHandlers instanceof Array&&IpsDataLayerPropertiesHandlers instanceof Array&&IpsDataLayerConfig instanceof Object&&IpsDataLayerConfig._properties instanceof Object&&IpsDataLayerConfig._events instanceof Object&&IpsDataLayerConfig._pii!==undefined);}catch(e){return false;}},loginLogout:function(){let stored=ips.utils.db.get('ipsDataLayer','login')||{};if(ipsSettings.memberID){if(stored.logged_in===0){this.scope.trigger('ipsDataLayer',{_key:'account_login',_properties:{}});}
ips.utils.db.set('ipsDataLayer','login',{logged_in:1},false)}else{if(stored.logged_in===1){this.scope.trigger('ipsDataLayer',{_key:'account_logout',_properties:{}});}
ips.utils.db.set('ipsDataLayer','login',{logged_in:0},false);}},uniqueId:function(){let s=i=>{return Math.floor((1+Math.random())*Math.pow(16,i)).toString(16).substring(1);};let time=Date.now();let sec=Math.floor(time/1000);let secString=sec.toString(16);secString=secString.substring(secString.length-8);let ms=(time-(sec*1000))*1000;let msString=(ms+0x100000).toString(16).substring(1);return secString+msString+s(1)+'.'+s(4)+s(4);},unsetOldUniqueKeys:function(){let Events=IpsDataLayerConfig._events;for(let eventKey in Events){let saved=ips.utils.db.get('ipsDataLayer',eventKey)||{};if(Object.keys(saved).length){Debug.log(`Found stored unique keys for the event '${eventKey}'`);Debug.log(saved);if(!saved.exp||saved.exp<=(Date.now()/1000)){Debug.log(`Removing expired stored unique keys for the event '${eventKey}'`);ips.utils.db.set('ipsDataLayer',eventKey,0,false);}}}},remoteFetchEvents:function(){let self=this;ips.getAjax()('?app=core&module=system&controller=ajax&do=getDataLayerEvents').done(function(response){for(let i in response){self.handleEvent({},response[i]);}});},});}(jQuery,_));;
;(function($,_,undefined){"use strict";ips.controller.register('core.front.core.contentMessage',{initialize:function(){this.on('change','#check_message_is_public',this.updateEditorBorder);this.setup();},setup:function(){this.scope.find('.ipsComposeArea_editor').addClass('cContentMessageEditor');this.updateEditorBorder();},updateEditorBorder:function(){if($('#check_message_is_public').is(":checked")){this.scope.find('.ipsComposeArea_editor').removeClass('cContentMessageEditor--private').addClass('cContentMessageEditor--public');}else{this.scope.find('.ipsComposeArea_editor').removeClass('cContentMessageEditor--public').addClass('cContentMessageEditor--private');}}});}(jQuery,_));;
;(function($,_,undefined){"use strict";ips.controller.register('core.front.core.moderation',{_editTimeout:0,_editingTitle:false,initialize:function(){this.on('submit','[data-role="moderationTools"]',this.moderationSubmit);this.on('mousedown','[data-role="editableTitle"]',this.editTitleMousedown);this.on('mouseup mouseleave','[data-role="editableTitle"]',this.editTitleMouseup);this.on('click','[data-role="editableTitle"]',this.editTitleMouseclick);},editTitleMousedown:function(e){var self=this;if(e.which!==1){return;}
this._editTimeout=setTimeout(function(){self._editingTitle=true;clearTimeout(this._editTimeout);var anchor=$(e.currentTarget);anchor.hide();var inputNode=$('<input/>').attr({type:'text'}).attr('data-role','editTitleField').val(anchor.text().trim());anchor.after(inputNode);inputNode.focus();let params={do:'ajaxEditTitle'};if(anchor.attr('data-params')!==undefined){params=Object.assign({},params,JSON.parse(anchor.attr('data-params')));}
inputNode.on('blur',function(){inputNode.addClass('ipsField_loading');const oldTitle=anchor.text().trim();const newTitle=inputNode.val().trim();if(newTitle===''||newTitle===oldTitle){inputNode.remove();anchor.show();self._editingTitle=false;}
else
{params={...params,...{"newTitle":newTitle}};ips.getAjax()(anchor.attr('href'),{method:'post',data:params}).done(function(response){anchor.text(response);}).fail(function(response){ips.ui.alert.show({type:'alert',icon:'warn',message:response.responseJSON,});}).always(function(){inputNode.remove();anchor.show();self._editingTitle=false;});}});inputNode.on('keypress',function(e){if(e.keyCode==ips.ui.key.ENTER){e.stopPropagation();e.preventDefault();inputNode.blur();return false;}});inputNode.on('keydown',function(e){if(e.keyCode==ips.ui.key.ESCAPE){inputNode.remove();anchor.show();self._editingTitle=false;return false;}});},1000);},editTitleMouseup:function(e){clearTimeout(this._editTimeout);},editTitleMouseclick:function(e){if(this._editingTitle){e.preventDefault();}},moderationSubmit:function(e){if(this._editingTitle){e.preventDefault();}
var action=this.scope.find('[data-role="moderationAction"]').val();switch(action){case'delete':this._modActionDelete(e);break;case'move':this._modActionDialog(e,'move','narrow');break;case'hide':this._modActionDialog(e,'hide','narrow');break;case'split':this._modActionDialog(e,'split','wide');break;case'merge':this._modActionDialog(e,'merge','medium');break;case'tag':this._modActionDialog(e,'tag','narrow');break;case'untag':this._modActionDialog(e,'untag','narrow');break;default:$(document).trigger('moderationSubmitted');break;}},_modActionDelete:function(e){var self=this;var form=this.scope.find('[data-role="moderationTools"]');if(self._bypassDeleteCheck){return;}
e.preventDefault();let count=parseInt(this.elem.querySelector('[data-role="moderationTools"][data-ipspageaction][data-ipspageaction-selected-count]')?.dataset.ipspageactionSelectedCount);if(Number.isNaN(count)){count=(parseInt(this.scope.find('[data-role="moderation"]:checked').length)+parseInt(this.scope.find('[data-role="moderation"]:hidden').length));}
ips.ui.alert.show({type:'confirm',icon:'warn',message:(count>1)?ips.pluralize(ips.getString('delete_confirm_many'),count):ips.getString('delete_confirm'),callbacks:{ok:function(){$(document).trigger('moderationSubmitted');self._bypassDeleteCheck=true;self.scope.find('[data-role="moderationTools"]').submit();}}});},_modActionDialog:function(e,title,size){e.preventDefault();var form=this.scope.find('[data-role="moderationTools"]');var moveDialog=ips.ui.dialog.create({url:form.attr('action')+'&'+form.serialize().replace(/%5B/g,'[').replace(/%5D/g,']'),modal:true,title:ips.getString(title),forceReload:true,size:size});moveDialog.show();$(document).trigger('moderationSubmitted');}});}(jQuery,_));;