;(function($,_,undefined){"use strict";ips.createModule('ips.ui.controlStrip',function(){var respond=function(elem,options){if(!$(elem).data('_controlStrip')){$(elem).data('_controlStrip',controlStripObj(elem));}};ips.ui.registerWidget('controlStrip',ips.ui.controlStrip);return{respond:respond};});var controlStripObj=function(elem){var init=function(){elem.on('click','[data-replace], [data-remove], [data-bubble]',_remoteAction);},_remoteAction=function(e){e.preventDefault();var link=$(e.currentTarget);var url=link.attr('href');ips.getAjax()(url,{dataType:'json',showLoading:true}).done(function(response){if(link.is('[data-replace]')){_replaceButton(link,response);}else if(link.is('[data-remove]')){_removeButton(link,response);}else if(link.is('[data-bubble]')){_bubbleAction(link,response);}}).fail(function(){window.location=url;});},_bubbleAction=function(link,response){link.trigger('buttonAction',response);},_replaceButton=function(link,response){ips.ui.flashMsg.show(response);var item=link.closest('.ipsControlStrip_button, .ipsControlStrip_menuItem');var newItem=$('#'+link.attr('data-replacewith'));if(item.hasClass('ipsControlStrip_button')){item.hide();newItem.show();}else{if(!newItem.hasClass('ipsControlStrip_menuItem')){var newHTML=_getMenuItemFromButton(newItem);item.hide().after(newHTML);}else{item.hide();newItem.show();}}},_removeButton=function(link,response){ips.ui.flashMsg.show(response);var dropdown=$(elem).find('[data-dropdown]');if(link.attr('data-alsoremove')){var also=ips.utils.getIDsFromList(link.attr('data-alsoremove'));}
var toRemove=$(link).add(also||'').closest('.ipsControlStrip_button, .ipsControlStrip_menuItem');toRemove.remove();if(dropdown.length){var menu=$(dropdown.attr('id')+'_menu');if(!menu.find('.ipsControlStrip_menuItem').length){menu.remove();dropdown.remove();}}},_getMenuItemFromButton=function(button){$(button).find('[data-ipsTooltip]').removeAttr('data-ipsTooltip');return ips.templates.render('core.controlStrip.menuItem',{id:$(button).attr('id')||'',item:$(button).html()});};init();return{};};}(jQuery,_));;
;(function($,_,undefined){"use strict";ips.controller.register('textarea.customtags',{initialize:function(){this.on('click','[data-textareacustomtag]',this.insertTag);},insertTag:function(e){console.log('Inserting custom tag: '+$(e.currentTarget).attr('data-textareacustomtag'));$('#'+this.scope.data('textareaid')).focus();$('#'+this.scope.data('textareaid')).insertText($(e.currentTarget).attr('data-textareacustomtag'),$('#'+this.scope.data('textareaid')).getSelection().start,"collapseToEnd");}});}(jQuery,_));;
;(function($,_,undefined){"use strict";ips.createModule('ips.ui.matrix',function(){var defaults={manageable:true,sortable:false,squashFields:false};var respond=function(elem,options){var matrix=$(elem).data('_matrix');if(!matrix){$(elem).data('_matrix',matrixObj(elem,_.defaults(options,defaults)));}else{matrix.checkRows();}},refresh=function(elem){try{var obj=$(elem).data('_matrix');obj.checkRows();}catch(err){Debug.log("Couldn't refresh matrix "+$(elem).identify().attr('id'));}};ips.ui.registerWidget('matrix',ips.ui.matrix,['manageable','sortable','squashFields']);return{respond:respond,refresh:refresh};});var matrixObj=function(elem,options){var init=function(){_setUpEvent();if(options.manageable){_setUpManageable();}
if(options.sortable){ips.loader.get(['core/interface/jquery/jquery-ui.js']).then(function(){elem.find('tbody').sortable({handle:'.ipsTree_drag'});});}
_checkRows();},_setUpEvent=function(){elem.on('click','td, th',_clickCell);elem.on('click','td input, th input',_clickInputInCell);elem.on('click','.matrixAdd',_addRow);elem.on('click','.matrixDelete',_deleteRow);elem.on('click','[data-action="checkRow"]',_checkRow);elem.on('click','[data-action="unCheckRow"]',_unCheckRow);elem.on('change','[data-action="checkAll"]',_checkAll);elem.on('change','td input[type="checkbox"]',_checkboxChanged);elem.closest('form').on('submit',_submitForm);$(document).on('tabShown',function(){_checkRows();});},_checkboxChanged=function(e){var col=$(e.currentTarget).closest('[data-col]').attr('data-col');var colHead=elem.find('[data-checkallheader="'+col+'"]');if(_.isUndefined(col)||!elem.find('[data-checkallheader="'+col+'"]').length){return;}
var similar=elem.find('[data-col="'+col+'"] input[type="checkbox"]');colHead.prop('checked',similar.filter(':checked').length==similar.length);},_clickCell=function(e){if(!$(e.target).is('td')&&!$(e.target).is('th')){return;}
var input=$(e.currentTarget).find('input:not([type="hidden"]),select,textarea');if(input.attr('type')=='checkbox'){input.click();}else{input.focus();}},_checkRow=function(e){e.preventDefault();$(e.target).closest('tr').find('input[type="checkbox"]:not(:disabled)').prop('checked',true).trigger('change');},_unCheckRow=function(e){e.preventDefault();$(e.target).closest('tr').find('input[type="checkbox"]:not(:disabled)').prop('checked',false).trigger('change');},_checkAll=function(e){var regex='^.*\\['+$(this).attr('data-checkallheader')+'_checkbox\\]$';$(this).closest('table.ipsMatrix').find('input[type="checkbox"]:not(:disabled)').filter(function(){return $(this).attr('name').match(regex);}).prop('checked',$(this).is(':checked'));},_deleteRow=function(e){e.preventDefault();var row=$(this).closest('tr');row.closest('form').find('input[data-matrixrowid="'+row.attr('data-matrixrowid')+'"]').val(0);ips.utils.anim.go('fadeOut',row).done(function(){row.remove();_checkRows();});},_addRow=function(e){var table=elem.find('.ipsTable[data-matrixID="'+$(this).attr('data-matrixID')+'"]');var blankRow=table.find('tbody tr:not( .ipsMatrix_empty ):last-child');var newRow=blankRow.clone();newRow.insertBefore(blankRow);var index=newRow.index();newRow.find('input,textarea,select,option').each(function(){var input=$(this);if(input.attr('name')){input.attr('name',input.attr('name').replace(/_new_\[x\]/g,'_new_['+index+']')).show();}
if(input.attr('id')){input.attr('id',input.attr('id').replace(/_new__x_/g,'_new__'+index+'_'));}
if(input.attr('data-toggles')){input.attr('data-toggles',input.attr('data-toggles').replace(/_new__x_/g,'_new__'+index+'_'));}
if(input.attr('data-toggle-id')){input.attr('data-toggle-id',input.attr('data-toggle-id').replace(/_new__x_/g,'_new__'+index+'_'));}
if(input.attr('data-ipsFormData')){input.removeAttr('data-ipsFormData');}});newRow.find('#check__new__x__yesno__wrapper').remove();ips.utils.anim.go('fadeIn',newRow).done(function(){_checkRows();});$(document).trigger('contentChange',[newRow]);$('html, body').animate({scrollTop:String(newRow.offset().top)});newRow.find('input,textarea,select').first().focus();return false;},_checkRows=function(){if(elem.find('[data-matrixrowid]:visible').length>0){elem.find('.ipsMatrix_empty').addClass('ipsHide');}else{elem.find('.ipsMatrix_empty').removeClass('ipsHide');}},_clickInputInCell=function(e){e.stopPropagation();},_submitForm=function(e){elem.find('[data-matrixrowid]:hidden').find('input, select, textarea').attr('name','').prop('disabled',true);if(!options.squashFields){return;}
var formElements=elem.find('[data-matrixid] *').filter(':input:enabled:not([data-role="noMatrixSquash"])');var output=ips.utils.form.serializeAsObject(formElements);var matrixID=elem.find('[data-matrixid]').attr('data-matrixid');var newInput=$('<input />').attr('type','hidden').attr('name',matrixID+'_squashed');Debug.log("Before encoding, matrix data is:");Debug.log(output);output=JSON.stringify(output);elem.prepend(newInput.val(output));formElements.prop('disabled',true);},_setUpManageable=function(){elem.find('tr:last-child').find('input, select[required], textarea').removeAttr('required');elem.find('tbody tr:not( .ipsMatrix_empty ):last-child').hide();};init();return{init:init,checkRows:_checkRows};};}(jQuery,_));;
;(function($,_,undefined){"use strict";ips.createModule('ips.ui.statusToggle',function(){var respond=function(elem,options,e){e.preventDefault();elem=$(elem);if(elem.attr('data-loading')){return;}
var currentBadge=elem.find('[data-state]:visible');var currentState=currentBadge.attr('data-state');var url=currentBadge.attr('href');if(currentBadge.attr('data-ipsdialog')){return;}
var nextState;if(options.intermediate){nextState=(currentState=='enabled')?'intermediate':(currentState=='disabled')?'enabled':'disabled';}else{nextState=(currentState=='enabled')?'disabled':'enabled';}
var nextBadge=elem.find('[data-state="'+nextState+'"]');if(!nextBadge.length){Debug.warn("No badge found for "+nextState+" state");return;}
elem.attr('data-loading',true);currentBadge.css({opacity:"0.5"});ips.getAjax()(url,{showLoading:true}).done(function(response){currentBadge.attr('hidden','').css({opacity:"1"});nextBadge.removeAttr('hidden');elem.removeAttr('data-loading');elem.trigger('stateChanged',{status:nextState});}).fail(function(jqXHR,textStatus,errorThrown){window.location=url;});};ips.ui.registerWidget('statusToggle',ips.ui.statusToggle,['intermediate'],{lazyLoad:true,lazyEvent:'click'});return{respond:respond};});}(jQuery,_));;
;(function($,_,undefined){"use strict";ips.createModule('ips.ui.tree',function(){var defaults={openClass:'ipsTree_open',closedClass:'ipsTree_closed',searchable:false,sortable:true};var respond=function(elem,options){if(!$(elem).data('_tree')){$(elem).data('_tree',treeObj(elem,_.defaults(options,defaults)));}};ips.ui.registerWidget('tree',ips.ui.tree,['openClass','closedClass','searchable','results','url','sortable','lockParents','protectRoots']);return{respond:respond};});var treeObj=function(elem,options,e){var _timer=null;var _searchAjax=null;var _currentParentOver=null;var init=function(){if(!options.url){Debug.error("No URL provided for tree widget on "+elem.identify().attr('id'));}
elem.addClass('ipsTree_js');if(options.sortable){_makeSortable();}
elem.on('click','.ipsTree_parent:not(.ipsTree_noToggle)',_toggleRow);if(options.searchable&&$(options.searchable).length){$(options.searchable).on('keydown',_searchKeyPress).on('search',_doSearch);}},_searchKeyPress=function(e){clearTimeout(_timer);_timer=setTimeout(_doSearch,500);},_doSearch=function(){if(_searchAjax&&_searchAjax.abort){_searchAjax.abort();}
var value=$(options.searchable).val().trim();var searchPane=elem.find('[data-role="treeResults"]');var listPane=elem.find('[data-role="treeListing"]');if(!_.isEmpty(value)){listPane.hide();searchPane.show();searchPane.html(ips.templates.render('core.trees.loadingPane'));_searchAjax=ips.getAjax()(options.url+'&do=search',{data:{input:value}}).done(function(response){if(_.isEmpty(response.trim())){searchPane.html(ips.templates.render('core.trees.noRows'));}else{searchPane.html(response);$(document).trigger('contentChange',[searchPane]);}});}else{listPane.show();searchPane.hide().html('');}},_toggleRow=function(e){var target=$(e.target);var row=$(e.currentTarget);if(target.closest('.ipsTree_controls').length||target.closest('[data-ipsStatusToggle]').length){return;}
if(row.hasClass(options.openClass)){_closeRow(row);}else{_openRow(row);}},_closeRow=function(row){row.removeClass(options.openClass).addClass(options.closedClass);var realRow=row.closest('[data-role="node"]');var rowID=realRow.find('[data-nodeid]').first().attr('data-nodeid');if(realRow.find('> ol').length){ips.utils.anim.go('fadeOut fast',realRow.find('> ol'));}},_openRow=function(row){row.removeClass(options.closedClass).addClass(options.openClass);var realRow=row.closest('[data-role="node"]');var rowID=realRow.find('[data-nodeid]').first().attr('data-nodeid');realRow.attr('data-nodeid',rowID);if(_.isUndefined(rowID)){Debug.warn('No rowID for row '+realRow.identify().attr('id'));return;}
if(realRow.data('_childrenLoaded')||realRow.data('_childrenLoading')){ips.utils.anim.go('fadeInDown fast',realRow.find('> ol'));return;}
var loading=ips.templates.render('core.trees.loadingRow');var content=ips.templates.render('core.trees.childWrapper',{content:loading});realRow.data('_childrenLoading',true).append(content);ips.getAjax()(options.url+'&root='+rowID).done(function(response){const doc=(new DOMParser()).parseFromString(response,'text/html').body;[...doc.querySelectorAll(':is(ol,ul).ipsTree > li')].forEach(el=>{if(!el.querySelector(":scope > div")){Debug.warn('A tree row has no child div element, which will break the sort functionality. One has been created to prevent errors, but the backend should not create <li> tags without a <div> directly inside it.');el.remove();}});realRow.find('> ol').remove();realRow.find('> .ipsTree_row').after(doc.innerHTML);realRow.data('_childrenLoaded',true).removeData('_childrenLoading');ips.utils.anim.go('fadeInDown',realRow.find('> ol'));$(document).trigger('contentChange',[realRow]);if(options.sortable){elem.find('.ipsTree_rows > .ipsTree').nestedSortable('refresh');elem.find('.ipsTree_rows > .ipsTree').nestedSortable('refreshPositions');}}).fail(function(){window.location=options.url+'&root='+rowID;});},_checkParentStatus=function(){Debug.log('check parent status');elem.find('.ipsTree_row:not( .ipsTree_root )').each(function(){var row=$(this);if(row.hasClass('ipsTree_parent')&&!row.hasClass('ipsTree_open')){return;}
var subList=row.siblings('ol');var currentlyParent=row.is('ipsTree_parent');var hasChildren=subList.find('> li').length>0;Debug.log('sublist: ');Debug.log(subList);row.toggleClass('ipsTree_parent',hasChildren);if(hasChildren&&!currentlyParent){row.addClass('ipsTree_open');}
if(row.hasClass('ipsTree_acceptsChildren')&&!subList.length){var newRow=$('<ol/>').addClass('ipsTree ipsTree_node');row.after(newRow);}});},_makeSortable=function(){var sortableOptions={placeholder:'sortable-placeholder',handle:'.ipsTree_dragHandle',items:'[data-role="node"]',excludeRoot:true,update:function(event,ui){var url=options.url+'&do=reorder';var rootID=elem.find('.ipsTree_root').attr('data-nodeid');var data='';setTimeout(function(){_checkParentStatus();},200);let failed=false;if(rootID){url+='&root='+rootID;var dataArray=$(this).nestedSortable('toArray',{key:'ajax_order'});var outputArray=[];for(var i=0;i<dataArray.length;i++){let id=dataArray[i].item_id!==undefined?dataArray[i].item_id:dataArray[i].id;if([undefined,null,NaN].includes(id)){failed=true;break;}
outputArray.push('ajax_order['+id+']='+((dataArray[i].parent_id==null)?rootID:dataArray[i].parent_id));}
data=outputArray.join('&');}else{data=$(this).nestedSortable('serialize',{key:'ajax_order'});}
if(failed){window.location.reload();}
data=data+'&csrfKey='+ips.getSetting('csrfKey');ips.getAjax()(url,{data:data,method:'POST'}).fail(function(){window.location=url+"&"+data;});},toleranceElement:'> div',listType:'ol',isTree:true,isAllowed:function(placeholder,placeholderParent,currentItem){$('#ipsTooltip')[0].hidePopover();var parent=null;if(_.isUndefined(placeholderParent)||placeholderParent===null){parent=elem.find('> .ipsTree_root');}else{parent=placeholderParent.closest('[data-role="node"]').find('> .ipsTree_row');}
if(parent.hasClass('ipsTree_acceptsChildren')||(!parent.length&&!currentItem.find('> .ipsTree_row').hasClass('ipsTree_noRoot'))){placeholder.removeAttr('data-error');return true;}else{placeholder.attr('data-error',ips.getString('cannotDragInto'));return false;}},expand:function(event,ui){var row=$(this).find('.mjs-nestedSortable-hovering > .ipsTree_parent[data-nodeid]').first();if(!row.hasClass('ipsTree_open')){_openRow(row);}},change:function(event,ui){$(this).find('.ipsTree_draggingInto').removeClass('ipsTree_draggingInto');ui.placeholder.closest('[data-role="node"]').find('> .ipsTree_row').addClass('ipsTree_draggingInto');},start:function(event,ui){ui.placeholder.closest('[data-role="node"]').find('> .ipsTree_row').addClass('ipsTree_draggingInto');},stop:function(event,ui){$(this).find('.ipsTree_draggingInto').removeClass('ipsTree_draggingInto');}};if(options.lockParents){sortableOptions['disableParentChange']=true;}
if(options.protectRoots){sortableOptions['protectRoot']=true;}
elem.find('.ipsTree_rows > .ipsTree').nestedSortable(sortableOptions);};init();return{init:init};};}(jQuery,_));;
;(function($,_,undefined){"use strict";ips.controller.mixin('acpTable','core.global.core.table',true,function(){this._timer=null;this._searchField=null;this._curSearchValue='';this._currentValue='';this.after('initialize',function(){this.on('focus','[data-role="tableSearch"]',this.startLiveSearch);this.on('blur','[data-role="tableSearch"]',this.endLiveSearch);this.on('click','[data-action="tableSort"]',this.changeSorting);this.on('paginationClicked',this.adminPaginationClicked);this.on('menuItemSelected','#elSortMenu',this.sortByMenu);this.on('menuItemSelected','#elOrderMenu',this.orderByMenu);});this.before('setup',function(){this._searchField=this.scope.find('[data-role="tableSearch"]');this.scope.find('[data-role="tableSearch"]').removeClass('ipsHide').show();});this.around('_getUrlParams',function(origFn){return _.extend(origFn(),{quicksearch:this._getSearchValue()||''});});this.after('_updateSort',function(data){var directions='ipsTable_sortableAsc ipsTable_sortableDesc';this.scope.find('[data-role="table"] [data-action="tableSort"]').removeClass('ipsTable_sortableActive').removeAttr('aria-sort').end().find('[data-action="tableSort"][data-key="'+data.by+'"]').addClass('ipsTable_sortableActive').removeClass(directions).addClass('ipsTable_sortable'+data.order.charAt(0).toUpperCase()+data.order.slice(1)).attr('aria-sort',(data.order=='asc')?'ascending':'descending');$('#elSortMenu_menu, #elOrderMenu_menu').find('[aria-selected="true"]').removeAttr('aria-selected').end().find('[data-ipsMenuValue="'+data.by+'"], [data-ipsMenuValue="'+data.order+'"]').attr('aria-selected','true');});this.after('_handleStateChanges',function(state){if(!_.isUndefined(state.data.quicksearch)&&state.data.quicksearch!=this._urlParams.quicksearch){this._updateSearch(state.data.quicksearch);}});this.adminPaginationClicked=function(){var wrappingDialog=this.scope.closest('.ipsDialog');var elemPosition=ips.utils.position.getElemPosition(wrappingDialog.length?wrappingDialog:this.scope);$('html, body').animate({scrollTop:(elemPosition.absPos.top-60)+'px'});};this.sortByMenu=function(e,data=e.detail){data.originalEvent.preventDefault();this.updateURL({sortby:data.selectedItemID});};this.orderByMenu=function(e,data=e.detail){data.originalEvent.preventDefault();this.updateURL({sortdirection:data.selectedItemID});};this.changeSorting=function(e){e.preventDefault();var cell=$(e.currentTarget);var order='';if(cell.hasClass('ipsTable_sortableActive')){order=(cell.hasClass('ipsTable_sortableDesc'))?'asc':'desc';}else{order=(cell.hasClass('ipsTable_sortableDesc'))?'desc':'asc';}
this.updateURL({sortby:cell.attr('data-key'),sortdirection:order});};this.startLiveSearch=function(e){this._timer=setInterval(_.bind(this._checkSearchValue,this),500);};this.endLiveSearch=function(e){clearInterval(this._timer);};this._checkSearchValue=function(){var val=this._searchField.val();if(this._currentValue!=val){this.updateURL({quicksearch:val,page:1});this._currentValue=val;}};this._updateSearch=function(searchValue){this._searchField.val(searchValue);};this._updateFilter=function(newFilter){this.scope.find('[data-role="tableSortBar"] [data-action="tableFilter"] a').removeClass('ipsDataFilters__button--active').end().find('[data-action="tableFilter"][data-filter="'+newFilter+'"] a').addClass('ipsDataFilters__button--active');};this._getSortValue=function(){var sortBy=this.scope.find('[data-role="table"] thead .ipsTable_sortable.ipsTable_sortableActive');var sortOrder='desc';if(sortBy.hasClass('ipsTable_sortableAsc')){sortOrder='asc';}
return{by:sortBy.attr('data-key'),order:sortOrder};};this._getFilterValue=function(){var sortBar=this.scope.find('[data-role="tableSortBar"]');if(!sortBar.length){return'';}
return sortBar.find('.ipsDataFilters__button--active').closest('[data-filter]').attr('data-filter');};this._getSearchValue=function(){if(ips.utils.url.getParam('quicksearch')){return ips.utils.url.getParam('quicksearch');}
return this.scope.find('[data-role="tableSearch"]').val();};});}(jQuery,_));;
ips.templates.set('core.appMenu.reorder'," 	<span data-role='reorder' style='display: none'><i class='fa-solid fa-bars'></i></span>");ips.templates.set('core.controlStrip.menuItem'," 	<li class='ipsMenu_item ipsControlStrip_menuItem' role='menuitem' id='{{id}}'>		{{{item}}}	</li>");ips.templates.set('core.trees.childWrapper'," 	{{{content}}}");ips.templates.set('core.trees.loadingRow'," 	<ol class='ipsTree'><li class='ipsTree_loadingRow ipsLoading ipsLoading--tiny'>{{#lang}}loading{{/lang}}</li></ol>");ips.templates.set('core.trees.loadingPane'," 	<div class='ipsLoading' style='height: 150px'>&nbsp;</div>");ips.templates.set('core.trees.noRows'," 	<div class='i-text-align_center i-padding_3 i-color_soft'>{{#lang}}no_results{{/lang}}</div>");ips.templates.set('core.livesearch.noResults'," 	<li class='i-text-align_center i-padding_3 i-color_soft' data-role='result'>		<br><br>	</li>");ips.templates.set('languages.translateString'," 	<div class='cTranslateTable_field'>		<textarea class='ipsInput'>{{value}}</textarea>		<button type='button' href='#' data-action='saveWords' tabindex='-1' class='ipsButton ipsButton--positive ipsButton--tiny ipsButton--icon'><i class='fa-solid fa-check'></i> {{#lang}}languageSave{{/lang}}</button>	</div>");ips.templates.set('support.guideSearch'," 	<li>		<a href=\"{{link}}\" target='_blank' rel='noopener'>{{title}}</a>	</li>");ips.templates.set('support.guideSearch.noResults'," 	<li class='i-color_soft'>		{{#lang}}no_results{{/lang}}	</li>");ips.templates.set('support.ticket.supportSummary'," 	<div class='i-padding-top_3'>		{{#lang}}health_ticket_beforeproceeding{{/lang}}	</div>");;
;(function($,_,undefined){"use strict";ips.controller.register('core.admin.core.app',{initialize:function(){this.on('click','[data-clickshow]',this.clickShow);this.on('click','[data-clickhide]',this.clickHide);this.on('click','[data-clickempty]',this.clickEmpty);this.on('click','[data-delete]',this.deleteSomething);this.on('click','a[data-confirm]',this.confirmSomething);this.on('click','[data-doajax]',this.doAjaxAction);this.on(document,'contentChange',this._checkAndClearAutosave);this.setup();},setup:function(){if(ips.utils.serviceWorker.supported){ips.utils.serviceWorker.registerServiceWorker('admin',false);}
this._checkAndClearAutosave();if(!ips.getSetting('memberID')&&ips.utils.url.getParam('_fromLogout')){ips.utils.db.removeByType('editorSave');}},_checkAndClearAutosave:function(){if(ips.utils.cookie.get('clearAutosave')){var autoSaveKeysToClear=ips.utils.cookie.get('clearAutosave').split(',');for(var i=0;i<autoSaveKeysToClear.length;i++){ips.utils.db.remove('editorSave',autoSaveKeysToClear[i]);}
ips.utils.cookie.unset('clearAutosave');}},doAjaxAction:function(e){e.preventDefault();ips.getAjax()($(e.currentTarget).attr('href'),{dataType:'json'}).done(function(response){ips.ui.flashMsg.show(response);}).fail(function(jqXHR){if(Debug.isEnabled()){Debug.error(jqXHR.responseText);}else{window.location=$(e.currentTarget).attr('href');}});},deleteSomething:function(e){e.preventDefault();var elem=$(e.currentTarget);var deleteTitle=elem.attr('data-delete-message');var extraWarning=elem.attr('data-delete-warning');ips.ui.alert.show({type:'confirm',icon:'warn',message:deleteTitle||ips.getString('delete_confirm'),subText:extraWarning||'',focus:'cancel',callbacks:{ok:function(){if(elem.attr('data-noajax')!==undefined){window.location=elem.attr('href')+'&csrfKey='+ips.getSetting('csrfKey')+'&wasConfirmed=1';return;}
var row=null;if(elem.attr('data-deleterow')){row=$(elem.attr('data-deleterow'));}else{row=elem.closest('tr, .row, [data-role=node]');}
let bypassRedirect=!(elem.attr('data-accept-redirect'));ips.getAjax()(elem.attr('href'),{showLoading:true,bypassRedirect:bypassRedirect,data:{form_submitted:1,wasConfirmed:1}}).done(function(response){if(row.hasClass('parent')){row.next().remove();}
ips.utils.anim.go('fadeOut',row);}).fail(function(){window.location=elem.attr('href')+'&csrfKey='+ips.getSetting('csrfKey')+'&wasConfirmed=1';});}}});},confirmSomething:function(e){e.preventDefault();var elem=$(e.currentTarget);var customMessage=$(e.currentTarget).attr('data-confirmMessage');var customSubMessage=$(e.currentTarget).attr('data-confirmSubMessage');var type=$(e.currentTarget).attr('data-confirmType');var icon=$(e.currentTarget).attr('data-confirmIcon');var alert={type:(type)?type:'confirm',icon:(icon)?icon:'warn',message:(customMessage)?customMessage:ips.getString('generic_confirm'),subText:(customSubMessage)?customSubMessage:'',callbacks:{ok:function(){window.location=elem.attr('href')+'&wasConfirmed=1';},yes:function(){window.location=elem.attr('href')+'&prompt=1';},no:function(){window.location=elem.attr('href')+'&prompt=0';}}};if($(e.currentTarget).attr('data-confirmButtons')){alert.buttons=$.parseJSON($(e.currentTarget).attr('data-confirmButtons'));}
ips.ui.alert.show(alert);},clickShow:function(e){e.preventDefault();var elems=ips.utils.getIDsFromList($(e.currentTarget).attr('data-clickshow'));this.scope.find(elems).show().removeClass('ipsHide');},clickHide:function(e){e.preventDefault();var elems=ips.utils.getIDsFromList($(e.currentTarget).attr('data-clickhide'));this.scope.find(elems).hide().addClass('ipsHide');},clickEmpty:function(e){e.preventDefault();var elems=ips.utils.getIDsFromList($(e.currentTarget).attr('data-clickempty'));this.scope.find(elems).val('');}});}(jQuery,_));;
;(function($,_,undefined){"use strict";ips.controller.register('core.admin.core.dynamicChart',{storedValues:{},identifier:'',type:'',initialize:function(){this.on('click','[data-timescale]',this.changeTimescale);this.on(document,'submit','[data-role="dateForm"]',this.changeDateRange);document.addEventListener('ips:stats.setDateFilters',e=>this.globalDateRangeSet(e));this.on(document,'click','[data-role="clearSearchTerm"]',this.resetSearch);this.on(document,'submit','[data-role="searchForm"]',this.changeSearch);this.on('menuItemSelected','[data-action="chartFilter"]',this.changeFilter);this.on('click','[data-type]',this.changeChartType);this.on('click','[data-role="filterMenu"] [data-role="selectAll"]',this.selectAllFilters);this.on('click','[data-role="filterMenu"] [data-role="unselectAll"]',this.unselectAllFilters);this.on('click','[data-role="saveReport"]',_.bind(this.saveFilters,this));this.on('click','[data-role="renameChart"]',_.bind(this.renameFilters,this));this.setup();},selectAllFilters:function(e){$(e.currentTarget).closest('i-dropdown').find('[data-ipsMenuValue]:not([aria-selected="true"])').each(function(){this.click();});},unselectAllFilters:function(e){$(e.currentTarget).closest('i-dropdown').find('[data-ipsMenuValue][aria-selected="true"]').each(function(){this.click();});},setup:function(){var self=this;this.identifier=this.scope.attr('data-chart-identifier');this.storedValues.timescale=this.scope.find('[data-timescale][data-selected]').attr('data-timescale');this.storedValues.type=this.scope.find('[data-type][data-selected]').attr('data-type');if(this.scope.find('[data-role="searchForm"] input')){this.storedValues.term=null;}
this.storedValues.filters=[];this.storedValues.dates={start:'',end:''};this.type=this.scope.attr('data-chart-type');this.timescale=this.scope.attr('data-chart-timescale');$('#el'+this.identifier+'Filter_menu').find('[aria-selected="true"]').each(function(){self.storedValues.filters.push($(this).attr('data-ipsMenuValue'));});this.checkType();const url=new URL(window.location.href);const action=new URL(this.elem.dataset.chartUrl,window.location.href);if(parseInt(url.searchParams.get('highlight'))&&url.searchParams.get('highlight')===action.searchParams.get('chartId')){this.pulse();ips.utils.history.replaceState(window.history.state?._current?.[window.history.state?._lastKey]||{},window.history.state?._lastKey||"",url.updateSearchParams({params:{highlight:null}}).toString());}},pulse(){setTimeout(()=>{requestAnimationFrame(()=>{this.elem.animate([{boxShadow:"0 0 0px 0px color-mix(in srgb-linear, var(--i-primary) 50%, transparent)",offset:0},{boxShadow:"0 0 4px 4px color-mix(in srgb-linear, var(--i-primary) 50%, transparent)",offset:0.15},{boxShadow:"0 0 4px 4px color-mix(in srgb-linear, var(--i-primary) 50%, transparent)",offset:0.85},{boxShadow:"0 0 0px 0px color-mix(in srgb-linear, var(--i-primary) 50%, transparent)",offset:1},],4000);});},1000);},changeTimescale:function(e){this.timescale=$(e.currentTarget).attr('data-timescale');this._toggleButtonRow(e,'timescale');},changeChartType:function(e){this.type=$(e.currentTarget).attr('data-type');this._toggleButtonRow(e,'type');this.checkType();},checkType:function(){if(this.type=='Table'||this.type=='PieChart'||this.type=='GeoChart'){$(this.scope).find('[data-role="groupingButtons"] a.ipsButton').addClass('ipsButton--disabled');}else{$(this.scope).find('[data-role="groupingButtons"] a.ipsButton').removeClass('ipsButton--disabled');}},updateUrlBound:false,changeFilter:function(e,data=e.detail){data.originalEvent.preventDefault();this._resetFilters();if(this.updateUrlBound===false){$('[data-action="chartFilter"]').one('menuClosed',_.bind(this.fetchNewResults,this));this.updateUrlBound=true;}},fetchNewResults:function(e){this._updateURL();this.updateUrlBound=false;},saveFilters:function(event){var identifier=this.scope.closest('.ipsTabs__panel').closest('section').attr('id');var self=this;var pieces=[];_.each(this.storedValues.filters,function(value,idx){pieces.push("chartFilters["+idx+"]="+value);});$('#el'+this.identifier+'CustomFiltersForm input[data-role="nodeValue"]').each(function(){pieces.push('customform_'+$(this).attr('name')+"="+$(this).val());});$('#el'+this.identifier+'CustomFiltersForm select').each(function(){pieces.push('customform_'+$(this).attr('name')+'='+$(this).val());})
var newFilters=pieces.join('&');if(this.timescale){newFilters=newFilters+"&timescale="+this.timescale;}
if(!$(event.currentTarget).attr('data-chartId')){this._skipUpdate=true;$('#el'+this.identifier+'FilterSave_menu').one('submit','form',function(e){if($(this).attr('data-bypassValidation')){return false;}
$(this)[0].closest("[popover]")?.hidePopover();var tabTitle=$(this).find('[name="custom_chart_title"]').val();e.preventDefault();ips.getAjax()($(this).attr('action'),{data:$(this).serialize()+'&'+newFilters,type:'post'}).done(function(response,status,jqXHR){if(response.reportURL){window.location.href=response.reportURL;return;}
$('[data-ipsTabBar-contentArea="#'+identifier+'"]').find('[role="tablist"]').append("<a href='"+response.tabHref+"' id='ipsTabs_"+response.tabId+"_"+response.chartId+"' class='ipsTabs__tab' title='"+tabTitle+"' role='tab' aria-controls='ipsTabs_"+response.tabId+"_"+response.chartId+"_panel' aria-selected='false'>"+tabTitle+"</a>");$('#'+identifier).append("<div id='ipsTabs_"+response.tabId+"_"+response.chartId+"_panel' class='ipsTabs__panel' role'tabpanel' aria-labelledby='ipsTabs_"+response.tabId+"_"+response.chartId+"' hidden></div>");self._skipUpdate=false;$(document).trigger('contentChange',[self.scope]);$('#el'+self.identifier+'FilterSave_menu').find('[name="custom_chart_title"]').val('');$('#'+response.tabId+"_"+response.chartId).click();ips.ui.flashMsg.show(ips.getString('saved'));}).fail(function(){$(this).attr('data-bypassValidation',true).submit();});});}
else
{ips.getAjax()(this.scope.attr('data-chart-url')+'&saveFilters=1&chartId='+$(event.currentTarget).attr('data-chartId'),{data:newFilters,type:'post'});this._updateURL();ips.ui.flashMsg.show(ips.getString('saved'));}},renameFilters(){const identifier=this.scope.closest('.ipsTabs__panel').closest('section').attr('id');const titlefield=()=>identifier?$(`[data-ipsTabBar-contentArea="#${identifier}"] [role="tablist"] [aria-selected="true"]`):this.scope.find('.ipsTitle');$('#el'+this.identifier+'FilterRename_menu').on('submit','form',async function(e){if($(this).attr('data-bypassValidation')){return false;}
e.preventDefault();$(this)[0].closest("[popover]")?.hidePopover();try{const{title}=await ips.fetch($(this).attr('action'),{data:$(this).serialize(),type:'post'});titlefield().text(title);}catch(e){Debug.error(e)
$(this).attr('data-bypassValidation',true).submit();}});},changeSearch:function(e){e.preventDefault();var form=$('#el'+this.identifier+'Search_menu');this.storedValues.term=form.find('[name="search"]').val();this.scope.find('[data-role="searchSummary"]').text(this.storedValues.term);form.find('[data-role="clearSearchTerm"]').prop('hidden',!this.storedValues.term);form[0].closest("[popover]")?.hidePopover();this._updateURL();},resetSearch:function(e){$('#el'+this.identifier+'Search_menu').find('[name="search"]').val('');},changeDateRange:function(e){const identifier=this.elem.querySelector('[data-action="chartDate"]')?.id;if(identifier&&!e.target?.closest(`#${identifier}_menu`)){return;}
e.preventDefault();var form=$('#el'+this.identifier+'Date_menu');this.storedValues.dates.start=form.find('[name="start"]').val();this.storedValues.dates.end=form.find('[name="end"]').val();form[0].closest("[popover]")?.hidePopover();if(this.storedValues.dates.start&&this.storedValues.dates.end){this.scope.find('[data-role="dateSummary"]').text('('+ips.getString('betweenXandX',{start:ips.utils.time.localeDateString(ips.utils.time.removeTimezone(new Date(this.storedValues.dates.start))),end:ips.utils.time.localeDateString(ips.utils.time.removeTimezone(new Date(this.storedValues.dates.end)))})+')');}
else if(this.storedValues.dates.start){this.scope.find('[data-role="dateSummary"]').text('('+ips.getString('afterX',{start:ips.utils.time.localeDateString(ips.utils.time.removeTimezone(new Date(this.storedValues.dates.start)))})+')');}
else if(this.storedValues.dates.end){this.scope.find('[data-role="dateSummary"]').text('('+ips.getString('beforeX',{end:ips.utils.time.localeDateString(ips.utils.time.removeTimezone(new Date(this.storedValues.dates.end)))})+')');}
else
{this.scope.find('[data-role="dateSummary"]').text('');}
this._updateURL();},globalDateRangeSet(e){let{start,end,range}=e?.detail?.dateFilters||{};if(!start&&!end&&!range){return;}
if(range){const days=parseInt(range);if(Number.isNaN(days)){throw new RangeError(`Expected range to be an integer representing a number of days`);}else if(days>=0){end=Math.round(Date.now()/1000);start=days>0?end-(86400*days):0;}}
if(typeof start==='string'){start=Math.round((new Date(start)).getTime()/1000);}
if(typeof end==='string'){end=Math.round((new Date(end)).getTime()/1000);}
if(Number.isNaN(start)||Number.isNaN(end)){throw new RangeError(`Could not determine either the start or end of the interval`);}
this.storedValues.dates.start=start;this.storedValues.dates.end=end;this.storedValues.dates.range=range;this._updateURL();},_toggleButtonRow:function(e,type){e.preventDefault();var val=$(e.currentTarget).attr('data-'+type);this.scope.find('[data-'+type+']').removeClass('ipsButton--active').removeAttr('data-selected').filter('[data-'+type+'="'+val+'"]').addClass('ipsButton--active').attr('data-selected',true);this.storedValues[type]=val;this._resetFilters();this._updateURL();},_resetFilters:function(){var self=this;this.storedValues.filters=[];$('#el'+this.identifier+'Filter_menu').find('[aria-selected="true"]').each(function(){self.storedValues.filters.push($(this).attr('data-ipsMenuValue'));});},_skipUpdate:false,_updateURL:function(){if(this._skipUpdate===true){this._skipUpdate=false;return;}
var url=this._buildURL();var chartArea=this.scope.find('[data-role="chart"]');chartArea.css('height',chartArea.height()).html('').addClass('ipsLoading');ips.getAjax()(this.scope.attr('data-chart-url'),{data:url,type:'post'}).done(function(response){chartArea.css('height','auto').html(response);$(document).trigger('contentChange',[chartArea]);}).always(function(){chartArea.removeClass('ipsLoading');});this.scope.find('[data-role="downloadChart"]').attr('href',this.scope.attr('data-chart-url')+'&'+url+'&download=1');},_buildURL:function(){const params=new URLSearchParams();params.set('noheader','1');params.set(`timescale[${this.identifier}]`,this.storedValues.timescale);if('type'in this.storedValues){params.set(`type[${this.identifier}]`,this.storedValues.type);}
if(this.storedValues.term!==undefined&&this.storedValues.term!==null){params.set(`search[${this.identifier}]`,this.storedValues.term);}
if(this.storedValues.filters&&Symbol.iterator in this.storedValues.filters){let idx=0;for(const value of this.storedValues.filters){params.set(`filters[${this.identifier}][${idx++}]`,value);}}
if(this.storedValues.dates.start||this.storedValues.dates.end){params.set(`start[${this.identifier}]`,this.storedValues.dates.start);params.set(`end[${this.identifier}]`,this.storedValues.dates.end);}
if(document.body.dataset.pagecontroller==='mycharts'&&document.body.dataset.pageapp==='core'&&document.body.dataset.pagemodule==='overview'){if(this.storedValues.dates.range){params.set('predate',this.storedValues.dates.range);}
if((!this.storedValues.dates.range||parseInt(this.storedValues.dates.range)===-1)&&(this.storedValues.dates.start||this.storedValues.dates.end)){params.delete('predate');params.set('date[start]',this.storedValues.dates.start||null);params.set('date[end]',this.storedValues.dates.end||null);}}
$('#el'+this.identifier+'CustomFiltersForm input[data-role="nodeValue"]').each(function(){params.set('customform_'+$(this).attr('name'),$(this).val());});$('#el'+this.identifier+'CustomFiltersForm select').each(function(){params.set('customform_'+$(this).attr('name'),$(this).val());});return params.toString();}});}(jQuery,_));;
;(function($,_){"use strict";ips.controller.register('core.admin.core.editorRestrictions',{_restrictions:[],_restrictionDefaults:{},initialize(){if(!this._getHeader()||!this._getTextarea()){return;}
this.hideRealElements();document.dispatchEvent(new CustomEvent('ips:editorBeforeInit',{detail:{textarea:null,elem:null,content:"",options:{}},bubbles:true,}));ips.ui.editorv5.getExtensionRestrictions(true).then(restrictions=>this.addFormElements(restrictions));this.elem.addEventListener('input',e=>this.updateTextarea(e));},hideRealElements(){this._getHeader()?.setAttribute('hidden','');this._getTextarea()?.closest('.ipsFieldRow')?.setAttribute('hidden','');},_getHeader(){return this.elem.querySelector("#form_header_editor_extensions");},_getTextarea(){return this.elem.querySelector("textarea#el_editor_extension_restrictions_input, #el_editor_extension_restrictions_input textarea");},async addFormElements(restrictions){this._restrictions=restrictions.map(r=>r[0]);this._restrictionDefaults=Object.fromEntries(restrictions);if(!restrictions.length){return;}
try{const content=await ips.fetch("/admin/?app=core&module=settings&controller=posting&do=getRestrictionInput",{data:{restrictionKey:this._restrictions.join(','),restrictionDefault:JSON.stringify(Object.fromEntries(restrictions)),restrictionLang:JSON.stringify(this._restrictions.map(restriction=>ips.getString(restriction))),restrictionDesc:JSON.stringify(this._restrictions.map(restriction=>ips.haveString(restriction+':description')?ips.getString(restriction+":description"):""))}});if(!content?.content||typeof content.content!=='string'){throw new TypeError(`content.content is not a string or is an empty string, so it cannot be added to the form`);}
this._getHeader().removeAttribute('hidden');const clean=(new DOMParser()).parseFromString(content.content,'text/html').body;let lastNode=this._getHeader();clean.querySelectorAll(':scope > *').forEach(node=>{lastNode.after(node);lastNode=node;})}catch(e){Debug.error(e);}},updateTextarea(e){const name=e.target.getAttribute('name');if(!name?.match(/^ipsCustom(?:Node|Mark|Extension)__/)){return}
const restrictionSetting=JSON.parse(this._getTextarea().innerText||'{}');restrictionSetting.removed=restrictionSetting.removed||[]
let value=parseInt(e.target.value);if([-1,0,1,2].includes(this._restrictionDefaults[name])&&this._restrictionDefaults[name]===value){restrictionSetting.removed.push(name);value=Number.NaN;}else if([0,1,2,-1].includes(value)&&!(value.toString()in restrictionSetting)){restrictionSetting[value.toString()]=[name];}
for(const level in restrictionSetting){if(level==='removed'){continue;}
if(parseInt(level)===value&&!Number.isNaN(value)){if(!restrictionSetting[level].includes(name)){restrictionSetting[level].push(name)}}else if(restrictionSetting[level].includes(name)){restrictionSetting[level]=restrictionSetting[level].filter(restriction=>restriction!==name);}
restrictionSetting[level]=restrictionSetting[level].filter(restriction=>{if(restriction.match(/^ipsCustom(Node|Mark|Extension)__/)&&!this._restrictions.includes(restriction)){if(!restrictionSetting.removed.includes(restriction)){restrictionSetting.removed.push(restriction)}
return false;}
return true;})}
this._getTextarea().innerText=JSON.stringify(restrictionSetting);this._getTextarea().setAttribute('value',this._getTextarea().innerText);}});}(jQuery,_));;
;(function($,_,undefined){"use strict";ips.controller.register('core.admin.core.genericDialog',{initialize:function(){this.on('submit','form',this.submitAjaxForm);$(document).on('multipleRedirectFinished',_.bind(this.dismissDialog,this));},submitAjaxForm:function(e){if($(e.currentTarget).attr('data-bypassValidation')){return;}
e.preventDefault();var dialog=this.scope.closest('.ipsDialog');if(!dialog.length){return;}
var elemId=dialog.attr('id').replace(/_dialog$/,'');var dialogObj=ips.ui.dialog.getObj($('#'+elemId));if(!dialogObj){return;}
dialogObj.setLoading(true);ips.getAjax()($(e.currentTarget).attr('action')+'&ajaxValidate=1',{data:$(e.currentTarget).serialize(),type:'post'}).done(function(response,textStatus,jqXHR){if(jqXHR.getAllResponseHeaders().indexOf('X-IPS-FormError: true')!==-1||jqXHR.getAllResponseHeaders().indexOf('x-ips-formerror: true')!==-1){dialogObj.updateContent(jqXHR.responseText);$(document).trigger('contentChange',[$('#'+elemId)]);dialogObj.setLoading(false);}else if(jqXHR.getAllResponseHeaders().indexOf('X-IPS-FormNoSubmit: true')!==-1||jqXHR.getAllResponseHeaders().indexOf('x-ips-formnosubmit: true')!==-1){dialogObj.updateContent(jqXHR.responseText);$(document).trigger('contentChange',[$('#'+elemId)]);dialogObj.setLoading(false);}else{$(e.currentTarget).attr('data-bypassValidation',true).submit();}}).fail(function(jqXHR,textStatus,errorThrown){if(Debug.isEnabled()){Debug.error("Ajax request failed ("+status+"): "+errorThrown);Debug.error(jqXHR.responseText);}else{$(e.currentTarget).attr('data-bypassValidation',true).submit();}});},dismissDialog:function(e){var elemId=$('.ipsDialog').attr('id').replace(/_dialog$/,'');var dialogObj=ips.ui.dialog.getObj($('#'+elemId));dialogObj.hide();$('#'+elemId).data('_dialog','')}});}(jQuery,_));;
;(function($,_,undefined){"use strict";ips.controller.register('core.admin.core.liveSearch',{_textField:null,_searchMenu:null,_resultsContainer:null,_lastValue:'',_results:{},_modal:null,_activePanel:null,_ajax:{},_defaultTab:null,initialize:function(){this.setup();this.on(document,'click','.ipsModal',this.clickModal);this.on(document,'click','[data-role="closeLiveSearch"]',this.clickCloseButton);this.on('itemClicked.sideMenu',this.changeSection);},setup:function(){this._searchMenu=this.scope.find('[data-role="searchMenu"]');this._resultsContainer=this.scope.find('[data-role="searchResults"]');this._defaultTab=this.scope.find('[data-role="defaultTab"]').attr('data-ipsMenuValue');this._textField=$('#acpSearchKeyword');this._textField.prop('autocomplete','off').prop('spellcheck',false).attr('aria-autocomplete','list').attr('aria-haspopup','true');this._activePanel=this._searchMenu.find('.ipsSideMenu_itemActive').attr('data-ipsMenuValue');this._textField.on('input',()=>this.refresh());},changeSection:function(e,data){this._activePanel=data.selectedItemID;this._showResultsInPanel(this._activePanel,this._results[this._activePanel]);},clickModal:function(e){if(this._modal==null||$(e.currentTarget).attr('id')!=this._modal.attr('id')){return;}
this._hideResults();},clickCloseButton:function(e){this._hideResults();},refresh:function(){var currentValue=this._textField.val().trim();if(currentValue===this._lastValue||this._textField.val().trim().length<3){return;}
this._lastValue=currentValue;this._showResults();this._showLoading();this._loadResults();},_hideResults:function(){ips.utils.anim.go('fadeOut fast',this._modal);ips.utils.anim.go('fadeOut',this.scope);},_showResults:function(){if(!this._modal){this._buildModal();}
this._modal.css({zIndex:ips.ui.zIndex()});$('#ipsLayout_header').css({zIndex:ips.ui.zIndex()});this.scope.css({zIndex:ips.ui.zIndex()});if(!this.scope.is(':visible')){ips.utils.anim.go('fadeIn fast',this.scope);}
if(!this._modal.is(':visible')){ips.utils.anim.go('fadeIn fast',this._modal);}},_showLoading(){var self=this;this.scope.find('[data-ipsMenuValue] [data-role="resultCount"]').addClass('ipsLoading').html('&nbsp;');this.scope.find('[data-ipsMenuValue] [data-role="resultCount"]').removeClass('ipsLoading_dark ipsSideMenu_clearCount');this.scope.find('[data-ipsMenuValue].ipsSideMenu_itemActive [data-role="resultCount"]').addClass('ipsLoading_dark ipsSideMenu_clearCount');this.scope.find('[data-ipsMenuValue]').each(function(){const key=$(this).attr('data-ipsMenuValue');self._setPanelToLoading(key);});},_loadResults:_.debounce(function(){var self=this;if(_.size(this._ajax)){_.each(this._ajax,function(ajax){try{if(_.isFunction(ajax.abort)){ajax.abort();Debug.log('aborted ajax');}}catch(err){}});}
this.scope.find('[data-ipsMenuValue] [data-role="resultCount"]').addClass('ipsLoading').html('&nbsp;');var value=this._lastValue.trim();this.scope.find('[data-ipsMenuValue]').each(function(){var tab=this;var key=$(this).attr('data-ipsMenuValue');self._ajax[key]=ips.getAjax()('?app=core&module=system&controller=livesearch',{dataType:'json',data:{search_key:key,search_term:encodeURIComponent(value)}}).done(function(response){self._results[key]=response;$(tab).find('[data-role="resultCount"]').removeClass('ipsLoading').text(parseInt(response.length)).end().toggleClass('ipsSideMenu_itemDisabled',(response.length===0)?true:false);if($(tab).attr('data-ipsMenuValue')==self._activePanel){self._showResultsInPanel(self._activePanel,response,true);}
if(!self._searchMenu.find('[data-ipsMenuValue].ipsSideMenu_itemActive:not( .ipsSideMenu_itemDisabled )').length){self._selectFirstResultsTab();}
if(response.length>0&&key==self._defaultTab&&self._activePanel==self._defaultTab){tab.click();}
delete self._ajax[key];}).fail(function(err){});});},700),_selectFirstResultsTab:function(){var first=this._searchMenu.find('[data-ipsMenuValue]:not( .ipsSideMenu_itemDisabled )').first();first.click();},_setPanelToLoading:function(panel){var panelContainer=this._resultsContainer.find('[data-resultsSection="'+panel+'"]');panelContainer.addClass('ipsLoading').find('> ol').hide();},_showResultsInPanel:function(panel,results,animate){this._resultsContainer.find('[data-resultsSection]').hide();var panelContainer=this._resultsContainer.find('[data-resultsSection="'+panel+'"]');var panelList=panelContainer.find('> ol');if(!panelContainer.length){this._buildResultsContainer(panel);panelContainer=this._resultsContainer.find('[data-resultsSection="'+panel+'"]');panelList=panelContainer.find('> ol');}
panelContainer.removeClass('ipsLoading');panelList.hide().html('');if(_.isUndefined(results)||_.isUndefined(results)||_.size(results)==0){panelList.html(ips.templates.render('core.livesearch.noResults')).show();return;}
_.each(results,function(val){panelList.prepend(val);});var resultItems=panelList.find('[data-role="result"]').hide();var delay=25;panelList.show();panelContainer.show();if(animate==true){resultItems.each(function(){var item=$(this);setTimeout(function(){ips.utils.anim.go('fadeIn fast',item);},delay);delay+=25;});}else{resultItems.show();}},_buildResultsContainer:function(panel){this._resultsContainer.prepend($('<div/>').attr('data-resultsSection',panel).addClass('ipsScrollbar').append($('<ol/>')));},_buildModal:function(){this._modal=ips.ui.getModal();}});}(jQuery,_));;
;(function($,_){"use strict";ips.controller.register('core.admin.core.nav',{_reordering:false,_orderChanged:false,_currentMenu:null,_menuTimer:null,initialize:function(){this.setup();this.on(document,'click','#acpMainArea',this.clickMainArea);this.on('click','[data-action="reorder"]',this.startReorder);this.on('click','[data-action="saveOrder"]',this.saveOrder);},setup:function(){const self=this;let activating;this._currentMenu=this.scope.find('.acpAppList_active');if(ips.utils.responsive.enabled()&&ips.utils.events.isTouchDevice()&&ips.utils.responsive.currentIs('tablet')){this.on('click','> li > a',this.handleTouchMenu);}else{$('#acpAppMenu').menuAim({rowSelector:"> #acpAppList > li:not( #elLogo )",enter:function(row){if($(row).attr('id')==='elReorderAppMenu'||$(row).attr('id')==='elHideMenu'){activating=self.scope.find('.acpAppList_active');}
if(self._menuTimer){clearTimeout(self._menuTimer);}},activate:function(row){if($(row).attr('id')==='elReorderAppMenu'||$(row).attr('id')==='elHideMenu'){activating.addClass('acpAppList_active');}else{$(row).addClass('acpAppList_active');}},deactivate:function(row){$(row).removeClass('acpAppList_active');},exitMenu:function(){self._menuTimer=setTimeout(function(){self.scope.find('.acpAppList_active').removeClass('acpAppList_active');self._currentMenu.addClass('acpAppList_active');},2000);return false;}});}},handleTouchMenu(e){if($(e.currentTarget).hasClass('acpAppList_active')&&$(e.currentTarget).find('> .acpAppList__sub:visible').length){return;}
e.preventDefault();this.scope.find('.acpAppList_active').removeClass('acpAppList_active').find('> .acpAppList__sub').hide();$(e.currentTarget).closest('li').addClass('acpAppList_active').find('> .acpAppList__sub').show();},clickMainArea(){if(ips.utils.responsive.enabled()&&ips.utils.events.isTouchDevice()&&ips.utils.responsive.currentIs('tablet')){this.scope.find('.acpAppList_active .acpAppList__sub').hide();}else{if(!this._reordering){$('#acpAppList').removeClass('acpAppList_childHovering').find('> li').trigger('mouseleave');}}},startReorder(){const self=this;this.scope.find('> li:not( #elReorderAppMenu ):not( #elHideMenu ) > a').each(function(){$(this).append(ips.templates.render('core.appMenu.reorder'));});this.scope.find('> li > ul > li h3').each(function(){$(this).prepend(ips.templates.render('core.appMenu.reorder'));});ips.utils.anim.go('zoomIn',this.scope.find('[data-role="reorder"]'));this.scope.addClass('acpAppList_reordering').sortable({start(e,ui){ui.item.addClass('acpAppList_dragging');},stop(e,ui){ui.item.removeClass('acpAppList_dragging');},update(){self._orderChanged=true;}}).find('#elReorderAppMenu').find('[data-action="reorder"]').addClass('ipsHide').end().find('[data-action="saveOrder"]').removeClass('ipsHide');this.getSubMenus().sortable({start(e,ui){ui.item.addClass('acpAppList_dragging');},stop(e,ui){ui.item.removeClass('acpAppList_dragging');},update(){self._orderChanged=true;}});this._reordering=true;this._orderChanged=false;},getSubMenus(tab){return this.scope.find('> li[data-tab'+(tab?`="${tab}"`:``)+']').find("> ul, > .acpAppList__sub > ul");},saveOrder(){this.scope.find('[data-role="reorder"]').remove();const tabOrder=this.scope.sortable('toArray',{attribute:'data-tab'}).filter(i=>!!i);const menuOrder={};const self=this;_.each(tabOrder,function(val){if(val){menuOrder[val]=self.getSubMenus(val).sortable('toArray',{attribute:'data-menuKey'})?.filter(i=>!!i);if(!Array.isArray(menuOrder[val])){ips.ui.alert.show({icon:'warning',message:ips.getString('tab_order_not_saved')});throw new TypeError(`Couldn't get the submenu sortable`);}}});this.scope.removeClass('acpAppList_reordering').find('#elReorderAppMenu').find('[data-action="reorder"]').removeClass('ipsHide').end().find('[data-action="saveOrder"]').addClass('ipsHide');if(this._orderChanged){ips.getAjax()('?app=core&module=system&controller=ajax&do=saveTabs',{data:{tabOrder,menuOrder},dataType:'json',type:'post'}).done(function(){ips.ui.flashMsg.show(ips.getString('tab_order_saved'));}).fail(function(){ips.ui.alert.show({icon:'warning',message:ips.getString('tab_order_not_saved')});});}
this.scope.sortable('destroy');this._reordering=false;}});}(jQuery,_));;
;(function($,_,undefined){"use strict";ips.controller.register('core.admin.core.nodeCopySetting',{initialize:function(){this.on('click',this.click);},click:function(e){e.preventDefault();if(this.scope.next().hasClass('ipsSelectTree')){var vals=this.scope.next('.ipsSelectTree').find("input").first().val();}
else
{var vals='';if(this.scope.next().hasClass('ipsField_stack')){var valArray=[];this.scope.next().find('input:not([type=hidden]):not([type=submit]),textarea,select').each(function(){if($(this).attr('type')=='checkbox'){valArray.push($(this).is(':checked')?1:0);}else{valArray.push($(this).val());}})
vals=valArray.join(',');}
else if(this.scope.next().hasClass('ipsField_autocomplete')){if($('#'+this.scope.data('field')).is(':checked ')){vals=this.scope.nextAll("input:not([type=hidden]),textarea,select").first().val();}
else{vals=$('input[name="'+this.scope.data('field')+'"]').val();}}
else{var input=this.scope.nextAll("input:not([type=hidden]),textarea,select").first();if($('#'+this.scope.attr('data-field')+"-unlimitedCheck:checked").length){vals="-1";}else if(input.attr('type')=='checkbox'){vals=input.is(':checked')?1:0;}else{vals=input.val();}}}
var dialogRef=ips.ui.dialog.create({title:this.scope.attr('_title'),url:this.scope.attr('data-baseLink'),forceReload:true,fixed:false,ajax:{type:'post',data:{value:vals}}});dialogRef.show();}});}(jQuery,_));;