<?php

namespace XF\Data;

class Emoji
{
	public function getEmojiListForDisplay($lazyLoad = false): array
	{
		if (!\XF::config('fullUnicode'))
		{
			return [];
		}


		$list = $this->getDetailedEmojiList();
		$formatter = \XF::app()->stringFormatter()->getEmojiFormatter();

		$output = [];

		foreach ($list AS $key => $emoji)
		{
			if ($emoji['diversity'])
			{
				// TODO: Support skin-tone modifiers
				unset($list[$key]);
				continue;
			}

			if (!$emoji['gender'] && $emoji['gender_children'])
			{
				// this removes items that are essentially duplicates
				// e.g. person_raising_hand is the same as woman_raising_hand
				unset($list[$key]);
				continue;
			}

			$emoji['html'] = $formatter->getImageFromShortname($emoji['shortname'], $lazyLoad);

			$output[$emoji['shortname']] = $emoji;
		}

		return $output;
	}

	//###### GENERATED CODE START ######
	public function getDetailedEmojiList(): array
	{
		return [
			'1f600' => [
				'name' => \XF::phrase('emoji.grinning'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':grinning:',
				'shortname_alternates' => [':grinning_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😀',
				'keywords' => ['face', 'grin', 'uc6'],
			],
			'1f603' => [
				'name' => \XF::phrase('emoji.smiley'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':smiley:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😃',
				'keywords' => ['face', 'mouth', 'open', 'smile', 'uc6'],
			],
			'1f604' => [
				'name' => \XF::phrase('emoji.smile'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':smile:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😄',
				'keywords' => ['eye', 'face', 'mouth', 'open', 'smile', 'uc6'],
			],
			'1f601' => [
				'name' => \XF::phrase('emoji.grin'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':grin:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😁',
				'keywords' => ['eye', 'face', 'grin', 'smile', 'uc6'],
			],
			'1f606' => [
				'name' => \XF::phrase('emoji.laughing'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':laughing:',
				'shortname_alternates' => [':satisfied:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😆',
				'keywords' => ['face', 'laugh', 'mouth', 'open', 'satisfied', 'smile', 'uc6'],
			],
			'1f979' => [
				'name' => \XF::phrase('emoji.face_holding_back_tears'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':face_holding_back_tears:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🥹',
				'keywords' => ['uc14'],
			],
			'1f605' => [
				'name' => \XF::phrase('emoji.sweat_smile'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':sweat_smile:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😅',
				'keywords' => ['cold', 'face', 'open', 'smile', 'sweat', 'uc6'],
			],
			'1f602' => [
				'name' => \XF::phrase('emoji.joy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':joy:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😂',
				'keywords' => ['face', 'joy', 'laugh', 'tear', 'uc6'],
			],
			'1f923' => [
				'name' => \XF::phrase('emoji.rofl'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':rofl:',
				'shortname_alternates' => [':rolling_on_the_floor_laughing:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤣',
				'keywords' => ['face', 'floor', 'laugh', 'rolling', 'uc9'],
			],
			'1f972' => [
				'name' => \XF::phrase('emoji.smiling_face_with_tear'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':smiling_face_with_tear:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🥲',
				'keywords' => ['uc13'],
			],
			'263a' => [
				'name' => \XF::phrase('emoji.relaxed'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':relaxed:',
				'shortname_alternates' => [':smiling_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '☺️',
				'keywords' => ['face', 'outlined', 'relaxed', 'smile', 'uc1'],
			],
			'1f60a' => [
				'name' => \XF::phrase('emoji.blush'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blush:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😊',
				'keywords' => ['blush', 'eye', 'face', 'smile', 'uc6'],
			],
			'1f607' => [
				'name' => \XF::phrase('emoji.innocent'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':innocent:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😇',
				'keywords' => ['angel', 'face', 'fairy tale', 'fantasy', 'halo', 'innocent', 'smile', 'uc6'],
			],
			'1f642' => [
				'name' => \XF::phrase('emoji.slight_smile'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':slight_smile:',
				'shortname_alternates' => [':slightly_smiling_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🙂',
				'keywords' => ['face', 'smile', 'uc7'],
			],
			'1f643' => [
				'name' => \XF::phrase('emoji.upside_down'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':upside_down:',
				'shortname_alternates' => [':upside_down_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🙃',
				'keywords' => ['face', 'upside-down', 'uc8'],
			],
			'1f609' => [
				'name' => \XF::phrase('emoji.wink'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':wink:',
				'shortname_alternates' => [':winking_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😉',
				'keywords' => ['face', 'wink', 'uc6'],
			],
			'1f60c' => [
				'name' => \XF::phrase('emoji.relieved'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':relieved:',
				'shortname_alternates' => [':relieved_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😌',
				'keywords' => ['face', 'relieved', 'uc6'],
			],
			'1f60d' => [
				'name' => \XF::phrase('emoji.heart_eyes'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':heart_eyes:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😍',
				'keywords' => ['eye', 'face', 'love', 'smile', 'uc6'],
			],
			'1f970' => [
				'name' => \XF::phrase('emoji.smiling_face_with_3_hearts'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':smiling_face_with_3_hearts:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🥰',
				'keywords' => ['uc11'],
			],
			'1f618' => [
				'name' => \XF::phrase('emoji.kissing_heart'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':kissing_heart:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😘',
				'keywords' => ['face', 'kiss', 'uc6'],
			],
			'1f617' => [
				'name' => \XF::phrase('emoji.kissing'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':kissing:',
				'shortname_alternates' => [':kissing_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😗',
				'keywords' => ['face', 'kiss', 'uc6'],
			],
			'1f619' => [
				'name' => \XF::phrase('emoji.kissing_smiling_eyes'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':kissing_smiling_eyes:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😙',
				'keywords' => ['eye', 'face', 'kiss', 'smile', 'uc6'],
			],
			'1f61a' => [
				'name' => \XF::phrase('emoji.kissing_closed_eyes'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':kissing_closed_eyes:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😚',
				'keywords' => ['closed', 'eye', 'face', 'kiss', 'uc6'],
			],
			'1f60b' => [
				'name' => \XF::phrase('emoji.yum'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':yum:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😋',
				'keywords' => ['delicious', 'face', 'savouring', 'smile', 'um', 'yum', 'uc6'],
			],
			'1f61b' => [
				'name' => \XF::phrase('emoji.stuck_out_tongue'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':stuck_out_tongue:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😛',
				'keywords' => ['face', 'tongue', 'uc6'],
			],
			'1f61d' => [
				'name' => \XF::phrase('emoji.stuck_out_tongue_closed_eyes'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':stuck_out_tongue_closed_eyes:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😝',
				'keywords' => ['eye', 'face', 'horrible', 'taste', 'tongue', 'uc6'],
			],
			'1f61c' => [
				'name' => \XF::phrase('emoji.stuck_out_tongue_winking_eye'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':stuck_out_tongue_winking_eye:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😜',
				'keywords' => ['eye', 'face', 'joke', 'tongue', 'wink', 'uc6'],
			],
			'1f92a' => [
				'name' => \XF::phrase('emoji.zany_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':zany_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤪',
				'keywords' => ['eye', 'large', 'small', 'uc10'],
			],
			'1f928' => [
				'name' => \XF::phrase('emoji.face_with_raised_eyebrow'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':face_with_raised_eyebrow:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤨',
				'keywords' => ['uc10'],
			],
			'1f9d0' => [
				'name' => \XF::phrase('emoji.face_with_monocle'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':face_with_monocle:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧐',
				'keywords' => ['uc10'],
			],
			'1f913' => [
				'name' => \XF::phrase('emoji.nerd'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nerd:',
				'shortname_alternates' => [':nerd_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤓',
				'keywords' => ['face', 'geek', 'nerd', 'uc8'],
			],
			'1f60e' => [
				'name' => \XF::phrase('emoji.sunglasses'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':sunglasses:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😎',
				'keywords' => ['bright', 'cool', 'eye', 'eyewear', 'face', 'glasses', 'smile', 'sun', 'sunglasses', 'uc6'],
			],
			'1f978' => [
				'name' => \XF::phrase('emoji.disguised_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':disguised_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🥸',
				'keywords' => ['uc13'],
			],
			'1f929' => [
				'name' => \XF::phrase('emoji.star_struck'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':star_struck:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤩',
				'keywords' => ['uc10'],
			],
			'1f973' => [
				'name' => \XF::phrase('emoji.partying_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':partying_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🥳',
				'keywords' => ['uc11'],
			],
			'1f60f' => [
				'name' => \XF::phrase('emoji.smirk'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':smirk:',
				'shortname_alternates' => [':smirking_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😏',
				'keywords' => ['face', 'smirk', 'uc6'],
			],
			'1f612' => [
				'name' => \XF::phrase('emoji.unamused'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':unamused:',
				'shortname_alternates' => [':unamused_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😒',
				'keywords' => ['face', 'unamused', 'unhappy', 'uc6'],
			],
			'1f61e' => [
				'name' => \XF::phrase('emoji.disappointed'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':disappointed:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😞',
				'keywords' => ['disappointed', 'face', 'uc6'],
			],
			'1f614' => [
				'name' => \XF::phrase('emoji.pensive'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pensive:',
				'shortname_alternates' => [':pensive_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😔',
				'keywords' => ['dejected', 'face', 'pensive', 'uc6'],
			],
			'1f61f' => [
				'name' => \XF::phrase('emoji.worried'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':worried:',
				'shortname_alternates' => [':worried_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😟',
				'keywords' => ['face', 'worried', 'uc6'],
			],
			'1f615' => [
				'name' => \XF::phrase('emoji.confused'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':confused:',
				'shortname_alternates' => [':confused_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😕',
				'keywords' => ['confused', 'face', 'uc6'],
			],
			'1f641' => [
				'name' => \XF::phrase('emoji.slight_frown'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':slight_frown:',
				'shortname_alternates' => [':slightly_frowning_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🙁',
				'keywords' => ['face', 'frown', 'uc7'],
			],
			'2639' => [
				'name' => \XF::phrase('emoji.frowning2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':frowning2:',
				'shortname_alternates' => [':white_frowning_face:', ':frowning_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '☹️',
				'keywords' => ['face', 'frown', 'uc1'],
			],
			'1f623' => [
				'name' => \XF::phrase('emoji.persevere'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':persevere:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😣',
				'keywords' => ['face', 'persevere', 'uc6'],
			],
			'1f616' => [
				'name' => \XF::phrase('emoji.confounded'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':confounded:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😖',
				'keywords' => ['confounded', 'face', 'uc6'],
			],
			'1f62b' => [
				'name' => \XF::phrase('emoji.tired_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':tired_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😫',
				'keywords' => ['face', 'tired', 'uc6'],
			],
			'1f629' => [
				'name' => \XF::phrase('emoji.weary'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':weary:',
				'shortname_alternates' => [':weary_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😩',
				'keywords' => ['face', 'tired', 'weary', 'uc6'],
			],
			'1f97a' => [
				'name' => \XF::phrase('emoji.pleading_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pleading_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🥺',
				'keywords' => ['uc11'],
			],
			'1f622' => [
				'name' => \XF::phrase('emoji.cry'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':cry:',
				'shortname_alternates' => [':crying_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😢',
				'keywords' => ['cry', 'face', 'sad', 'tear', 'uc6'],
			],
			'1f62d' => [
				'name' => \XF::phrase('emoji.sob'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':sob:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😭',
				'keywords' => ['cry', 'face', 'sad', 'sob', 'tear', 'uc6'],
			],
			'1f624' => [
				'name' => \XF::phrase('emoji.triumph'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':triumph:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😤',
				'keywords' => ['face', 'triumph', 'won', 'uc6'],
			],
			'1f620' => [
				'name' => \XF::phrase('emoji.angry'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':angry:',
				'shortname_alternates' => [':angry_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😠',
				'keywords' => ['angry', 'face', 'mad', 'uc6'],
			],
			'1f621' => [
				'name' => \XF::phrase('emoji.rage'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':rage:',
				'shortname_alternates' => [':pouting_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😡',
				'keywords' => ['angry', 'face', 'mad', 'pouting', 'rage', 'red', 'uc6'],
			],
			'1f92c' => [
				'name' => \XF::phrase('emoji.face_with_symbols_over_mouth'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':face_with_symbols_over_mouth:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤬',
				'keywords' => ['uc10'],
			],
			'1f92f' => [
				'name' => \XF::phrase('emoji.exploding_head'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':exploding_head:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤯',
				'keywords' => ['shocked', 'uc10'],
			],
			'1f633' => [
				'name' => \XF::phrase('emoji.flushed'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':flushed:',
				'shortname_alternates' => [':flushed_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😳',
				'keywords' => ['dazed', 'face', 'flushed', 'uc6'],
			],
			'1f975' => [
				'name' => \XF::phrase('emoji.hot_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hot_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🥵',
				'keywords' => ['uc11'],
			],
			'1f976' => [
				'name' => \XF::phrase('emoji.cold_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':cold_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🥶',
				'keywords' => ['uc11'],
			],
			'1f636-1f32b' => [
				'name' => \XF::phrase('emoji.face_in_clouds'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':face_in_clouds:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😶‍🌫️',
				'keywords' => ['uc13'],
			],
			'1f631' => [
				'name' => \XF::phrase('emoji.scream'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':scream:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😱',
				'keywords' => ['face', 'fear', 'fearful', 'munch', 'scared', 'scream', 'uc6'],
			],
			'1f628' => [
				'name' => \XF::phrase('emoji.fearful'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fearful:',
				'shortname_alternates' => [':fearful_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😨',
				'keywords' => ['face', 'fear', 'fearful', 'scared', 'uc6'],
			],
			'1f630' => [
				'name' => \XF::phrase('emoji.cold_sweat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':cold_sweat:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😰',
				'keywords' => ['blue', 'cold', 'face', 'mouth', 'open', 'rushed', 'sweat', 'uc6'],
			],
			'1f625' => [
				'name' => \XF::phrase('emoji.disappointed_relieved'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':disappointed_relieved:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😥',
				'keywords' => ['disappointed', 'face', 'relieved', 'whew', 'uc6'],
			],
			'1f613' => [
				'name' => \XF::phrase('emoji.sweat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':sweat:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😓',
				'keywords' => ['cold', 'face', 'sweat', 'uc6'],
			],
			'1f917' => [
				'name' => \XF::phrase('emoji.hugging'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hugging:',
				'shortname_alternates' => [':hugging_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤗',
				'keywords' => ['face', 'hug', 'hugging', 'uc8'],
			],
			'1f914' => [
				'name' => \XF::phrase('emoji.thinking'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thinking:',
				'shortname_alternates' => [':thinking_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤔',
				'keywords' => ['face', 'thinking', 'uc8'],
			],
			'1fae3' => [
				'name' => \XF::phrase('emoji.face_with_peeking_eye'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':face_with_peeking_eye:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫣',
				'keywords' => ['uc14'],
			],
			'1f92d' => [
				'name' => \XF::phrase('emoji.face_with_hand_over_mouth'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':face_with_hand_over_mouth:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤭',
				'keywords' => ['uc10'],
			],
			'1fae2' => [
				'name' => \XF::phrase('emoji.face_with_open_eyes_and_hand_over_mouth'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':face_with_open_eyes_and_hand_over_mouth:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫢',
				'keywords' => ['uc14'],
			],
			'1fae1' => [
				'name' => \XF::phrase('emoji.saluting_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':saluting_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫡',
				'keywords' => ['uc14'],
			],
			'1f92b' => [
				'name' => \XF::phrase('emoji.shushing_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':shushing_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤫',
				'keywords' => ['quiet', 'shush', 'uc10'],
			],
			'1fae0' => [
				'name' => \XF::phrase('emoji.melting_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':melting_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫠',
				'keywords' => ['uc14'],
			],
			'1f925' => [
				'name' => \XF::phrase('emoji.lying_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':lying_face:',
				'shortname_alternates' => [':liar:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤥',
				'keywords' => ['face', 'lie', 'pinocchio', 'uc9'],
			],
			'1f636' => [
				'name' => \XF::phrase('emoji.no_mouth'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':no_mouth:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😶',
				'keywords' => ['face', 'mouth', 'quiet', 'silent', 'uc6'],
			],
			'1fae5' => [
				'name' => \XF::phrase('emoji.dotted_line_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':dotted_line_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫥',
				'keywords' => ['uc14'],
			],
			'1f610' => [
				'name' => \XF::phrase('emoji.neutral_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':neutral_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😐',
				'keywords' => ['deadpan', 'face', 'neutral', 'uc6'],
			],
			'1fae4' => [
				'name' => \XF::phrase('emoji.face_with_diagonal_mouth'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':face_with_diagonal_mouth:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫤',
				'keywords' => ['uc14'],
			],
			'1f611' => [
				'name' => \XF::phrase('emoji.expressionless'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':expressionless:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😑',
				'keywords' => ['expressionless', 'face', 'inexpressive', 'unexpressive', 'uc6'],
			],
			'1fae8' => [
				'name' => \XF::phrase('emoji.shaking_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':shaking_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫨',
				'keywords' => ['uc15'],
			],
			'1f62c' => [
				'name' => \XF::phrase('emoji.grimacing'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':grimacing:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😬',
				'keywords' => ['face', 'grimace', 'uc6'],
			],
			'1f644' => [
				'name' => \XF::phrase('emoji.rolling_eyes'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':rolling_eyes:',
				'shortname_alternates' => [':face_with_rolling_eyes:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🙄',
				'keywords' => ['eyes', 'face', 'rolling', 'uc8'],
			],
			'1f62f' => [
				'name' => \XF::phrase('emoji.hushed'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hushed:',
				'shortname_alternates' => [':hushed_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😯',
				'keywords' => ['face', 'hushed', 'stunned', 'surprised', 'uc6'],
			],
			'1f626' => [
				'name' => \XF::phrase('emoji.frowning'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':frowning:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😦',
				'keywords' => ['face', 'frown', 'mouth', 'open', 'uc6'],
			],
			'1f627' => [
				'name' => \XF::phrase('emoji.anguished'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':anguished:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😧',
				'keywords' => ['anguished', 'face', 'uc6'],
			],
			'1f62e' => [
				'name' => \XF::phrase('emoji.open_mouth'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':open_mouth:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😮',
				'keywords' => ['face', 'mouth', 'open', 'sympathy', 'uc6'],
			],
			'1f632' => [
				'name' => \XF::phrase('emoji.astonished'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':astonished:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😲',
				'keywords' => ['astonished', 'face', 'shocked', 'totally', 'uc6'],
			],
			'1f971' => [
				'name' => \XF::phrase('emoji.yawning_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':yawning_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🥱',
				'keywords' => ['uc12'],
			],
			'1f634' => [
				'name' => \XF::phrase('emoji.sleeping'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':sleeping:',
				'shortname_alternates' => [':sleeping_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😴',
				'keywords' => ['face', 'sleep', 'zzz', 'uc6'],
			],
			'1f924' => [
				'name' => \XF::phrase('emoji.drooling_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':drooling_face:',
				'shortname_alternates' => [':drool:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤤',
				'keywords' => ['drooling', 'face', 'uc9'],
			],
			'1f62a' => [
				'name' => \XF::phrase('emoji.sleepy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':sleepy:',
				'shortname_alternates' => [':sleepy_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😪',
				'keywords' => ['face', 'sleep', 'uc6'],
			],
			'1f62e-1f4a8' => [
				'name' => \XF::phrase('emoji.face_exhaling'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':face_exhaling:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😮‍💨',
				'keywords' => ['uc13'],
			],
			'1f635' => [
				'name' => \XF::phrase('emoji.dizzy_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':dizzy_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😵',
				'keywords' => ['dizzy', 'face', 'uc6'],
			],
			'1f635-1f4ab' => [
				'name' => \XF::phrase('emoji.face_with_spiral_eyes'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':face_with_spiral_eyes:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😵‍💫',
				'keywords' => ['uc13'],
			],
			'1f910' => [
				'name' => \XF::phrase('emoji.zipper_mouth'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':zipper_mouth:',
				'shortname_alternates' => [':zipper_mouth_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤐',
				'keywords' => ['face', 'mouth', 'zipper', 'uc8'],
			],
			'1f974' => [
				'name' => \XF::phrase('emoji.woozy_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woozy_face:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🥴',
				'keywords' => ['uc11'],
			],
			'1f922' => [
				'name' => \XF::phrase('emoji.nauseated_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nauseated_face:',
				'shortname_alternates' => [':sick:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤢',
				'keywords' => ['face', 'nauseated', 'vomit', 'uc9'],
			],
			'1f92e' => [
				'name' => \XF::phrase('emoji.face_vomiting'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':face_vomiting:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤮',
				'keywords' => ['sick', 'vomit', 'uc10'],
			],
			'1f927' => [
				'name' => \XF::phrase('emoji.sneezing_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':sneezing_face:',
				'shortname_alternates' => [':sneeze:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤧',
				'keywords' => ['face', 'gesundheit', 'sneeze', 'uc9'],
			],
			'1f637' => [
				'name' => \XF::phrase('emoji.mask'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mask:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😷',
				'keywords' => ['cold', 'doctor', 'face', 'mask', 'medicine', 'sick', 'uc6'],
			],
			'1f912' => [
				'name' => \XF::phrase('emoji.thermometer_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thermometer_face:',
				'shortname_alternates' => [':face_with_thermometer:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤒',
				'keywords' => ['face', 'ill', 'sick', 'thermometer', 'uc8'],
			],
			'1f915' => [
				'name' => \XF::phrase('emoji.head_bandage'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':head_bandage:',
				'shortname_alternates' => [':face_with_head_bandage:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤕',
				'keywords' => ['bandage', 'face', 'hurt', 'injury', 'uc8'],
			],
			'1f911' => [
				'name' => \XF::phrase('emoji.money_mouth'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':money_mouth:',
				'shortname_alternates' => [':money_mouth_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤑',
				'keywords' => ['face', 'money', 'mouth', 'uc8'],
			],
			'1f920' => [
				'name' => \XF::phrase('emoji.cowboy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':cowboy:',
				'shortname_alternates' => [':face_with_cowboy_hat:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤠',
				'keywords' => ['cowboy', 'cowgirl', 'face', 'hat', 'uc9'],
			],
			'1f608' => [
				'name' => \XF::phrase('emoji.smiling_imp'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':smiling_imp:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😈',
				'keywords' => ['face', 'fairy tale', 'fantasy', 'horns', 'smile', 'uc6'],
			],
			'1f47f' => [
				'name' => \XF::phrase('emoji.imp'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':imp:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👿',
				'keywords' => ['demon', 'devil', 'face', 'fairy tale', 'fantasy', 'imp', 'uc6'],
			],
			'1f479' => [
				'name' => \XF::phrase('emoji.japanese_ogre'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':japanese_ogre:',
				'shortname_alternates' => [':ogre:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👹',
				'keywords' => ['uc6'],
			],
			'1f47a' => [
				'name' => \XF::phrase('emoji.japanese_goblin'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':japanese_goblin:',
				'shortname_alternates' => [':goblin:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👺',
				'keywords' => ['creature', 'face', 'fairy tale', 'fantasy', 'monster', 'uc6'],
			],
			'1f921' => [
				'name' => \XF::phrase('emoji.clown'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':clown:',
				'shortname_alternates' => [':clown_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤡',
				'keywords' => ['clown', 'face', 'uc9'],
			],
			'1f4a9' => [
				'name' => \XF::phrase('emoji.poop'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':poop:',
				'shortname_alternates' => [':shit:', ':hankey:', ':poo:', ':pile_of_poo:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '💩',
				'keywords' => ['comic', 'dung', 'face', 'monster', 'poo', 'poop', 'uc6'],
			],
			'1f47b' => [
				'name' => \XF::phrase('emoji.ghost'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ghost:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👻',
				'keywords' => ['creature', 'face', 'fairy tale', 'fantasy', 'monster', 'uc6'],
			],
			'1f480' => [
				'name' => \XF::phrase('emoji.skull'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':skull:',
				'shortname_alternates' => [':skeleton:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '💀',
				'keywords' => ['death', 'face', 'fairy tale', 'monster', 'uc6'],
			],
			'2620' => [
				'name' => \XF::phrase('emoji.skull_crossbones'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':skull_crossbones:',
				'shortname_alternates' => [':skull_and_crossbones:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '☠️',
				'keywords' => ['crossbones', 'death', 'face', 'monster', 'skull', 'uc1'],
			],
			'1f47d' => [
				'name' => \XF::phrase('emoji.alien'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':alien:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👽',
				'keywords' => ['creature', 'extraterrestrial', 'face', 'fairy tale', 'fantasy', 'monster', 'ufo', 'uc6'],
			],
			'1f47e' => [
				'name' => \XF::phrase('emoji.space_invader'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':space_invader:',
				'shortname_alternates' => [':alien_monster:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👾',
				'keywords' => ['alien', 'creature', 'extraterrestrial', 'face', 'fairy tale', 'fantasy', 'monster', 'ufo', 'uc6'],
			],
			'1f916' => [
				'name' => \XF::phrase('emoji.robot'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':robot:',
				'shortname_alternates' => [':robot_face:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤖',
				'keywords' => ['face', 'monster', 'robot', 'uc8'],
			],
			'1f383' => [
				'name' => \XF::phrase('emoji.jack_o_lantern'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':jack_o_lantern:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🎃',
				'keywords' => ['celebration', 'halloween', 'jack', 'lantern', 'uc6'],
			],
			'1f63a' => [
				'name' => \XF::phrase('emoji.smiley_cat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':smiley_cat:',
				'shortname_alternates' => [':grinning_cat:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😺',
				'keywords' => ['cat', 'face', 'mouth', 'open', 'smile', 'uc6'],
			],
			'1f638' => [
				'name' => \XF::phrase('emoji.smile_cat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':smile_cat:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😸',
				'keywords' => ['cat', 'eye', 'face', 'grin', 'smile', 'uc6'],
			],
			'1f639' => [
				'name' => \XF::phrase('emoji.joy_cat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':joy_cat:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😹',
				'keywords' => ['cat', 'face', 'joy', 'tear', 'uc6'],
			],
			'1f63b' => [
				'name' => \XF::phrase('emoji.heart_eyes_cat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':heart_eyes_cat:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😻',
				'keywords' => ['cat', 'eye', 'face', 'love', 'smile', 'uc6'],
			],
			'1f63c' => [
				'name' => \XF::phrase('emoji.smirk_cat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':smirk_cat:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😼',
				'keywords' => ['cat', 'face', 'ironic', 'smile', 'wry', 'uc6'],
			],
			'1f63d' => [
				'name' => \XF::phrase('emoji.kissing_cat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':kissing_cat:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😽',
				'keywords' => ['cat', 'eye', 'face', 'kiss', 'uc6'],
			],
			'1f640' => [
				'name' => \XF::phrase('emoji.scream_cat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':scream_cat:',
				'shortname_alternates' => [':weary_cat:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🙀',
				'keywords' => ['cat', 'face', 'oh', 'surprised', 'weary', 'uc6'],
			],
			'1f63f' => [
				'name' => \XF::phrase('emoji.crying_cat_face'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':crying_cat_face:',
				'shortname_alternates' => [':crying_cat:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😿',
				'keywords' => ['cat', 'cry', 'face', 'sad', 'tear', 'uc6'],
			],
			'1f63e' => [
				'name' => \XF::phrase('emoji.pouting_cat'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pouting_cat:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '😾',
				'keywords' => ['cat', 'face', 'pouting', 'uc6'],
			],
			'1faf6' => [
				'name' => \XF::phrase('emoji.heart_hands'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':heart_hands:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1faf6-1f3fb', '1faf6-1f3fc', '1faf6-1f3fd', '1faf6-1f3fe', '1faf6-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫶',
				'keywords' => ['uc14'],
			],
			'1faf6-1f3fb' => [
				'name' => \XF::phrase('emoji.heart_hands_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':heart_hands_tone1:',
				'shortname_alternates' => [':heart_hands_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫶🏻',
				'keywords' => ['uc14'],
			],
			'1faf6-1f3fc' => [
				'name' => \XF::phrase('emoji.heart_hands_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':heart_hands_tone2:',
				'shortname_alternates' => [':heart_hands_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫶🏼',
				'keywords' => ['uc14'],
			],
			'1faf6-1f3fd' => [
				'name' => \XF::phrase('emoji.heart_hands_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':heart_hands_tone3:',
				'shortname_alternates' => [':heart_hands_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫶🏽',
				'keywords' => ['uc14'],
			],
			'1faf6-1f3fe' => [
				'name' => \XF::phrase('emoji.heart_hands_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':heart_hands_tone4:',
				'shortname_alternates' => [':heart_hands_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫶🏾',
				'keywords' => ['uc14'],
			],
			'1faf6-1f3ff' => [
				'name' => \XF::phrase('emoji.heart_hands_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':heart_hands_tone5:',
				'shortname_alternates' => [':heart_hands_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫶🏿',
				'keywords' => ['uc14'],
			],
			'1f932' => [
				'name' => \XF::phrase('emoji.palms_up_together'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':palms_up_together:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f932-1f3fb', '1f932-1f3fc', '1f932-1f3fd', '1f932-1f3fe', '1f932-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤲',
				'keywords' => ['uc10'],
			],
			'1f932-1f3fb' => [
				'name' => \XF::phrase('emoji.palms_up_together_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':palms_up_together_tone1:',
				'shortname_alternates' => [':palms_up_together_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤲🏻',
				'keywords' => ['light skin tone', 'prayer', 'uc10'],
			],
			'1f932-1f3fc' => [
				'name' => \XF::phrase('emoji.palms_up_together_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':palms_up_together_tone2:',
				'shortname_alternates' => [':palms_up_together_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤲🏼',
				'keywords' => ['medium-light skin tone', 'prayer', 'uc10'],
			],
			'1f932-1f3fd' => [
				'name' => \XF::phrase('emoji.palms_up_together_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':palms_up_together_tone3:',
				'shortname_alternates' => [':palms_up_together_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤲🏽',
				'keywords' => ['medium skin tone', 'prayer', 'uc10'],
			],
			'1f932-1f3fe' => [
				'name' => \XF::phrase('emoji.palms_up_together_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':palms_up_together_tone4:',
				'shortname_alternates' => [':palms_up_together_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤲🏾',
				'keywords' => ['medium-dark skin tone', 'prayer', 'uc10'],
			],
			'1f932-1f3ff' => [
				'name' => \XF::phrase('emoji.palms_up_together_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':palms_up_together_tone5:',
				'shortname_alternates' => [':palms_up_together_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤲🏿',
				'keywords' => ['dark skin tone', 'prayer', 'uc10'],
			],
			'1f450' => [
				'name' => \XF::phrase('emoji.open_hands'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':open_hands:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f450-1f3fb', '1f450-1f3fc', '1f450-1f3fd', '1f450-1f3fe', '1f450-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👐',
				'keywords' => ['hand', 'open', 'uc6'],
			],
			'1f450-1f3fb' => [
				'name' => \XF::phrase('emoji.open_hands_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':open_hands_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👐🏻',
				'keywords' => ['hand', 'light skin tone', 'open', 'uc8'],
			],
			'1f450-1f3fc' => [
				'name' => \XF::phrase('emoji.open_hands_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':open_hands_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👐🏼',
				'keywords' => ['hand', 'medium-light skin tone', 'open', 'uc8'],
			],
			'1f450-1f3fd' => [
				'name' => \XF::phrase('emoji.open_hands_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':open_hands_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👐🏽',
				'keywords' => ['hand', 'medium skin tone', 'open', 'uc8'],
			],
			'1f450-1f3fe' => [
				'name' => \XF::phrase('emoji.open_hands_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':open_hands_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👐🏾',
				'keywords' => ['hand', 'medium-dark skin tone', 'open', 'uc8'],
			],
			'1f450-1f3ff' => [
				'name' => \XF::phrase('emoji.open_hands_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':open_hands_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👐🏿',
				'keywords' => ['dark skin tone', 'hand', 'open', 'uc8'],
			],
			'1f64c' => [
				'name' => \XF::phrase('emoji.raised_hands'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hands:',
				'shortname_alternates' => [':raising_hands:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f64c-1f3fb', '1f64c-1f3fc', '1f64c-1f3fd', '1f64c-1f3fe', '1f64c-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🙌',
				'keywords' => ['celebration', 'gesture', 'hand', 'hooray', 'raised', 'uc6'],
			],
			'1f64c-1f3fb' => [
				'name' => \XF::phrase('emoji.raised_hands_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hands_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🙌🏻',
				'keywords' => ['celebration', 'gesture', 'hand', 'hooray', 'light skin tone', 'raised', 'uc8'],
			],
			'1f64c-1f3fc' => [
				'name' => \XF::phrase('emoji.raised_hands_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hands_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🙌🏼',
				'keywords' => ['celebration', 'gesture', 'hand', 'hooray', 'medium-light skin tone', 'raised', 'uc8'],
			],
			'1f64c-1f3fd' => [
				'name' => \XF::phrase('emoji.raised_hands_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hands_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🙌🏽',
				'keywords' => ['celebration', 'gesture', 'hand', 'hooray', 'medium skin tone', 'raised', 'uc8'],
			],
			'1f64c-1f3fe' => [
				'name' => \XF::phrase('emoji.raised_hands_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hands_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🙌🏾',
				'keywords' => ['celebration', 'gesture', 'hand', 'hooray', 'medium-dark skin tone', 'raised', 'uc8'],
			],
			'1f64c-1f3ff' => [
				'name' => \XF::phrase('emoji.raised_hands_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hands_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🙌🏿',
				'keywords' => ['celebration', 'dark skin tone', 'gesture', 'hand', 'hooray', 'raised', 'uc8'],
			],
			'1f44f' => [
				'name' => \XF::phrase('emoji.clap'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':clap:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f44f-1f3fb', '1f44f-1f3fc', '1f44f-1f3fd', '1f44f-1f3fe', '1f44f-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👏',
				'keywords' => ['clap', 'hand', 'uc6'],
			],
			'1f44f-1f3fb' => [
				'name' => \XF::phrase('emoji.clap_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':clap_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👏🏻',
				'keywords' => ['clap', 'hand', 'light skin tone', 'uc8'],
			],
			'1f44f-1f3fc' => [
				'name' => \XF::phrase('emoji.clap_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':clap_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👏🏼',
				'keywords' => ['clap', 'hand', 'medium-light skin tone', 'uc8'],
			],
			'1f44f-1f3fd' => [
				'name' => \XF::phrase('emoji.clap_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':clap_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👏🏽',
				'keywords' => ['clap', 'hand', 'medium skin tone', 'uc8'],
			],
			'1f44f-1f3fe' => [
				'name' => \XF::phrase('emoji.clap_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':clap_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👏🏾',
				'keywords' => ['clap', 'hand', 'medium-dark skin tone', 'uc8'],
			],
			'1f44f-1f3ff' => [
				'name' => \XF::phrase('emoji.clap_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':clap_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👏🏿',
				'keywords' => ['clap', 'dark skin tone', 'hand', 'uc8'],
			],
			'1f91d' => [
				'name' => \XF::phrase('emoji.handshake'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':handshake:',
				'shortname_alternates' => [':shaking_hands:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f91d-1f3fb', '1f91d-1f3fc', '1f91d-1f3fd', '1f91d-1f3fe', '1f91d-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤝',
				'keywords' => ['agreement', 'hand', 'handshake', 'meeting', 'shake', 'uc9'],
			],
			'1f91d-1f3fb' => [
				'name' => \XF::phrase('emoji.handshake_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':handshake_tone1:',
				'shortname_alternates' => [':handshake_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤝🏻',
				'keywords' => ['uc14'],
			],
			'1faf1-1f3fb-1faf2-1f3fc' => [
				'name' => \XF::phrase('emoji.handshake_tone1_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':handshake_tone1_tone2:',
				'shortname_alternates' => [':handshake_light_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫱🏻‍🫲🏼',
				'keywords' => ['uc14'],
			],
			'1faf1-1f3fb-1faf2-1f3fd' => [
				'name' => \XF::phrase('emoji.handshake_tone1_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':handshake_tone1_tone3:',
				'shortname_alternates' => [':handshake_light_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫱🏻‍🫲🏽',
				'keywords' => ['uc14'],
			],
			'1faf1-1f3fb-1faf2-1f3fe' => [
				'name' => \XF::phrase('emoji.handshake_tone1_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':handshake_tone1_tone4:',
				'shortname_alternates' => [':handshake_light_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫱🏻‍🫲🏾',
				'keywords' => ['uc14'],
			],
			'1faf1-1f3fb-1faf2-1f3ff' => [
				'name' => \XF::phrase('emoji.handshake_tone1_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':handshake_tone1_tone5:',
				'shortname_alternates' => [':handshake_light_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫱🏻‍🫲🏿',
				'keywords' => ['uc14'],
			],
			'1faf1-1f3fc-1faf2-1f3fb' => [
				'name' => \XF::phrase('emoji.handshake_tone2_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':handshake_tone2_tone1:',
				'shortname_alternates' => [':handshake_medium_light_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫱🏼‍🫲🏻',
				'keywords' => ['uc14'],
			],
			'1f91d-1f3fc' => [
				'name' => \XF::phrase('emoji.handshake_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':handshake_tone2:',
				'shortname_alternates' => [':handshake_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤝🏼',
				'keywords' => ['uc14'],
			],
			'1faf1-1f3fc-1faf2-1f3fd' => [
				'name' => \XF::phrase('emoji.handshake_tone2_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':handshake_tone2_tone3:',
				'shortname_alternates' => [':handshake_medium_light_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫱🏼‍🫲🏽',
				'keywords' => ['uc14'],
			],
			'1faf1-1f3fc-1faf2-1f3fe' => [
				'name' => \XF::phrase('emoji.handshake_tone2_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':handshake_tone2_tone4:',
				'shortname_alternates' => [':handshake_medium_light_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫱🏼‍🫲🏾',
				'keywords' => ['uc14'],
			],
			'1faf1-1f3fc-1faf2-1f3ff' => [
				'name' => \XF::phrase('emoji.handshake_tone2_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':handshake_tone2_tone5:',
				'shortname_alternates' => [':handshake_medium_light_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫱🏼‍🫲🏿',
				'keywords' => ['uc14'],
			],
			'1faf1-1f3fd-1faf2-1f3fb' => [
				'name' => \XF::phrase('emoji.handshake_tone3_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':handshake_tone3_tone1:',
				'shortname_alternates' => [':handshake_medium_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫱🏽‍🫲🏻',
				'keywords' => ['uc14'],
			],
			'1faf1-1f3fd-1faf2-1f3fc' => [
				'name' => \XF::phrase('emoji.handshake_tone3_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':handshake_tone3_tone2:',
				'shortname_alternates' => [':handshake_medium_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫱🏽‍🫲🏼',
				'keywords' => ['uc14'],
			],
			'1f91d-1f3fd' => [
				'name' => \XF::phrase('emoji.handshake_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':handshake_tone3:',
				'shortname_alternates' => [':handshake_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤝🏽',
				'keywords' => ['uc14'],
			],
			'1faf1-1f3fd-1faf2-1f3fe' => [
				'name' => \XF::phrase('emoji.handshake_tone3_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':handshake_tone3_tone4:',
				'shortname_alternates' => [':handshake_medium_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫱🏽‍🫲🏾',
				'keywords' => ['uc14'],
			],
			'1faf1-1f3fd-1faf2-1f3ff' => [
				'name' => \XF::phrase('emoji.handshake_tone3_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':handshake_tone3_tone5:',
				'shortname_alternates' => [':handshake_medium_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫱🏽‍🫲🏿',
				'keywords' => ['uc14'],
			],
			'1faf1-1f3fe-1faf2-1f3fb' => [
				'name' => \XF::phrase('emoji.handshake_tone4_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':handshake_tone4_tone1:',
				'shortname_alternates' => [':handshake_medium_dark_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫱🏾‍🫲🏻',
				'keywords' => ['uc14'],
			],
			'1faf1-1f3fe-1faf2-1f3fc' => [
				'name' => \XF::phrase('emoji.handshake_tone4_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':handshake_tone4_tone2:',
				'shortname_alternates' => [':handshake_medium_dark_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫱🏾‍🫲🏼',
				'keywords' => ['uc14'],
			],
			'1faf1-1f3fe-1faf2-1f3fd' => [
				'name' => \XF::phrase('emoji.handshake_tone4_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':handshake_tone4_tone3:',
				'shortname_alternates' => [':handshake_medium_dark_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫱🏾‍🫲🏽',
				'keywords' => ['uc14'],
			],
			'1f91d-1f3fe' => [
				'name' => \XF::phrase('emoji.handshake_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':handshake_tone4:',
				'shortname_alternates' => [':handshake_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤝🏾',
				'keywords' => ['uc14'],
			],
			'1faf1-1f3fe-1faf2-1f3ff' => [
				'name' => \XF::phrase('emoji.handshake_tone4_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':handshake_tone4_tone5:',
				'shortname_alternates' => [':handshake_medium_dark_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe', '1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫱🏾‍🫲🏿',
				'keywords' => ['uc14'],
			],
			'1faf1-1f3ff-1faf2-1f3fb' => [
				'name' => \XF::phrase('emoji.handshake_tone5_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':handshake_tone5_tone1:',
				'shortname_alternates' => [':handshake_dark_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫱🏿‍🫲🏻',
				'keywords' => ['uc14'],
			],
			'1faf1-1f3ff-1faf2-1f3fc' => [
				'name' => \XF::phrase('emoji.handshake_tone5_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':handshake_tone5_tone2:',
				'shortname_alternates' => [':handshake_dark_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫱🏿‍🫲🏼',
				'keywords' => ['uc14'],
			],
			'1faf1-1f3ff-1faf2-1f3fd' => [
				'name' => \XF::phrase('emoji.handshake_tone5_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':handshake_tone5_tone3:',
				'shortname_alternates' => [':handshake_dark_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫱🏿‍🫲🏽',
				'keywords' => ['uc14'],
			],
			'1faf1-1f3ff-1faf2-1f3fe' => [
				'name' => \XF::phrase('emoji.handshake_tone5_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':handshake_tone5_tone4:',
				'shortname_alternates' => [':handshake_dark_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe', '1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫱🏿‍🫲🏾',
				'keywords' => ['uc14'],
			],
			'1f91d-1f3ff' => [
				'name' => \XF::phrase('emoji.handshake_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':handshake_tone5:',
				'shortname_alternates' => [':handshake_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤝🏿',
				'keywords' => ['uc14'],
			],
			'1f44d' => [
				'name' => \XF::phrase('emoji.thumbsup'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsup:',
				'shortname_alternates' => [':+1:', ':thumbup:', ':thumbs_up:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f44d-1f3fb', '1f44d-1f3fc', '1f44d-1f3fd', '1f44d-1f3fe', '1f44d-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👍',
				'keywords' => ['+1', 'hand', 'thumb', 'up', 'uc6'],
			],
			'1f44d-1f3fb' => [
				'name' => \XF::phrase('emoji.thumbsup_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsup_tone1:',
				'shortname_alternates' => [':+1_tone1:', ':thumbup_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👍🏻',
				'keywords' => ['+1', 'hand', 'light skin tone', 'thumb', 'up', 'uc8'],
			],
			'1f44d-1f3fc' => [
				'name' => \XF::phrase('emoji.thumbsup_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsup_tone2:',
				'shortname_alternates' => [':+1_tone2:', ':thumbup_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👍🏼',
				'keywords' => ['+1', 'hand', 'medium-light skin tone', 'thumb', 'up', 'uc8'],
			],
			'1f44d-1f3fd' => [
				'name' => \XF::phrase('emoji.thumbsup_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsup_tone3:',
				'shortname_alternates' => [':+1_tone3:', ':thumbup_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👍🏽',
				'keywords' => ['+1', 'hand', 'medium skin tone', 'thumb', 'up', 'uc8'],
			],
			'1f44d-1f3fe' => [
				'name' => \XF::phrase('emoji.thumbsup_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsup_tone4:',
				'shortname_alternates' => [':+1_tone4:', ':thumbup_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👍🏾',
				'keywords' => ['+1', 'hand', 'medium-dark skin tone', 'thumb', 'up', 'uc8'],
			],
			'1f44d-1f3ff' => [
				'name' => \XF::phrase('emoji.thumbsup_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsup_tone5:',
				'shortname_alternates' => [':+1_tone5:', ':thumbup_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👍🏿',
				'keywords' => ['+1', 'dark skin tone', 'hand', 'thumb', 'up', 'uc8'],
			],
			'1f44e' => [
				'name' => \XF::phrase('emoji.thumbsdown'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsdown:',
				'shortname_alternates' => [':-1:', ':thumbdown:', ':thumbs_down:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f44e-1f3fb', '1f44e-1f3fc', '1f44e-1f3fd', '1f44e-1f3fe', '1f44e-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👎',
				'keywords' => ['-1', 'down', 'hand', 'thumb', 'uc6'],
			],
			'1f44e-1f3fb' => [
				'name' => \XF::phrase('emoji.thumbsdown_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsdown_tone1:',
				'shortname_alternates' => [':-1_tone1:', ':thumbdown_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👎🏻',
				'keywords' => ['-1', 'down', 'hand', 'light skin tone', 'thumb', 'uc8'],
			],
			'1f44e-1f3fc' => [
				'name' => \XF::phrase('emoji.thumbsdown_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsdown_tone2:',
				'shortname_alternates' => [':-1_tone2:', ':thumbdown_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👎🏼',
				'keywords' => ['-1', 'down', 'hand', 'medium-light skin tone', 'thumb', 'uc8'],
			],
			'1f44e-1f3fd' => [
				'name' => \XF::phrase('emoji.thumbsdown_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsdown_tone3:',
				'shortname_alternates' => [':-1_tone3:', ':thumbdown_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👎🏽',
				'keywords' => ['-1', 'down', 'hand', 'medium skin tone', 'thumb', 'uc8'],
			],
			'1f44e-1f3fe' => [
				'name' => \XF::phrase('emoji.thumbsdown_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsdown_tone4:',
				'shortname_alternates' => [':-1_tone4:', ':thumbdown_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👎🏾',
				'keywords' => ['-1', 'down', 'hand', 'medium-dark skin tone', 'thumb', 'uc8'],
			],
			'1f44e-1f3ff' => [
				'name' => \XF::phrase('emoji.thumbsdown_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':thumbsdown_tone5:',
				'shortname_alternates' => [':-1_tone5:', ':thumbdown_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👎🏿',
				'keywords' => ['-1', 'dark skin tone', 'down', 'hand', 'thumb', 'uc8'],
			],
			'1f44a' => [
				'name' => \XF::phrase('emoji.punch'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':punch:',
				'shortname_alternates' => [':oncoming_fist:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f44a-1f3fb', '1f44a-1f3fc', '1f44a-1f3fd', '1f44a-1f3fe', '1f44a-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👊',
				'keywords' => ['clenched', 'fist', 'hand', 'punch', 'uc6'],
			],
			'1f44a-1f3fb' => [
				'name' => \XF::phrase('emoji.punch_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':punch_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👊🏻',
				'keywords' => ['clenched', 'fist', 'hand', 'light skin tone', 'punch', 'uc8'],
			],
			'1f44a-1f3fc' => [
				'name' => \XF::phrase('emoji.punch_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':punch_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👊🏼',
				'keywords' => ['clenched', 'fist', 'hand', 'medium-light skin tone', 'punch', 'uc8'],
			],
			'1f44a-1f3fd' => [
				'name' => \XF::phrase('emoji.punch_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':punch_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👊🏽',
				'keywords' => ['clenched', 'fist', 'hand', 'medium skin tone', 'punch', 'uc8'],
			],
			'1f44a-1f3fe' => [
				'name' => \XF::phrase('emoji.punch_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':punch_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👊🏾',
				'keywords' => ['clenched', 'fist', 'hand', 'medium-dark skin tone', 'punch', 'uc8'],
			],
			'1f44a-1f3ff' => [
				'name' => \XF::phrase('emoji.punch_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':punch_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👊🏿',
				'keywords' => ['clenched', 'dark skin tone', 'fist', 'hand', 'punch', 'uc8'],
			],
			'270a' => [
				'name' => \XF::phrase('emoji.fist'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fist:',
				'shortname_alternates' => [':raised_fist:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['270a-1f3fb', '270a-1f3fc', '270a-1f3fd', '270a-1f3fe', '270a-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '✊',
				'keywords' => ['clenched', 'fist', 'hand', 'punch', 'uc6'],
			],
			'270a-1f3fb' => [
				'name' => \XF::phrase('emoji.fist_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fist_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '✊🏻',
				'keywords' => ['clenched', 'fist', 'hand', 'light skin tone', 'punch', 'uc8'],
			],
			'270a-1f3fc' => [
				'name' => \XF::phrase('emoji.fist_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fist_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '✊🏼',
				'keywords' => ['clenched', 'fist', 'hand', 'medium-light skin tone', 'punch', 'uc8'],
			],
			'270a-1f3fd' => [
				'name' => \XF::phrase('emoji.fist_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fist_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '✊🏽',
				'keywords' => ['clenched', 'fist', 'hand', 'medium skin tone', 'punch', 'uc8'],
			],
			'270a-1f3fe' => [
				'name' => \XF::phrase('emoji.fist_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fist_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '✊🏾',
				'keywords' => ['clenched', 'fist', 'hand', 'medium-dark skin tone', 'punch', 'uc8'],
			],
			'270a-1f3ff' => [
				'name' => \XF::phrase('emoji.fist_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fist_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '✊🏿',
				'keywords' => ['clenched', 'dark skin tone', 'fist', 'hand', 'punch', 'uc8'],
			],
			'1f91b' => [
				'name' => \XF::phrase('emoji.left_facing_fist'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':left_facing_fist:',
				'shortname_alternates' => [':left_fist:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f91b-1f3fb', '1f91b-1f3fc', '1f91b-1f3fd', '1f91b-1f3fe', '1f91b-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤛',
				'keywords' => ['fist', 'leftwards', 'uc9'],
			],
			'1f91b-1f3fb' => [
				'name' => \XF::phrase('emoji.left_facing_fist_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':left_facing_fist_tone1:',
				'shortname_alternates' => [':left_fist_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤛🏻',
				'keywords' => ['fist', 'leftwards', 'light skin tone', 'uc9'],
			],
			'1f91b-1f3fc' => [
				'name' => \XF::phrase('emoji.left_facing_fist_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':left_facing_fist_tone2:',
				'shortname_alternates' => [':left_fist_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤛🏼',
				'keywords' => ['fist', 'leftwards', 'medium-light skin tone', 'uc9'],
			],
			'1f91b-1f3fd' => [
				'name' => \XF::phrase('emoji.left_facing_fist_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':left_facing_fist_tone3:',
				'shortname_alternates' => [':left_fist_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤛🏽',
				'keywords' => ['fist', 'leftwards', 'medium skin tone', 'uc9'],
			],
			'1f91b-1f3fe' => [
				'name' => \XF::phrase('emoji.left_facing_fist_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':left_facing_fist_tone4:',
				'shortname_alternates' => [':left_fist_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤛🏾',
				'keywords' => ['fist', 'leftwards', 'medium-dark skin tone', 'uc9'],
			],
			'1f91b-1f3ff' => [
				'name' => \XF::phrase('emoji.left_facing_fist_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':left_facing_fist_tone5:',
				'shortname_alternates' => [':left_fist_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤛🏿',
				'keywords' => ['dark skin tone', 'fist', 'leftwards', 'uc9'],
			],
			'1f91c' => [
				'name' => \XF::phrase('emoji.right_facing_fist'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':right_facing_fist:',
				'shortname_alternates' => [':right_fist:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f91c-1f3fb', '1f91c-1f3fc', '1f91c-1f3fd', '1f91c-1f3fe', '1f91c-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤜',
				'keywords' => ['fist', 'rightwards', 'uc9'],
			],
			'1f91c-1f3fb' => [
				'name' => \XF::phrase('emoji.right_facing_fist_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':right_facing_fist_tone1:',
				'shortname_alternates' => [':right_fist_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤜🏻',
				'keywords' => ['fist', 'light skin tone', 'rightwards', 'uc9'],
			],
			'1f91c-1f3fc' => [
				'name' => \XF::phrase('emoji.right_facing_fist_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':right_facing_fist_tone2:',
				'shortname_alternates' => [':right_fist_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤜🏼',
				'keywords' => ['fist', 'medium-light skin tone', 'rightwards', 'uc9'],
			],
			'1f91c-1f3fd' => [
				'name' => \XF::phrase('emoji.right_facing_fist_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':right_facing_fist_tone3:',
				'shortname_alternates' => [':right_fist_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤜🏽',
				'keywords' => ['fist', 'medium skin tone', 'rightwards', 'uc9'],
			],
			'1f91c-1f3fe' => [
				'name' => \XF::phrase('emoji.right_facing_fist_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':right_facing_fist_tone4:',
				'shortname_alternates' => [':right_fist_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤜🏾',
				'keywords' => ['fist', 'medium-dark skin tone', 'rightwards', 'uc9'],
			],
			'1f91c-1f3ff' => [
				'name' => \XF::phrase('emoji.right_facing_fist_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':right_facing_fist_tone5:',
				'shortname_alternates' => [':right_fist_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤜🏿',
				'keywords' => ['dark skin tone', 'fist', 'rightwards', 'uc9'],
			],
			'1faf7' => [
				'name' => \XF::phrase('emoji.leftwards_pushing_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':leftwards_pushing_hand:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1faf7-1f3fb', '1faf7-1f3fc', '1faf7-1f3fd', '1faf7-1f3fe', '1faf7-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫷',
				'keywords' => ['uc15'],
			],
			'1faf7-1f3fb' => [
				'name' => \XF::phrase('emoji.leftwards_pushing_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':leftwards_pushing_hand_tone1:',
				'shortname_alternates' => [':leftwards_pushing_hand_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫷🏻',
				'keywords' => ['uc15'],
			],
			'1faf7-1f3fc' => [
				'name' => \XF::phrase('emoji.leftwards_pushing_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':leftwards_pushing_hand_tone2:',
				'shortname_alternates' => [':leftwards_pushing_hand_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫷🏼',
				'keywords' => ['uc15'],
			],
			'1faf7-1f3fd' => [
				'name' => \XF::phrase('emoji.leftwards_pushing_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':leftwards_pushing_hand_tone3:',
				'shortname_alternates' => [':leftwards_pushing_hand_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫷🏽',
				'keywords' => ['uc15'],
			],
			'1faf7-1f3fe' => [
				'name' => \XF::phrase('emoji.leftwards_pushing_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':leftwards_pushing_hand_tone4:',
				'shortname_alternates' => [':leftwards_pushing_hand_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫷🏾',
				'keywords' => ['uc15'],
			],
			'1faf7-1f3ff' => [
				'name' => \XF::phrase('emoji.leftwards_pushing_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':leftwards_pushing_hand_tone5:',
				'shortname_alternates' => [':leftwards_pushing_hand_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫷🏿',
				'keywords' => ['uc15'],
			],
			'1faf8' => [
				'name' => \XF::phrase('emoji.rightwards_pushing_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':rightwards_pushing_hand:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1faf8-1f3fb', '1faf8-1f3fc', '1faf8-1f3fd', '1faf8-1f3fe', '1faf8-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫸',
				'keywords' => ['uc15'],
			],
			'1faf8-1f3fb' => [
				'name' => \XF::phrase('emoji.rightwards_pushing_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':rightwards_pushing_hand_tone1:',
				'shortname_alternates' => [':rightwards_pushing_hand_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫸🏻',
				'keywords' => ['uc15'],
			],
			'1faf8-1f3fc' => [
				'name' => \XF::phrase('emoji.rightwards_pushing_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':rightwards_pushing_hand_tone2:',
				'shortname_alternates' => [':rightwards_pushing_hand_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫸🏼',
				'keywords' => ['uc15'],
			],
			'1faf8-1f3fd' => [
				'name' => \XF::phrase('emoji.rightwards_pushing_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':rightwards_pushing_hand_tone3:',
				'shortname_alternates' => [':rightwards_pushing_hand_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫸🏽',
				'keywords' => ['uc15'],
			],
			'1faf8-1f3fe' => [
				'name' => \XF::phrase('emoji.rightwards_pushing_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':rightwards_pushing_hand_tone4:',
				'shortname_alternates' => [':rightwards_pushing_hand_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫸🏾',
				'keywords' => ['uc15'],
			],
			'1faf8-1f3ff' => [
				'name' => \XF::phrase('emoji.rightwards_pushing_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':rightwards_pushing_hand_tone5:',
				'shortname_alternates' => [':rightwards_pushing_hand_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫸🏿',
				'keywords' => ['uc15'],
			],
			'1f91e' => [
				'name' => \XF::phrase('emoji.fingers_crossed'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fingers_crossed:',
				'shortname_alternates' => [':hand_with_index_and_middle_finger_crossed:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f91e-1f3fb', '1f91e-1f3fc', '1f91e-1f3fd', '1f91e-1f3fe', '1f91e-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤞',
				'keywords' => ['cross', 'finger', 'hand', 'luck', 'uc9'],
			],
			'1f91e-1f3fb' => [
				'name' => \XF::phrase('emoji.fingers_crossed_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fingers_crossed_tone1:',
				'shortname_alternates' => [':hand_with_index_and_middle_fingers_crossed_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤞🏻',
				'keywords' => ['cross', 'finger', 'hand', 'light skin tone', 'luck', 'uc9'],
			],
			'1f91e-1f3fc' => [
				'name' => \XF::phrase('emoji.fingers_crossed_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fingers_crossed_tone2:',
				'shortname_alternates' => [':hand_with_index_and_middle_fingers_crossed_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤞🏼',
				'keywords' => ['cross', 'finger', 'hand', 'luck', 'medium-light skin tone', 'uc9'],
			],
			'1f91e-1f3fd' => [
				'name' => \XF::phrase('emoji.fingers_crossed_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fingers_crossed_tone3:',
				'shortname_alternates' => [':hand_with_index_and_middle_fingers_crossed_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤞🏽',
				'keywords' => ['cross', 'finger', 'hand', 'luck', 'medium skin tone', 'uc9'],
			],
			'1f91e-1f3fe' => [
				'name' => \XF::phrase('emoji.fingers_crossed_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fingers_crossed_tone4:',
				'shortname_alternates' => [':hand_with_index_and_middle_fingers_crossed_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤞🏾',
				'keywords' => ['cross', 'finger', 'hand', 'luck', 'medium-dark skin tone', 'uc9'],
			],
			'1f91e-1f3ff' => [
				'name' => \XF::phrase('emoji.fingers_crossed_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fingers_crossed_tone5:',
				'shortname_alternates' => [':hand_with_index_and_middle_fingers_crossed_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤞🏿',
				'keywords' => ['cross', 'dark skin tone', 'finger', 'hand', 'luck', 'uc9'],
			],
			'270c' => [
				'name' => \XF::phrase('emoji.v'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':v:',
				'shortname_alternates' => [':victory_hand:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['270c-1f3fb', '270c-1f3fc', '270c-1f3fd', '270c-1f3fe', '270c-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '✌️',
				'keywords' => ['hand', 'v', 'victory', 'uc1'],
			],
			'270c-1f3fb' => [
				'name' => \XF::phrase('emoji.v_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':v_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '✌🏻',
				'keywords' => ['hand', 'light skin tone', 'v', 'victory', 'uc8'],
			],
			'270c-1f3fc' => [
				'name' => \XF::phrase('emoji.v_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':v_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '✌🏼',
				'keywords' => ['hand', 'medium-light skin tone', 'v', 'victory', 'uc8'],
			],
			'270c-1f3fd' => [
				'name' => \XF::phrase('emoji.v_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':v_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '✌🏽',
				'keywords' => ['hand', 'medium skin tone', 'v', 'victory', 'uc8'],
			],
			'270c-1f3fe' => [
				'name' => \XF::phrase('emoji.v_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':v_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '✌🏾',
				'keywords' => ['hand', 'medium-dark skin tone', 'v', 'victory', 'uc8'],
			],
			'270c-1f3ff' => [
				'name' => \XF::phrase('emoji.v_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':v_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '✌🏿',
				'keywords' => ['dark skin tone', 'hand', 'v', 'victory', 'uc8'],
			],
			'1faf0' => [
				'name' => \XF::phrase('emoji.hand_with_index_finger_and_thumb_crossed'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hand_with_index_finger_and_thumb_crossed:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1faf0-1f3fb', '1faf0-1f3fc', '1faf0-1f3fd', '1faf0-1f3fe', '1faf0-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫰',
				'keywords' => ['uc14'],
			],
			'1faf0-1f3fb' => [
				'name' => \XF::phrase('emoji.hand_with_index_finger_and_thumb_crossed_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hand_with_index_finger_and_thumb_crossed_tone1:',
				'shortname_alternates' => [':hand_with_index_finger_and_thumb_crossed_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫰🏻',
				'keywords' => ['uc14'],
			],
			'1faf0-1f3fc' => [
				'name' => \XF::phrase('emoji.hand_with_index_finger_and_thumb_crossed_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hand_with_index_finger_and_thumb_crossed_tone2:',
				'shortname_alternates' => [':hand_with_index_finger_and_thumb_crossed_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫰🏼',
				'keywords' => ['uc14'],
			],
			'1faf0-1f3fd' => [
				'name' => \XF::phrase('emoji.hand_with_index_finger_and_thumb_crossed_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hand_with_index_finger_and_thumb_crossed_tone3:',
				'shortname_alternates' => [':hand_with_index_finger_and_thumb_crossed_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫰🏽',
				'keywords' => ['uc14'],
			],
			'1faf0-1f3fe' => [
				'name' => \XF::phrase('emoji.hand_with_index_finger_and_thumb_crossed_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hand_with_index_finger_and_thumb_crossed_tone4:',
				'shortname_alternates' => [':hand_with_index_finger_and_thumb_crossed_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫰🏾',
				'keywords' => ['uc14'],
			],
			'1faf0-1f3ff' => [
				'name' => \XF::phrase('emoji.hand_with_index_finger_and_thumb_crossed_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hand_with_index_finger_and_thumb_crossed_tone5:',
				'shortname_alternates' => [':hand_with_index_finger_and_thumb_crossed_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫰🏿',
				'keywords' => ['uc14'],
			],
			'1f91f' => [
				'name' => \XF::phrase('emoji.love_you_gesture'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':love_you_gesture:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f91f-1f3fb', '1f91f-1f3fc', '1f91f-1f3fd', '1f91f-1f3fe', '1f91f-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤟',
				'keywords' => ['ILY', 'hand', 'uc10'],
			],
			'1f91f-1f3fb' => [
				'name' => \XF::phrase('emoji.love_you_gesture_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':love_you_gesture_tone1:',
				'shortname_alternates' => [':love_you_gesture_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤟🏻',
				'keywords' => ['ILY', 'hand', 'light skin tone', 'uc10'],
			],
			'1f91f-1f3fc' => [
				'name' => \XF::phrase('emoji.love_you_gesture_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':love_you_gesture_tone2:',
				'shortname_alternates' => [':love_you_gesture_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤟🏼',
				'keywords' => ['ILY', 'hand', 'medium-light skin tone', 'uc10'],
			],
			'1f91f-1f3fd' => [
				'name' => \XF::phrase('emoji.love_you_gesture_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':love_you_gesture_tone3:',
				'shortname_alternates' => [':love_you_gesture_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤟🏽',
				'keywords' => ['ILY', 'hand', 'medium skin tone', 'uc10'],
			],
			'1f91f-1f3fe' => [
				'name' => \XF::phrase('emoji.love_you_gesture_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':love_you_gesture_tone4:',
				'shortname_alternates' => [':love_you_gesture_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤟🏾',
				'keywords' => ['ILY', 'hand', 'medium-dark skin tone', 'uc10'],
			],
			'1f91f-1f3ff' => [
				'name' => \XF::phrase('emoji.love_you_gesture_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':love_you_gesture_tone5:',
				'shortname_alternates' => [':love_you_gesture_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤟🏿',
				'keywords' => ['ILY', 'dark skin tone', 'hand', 'uc10'],
			],
			'1f918' => [
				'name' => \XF::phrase('emoji.metal'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':metal:',
				'shortname_alternates' => [':sign_of_the_horns:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f918-1f3fb', '1f918-1f3fc', '1f918-1f3fd', '1f918-1f3fe', '1f918-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤘',
				'keywords' => ['finger', 'hand', 'horns', 'rock-on', 'uc8'],
			],
			'1f918-1f3fb' => [
				'name' => \XF::phrase('emoji.metal_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':metal_tone1:',
				'shortname_alternates' => [':sign_of_the_horns_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤘🏻',
				'keywords' => ['finger', 'hand', 'horns', 'light skin tone', 'rock-on', 'uc8'],
			],
			'1f918-1f3fc' => [
				'name' => \XF::phrase('emoji.metal_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':metal_tone2:',
				'shortname_alternates' => [':sign_of_the_horns_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤘🏼',
				'keywords' => ['finger', 'hand', 'horns', 'medium-light skin tone', 'rock-on', 'uc8'],
			],
			'1f918-1f3fd' => [
				'name' => \XF::phrase('emoji.metal_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':metal_tone3:',
				'shortname_alternates' => [':sign_of_the_horns_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤘🏽',
				'keywords' => ['finger', 'hand', 'horns', 'medium skin tone', 'rock-on', 'uc8'],
			],
			'1f918-1f3fe' => [
				'name' => \XF::phrase('emoji.metal_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':metal_tone4:',
				'shortname_alternates' => [':sign_of_the_horns_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤘🏾',
				'keywords' => ['finger', 'hand', 'horns', 'medium-dark skin tone', 'rock-on', 'uc8'],
			],
			'1f918-1f3ff' => [
				'name' => \XF::phrase('emoji.metal_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':metal_tone5:',
				'shortname_alternates' => [':sign_of_the_horns_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤘🏿',
				'keywords' => ['dark skin tone', 'finger', 'hand', 'horns', 'rock-on', 'uc8'],
			],
			'1f44c' => [
				'name' => \XF::phrase('emoji.ok_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ok_hand:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f44c-1f3fb', '1f44c-1f3fc', '1f44c-1f3fd', '1f44c-1f3fe', '1f44c-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👌',
				'keywords' => ['OK', 'hand', 'uc6'],
			],
			'1f44c-1f3fb' => [
				'name' => \XF::phrase('emoji.ok_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ok_hand_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👌🏻',
				'keywords' => ['OK', 'hand', 'light skin tone', 'uc8'],
			],
			'1f44c-1f3fc' => [
				'name' => \XF::phrase('emoji.ok_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ok_hand_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👌🏼',
				'keywords' => ['OK', 'hand', 'medium-light skin tone', 'uc8'],
			],
			'1f44c-1f3fd' => [
				'name' => \XF::phrase('emoji.ok_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ok_hand_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👌🏽',
				'keywords' => ['OK', 'hand', 'medium skin tone', 'uc8'],
			],
			'1f44c-1f3fe' => [
				'name' => \XF::phrase('emoji.ok_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ok_hand_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👌🏾',
				'keywords' => ['OK', 'hand', 'medium-dark skin tone', 'uc8'],
			],
			'1f44c-1f3ff' => [
				'name' => \XF::phrase('emoji.ok_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ok_hand_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👌🏿',
				'keywords' => ['OK', 'dark skin tone', 'hand', 'uc8'],
			],
			'1f90c' => [
				'name' => \XF::phrase('emoji.pinched_fingers'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pinched_fingers:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f90c-1f3fb', '1f90c-1f3fc', '1f90c-1f3fd', '1f90c-1f3fe', '1f90c-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤌',
				'keywords' => ['uc13'],
			],
			'1f90c-1f3fc' => [
				'name' => \XF::phrase('emoji.pinched_fingers_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pinched_fingers_tone2:',
				'shortname_alternates' => [':pinched_fingers_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤌🏼',
				'keywords' => ['uc13'],
			],
			'1f90c-1f3fb' => [
				'name' => \XF::phrase('emoji.pinched_fingers_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pinched_fingers_tone1:',
				'shortname_alternates' => [':pinched_fingers_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤌🏻',
				'keywords' => ['uc13'],
			],
			'1f90c-1f3fd' => [
				'name' => \XF::phrase('emoji.pinched_fingers_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pinched_fingers_tone3:',
				'shortname_alternates' => [':pinched_fingers_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤌🏽',
				'keywords' => ['uc13'],
			],
			'1f90c-1f3fe' => [
				'name' => \XF::phrase('emoji.pinched_fingers_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pinched_fingers_tone4:',
				'shortname_alternates' => [':pinched_fingers_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤌🏾',
				'keywords' => ['uc13'],
			],
			'1f90c-1f3ff' => [
				'name' => \XF::phrase('emoji.pinched_fingers_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pinched_fingers_tone5:',
				'shortname_alternates' => [':pinched_fingers_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤌🏿',
				'keywords' => ['uc13'],
			],
			'1f90f' => [
				'name' => \XF::phrase('emoji.pinching_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pinching_hand:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f90f-1f3fb', '1f90f-1f3fc', '1f90f-1f3fd', '1f90f-1f3fe', '1f90f-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤏',
				'keywords' => ['uc12'],
			],
			'1f90f-1f3fb' => [
				'name' => \XF::phrase('emoji.pinching_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pinching_hand_tone1:',
				'shortname_alternates' => [':pinching_hand_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤏🏻',
				'keywords' => ['uc12'],
			],
			'1f90f-1f3fc' => [
				'name' => \XF::phrase('emoji.pinching_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pinching_hand_tone2:',
				'shortname_alternates' => [':pinching_hand_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤏🏼',
				'keywords' => ['uc12'],
			],
			'1f90f-1f3fd' => [
				'name' => \XF::phrase('emoji.pinching_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pinching_hand_tone3:',
				'shortname_alternates' => [':pinching_hand_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤏🏽',
				'keywords' => ['uc12'],
			],
			'1f90f-1f3fe' => [
				'name' => \XF::phrase('emoji.pinching_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pinching_hand_tone4:',
				'shortname_alternates' => [':pinching_hand_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤏🏾',
				'keywords' => ['uc12'],
			],
			'1f90f-1f3ff' => [
				'name' => \XF::phrase('emoji.pinching_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pinching_hand_tone5:',
				'shortname_alternates' => [':pinching_hand_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤏🏿',
				'keywords' => ['uc12'],
			],
			'1faf3' => [
				'name' => \XF::phrase('emoji.palm_down_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':palm_down_hand:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1faf3-1f3fb', '1faf3-1f3fc', '1faf3-1f3fd', '1faf3-1f3fe', '1faf3-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫳',
				'keywords' => ['uc14'],
			],
			'1faf3-1f3fb' => [
				'name' => \XF::phrase('emoji.palm_down_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':palm_down_hand_tone1:',
				'shortname_alternates' => [':palm_down_hand_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫳🏻',
				'keywords' => ['uc14'],
			],
			'1faf3-1f3fc' => [
				'name' => \XF::phrase('emoji.palm_down_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':palm_down_hand_tone2:',
				'shortname_alternates' => [':palm_down_hand_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫳🏼',
				'keywords' => ['uc14'],
			],
			'1faf3-1f3fd' => [
				'name' => \XF::phrase('emoji.palm_down_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':palm_down_hand_tone3:',
				'shortname_alternates' => [':palm_down_hand_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫳🏽',
				'keywords' => ['uc14'],
			],
			'1faf3-1f3fe' => [
				'name' => \XF::phrase('emoji.palm_down_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':palm_down_hand_tone4:',
				'shortname_alternates' => [':palm_down_hand_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫳🏾',
				'keywords' => ['uc14'],
			],
			'1faf3-1f3ff' => [
				'name' => \XF::phrase('emoji.palm_down_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':palm_down_hand_tone5:',
				'shortname_alternates' => [':palm_down_hand_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫳🏿',
				'keywords' => ['uc14'],
			],
			'1faf4' => [
				'name' => \XF::phrase('emoji.palm_up_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':palm_up_hand:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1faf4-1f3fb', '1faf4-1f3fc', '1faf4-1f3fd', '1faf4-1f3fe', '1faf4-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫴',
				'keywords' => ['uc14'],
			],
			'1faf4-1f3fb' => [
				'name' => \XF::phrase('emoji.palm_up_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':palm_up_hand_tone1:',
				'shortname_alternates' => [':palm_up_hand_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫴🏻',
				'keywords' => ['uc14'],
			],
			'1faf4-1f3fc' => [
				'name' => \XF::phrase('emoji.palm_up_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':palm_up_hand_tone2:',
				'shortname_alternates' => [':palm_up_hand_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫴🏼',
				'keywords' => ['uc14'],
			],
			'1faf4-1f3fd' => [
				'name' => \XF::phrase('emoji.palm_up_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':palm_up_hand_tone3:',
				'shortname_alternates' => [':palm_up_hand_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫴🏽',
				'keywords' => ['uc14'],
			],
			'1faf4-1f3fe' => [
				'name' => \XF::phrase('emoji.palm_up_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':palm_up_hand_tone4:',
				'shortname_alternates' => [':palm_up_hand_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫴🏾',
				'keywords' => ['uc14'],
			],
			'1faf4-1f3ff' => [
				'name' => \XF::phrase('emoji.palm_up_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':palm_up_hand_tone5:',
				'shortname_alternates' => [':palm_up_hand_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫴🏿',
				'keywords' => ['uc14'],
			],
			'1f448' => [
				'name' => \XF::phrase('emoji.point_left'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_left:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f448-1f3fb', '1f448-1f3fc', '1f448-1f3fd', '1f448-1f3fe', '1f448-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👈',
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'point', 'uc6'],
			],
			'1f448-1f3fb' => [
				'name' => \XF::phrase('emoji.point_left_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_left_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👈🏻',
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'light skin tone', 'point', 'uc8'],
			],
			'1f448-1f3fc' => [
				'name' => \XF::phrase('emoji.point_left_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_left_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👈🏼',
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'medium-light skin tone', 'point', 'uc8'],
			],
			'1f448-1f3fd' => [
				'name' => \XF::phrase('emoji.point_left_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_left_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👈🏽',
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'medium skin tone', 'point', 'uc8'],
			],
			'1f448-1f3fe' => [
				'name' => \XF::phrase('emoji.point_left_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_left_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👈🏾',
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'medium-dark skin tone', 'point', 'uc8'],
			],
			'1f448-1f3ff' => [
				'name' => \XF::phrase('emoji.point_left_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_left_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👈🏿',
				'keywords' => ['backhand', 'dark skin tone', 'finger', 'hand', 'index', 'point', 'uc8'],
			],
			'1f449' => [
				'name' => \XF::phrase('emoji.point_right'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_right:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f449-1f3fb', '1f449-1f3fc', '1f449-1f3fd', '1f449-1f3fe', '1f449-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👉',
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'point', 'uc6'],
			],
			'1f449-1f3fb' => [
				'name' => \XF::phrase('emoji.point_right_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_right_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👉🏻',
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'light skin tone', 'point', 'uc8'],
			],
			'1f449-1f3fc' => [
				'name' => \XF::phrase('emoji.point_right_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_right_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👉🏼',
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'medium-light skin tone', 'point', 'uc8'],
			],
			'1f449-1f3fd' => [
				'name' => \XF::phrase('emoji.point_right_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_right_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👉🏽',
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'medium skin tone', 'point', 'uc8'],
			],
			'1f449-1f3fe' => [
				'name' => \XF::phrase('emoji.point_right_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_right_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👉🏾',
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'medium-dark skin tone', 'point', 'uc8'],
			],
			'1f449-1f3ff' => [
				'name' => \XF::phrase('emoji.point_right_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_right_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👉🏿',
				'keywords' => ['backhand', 'dark skin tone', 'finger', 'hand', 'index', 'point', 'uc8'],
			],
			'1f446' => [
				'name' => \XF::phrase('emoji.point_up_2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up_2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f446-1f3fb', '1f446-1f3fc', '1f446-1f3fd', '1f446-1f3fe', '1f446-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👆',
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'point', 'up', 'uc6'],
			],
			'1f446-1f3fb' => [
				'name' => \XF::phrase('emoji.point_up_2_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up_2_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👆🏻',
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'light skin tone', 'point', 'up', 'uc8'],
			],
			'1f446-1f3fc' => [
				'name' => \XF::phrase('emoji.point_up_2_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up_2_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👆🏼',
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'medium-light skin tone', 'point', 'up', 'uc8'],
			],
			'1f446-1f3fd' => [
				'name' => \XF::phrase('emoji.point_up_2_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up_2_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👆🏽',
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'medium skin tone', 'point', 'up', 'uc8'],
			],
			'1f446-1f3fe' => [
				'name' => \XF::phrase('emoji.point_up_2_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up_2_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👆🏾',
				'keywords' => ['backhand', 'finger', 'hand', 'index', 'medium-dark skin tone', 'point', 'up', 'uc8'],
			],
			'1f446-1f3ff' => [
				'name' => \XF::phrase('emoji.point_up_2_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up_2_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👆🏿',
				'keywords' => ['backhand', 'dark skin tone', 'finger', 'hand', 'index', 'point', 'up', 'uc8'],
			],
			'1f447' => [
				'name' => \XF::phrase('emoji.point_down'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_down:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f447-1f3fb', '1f447-1f3fc', '1f447-1f3fd', '1f447-1f3fe', '1f447-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👇',
				'keywords' => ['backhand', 'down', 'finger', 'hand', 'index', 'point', 'uc6'],
			],
			'1f447-1f3fb' => [
				'name' => \XF::phrase('emoji.point_down_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_down_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👇🏻',
				'keywords' => ['backhand', 'down', 'finger', 'hand', 'index', 'light skin tone', 'point', 'uc8'],
			],
			'1f447-1f3fc' => [
				'name' => \XF::phrase('emoji.point_down_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_down_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👇🏼',
				'keywords' => ['backhand', 'down', 'finger', 'hand', 'index', 'medium-light skin tone', 'point', 'uc8'],
			],
			'1f447-1f3fd' => [
				'name' => \XF::phrase('emoji.point_down_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_down_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👇🏽',
				'keywords' => ['backhand', 'down', 'finger', 'hand', 'index', 'medium skin tone', 'point', 'uc8'],
			],
			'1f447-1f3fe' => [
				'name' => \XF::phrase('emoji.point_down_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_down_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👇🏾',
				'keywords' => ['backhand', 'down', 'finger', 'hand', 'index', 'medium-dark skin tone', 'point', 'uc8'],
			],
			'1f447-1f3ff' => [
				'name' => \XF::phrase('emoji.point_down_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_down_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👇🏿',
				'keywords' => ['backhand', 'dark skin tone', 'down', 'finger', 'hand', 'index', 'point', 'uc8'],
			],
			'261d' => [
				'name' => \XF::phrase('emoji.point_up'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['261d-1f3fb', '261d-1f3fc', '261d-1f3fd', '261d-1f3fe', '261d-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '☝️',
				'keywords' => ['finger', 'hand', 'index', 'point', 'up', 'uc1'],
			],
			'261d-1f3fb' => [
				'name' => \XF::phrase('emoji.point_up_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '☝🏻',
				'keywords' => ['finger', 'hand', 'index', 'light skin tone', 'point', 'up', 'uc8'],
			],
			'261d-1f3fc' => [
				'name' => \XF::phrase('emoji.point_up_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '☝🏼',
				'keywords' => ['finger', 'hand', 'index', 'medium-light skin tone', 'point', 'up', 'uc8'],
			],
			'261d-1f3fd' => [
				'name' => \XF::phrase('emoji.point_up_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '☝🏽',
				'keywords' => ['finger', 'hand', 'index', 'medium skin tone', 'point', 'up', 'uc8'],
			],
			'261d-1f3fe' => [
				'name' => \XF::phrase('emoji.point_up_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '☝🏾',
				'keywords' => ['finger', 'hand', 'index', 'medium-dark skin tone', 'point', 'up', 'uc8'],
			],
			'261d-1f3ff' => [
				'name' => \XF::phrase('emoji.point_up_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':point_up_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '☝🏿',
				'keywords' => ['dark skin tone', 'finger', 'hand', 'index', 'point', 'up', 'uc8'],
			],
			'270b' => [
				'name' => \XF::phrase('emoji.raised_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hand:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['270b-1f3fb', '270b-1f3fc', '270b-1f3fd', '270b-1f3fe', '270b-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '✋',
				'keywords' => ['hand', 'uc6'],
			],
			'270b-1f3fb' => [
				'name' => \XF::phrase('emoji.raised_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hand_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '✋🏻',
				'keywords' => ['hand', 'light skin tone', 'uc8'],
			],
			'270b-1f3fc' => [
				'name' => \XF::phrase('emoji.raised_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hand_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '✋🏼',
				'keywords' => ['hand', 'medium-light skin tone', 'uc8'],
			],
			'270b-1f3fd' => [
				'name' => \XF::phrase('emoji.raised_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hand_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '✋🏽',
				'keywords' => ['hand', 'medium skin tone', 'uc8'],
			],
			'270b-1f3fe' => [
				'name' => \XF::phrase('emoji.raised_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hand_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '✋🏾',
				'keywords' => ['hand', 'medium-dark skin tone', 'uc8'],
			],
			'270b-1f3ff' => [
				'name' => \XF::phrase('emoji.raised_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_hand_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '✋🏿',
				'keywords' => ['dark skin tone', 'hand', 'uc8'],
			],
			'1f91a' => [
				'name' => \XF::phrase('emoji.raised_back_of_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_back_of_hand:',
				'shortname_alternates' => [':back_of_hand:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f91a-1f3fb', '1f91a-1f3fc', '1f91a-1f3fd', '1f91a-1f3fe', '1f91a-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤚',
				'keywords' => ['backhand', 'raised', 'uc9'],
			],
			'1f91a-1f3fb' => [
				'name' => \XF::phrase('emoji.raised_back_of_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_back_of_hand_tone1:',
				'shortname_alternates' => [':back_of_hand_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤚🏻',
				'keywords' => ['backhand', 'light skin tone', 'raised', 'uc9'],
			],
			'1f91a-1f3fc' => [
				'name' => \XF::phrase('emoji.raised_back_of_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_back_of_hand_tone2:',
				'shortname_alternates' => [':back_of_hand_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤚🏼',
				'keywords' => ['backhand', 'medium-light skin tone', 'raised', 'uc9'],
			],
			'1f91a-1f3fd' => [
				'name' => \XF::phrase('emoji.raised_back_of_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_back_of_hand_tone3:',
				'shortname_alternates' => [':back_of_hand_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤚🏽',
				'keywords' => ['backhand', 'medium skin tone', 'raised', 'uc9'],
			],
			'1f91a-1f3fe' => [
				'name' => \XF::phrase('emoji.raised_back_of_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_back_of_hand_tone4:',
				'shortname_alternates' => [':back_of_hand_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤚🏾',
				'keywords' => ['backhand', 'medium-dark skin tone', 'raised', 'uc9'],
			],
			'1f91a-1f3ff' => [
				'name' => \XF::phrase('emoji.raised_back_of_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':raised_back_of_hand_tone5:',
				'shortname_alternates' => [':back_of_hand_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤚🏿',
				'keywords' => ['backhand', 'dark skin tone', 'raised', 'uc9'],
			],
			'1f590' => [
				'name' => \XF::phrase('emoji.hand_splayed'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hand_splayed:',
				'shortname_alternates' => [':raised_hand_with_fingers_splayed:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f590-1f3fb', '1f590-1f3fc', '1f590-1f3fd', '1f590-1f3fe', '1f590-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🖐️',
				'keywords' => ['finger', 'hand', 'splayed', 'uc7'],
			],
			'1f590-1f3fb' => [
				'name' => \XF::phrase('emoji.hand_splayed_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hand_splayed_tone1:',
				'shortname_alternates' => [':raised_hand_with_fingers_splayed_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🖐🏻',
				'keywords' => ['finger', 'hand', 'light skin tone', 'splayed', 'uc8'],
			],
			'1f590-1f3fc' => [
				'name' => \XF::phrase('emoji.hand_splayed_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hand_splayed_tone2:',
				'shortname_alternates' => [':raised_hand_with_fingers_splayed_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🖐🏼',
				'keywords' => ['finger', 'hand', 'medium-light skin tone', 'splayed', 'uc8'],
			],
			'1f590-1f3fd' => [
				'name' => \XF::phrase('emoji.hand_splayed_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hand_splayed_tone3:',
				'shortname_alternates' => [':raised_hand_with_fingers_splayed_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🖐🏽',
				'keywords' => ['finger', 'hand', 'medium skin tone', 'splayed', 'uc8'],
			],
			'1f590-1f3fe' => [
				'name' => \XF::phrase('emoji.hand_splayed_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hand_splayed_tone4:',
				'shortname_alternates' => [':raised_hand_with_fingers_splayed_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🖐🏾',
				'keywords' => ['finger', 'hand', 'medium-dark skin tone', 'splayed', 'uc8'],
			],
			'1f590-1f3ff' => [
				'name' => \XF::phrase('emoji.hand_splayed_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':hand_splayed_tone5:',
				'shortname_alternates' => [':raised_hand_with_fingers_splayed_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🖐🏿',
				'keywords' => ['dark skin tone', 'finger', 'hand', 'splayed', 'uc8'],
			],
			'1f596' => [
				'name' => \XF::phrase('emoji.vulcan'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vulcan:',
				'shortname_alternates' => [':raised_hand_with_part_between_middle_and_ring_fingers:', ':vulcan_salute:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f596-1f3fb', '1f596-1f3fc', '1f596-1f3fd', '1f596-1f3fe', '1f596-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🖖',
				'keywords' => ['finger', 'hand', 'spock', 'vulcan', 'uc7'],
			],
			'1f596-1f3fb' => [
				'name' => \XF::phrase('emoji.vulcan_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vulcan_tone1:',
				'shortname_alternates' => [':raised_hand_with_part_between_middle_and_ring_fingers_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🖖🏻',
				'keywords' => ['finger', 'hand', 'light skin tone', 'spock', 'vulcan', 'uc8'],
			],
			'1f596-1f3fc' => [
				'name' => \XF::phrase('emoji.vulcan_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vulcan_tone2:',
				'shortname_alternates' => [':raised_hand_with_part_between_middle_and_ring_fingers_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🖖🏼',
				'keywords' => ['finger', 'hand', 'medium-light skin tone', 'spock', 'vulcan', 'uc8'],
			],
			'1f596-1f3fd' => [
				'name' => \XF::phrase('emoji.vulcan_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vulcan_tone3:',
				'shortname_alternates' => [':raised_hand_with_part_between_middle_and_ring_fingers_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🖖🏽',
				'keywords' => ['finger', 'hand', 'medium skin tone', 'spock', 'vulcan', 'uc8'],
			],
			'1f596-1f3fe' => [
				'name' => \XF::phrase('emoji.vulcan_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vulcan_tone4:',
				'shortname_alternates' => [':raised_hand_with_part_between_middle_and_ring_fingers_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🖖🏾',
				'keywords' => ['finger', 'hand', 'medium-dark skin tone', 'spock', 'vulcan', 'uc8'],
			],
			'1f596-1f3ff' => [
				'name' => \XF::phrase('emoji.vulcan_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vulcan_tone5:',
				'shortname_alternates' => [':raised_hand_with_part_between_middle_and_ring_fingers_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🖖🏿',
				'keywords' => ['dark skin tone', 'finger', 'hand', 'spock', 'vulcan', 'uc8'],
			],
			'1f44b' => [
				'name' => \XF::phrase('emoji.wave'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':wave:',
				'shortname_alternates' => [':waving_hand:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f44b-1f3fb', '1f44b-1f3fc', '1f44b-1f3fd', '1f44b-1f3fe', '1f44b-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👋',
				'keywords' => ['hand', 'wave', 'waving', 'uc6'],
			],
			'1f44b-1f3fb' => [
				'name' => \XF::phrase('emoji.wave_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':wave_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👋🏻',
				'keywords' => ['hand', 'light skin tone', 'wave', 'waving', 'uc8'],
			],
			'1f44b-1f3fc' => [
				'name' => \XF::phrase('emoji.wave_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':wave_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👋🏼',
				'keywords' => ['hand', 'medium-light skin tone', 'wave', 'waving', 'uc8'],
			],
			'1f44b-1f3fd' => [
				'name' => \XF::phrase('emoji.wave_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':wave_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👋🏽',
				'keywords' => ['hand', 'medium skin tone', 'wave', 'waving', 'uc8'],
			],
			'1f44b-1f3fe' => [
				'name' => \XF::phrase('emoji.wave_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':wave_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👋🏾',
				'keywords' => ['hand', 'medium-dark skin tone', 'wave', 'waving', 'uc8'],
			],
			'1f44b-1f3ff' => [
				'name' => \XF::phrase('emoji.wave_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':wave_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👋🏿',
				'keywords' => ['dark skin tone', 'hand', 'wave', 'waving', 'uc8'],
			],
			'1f919' => [
				'name' => \XF::phrase('emoji.call_me'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':call_me:',
				'shortname_alternates' => [':call_me_hand:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f919-1f3fb', '1f919-1f3fc', '1f919-1f3fd', '1f919-1f3fe', '1f919-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤙',
				'keywords' => ['call', 'hand', 'uc9'],
			],
			'1f919-1f3fb' => [
				'name' => \XF::phrase('emoji.call_me_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':call_me_tone1:',
				'shortname_alternates' => [':call_me_hand_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤙🏻',
				'keywords' => ['call', 'hand', 'light skin tone', 'uc9'],
			],
			'1f919-1f3fc' => [
				'name' => \XF::phrase('emoji.call_me_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':call_me_tone2:',
				'shortname_alternates' => [':call_me_hand_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤙🏼',
				'keywords' => ['call', 'hand', 'medium-light skin tone', 'uc9'],
			],
			'1f919-1f3fd' => [
				'name' => \XF::phrase('emoji.call_me_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':call_me_tone3:',
				'shortname_alternates' => [':call_me_hand_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤙🏽',
				'keywords' => ['call', 'hand', 'medium skin tone', 'uc9'],
			],
			'1f919-1f3fe' => [
				'name' => \XF::phrase('emoji.call_me_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':call_me_tone4:',
				'shortname_alternates' => [':call_me_hand_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤙🏾',
				'keywords' => ['call', 'hand', 'medium-dark skin tone', 'uc9'],
			],
			'1f919-1f3ff' => [
				'name' => \XF::phrase('emoji.call_me_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':call_me_tone5:',
				'shortname_alternates' => [':call_me_hand_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤙🏿',
				'keywords' => ['call', 'dark skin tone', 'hand', 'uc9'],
			],
			'1faf2' => [
				'name' => \XF::phrase('emoji.leftwards_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':leftwards_hand:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1faf2-1f3fb', '1faf2-1f3fc', '1faf2-1f3fd', '1faf2-1f3fe', '1faf2-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫲',
				'keywords' => ['uc14'],
			],
			'1faf2-1f3fb' => [
				'name' => \XF::phrase('emoji.leftwards_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':leftwards_hand_tone1:',
				'shortname_alternates' => [':leftwards_hand_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫲🏻',
				'keywords' => ['uc14'],
			],
			'1faf2-1f3fc' => [
				'name' => \XF::phrase('emoji.leftwards_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':leftwards_hand_tone2:',
				'shortname_alternates' => [':leftwards_hand_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫲🏼',
				'keywords' => ['uc14'],
			],
			'1faf2-1f3fd' => [
				'name' => \XF::phrase('emoji.leftwards_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':leftwards_hand_tone3:',
				'shortname_alternates' => [':leftwards_hand_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫲🏽',
				'keywords' => ['uc14'],
			],
			'1faf2-1f3fe' => [
				'name' => \XF::phrase('emoji.leftwards_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':leftwards_hand_tone4:',
				'shortname_alternates' => [':leftwards_hand_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫲🏾',
				'keywords' => ['uc14'],
			],
			'1faf2-1f3ff' => [
				'name' => \XF::phrase('emoji.leftwards_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':leftwards_hand_tone5:',
				'shortname_alternates' => [':leftwards_hand_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫲🏿',
				'keywords' => ['uc14'],
			],
			'1faf1' => [
				'name' => \XF::phrase('emoji.rightwards_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':rightwards_hand:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1faf1-1f3fb', '1faf1-1f3fc', '1faf1-1f3fd', '1faf1-1f3fe', '1faf1-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫱',
				'keywords' => ['uc14'],
			],
			'1faf1-1f3fb' => [
				'name' => \XF::phrase('emoji.rightwards_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':rightwards_hand_tone1:',
				'shortname_alternates' => [':rightwards_hand_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫱🏻',
				'keywords' => ['uc14'],
			],
			'1faf1-1f3fc' => [
				'name' => \XF::phrase('emoji.rightwards_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':rightwards_hand_tone2:',
				'shortname_alternates' => [':rightwards_hand_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫱🏼',
				'keywords' => ['uc14'],
			],
			'1faf1-1f3fd' => [
				'name' => \XF::phrase('emoji.rightwards_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':rightwards_hand_tone3:',
				'shortname_alternates' => [':rightwards_hand_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫱🏽',
				'keywords' => ['uc14'],
			],
			'1faf1-1f3fe' => [
				'name' => \XF::phrase('emoji.rightwards_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':rightwards_hand_tone4:',
				'shortname_alternates' => [':rightwards_hand_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫱🏾',
				'keywords' => ['uc14'],
			],
			'1faf1-1f3ff' => [
				'name' => \XF::phrase('emoji.rightwards_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':rightwards_hand_tone5:',
				'shortname_alternates' => [':rightwards_hand_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫱🏿',
				'keywords' => ['uc14'],
			],
			'1f4aa' => [
				'name' => \XF::phrase('emoji.muscle'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':muscle:',
				'shortname_alternates' => [':flexed_biceps:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f4aa-1f3fb', '1f4aa-1f3fc', '1f4aa-1f3fd', '1f4aa-1f3fe', '1f4aa-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '💪',
				'keywords' => ['biceps', 'comic', 'flex', 'muscle', 'uc6'],
			],
			'1f4aa-1f3fb' => [
				'name' => \XF::phrase('emoji.muscle_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':muscle_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '💪🏻',
				'keywords' => ['biceps', 'comic', 'flex', 'light skin tone', 'muscle', 'uc8'],
			],
			'1f4aa-1f3fc' => [
				'name' => \XF::phrase('emoji.muscle_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':muscle_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '💪🏼',
				'keywords' => ['biceps', 'comic', 'flex', 'medium-light skin tone', 'muscle', 'uc8'],
			],
			'1f4aa-1f3fd' => [
				'name' => \XF::phrase('emoji.muscle_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':muscle_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '💪🏽',
				'keywords' => ['biceps', 'comic', 'flex', 'medium skin tone', 'muscle', 'uc8'],
			],
			'1f4aa-1f3fe' => [
				'name' => \XF::phrase('emoji.muscle_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':muscle_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '💪🏾',
				'keywords' => ['biceps', 'comic', 'flex', 'medium-dark skin tone', 'muscle', 'uc8'],
			],
			'1f4aa-1f3ff' => [
				'name' => \XF::phrase('emoji.muscle_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':muscle_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '💪🏿',
				'keywords' => ['biceps', 'comic', 'dark skin tone', 'flex', 'muscle', 'uc8'],
			],
			'1f9be' => [
				'name' => \XF::phrase('emoji.mechanical_arm'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mechanical_arm:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🦾',
				'keywords' => ['uc12'],
			],
			'1f595' => [
				'name' => \XF::phrase('emoji.middle_finger'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':middle_finger:',
				'shortname_alternates' => [':reversed_hand_with_middle_finger_extended:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f595-1f3fb', '1f595-1f3fc', '1f595-1f3fd', '1f595-1f3fe', '1f595-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🖕',
				'keywords' => ['finger', 'hand', 'uc7'],
			],
			'1f595-1f3fb' => [
				'name' => \XF::phrase('emoji.middle_finger_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':middle_finger_tone1:',
				'shortname_alternates' => [':reversed_hand_with_middle_finger_extended_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🖕🏻',
				'keywords' => ['finger', 'hand', 'light skin tone', 'uc8'],
			],
			'1f595-1f3fc' => [
				'name' => \XF::phrase('emoji.middle_finger_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':middle_finger_tone2:',
				'shortname_alternates' => [':reversed_hand_with_middle_finger_extended_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🖕🏼',
				'keywords' => ['finger', 'hand', 'medium-light skin tone', 'uc8'],
			],
			'1f595-1f3fd' => [
				'name' => \XF::phrase('emoji.middle_finger_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':middle_finger_tone3:',
				'shortname_alternates' => [':reversed_hand_with_middle_finger_extended_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🖕🏽',
				'keywords' => ['finger', 'hand', 'medium skin tone', 'uc8'],
			],
			'1f595-1f3fe' => [
				'name' => \XF::phrase('emoji.middle_finger_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':middle_finger_tone4:',
				'shortname_alternates' => [':reversed_hand_with_middle_finger_extended_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🖕🏾',
				'keywords' => ['finger', 'hand', 'medium-dark skin tone', 'uc8'],
			],
			'1f595-1f3ff' => [
				'name' => \XF::phrase('emoji.middle_finger_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':middle_finger_tone5:',
				'shortname_alternates' => [':reversed_hand_with_middle_finger_extended_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🖕🏿',
				'keywords' => ['dark skin tone', 'finger', 'hand', 'uc8'],
			],
			'270d' => [
				'name' => \XF::phrase('emoji.writing_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':writing_hand:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['270d-1f3fb', '270d-1f3fc', '270d-1f3fd', '270d-1f3fe', '270d-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '✍️',
				'keywords' => ['hand', 'write', 'uc1'],
			],
			'270d-1f3fb' => [
				'name' => \XF::phrase('emoji.writing_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':writing_hand_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '✍🏻',
				'keywords' => ['hand', 'light skin tone', 'write', 'uc8'],
			],
			'270d-1f3fc' => [
				'name' => \XF::phrase('emoji.writing_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':writing_hand_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '✍🏼',
				'keywords' => ['hand', 'medium-light skin tone', 'write', 'uc8'],
			],
			'270d-1f3fd' => [
				'name' => \XF::phrase('emoji.writing_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':writing_hand_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '✍🏽',
				'keywords' => ['hand', 'medium skin tone', 'write', 'uc8'],
			],
			'270d-1f3fe' => [
				'name' => \XF::phrase('emoji.writing_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':writing_hand_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '✍🏾',
				'keywords' => ['hand', 'medium-dark skin tone', 'write', 'uc8'],
			],
			'270d-1f3ff' => [
				'name' => \XF::phrase('emoji.writing_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':writing_hand_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '✍🏿',
				'keywords' => ['dark skin tone', 'hand', 'write', 'uc8'],
			],
			'1f64f' => [
				'name' => \XF::phrase('emoji.pray'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pray:',
				'shortname_alternates' => [':folded_hands:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f64f-1f3fb', '1f64f-1f3fc', '1f64f-1f3fd', '1f64f-1f3fe', '1f64f-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🙏',
				'keywords' => ['ask', 'bow', 'folded', 'gesture', 'hand', 'please', 'pray', 'thanks', 'uc6'],
			],
			'1f64f-1f3fb' => [
				'name' => \XF::phrase('emoji.pray_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pray_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🙏🏻',
				'keywords' => ['ask', 'bow', 'folded', 'gesture', 'hand', 'light skin tone', 'please', 'pray', 'thanks', 'uc8'],
			],
			'1f64f-1f3fc' => [
				'name' => \XF::phrase('emoji.pray_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pray_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🙏🏼',
				'keywords' => ['ask', 'bow', 'folded', 'gesture', 'hand', 'medium-light skin tone', 'please', 'pray', 'thanks', 'uc8'],
			],
			'1f64f-1f3fd' => [
				'name' => \XF::phrase('emoji.pray_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pray_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🙏🏽',
				'keywords' => ['ask', 'bow', 'folded', 'gesture', 'hand', 'medium skin tone', 'please', 'pray', 'thanks', 'uc8'],
			],
			'1f64f-1f3fe' => [
				'name' => \XF::phrase('emoji.pray_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pray_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🙏🏾',
				'keywords' => ['ask', 'bow', 'folded', 'gesture', 'hand', 'medium-dark skin tone', 'please', 'pray', 'thanks', 'uc8'],
			],
			'1f64f-1f3ff' => [
				'name' => \XF::phrase('emoji.pray_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pray_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🙏🏿',
				'keywords' => ['ask', 'bow', 'dark skin tone', 'folded', 'gesture', 'hand', 'please', 'pray', 'thanks', 'uc8'],
			],
			'1faf5' => [
				'name' => \XF::phrase('emoji.index_pointing_at_the_viewer'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':index_pointing_at_the_viewer:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1faf5-1f3fb', '1faf5-1f3fc', '1faf5-1f3fd', '1faf5-1f3fe', '1faf5-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫵',
				'keywords' => ['uc14'],
			],
			'1faf5-1f3fb' => [
				'name' => \XF::phrase('emoji.index_pointing_at_the_viewer_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':index_pointing_at_the_viewer_tone1:',
				'shortname_alternates' => [':index_pointing_at_the_viewer_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫵🏻',
				'keywords' => ['uc14'],
			],
			'1faf5-1f3fc' => [
				'name' => \XF::phrase('emoji.index_pointing_at_the_viewer_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':index_pointing_at_the_viewer_tone2:',
				'shortname_alternates' => [':index_pointing_at_the_viewer_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫵🏼',
				'keywords' => ['uc14'],
			],
			'1faf5-1f3fd' => [
				'name' => \XF::phrase('emoji.index_pointing_at_the_viewer_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':index_pointing_at_the_viewer_tone3:',
				'shortname_alternates' => [':index_pointing_at_the_viewer_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫵🏽',
				'keywords' => ['uc14'],
			],
			'1faf5-1f3fe' => [
				'name' => \XF::phrase('emoji.index_pointing_at_the_viewer_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':index_pointing_at_the_viewer_tone4:',
				'shortname_alternates' => [':index_pointing_at_the_viewer_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫵🏾',
				'keywords' => ['uc14'],
			],
			'1faf5-1f3ff' => [
				'name' => \XF::phrase('emoji.index_pointing_at_the_viewer_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':index_pointing_at_the_viewer_tone5:',
				'shortname_alternates' => [':index_pointing_at_the_viewer_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫵🏿',
				'keywords' => ['uc14'],
			],
			'1f9b6' => [
				'name' => \XF::phrase('emoji.foot'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':foot:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9b6-1f3fb', '1f9b6-1f3fc', '1f9b6-1f3fd', '1f9b6-1f3fe', '1f9b6-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🦶',
				'keywords' => ['uc11'],
			],
			'1f9b6-1f3fb' => [
				'name' => \XF::phrase('emoji.foot_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':foot_tone1:',
				'shortname_alternates' => [':foot_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🦶🏻',
				'keywords' => ['uc11'],
			],
			'1f9b6-1f3fc' => [
				'name' => \XF::phrase('emoji.foot_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':foot_tone2:',
				'shortname_alternates' => [':foot_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🦶🏼',
				'keywords' => ['uc11'],
			],
			'1f9b6-1f3fd' => [
				'name' => \XF::phrase('emoji.foot_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':foot_tone3:',
				'shortname_alternates' => [':foot_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🦶🏽',
				'keywords' => ['uc11'],
			],
			'1f9b6-1f3fe' => [
				'name' => \XF::phrase('emoji.foot_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':foot_tone4:',
				'shortname_alternates' => [':foot_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🦶🏾',
				'keywords' => ['uc11'],
			],
			'1f9b6-1f3ff' => [
				'name' => \XF::phrase('emoji.foot_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':foot_tone5:',
				'shortname_alternates' => [':foot_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🦶🏿',
				'keywords' => ['uc11'],
			],
			'1f9b5' => [
				'name' => \XF::phrase('emoji.leg'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':leg:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9b5-1f3fb', '1f9b5-1f3fc', '1f9b5-1f3fd', '1f9b5-1f3fe', '1f9b5-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🦵',
				'keywords' => ['uc11'],
			],
			'1f9b5-1f3fb' => [
				'name' => \XF::phrase('emoji.leg_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':leg_tone1:',
				'shortname_alternates' => [':leg_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🦵🏻',
				'keywords' => ['uc11'],
			],
			'1f9b5-1f3fc' => [
				'name' => \XF::phrase('emoji.leg_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':leg_tone2:',
				'shortname_alternates' => [':leg_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🦵🏼',
				'keywords' => ['uc11'],
			],
			'1f9b5-1f3fd' => [
				'name' => \XF::phrase('emoji.leg_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':leg_tone3:',
				'shortname_alternates' => [':leg_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🦵🏽',
				'keywords' => ['uc11'],
			],
			'1f9b5-1f3fe' => [
				'name' => \XF::phrase('emoji.leg_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':leg_tone4:',
				'shortname_alternates' => [':leg_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🦵🏾',
				'keywords' => ['uc11'],
			],
			'1f9b5-1f3ff' => [
				'name' => \XF::phrase('emoji.leg_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':leg_tone5:',
				'shortname_alternates' => [':leg_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🦵🏿',
				'keywords' => ['uc11'],
			],
			'1f9bf' => [
				'name' => \XF::phrase('emoji.mechanical_leg'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mechanical_leg:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🦿',
				'keywords' => ['uc12'],
			],
			'1f484' => [
				'name' => \XF::phrase('emoji.lipstick'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':lipstick:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '💄',
				'keywords' => ['cosmetics', 'makeup', 'uc6'],
			],
			'1f48b' => [
				'name' => \XF::phrase('emoji.kiss'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':kiss:',
				'shortname_alternates' => [':kiss_mark:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '💋',
				'keywords' => ['kiss', 'lips', 'uc6'],
			],
			'1f444' => [
				'name' => \XF::phrase('emoji.lips'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':lips:',
				'shortname_alternates' => [':mouth:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👄',
				'keywords' => ['lips', 'uc6'],
			],
			'1fae6' => [
				'name' => \XF::phrase('emoji.biting_lip'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':biting_lip:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫦',
				'keywords' => ['uc14'],
			],
			'1f9b7' => [
				'name' => \XF::phrase('emoji.tooth'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':tooth:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🦷',
				'keywords' => ['uc11'],
			],
			'1f445' => [
				'name' => \XF::phrase('emoji.tongue'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':tongue:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👅',
				'keywords' => ['body', 'uc6'],
			],
			'1f442' => [
				'name' => \XF::phrase('emoji.ear'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ear:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f442-1f3fb', '1f442-1f3fc', '1f442-1f3fd', '1f442-1f3fe', '1f442-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👂',
				'keywords' => ['body', 'uc6'],
			],
			'1f442-1f3fb' => [
				'name' => \XF::phrase('emoji.ear_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ear_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👂🏻',
				'keywords' => ['body', 'light skin tone', 'uc8'],
			],
			'1f442-1f3fc' => [
				'name' => \XF::phrase('emoji.ear_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ear_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👂🏼',
				'keywords' => ['body', 'medium-light skin tone', 'uc8'],
			],
			'1f442-1f3fd' => [
				'name' => \XF::phrase('emoji.ear_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ear_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👂🏽',
				'keywords' => ['body', 'medium skin tone', 'uc8'],
			],
			'1f442-1f3fe' => [
				'name' => \XF::phrase('emoji.ear_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ear_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👂🏾',
				'keywords' => ['body', 'medium-dark skin tone', 'uc8'],
			],
			'1f442-1f3ff' => [
				'name' => \XF::phrase('emoji.ear_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ear_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👂🏿',
				'keywords' => ['body', 'dark skin tone', 'uc8'],
			],
			'1f9bb' => [
				'name' => \XF::phrase('emoji.ear_with_hearing_aid'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ear_with_hearing_aid:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9bb-1f3fb', '1f9bb-1f3fc', '1f9bb-1f3fd', '1f9bb-1f3fe', '1f9bb-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🦻',
				'keywords' => ['uc12'],
			],
			'1f9bb-1f3fb' => [
				'name' => \XF::phrase('emoji.ear_with_hearing_aid_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ear_with_hearing_aid_tone1:',
				'shortname_alternates' => [':ear_with_hearing_aid_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🦻🏻',
				'keywords' => ['uc12'],
			],
			'1f9bb-1f3fc' => [
				'name' => \XF::phrase('emoji.ear_with_hearing_aid_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ear_with_hearing_aid_tone2:',
				'shortname_alternates' => [':ear_with_hearing_aid_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🦻🏼',
				'keywords' => ['uc12'],
			],
			'1f9bb-1f3fd' => [
				'name' => \XF::phrase('emoji.ear_with_hearing_aid_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ear_with_hearing_aid_tone3:',
				'shortname_alternates' => [':ear_with_hearing_aid_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🦻🏽',
				'keywords' => ['uc12'],
			],
			'1f9bb-1f3fe' => [
				'name' => \XF::phrase('emoji.ear_with_hearing_aid_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ear_with_hearing_aid_tone4:',
				'shortname_alternates' => [':ear_with_hearing_aid_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🦻🏾',
				'keywords' => ['uc12'],
			],
			'1f9bb-1f3ff' => [
				'name' => \XF::phrase('emoji.ear_with_hearing_aid_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ear_with_hearing_aid_tone5:',
				'shortname_alternates' => [':ear_with_hearing_aid_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🦻🏿',
				'keywords' => ['uc12'],
			],
			'1f443' => [
				'name' => \XF::phrase('emoji.nose'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nose:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f443-1f3fb', '1f443-1f3fc', '1f443-1f3fd', '1f443-1f3fe', '1f443-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👃',
				'keywords' => ['body', 'uc6'],
			],
			'1f443-1f3fb' => [
				'name' => \XF::phrase('emoji.nose_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nose_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👃🏻',
				'keywords' => ['body', 'light skin tone', 'uc8'],
			],
			'1f443-1f3fc' => [
				'name' => \XF::phrase('emoji.nose_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nose_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👃🏼',
				'keywords' => ['body', 'medium-light skin tone', 'uc8'],
			],
			'1f443-1f3fd' => [
				'name' => \XF::phrase('emoji.nose_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nose_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👃🏽',
				'keywords' => ['body', 'medium skin tone', 'uc8'],
			],
			'1f443-1f3fe' => [
				'name' => \XF::phrase('emoji.nose_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nose_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👃🏾',
				'keywords' => ['body', 'medium-dark skin tone', 'uc8'],
			],
			'1f443-1f3ff' => [
				'name' => \XF::phrase('emoji.nose_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nose_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👃🏿',
				'keywords' => ['body', 'dark skin tone', 'uc8'],
			],
			'1f463' => [
				'name' => \XF::phrase('emoji.footprints'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':footprints:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👣',
				'keywords' => ['clothing', 'footprint', 'print', 'uc6'],
			],
			'1f441' => [
				'name' => \XF::phrase('emoji.eye'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':eye:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👁️',
				'keywords' => ['body', 'uc7'],
			],
			'1f440' => [
				'name' => \XF::phrase('emoji.eyes'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':eyes:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👀',
				'keywords' => ['eye', 'face', 'uc6'],
			],
			'1fac0' => [
				'name' => \XF::phrase('emoji.anatomical_heart'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':anatomical_heart:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫀',
				'keywords' => ['uc13'],
			],
			'1fac1' => [
				'name' => \XF::phrase('emoji.lungs'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':lungs:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫁',
				'keywords' => ['uc13'],
			],
			'1f9e0' => [
				'name' => \XF::phrase('emoji.brain'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':brain:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧠',
				'keywords' => ['intelligent', 'uc10'],
			],
			'1f5e3' => [
				'name' => \XF::phrase('emoji.speaking_head'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':speaking_head:',
				'shortname_alternates' => [':speaking_head_in_silhouette:'],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🗣️',
				'keywords' => ['face', 'head', 'silhouette', 'speak', 'speaking', 'uc7'],
			],
			'1f464' => [
				'name' => \XF::phrase('emoji.bust_in_silhouette'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':bust_in_silhouette:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👤',
				'keywords' => ['bust', 'silhouette', 'uc6'],
			],
			'1f465' => [
				'name' => \XF::phrase('emoji.busts_in_silhouette'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':busts_in_silhouette:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👥',
				'keywords' => ['bust', 'silhouette', 'uc6'],
			],
			'1fac2' => [
				'name' => \XF::phrase('emoji.people_hugging'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_hugging:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫂',
				'keywords' => ['uc13'],
			],
			'1f476' => [
				'name' => \XF::phrase('emoji.baby'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':baby:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f476-1f3fb', '1f476-1f3fc', '1f476-1f3fd', '1f476-1f3fe', '1f476-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👶',
				'keywords' => ['baby', 'young', 'uc6'],
			],
			'1f476-1f3fb' => [
				'name' => \XF::phrase('emoji.baby_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':baby_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👶🏻',
				'keywords' => ['baby', 'light skin tone', 'young', 'uc8'],
			],
			'1f476-1f3fc' => [
				'name' => \XF::phrase('emoji.baby_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':baby_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👶🏼',
				'keywords' => ['baby', 'medium-light skin tone', 'young', 'uc8'],
			],
			'1f476-1f3fd' => [
				'name' => \XF::phrase('emoji.baby_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':baby_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👶🏽',
				'keywords' => ['baby', 'medium skin tone', 'young', 'uc8'],
			],
			'1f476-1f3fe' => [
				'name' => \XF::phrase('emoji.baby_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':baby_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👶🏾',
				'keywords' => ['baby', 'medium-dark skin tone', 'young', 'uc8'],
			],
			'1f476-1f3ff' => [
				'name' => \XF::phrase('emoji.baby_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':baby_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👶🏿',
				'keywords' => ['baby', 'dark skin tone', 'young', 'uc8'],
			],
			'1f9d2' => [
				'name' => \XF::phrase('emoji.child'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':child:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d2-1f3fb', '1f9d2-1f3fc', '1f9d2-1f3fd', '1f9d2-1f3fe', '1f9d2-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧒',
				'keywords' => ['uc10'],
			],
			'1f9d2-1f3fb' => [
				'name' => \XF::phrase('emoji.child_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':child_tone1:',
				'shortname_alternates' => [':child_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧒🏻',
				'keywords' => ['gender-neutral', 'light skin tone', 'young', 'uc10'],
			],
			'1f9d2-1f3fc' => [
				'name' => \XF::phrase('emoji.child_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':child_tone2:',
				'shortname_alternates' => [':child_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧒🏼',
				'keywords' => ['gender-neutral', 'medium-light skin tone', 'young', 'uc10'],
			],
			'1f9d2-1f3fd' => [
				'name' => \XF::phrase('emoji.child_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':child_tone3:',
				'shortname_alternates' => [':child_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧒🏽',
				'keywords' => ['gender-neutral', 'medium skin tone', 'young', 'uc10'],
			],
			'1f9d2-1f3fe' => [
				'name' => \XF::phrase('emoji.child_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':child_tone4:',
				'shortname_alternates' => [':child_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧒🏾',
				'keywords' => ['gender-neutral', 'medium-dark skin tone', 'young', 'uc10'],
			],
			'1f9d2-1f3ff' => [
				'name' => \XF::phrase('emoji.child_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':child_tone5:',
				'shortname_alternates' => [':child_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧒🏿',
				'keywords' => ['dark skin tone', 'gender-neutral', 'young', 'uc10'],
			],
			'1f467' => [
				'name' => \XF::phrase('emoji.girl'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':girl:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f467-1f3fb', '1f467-1f3fc', '1f467-1f3fd', '1f467-1f3fe', '1f467-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👧',
				'keywords' => ['Virgo', 'young', 'zodiac', 'uc6'],
			],
			'1f467-1f3fb' => [
				'name' => \XF::phrase('emoji.girl_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':girl_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👧🏻',
				'keywords' => ['Virgo', 'light skin tone', 'young', 'zodiac', 'uc8'],
			],
			'1f467-1f3fc' => [
				'name' => \XF::phrase('emoji.girl_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':girl_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👧🏼',
				'keywords' => ['Virgo', 'medium-light skin tone', 'young', 'zodiac', 'uc8'],
			],
			'1f467-1f3fd' => [
				'name' => \XF::phrase('emoji.girl_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':girl_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👧🏽',
				'keywords' => ['Virgo', 'medium skin tone', 'young', 'zodiac', 'uc8'],
			],
			'1f467-1f3fe' => [
				'name' => \XF::phrase('emoji.girl_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':girl_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👧🏾',
				'keywords' => ['Virgo', 'medium-dark skin tone', 'young', 'zodiac', 'uc8'],
			],
			'1f467-1f3ff' => [
				'name' => \XF::phrase('emoji.girl_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':girl_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👧🏿',
				'keywords' => ['Virgo', 'dark skin tone', 'young', 'zodiac', 'uc8'],
			],
			'1f466' => [
				'name' => \XF::phrase('emoji.boy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':boy:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f466-1f3fb', '1f466-1f3fc', '1f466-1f3fd', '1f466-1f3fe', '1f466-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👦',
				'keywords' => ['boy', 'young', 'uc6'],
			],
			'1f466-1f3fb' => [
				'name' => \XF::phrase('emoji.boy_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':boy_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👦🏻',
				'keywords' => ['boy', 'light skin tone', 'young', 'uc8'],
			],
			'1f466-1f3fc' => [
				'name' => \XF::phrase('emoji.boy_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':boy_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👦🏼',
				'keywords' => ['boy', 'medium-light skin tone', 'young', 'uc8'],
			],
			'1f466-1f3fd' => [
				'name' => \XF::phrase('emoji.boy_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':boy_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👦🏽',
				'keywords' => ['boy', 'medium skin tone', 'young', 'uc8'],
			],
			'1f466-1f3fe' => [
				'name' => \XF::phrase('emoji.boy_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':boy_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👦🏾',
				'keywords' => ['boy', 'medium-dark skin tone', 'young', 'uc8'],
			],
			'1f466-1f3ff' => [
				'name' => \XF::phrase('emoji.boy_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':boy_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👦🏿',
				'keywords' => ['boy', 'dark skin tone', 'young', 'uc8'],
			],
			'1f9d1' => [
				'name' => \XF::phrase('emoji.adult'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':adult:',
				'shortname_alternates' => [':person:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb', '1f9d1-1f3fc', '1f9d1-1f3fd', '1f9d1-1f3fe', '1f9d1-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑',
				'keywords' => ['uc10'],
			],
			'1f9d1-1f3fb' => [
				'name' => \XF::phrase('emoji.adult_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':adult_tone1:',
				'shortname_alternates' => [':adult_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻',
				'keywords' => ['gender-neutral', 'light skin tone', 'uc10'],
			],
			'1f9d1-1f3fc' => [
				'name' => \XF::phrase('emoji.adult_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':adult_tone2:',
				'shortname_alternates' => [':adult_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼',
				'keywords' => ['gender-neutral', 'medium-light skin tone', 'uc10'],
			],
			'1f9d1-1f3fd' => [
				'name' => \XF::phrase('emoji.adult_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':adult_tone3:',
				'shortname_alternates' => [':adult_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽',
				'keywords' => ['gender-neutral', 'medium skin tone', 'uc10'],
			],
			'1f9d1-1f3fe' => [
				'name' => \XF::phrase('emoji.adult_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':adult_tone4:',
				'shortname_alternates' => [':adult_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾',
				'keywords' => ['gender-neutral', 'medium-dark skin tone', 'uc10'],
			],
			'1f9d1-1f3ff' => [
				'name' => \XF::phrase('emoji.adult_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':adult_tone5:',
				'shortname_alternates' => [':adult_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿',
				'keywords' => ['dark skin tone', 'gender-neutral', 'uc10'],
			],
			'1f469' => [
				'name' => \XF::phrase('emoji.woman'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3fb', '1f469-1f3fc', '1f469-1f3fd', '1f469-1f3fe', '1f469-1f3ff'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩',
				'keywords' => ['woman', 'uc6'],
			],
			'1f469-1f3fb' => [
				'name' => \XF::phrase('emoji.woman_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻',
				'keywords' => ['light skin tone', 'woman', 'uc8'],
			],
			'1f469-1f3fc' => [
				'name' => \XF::phrase('emoji.woman_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼',
				'keywords' => ['medium-light skin tone', 'woman', 'uc8'],
			],
			'1f469-1f3fd' => [
				'name' => \XF::phrase('emoji.woman_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏽',
				'keywords' => ['medium skin tone', 'woman', 'uc8'],
			],
			'1f469-1f3fe' => [
				'name' => \XF::phrase('emoji.woman_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏾',
				'keywords' => ['medium-dark skin tone', 'woman', 'uc8'],
			],
			'1f469-1f3ff' => [
				'name' => \XF::phrase('emoji.woman_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏿',
				'keywords' => ['dark skin tone', 'woman', 'uc8'],
			],
			'1f468' => [
				'name' => \XF::phrase('emoji.man'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3fb', '1f468-1f3fc', '1f468-1f3fd', '1f468-1f3fe', '1f468-1f3ff'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨',
				'keywords' => ['man', 'uc6'],
			],
			'1f468-1f3fb' => [
				'name' => \XF::phrase('emoji.man_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏻',
				'keywords' => ['light skin tone', 'man', 'uc8'],
			],
			'1f468-1f3fc' => [
				'name' => \XF::phrase('emoji.man_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏼',
				'keywords' => ['man', 'medium-light skin tone', 'uc8'],
			],
			'1f468-1f3fd' => [
				'name' => \XF::phrase('emoji.man_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏽',
				'keywords' => ['man', 'medium skin tone', 'uc8'],
			],
			'1f468-1f3fe' => [
				'name' => \XF::phrase('emoji.man_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏾',
				'keywords' => ['man', 'medium-dark skin tone', 'uc8'],
			],
			'1f468-1f3ff' => [
				'name' => \XF::phrase('emoji.man_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏿',
				'keywords' => ['dark skin tone', 'man', 'uc8'],
			],
			'1f9d1-1f9b1' => [
				'name' => \XF::phrase('emoji.person_curly_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_curly_hair:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f9b1', '1f9d1-1f3fc-1f9b1', '1f9d1-1f3fd-1f9b1', '1f9d1-1f3fe-1f9b1', '1f9d1-1f3ff-1f9b1'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑‍🦱',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f9b1' => [
				'name' => \XF::phrase('emoji.person_tone1_curly_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone1_curly_hair:',
				'shortname_alternates' => [':person_light_skin_tone_curly_hair:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍🦱',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f9b1' => [
				'name' => \XF::phrase('emoji.person_tone2_curly_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone2_curly_hair:',
				'shortname_alternates' => [':person_medium_light_skin_tone_curly_hair:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍🦱',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f9b1' => [
				'name' => \XF::phrase('emoji.person_tone3_curly_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone3_curly_hair:',
				'shortname_alternates' => [':person_medium_skin_tone_curly_hair:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍🦱',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f9b1' => [
				'name' => \XF::phrase('emoji.person_tone4_curly_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone4_curly_hair:',
				'shortname_alternates' => [':person_medium_dark_skin_tone_curly_hair:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍🦱',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f9b1' => [
				'name' => \XF::phrase('emoji.person_tone5_curly_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone5_curly_hair:',
				'shortname_alternates' => [':person_dark_skin_tone_curly_hair:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍🦱',
				'keywords' => ['uc12'],
			],
			'1f469-1f9b1' => [
				'name' => \XF::phrase('emoji.woman_curly_haired'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_curly_haired:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3fb-1f9b1', '1f469-1f3fc-1f9b1', '1f469-1f3fd-1f9b1', '1f469-1f3fe-1f9b1', '1f469-1f3ff-1f9b1'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩‍🦱',
				'keywords' => ['uc11'],
			],
			'1f469-1f3fb-1f9b1' => [
				'name' => \XF::phrase('emoji.woman_curly_haired_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_curly_haired_tone1:',
				'shortname_alternates' => [':woman_curly_haired_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻‍🦱',
				'keywords' => ['uc11'],
			],
			'1f469-1f3fc-1f9b1' => [
				'name' => \XF::phrase('emoji.woman_curly_haired_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_curly_haired_tone2:',
				'shortname_alternates' => [':woman_curly_haired_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼‍🦱',
				'keywords' => ['uc11'],
			],
			'1f469-1f3fd-1f9b1' => [
				'name' => \XF::phrase('emoji.woman_curly_haired_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_curly_haired_tone3:',
				'shortname_alternates' => [':woman_curly_haired_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏽‍🦱',
				'keywords' => ['uc11'],
			],
			'1f469-1f3fe-1f9b1' => [
				'name' => \XF::phrase('emoji.woman_curly_haired_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_curly_haired_tone4:',
				'shortname_alternates' => [':woman_curly_haired_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏾‍🦱',
				'keywords' => ['uc11'],
			],
			'1f469-1f3ff-1f9b1' => [
				'name' => \XF::phrase('emoji.woman_curly_haired_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_curly_haired_tone5:',
				'shortname_alternates' => [':woman_curly_haired_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏿‍🦱',
				'keywords' => ['uc11'],
			],
			'1f468-1f9b1' => [
				'name' => \XF::phrase('emoji.man_curly_haired'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_curly_haired:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3fb-1f9b1', '1f468-1f3fc-1f9b1', '1f468-1f3fd-1f9b1', '1f468-1f3fe-1f9b1', '1f468-1f3ff-1f9b1'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨‍🦱',
				'keywords' => ['uc11'],
			],
			'1f468-1f3fb-1f9b1' => [
				'name' => \XF::phrase('emoji.man_curly_haired_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_curly_haired_tone1:',
				'shortname_alternates' => [':man_curly_haired_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏻‍🦱',
				'keywords' => ['uc11'],
			],
			'1f468-1f3fc-1f9b1' => [
				'name' => \XF::phrase('emoji.man_curly_haired_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_curly_haired_tone2:',
				'shortname_alternates' => [':man_curly_haired_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏼‍🦱',
				'keywords' => ['uc11'],
			],
			'1f468-1f3fd-1f9b1' => [
				'name' => \XF::phrase('emoji.man_curly_haired_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_curly_haired_tone3:',
				'shortname_alternates' => [':man_curly_haired_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏽‍🦱',
				'keywords' => ['uc11'],
			],
			'1f468-1f3fe-1f9b1' => [
				'name' => \XF::phrase('emoji.man_curly_haired_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_curly_haired_tone4:',
				'shortname_alternates' => [':man_curly_haired_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏾‍🦱',
				'keywords' => ['uc11'],
			],
			'1f468-1f3ff-1f9b1' => [
				'name' => \XF::phrase('emoji.man_curly_haired_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_curly_haired_tone5:',
				'shortname_alternates' => [':man_curly_haired_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏿‍🦱',
				'keywords' => ['uc11'],
			],
			'1f9d1-1f9b0' => [
				'name' => \XF::phrase('emoji.person_red_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_red_hair:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f9b0', '1f9d1-1f3fc-1f9b0', '1f9d1-1f3fd-1f9b0', '1f9d1-1f3fe-1f9b0', '1f9d1-1f3ff-1f9b0'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑‍🦰',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f9b0' => [
				'name' => \XF::phrase('emoji.person_tone1_red_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone1_red_hair:',
				'shortname_alternates' => [':person_light_skin_tone_red_hair:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍🦰',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f9b0' => [
				'name' => \XF::phrase('emoji.person_tone2_red_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone2_red_hair:',
				'shortname_alternates' => [':person_medium_light_skin_tone_red_hair:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍🦰',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f9b0' => [
				'name' => \XF::phrase('emoji.person_tone3_red_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone3_red_hair:',
				'shortname_alternates' => [':person_medium_skin_tone_red_hair:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍🦰',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f9b0' => [
				'name' => \XF::phrase('emoji.person_tone4_red_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone4_red_hair:',
				'shortname_alternates' => [':person_medium_dark_skin_tone_red_hair:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍🦰',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f9b0' => [
				'name' => \XF::phrase('emoji.person_tone5_red_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone5_red_hair:',
				'shortname_alternates' => [':person_dark_skin_tone_red_hair:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍🦰',
				'keywords' => ['uc12'],
			],
			'1f469-1f9b0' => [
				'name' => \XF::phrase('emoji.woman_red_haired'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_red_haired:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3fb-1f9b0', '1f469-1f3fc-1f9b0', '1f469-1f3fd-1f9b0', '1f469-1f3fe-1f9b0', '1f469-1f3ff-1f9b0'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩‍🦰',
				'keywords' => ['uc11'],
			],
			'1f469-1f3fb-1f9b0' => [
				'name' => \XF::phrase('emoji.woman_red_haired_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_red_haired_tone1:',
				'shortname_alternates' => [':woman_red_haired_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻‍🦰',
				'keywords' => ['uc11'],
			],
			'1f469-1f3fc-1f9b0' => [
				'name' => \XF::phrase('emoji.woman_red_haired_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_red_haired_tone2:',
				'shortname_alternates' => [':woman_red_haired_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼‍🦰',
				'keywords' => ['uc11'],
			],
			'1f469-1f3fd-1f9b0' => [
				'name' => \XF::phrase('emoji.woman_red_haired_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_red_haired_tone3:',
				'shortname_alternates' => [':woman_red_haired_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏽‍🦰',
				'keywords' => ['uc11'],
			],
			'1f469-1f3fe-1f9b0' => [
				'name' => \XF::phrase('emoji.woman_red_haired_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_red_haired_tone4:',
				'shortname_alternates' => [':woman_red_haired_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏾‍🦰',
				'keywords' => ['uc11'],
			],
			'1f469-1f3ff-1f9b0' => [
				'name' => \XF::phrase('emoji.woman_red_haired_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_red_haired_tone5:',
				'shortname_alternates' => [':woman_red_haired_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏿‍🦰',
				'keywords' => ['uc11'],
			],
			'1f468-1f9b0' => [
				'name' => \XF::phrase('emoji.man_red_haired'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_red_haired:',
				'shortname_alternates' => [':man_red_hair:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3fb-1f9b0', '1f468-1f3fc-1f9b0', '1f468-1f3fd-1f9b0', '1f468-1f3fe-1f9b0', '1f468-1f3ff-1f9b0'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨‍🦰',
				'keywords' => ['uc11'],
			],
			'1f468-1f3fb-1f9b0' => [
				'name' => \XF::phrase('emoji.man_red_haired_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_red_haired_tone1:',
				'shortname_alternates' => [':man_red_haired_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏻‍🦰',
				'keywords' => ['uc11'],
			],
			'1f468-1f3fc-1f9b0' => [
				'name' => \XF::phrase('emoji.man_red_haired_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_red_haired_tone2:',
				'shortname_alternates' => [':man_red_haired_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏼‍🦰',
				'keywords' => ['uc11'],
			],
			'1f468-1f3fd-1f9b0' => [
				'name' => \XF::phrase('emoji.man_red_haired_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_red_haired_tone3:',
				'shortname_alternates' => [':man_red_haired_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏽‍🦰',
				'keywords' => ['uc11'],
			],
			'1f468-1f3fe-1f9b0' => [
				'name' => \XF::phrase('emoji.man_red_haired_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_red_haired_tone4:',
				'shortname_alternates' => [':man_red_haired_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏾‍🦰',
				'keywords' => ['uc11'],
			],
			'1f468-1f3ff-1f9b0' => [
				'name' => \XF::phrase('emoji.man_red_haired_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_red_haired_tone5:',
				'shortname_alternates' => [':man_red_haired_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏿‍🦰',
				'keywords' => ['uc11'],
			],
			'1f471' => [
				'name' => \XF::phrase('emoji.blond_haired_person'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond_haired_person:',
				'shortname_alternates' => [':person_with_blond_hair:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f471-1f3fb', '1f471-1f3fc', '1f471-1f3fd', '1f471-1f3fe', '1f471-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f471-2642', '1f471-2640'],
				'unicode' => '👱',
				'keywords' => ['blond', 'uc6'],
			],
			'1f471-1f3fb' => [
				'name' => \XF::phrase('emoji.blond_haired_person_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond_haired_person_tone1:',
				'shortname_alternates' => [':person_with_blond_hair_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f471-1f3fb-2642', '1f471-1f3fb-2640'],
				'unicode' => '👱🏻',
				'keywords' => ['blond', 'light skin tone', 'uc8'],
			],
			'1f471-1f3fc' => [
				'name' => \XF::phrase('emoji.blond_haired_person_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond_haired_person_tone2:',
				'shortname_alternates' => [':person_with_blond_hair_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f471-1f3fc-2642', '1f471-1f3fc-2640'],
				'unicode' => '👱🏼',
				'keywords' => ['blond', 'medium-light skin tone', 'uc8'],
			],
			'1f471-1f3fd' => [
				'name' => \XF::phrase('emoji.blond_haired_person_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond_haired_person_tone3:',
				'shortname_alternates' => [':person_with_blond_hair_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f471-1f3fd-2642', '1f471-1f3fd-2640'],
				'unicode' => '👱🏽',
				'keywords' => ['blond', 'medium skin tone', 'uc8'],
			],
			'1f471-1f3fe' => [
				'name' => \XF::phrase('emoji.blond_haired_person_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond_haired_person_tone4:',
				'shortname_alternates' => [':person_with_blond_hair_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f471-1f3fe-2642', '1f471-1f3fe-2640'],
				'unicode' => '👱🏾',
				'keywords' => ['blond', 'medium-dark skin tone', 'uc8'],
			],
			'1f471-1f3ff' => [
				'name' => \XF::phrase('emoji.blond_haired_person_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond_haired_person_tone5:',
				'shortname_alternates' => [':person_with_blond_hair_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f471-1f3ff-2642', '1f471-1f3ff-2640'],
				'unicode' => '👱🏿',
				'keywords' => ['blond', 'dark skin tone', 'uc8'],
			],
			'1f471-2640' => [
				'name' => \XF::phrase('emoji.blond_haired_woman'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_woman:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f471-1f3ff-2640', '1f471-1f3fe-2640', '1f471-1f3fd-2640', '1f471-1f3fc-2640', '1f471-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👱‍♀️',
				'keywords' => ['blonde', 'woman', 'uc6'],
			],
			'1f471-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.blond_haired_woman_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_woman_tone1:',
				'shortname_alternates' => [':blond-haired_woman_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👱🏻‍♀️',
				'keywords' => ['blonde', 'light skin tone', 'woman', 'uc8'],
			],
			'1f471-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.blond_haired_woman_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_woman_tone2:',
				'shortname_alternates' => [':blond-haired_woman_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👱🏼‍♀️',
				'keywords' => ['blonde', 'medium-light skin tone', 'woman', 'uc8'],
			],
			'1f471-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.blond_haired_woman_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_woman_tone3:',
				'shortname_alternates' => [':blond-haired_woman_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👱🏽‍♀️',
				'keywords' => ['blonde', 'medium skin tone', 'woman', 'uc8'],
			],
			'1f471-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.blond_haired_woman_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_woman_tone4:',
				'shortname_alternates' => [':blond-haired_woman_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👱🏾‍♀️',
				'keywords' => ['blonde', 'medium-dark skin tone', 'woman', 'uc8'],
			],
			'1f471-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.blond_haired_woman_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_woman_tone5:',
				'shortname_alternates' => [':blond-haired_woman_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👱🏿‍♀️',
				'keywords' => ['blonde', 'dark skin tone', 'woman', 'uc8'],
			],
			'1f471-2642' => [
				'name' => \XF::phrase('emoji.blond_haired_man'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_man:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f471-1f3ff-2642', '1f471-1f3fe-2642', '1f471-1f3fd-2642', '1f471-1f3fc-2642', '1f471-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👱‍♂️',
				'keywords' => ['blond', 'man', 'uc6'],
			],
			'1f471-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.blond_haired_man_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_man_tone1:',
				'shortname_alternates' => [':blond-haired_man_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👱🏻‍♂️',
				'keywords' => ['blond', 'light skin tone', 'man', 'uc8'],
			],
			'1f471-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.blond_haired_man_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_man_tone2:',
				'shortname_alternates' => [':blond-haired_man_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👱🏼‍♂️',
				'keywords' => ['blond', 'man', 'medium-light skin tone', 'uc8'],
			],
			'1f471-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.blond_haired_man_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_man_tone3:',
				'shortname_alternates' => [':blond-haired_man_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👱🏽‍♂️',
				'keywords' => ['blond', 'man', 'medium skin tone', 'uc8'],
			],
			'1f471-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.blond_haired_man_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_man_tone4:',
				'shortname_alternates' => [':blond-haired_man_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👱🏾‍♂️',
				'keywords' => ['blond', 'man', 'medium-dark skin tone', 'uc8'],
			],
			'1f471-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.blond_haired_man_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':blond-haired_man_tone5:',
				'shortname_alternates' => [':blond-haired_man_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👱🏿‍♂️',
				'keywords' => ['blond', 'dark skin tone', 'man', 'uc8'],
			],
			'1f9d1-1f9b3' => [
				'name' => \XF::phrase('emoji.person_white_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_white_hair:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f9b3', '1f9d1-1f3fc-1f9b3', '1f9d1-1f3fd-1f9b3', '1f9d1-1f3fe-1f9b3', '1f9d1-1f3ff-1f9b3'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑‍🦳',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f9b3' => [
				'name' => \XF::phrase('emoji.person_tone1_white_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone1_white_hair:',
				'shortname_alternates' => [':person_light_skin_tone_white_hair:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍🦳',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f9b3' => [
				'name' => \XF::phrase('emoji.person_tone2_white_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone2_white_hair:',
				'shortname_alternates' => [':person_medium_light_skin_tone_white_hair:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍🦳',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f9b3' => [
				'name' => \XF::phrase('emoji.person_tone3_white_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone3_white_hair:',
				'shortname_alternates' => [':person_medium_skin_tone_white_hair:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍🦳',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f9b3' => [
				'name' => \XF::phrase('emoji.person_tone4_white_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone4_white_hair:',
				'shortname_alternates' => [':person_medium_dark_skin_tone_white_hair:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍🦳',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f9b3' => [
				'name' => \XF::phrase('emoji.person_tone5_white_hair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone5_white_hair:',
				'shortname_alternates' => [':person_dark_skin_tone_white_hair:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍🦳',
				'keywords' => ['uc12'],
			],
			'1f469-1f9b3' => [
				'name' => \XF::phrase('emoji.woman_white_haired'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_white_haired:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3fb-1f9b3', '1f469-1f3fc-1f9b3', '1f469-1f3fd-1f9b3', '1f469-1f3fe-1f9b3', '1f469-1f3ff-1f9b3'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩‍🦳',
				'keywords' => ['uc11'],
			],
			'1f469-1f3fb-1f9b3' => [
				'name' => \XF::phrase('emoji.woman_white_haired_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_white_haired_tone1:',
				'shortname_alternates' => [':woman_white_haired_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻‍🦳',
				'keywords' => ['uc11'],
			],
			'1f469-1f3fc-1f9b3' => [
				'name' => \XF::phrase('emoji.woman_white_haired_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_white_haired_tone2:',
				'shortname_alternates' => [':woman_white_haired_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼‍🦳',
				'keywords' => ['uc11'],
			],
			'1f469-1f3fd-1f9b3' => [
				'name' => \XF::phrase('emoji.woman_white_haired_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_white_haired_tone3:',
				'shortname_alternates' => [':woman_white_haired_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏽‍🦳',
				'keywords' => ['uc11'],
			],
			'1f469-1f3fe-1f9b3' => [
				'name' => \XF::phrase('emoji.woman_white_haired_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_white_haired_tone4:',
				'shortname_alternates' => [':woman_white_haired_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏾‍🦳',
				'keywords' => ['uc11'],
			],
			'1f469-1f3ff-1f9b3' => [
				'name' => \XF::phrase('emoji.woman_white_haired_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_white_haired_tone5:',
				'shortname_alternates' => [':woman_white_haired_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏿‍🦳',
				'keywords' => ['uc11'],
			],
			'1f468-1f9b3' => [
				'name' => \XF::phrase('emoji.man_white_haired'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_white_haired:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3fb-1f9b3', '1f468-1f3fc-1f9b3', '1f468-1f3fd-1f9b3', '1f468-1f3fe-1f9b3', '1f468-1f3ff-1f9b3'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨‍🦳',
				'keywords' => ['uc11'],
			],
			'1f468-1f3fb-1f9b3' => [
				'name' => \XF::phrase('emoji.man_white_haired_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_white_haired_tone1:',
				'shortname_alternates' => [':man_white_haired_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏻‍🦳',
				'keywords' => ['uc11'],
			],
			'1f468-1f3fc-1f9b3' => [
				'name' => \XF::phrase('emoji.man_white_haired_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_white_haired_tone2:',
				'shortname_alternates' => [':man_white_haired_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏼‍🦳',
				'keywords' => ['uc11'],
			],
			'1f468-1f3fd-1f9b3' => [
				'name' => \XF::phrase('emoji.man_white_haired_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_white_haired_tone3:',
				'shortname_alternates' => [':man_white_haired_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏽‍🦳',
				'keywords' => ['uc11'],
			],
			'1f468-1f3fe-1f9b3' => [
				'name' => \XF::phrase('emoji.man_white_haired_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_white_haired_tone4:',
				'shortname_alternates' => [':man_white_haired_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏾‍🦳',
				'keywords' => ['uc11'],
			],
			'1f468-1f3ff-1f9b3' => [
				'name' => \XF::phrase('emoji.man_white_haired_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_white_haired_tone5:',
				'shortname_alternates' => [':man_white_haired_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏿‍🦳',
				'keywords' => ['uc11'],
			],
			'1f9d1-1f9b2' => [
				'name' => \XF::phrase('emoji.person_bald'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_bald:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f9b2', '1f9d1-1f3fc-1f9b2', '1f9d1-1f3fd-1f9b2', '1f9d1-1f3fe-1f9b2', '1f9d1-1f3ff-1f9b2'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑‍🦲',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f9b2' => [
				'name' => \XF::phrase('emoji.person_tone1_bald'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone1_bald:',
				'shortname_alternates' => [':person_light_skin_tone_bald:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍🦲',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f9b2' => [
				'name' => \XF::phrase('emoji.person_tone2_bald'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone2_bald:',
				'shortname_alternates' => [':person_medium_light_skin_tone_bald:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍🦲',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f9b2' => [
				'name' => \XF::phrase('emoji.person_tone3_bald'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone3_bald:',
				'shortname_alternates' => [':person_medium_skin_tone_bald:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍🦲',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f9b2' => [
				'name' => \XF::phrase('emoji.person_tone4_bald'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone4_bald:',
				'shortname_alternates' => [':person_medium_dark_skin_tone_bald:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍🦲',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f9b2' => [
				'name' => \XF::phrase('emoji.person_tone5_bald'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tone5_bald:',
				'shortname_alternates' => [':person_dark_skin_tone_bald:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍🦲',
				'keywords' => ['uc12'],
			],
			'1f469-1f9b2' => [
				'name' => \XF::phrase('emoji.woman_bald'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bald:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3fb-1f9b2', '1f469-1f3fc-1f9b2', '1f469-1f3fd-1f9b2', '1f469-1f3fe-1f9b2', '1f469-1f3ff-1f9b2'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩‍🦲',
				'keywords' => ['uc11'],
			],
			'1f469-1f3fb-1f9b2' => [
				'name' => \XF::phrase('emoji.woman_bald_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bald_tone1:',
				'shortname_alternates' => [':woman_bald_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻‍🦲',
				'keywords' => ['uc11'],
			],
			'1f469-1f3fc-1f9b2' => [
				'name' => \XF::phrase('emoji.woman_bald_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bald_tone2:',
				'shortname_alternates' => [':woman_bald_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼‍🦲',
				'keywords' => ['uc11'],
			],
			'1f469-1f3fd-1f9b2' => [
				'name' => \XF::phrase('emoji.woman_bald_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bald_tone3:',
				'shortname_alternates' => [':woman_bald_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏽‍🦲',
				'keywords' => ['uc11'],
			],
			'1f469-1f3fe-1f9b2' => [
				'name' => \XF::phrase('emoji.woman_bald_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bald_tone4:',
				'shortname_alternates' => [':woman_bald_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏾‍🦲',
				'keywords' => ['uc11'],
			],
			'1f469-1f3ff-1f9b2' => [
				'name' => \XF::phrase('emoji.woman_bald_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bald_tone5:',
				'shortname_alternates' => [':woman_bald_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏿‍🦲',
				'keywords' => ['uc11'],
			],
			'1f468-1f9b2' => [
				'name' => \XF::phrase('emoji.man_bald'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bald:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3fb-1f9b2', '1f468-1f3fc-1f9b2', '1f468-1f3fd-1f9b2', '1f468-1f3fe-1f9b2', '1f468-1f3ff-1f9b2'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨‍🦲',
				'keywords' => ['uc11'],
			],
			'1f468-1f3fb-1f9b2' => [
				'name' => \XF::phrase('emoji.man_bald_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bald_tone1:',
				'shortname_alternates' => [':man_bald_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏻‍🦲',
				'keywords' => ['uc11'],
			],
			'1f468-1f3fc-1f9b2' => [
				'name' => \XF::phrase('emoji.man_bald_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bald_tone2:',
				'shortname_alternates' => [':man_bald_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏼‍🦲',
				'keywords' => ['uc11'],
			],
			'1f468-1f3fd-1f9b2' => [
				'name' => \XF::phrase('emoji.man_bald_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bald_tone3:',
				'shortname_alternates' => [':man_bald_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏽‍🦲',
				'keywords' => ['uc11'],
			],
			'1f468-1f3fe-1f9b2' => [
				'name' => \XF::phrase('emoji.man_bald_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bald_tone4:',
				'shortname_alternates' => [':man_bald_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏾‍🦲',
				'keywords' => ['uc11'],
			],
			'1f468-1f3ff-1f9b2' => [
				'name' => \XF::phrase('emoji.man_bald_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bald_tone5:',
				'shortname_alternates' => [':man_bald_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏿‍🦲',
				'keywords' => ['uc11'],
			],
			'1f9d4' => [
				'name' => \XF::phrase('emoji.bearded_person'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':bearded_person:',
				'shortname_alternates' => [':person_beard:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d4-1f3fb', '1f9d4-1f3fc', '1f9d4-1f3fd', '1f9d4-1f3fe', '1f9d4-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f9d4-2642', '1f9d4-2640'],
				'unicode' => '🧔',
				'keywords' => ['uc10'],
			],
			'1f9d4-1f3fb' => [
				'name' => \XF::phrase('emoji.bearded_person_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':bearded_person_tone1:',
				'shortname_alternates' => [':bearded_person_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9d4-1f3fb-2642', '1f9d4-1f3fb-2640'],
				'unicode' => '🧔🏻',
				'keywords' => ['beard', 'light skin tone', 'uc10'],
			],
			'1f9d4-1f3fc' => [
				'name' => \XF::phrase('emoji.bearded_person_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':bearded_person_tone2:',
				'shortname_alternates' => [':bearded_person_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9d4-1f3fc-2642', '1f9d4-1f3fc-2640'],
				'unicode' => '🧔🏼',
				'keywords' => ['beard', 'medium-light skin tone', 'uc10'],
			],
			'1f9d4-1f3fd' => [
				'name' => \XF::phrase('emoji.bearded_person_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':bearded_person_tone3:',
				'shortname_alternates' => [':bearded_person_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9d4-1f3fd-2642', '1f9d4-1f3fd-2640'],
				'unicode' => '🧔🏽',
				'keywords' => ['beard', 'medium skin tone', 'uc10'],
			],
			'1f9d4-1f3fe' => [
				'name' => \XF::phrase('emoji.bearded_person_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':bearded_person_tone4:',
				'shortname_alternates' => [':bearded_person_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9d4-1f3fe-2642', '1f9d4-1f3fe-2640'],
				'unicode' => '🧔🏾',
				'keywords' => ['beard', 'medium-dark skin tone', 'uc10'],
			],
			'1f9d4-1f3ff' => [
				'name' => \XF::phrase('emoji.bearded_person_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':bearded_person_tone5:',
				'shortname_alternates' => [':bearded_person_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9d4-1f3ff-2642', '1f9d4-1f3ff-2640'],
				'unicode' => '🧔🏿',
				'keywords' => ['beard', 'dark skin tone', 'uc10'],
			],
			'1f9d4-2640' => [
				'name' => \XF::phrase('emoji.woman_beard'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_beard:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d4-1f3fb-2640', '1f9d4-1f3fc-2640', '1f9d4-1f3fd-2640', '1f9d4-1f3fe-2640', '1f9d4-1f3ff-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧔‍♀️',
				'keywords' => ['uc13'],
			],
			'1f9d4-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_tone1_beard'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tone1_beard:',
				'shortname_alternates' => [':woman_light_skin_tone_beard:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧔🏻‍♀️',
				'keywords' => ['uc13'],
			],
			'1f9d4-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_tone2_beard'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tone2_beard:',
				'shortname_alternates' => [':woman_medium_light_skin_tone_beard:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧔🏼‍♀️',
				'keywords' => ['uc13'],
			],
			'1f9d4-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_tone3_beard'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tone3_beard:',
				'shortname_alternates' => [':woman_medium_skin_tone_beard:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧔🏽‍♀️',
				'keywords' => ['uc13'],
			],
			'1f9d4-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_tone4_beard'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tone4_beard:',
				'shortname_alternates' => [':woman_medium_dark_skin_tone_beard:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧔🏾‍♀️',
				'keywords' => ['uc13'],
			],
			'1f9d4-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_tone5_beard'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tone5_beard:',
				'shortname_alternates' => [':woman_dark_skin_tone_beard:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧔🏿‍♀️',
				'keywords' => ['uc13'],
			],
			'1f9d4-2642' => [
				'name' => \XF::phrase('emoji.man_beard'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_beard:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d4-1f3fb-2642', '1f9d4-1f3fc-2642', '1f9d4-1f3fd-2642', '1f9d4-1f3fe-2642', '1f9d4-1f3ff-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧔‍♂️',
				'keywords' => ['uc13'],
			],
			'1f9d4-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_tone1_beard'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tone1_beard:',
				'shortname_alternates' => [':man_light_skin_tone_beard:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧔🏻‍♂️',
				'keywords' => ['uc13'],
			],
			'1f9d4-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_tone2_beard'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tone2_beard:',
				'shortname_alternates' => [':man_medium_light_skin_tone_beard:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧔🏼‍♂️',
				'keywords' => ['uc13'],
			],
			'1f9d4-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_tone3_beard'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tone3_beard:',
				'shortname_alternates' => [':man_medium_skin_tone_beard:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧔🏽‍♂️',
				'keywords' => ['uc13'],
			],
			'1f9d4-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_tone4_beard'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tone4_beard:',
				'shortname_alternates' => [':man_medium_dark_skin_tone_beard:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧔🏾‍♂️',
				'keywords' => ['uc13'],
			],
			'1f9d4-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_tone5_beard'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tone5_beard:',
				'shortname_alternates' => [':man_dark_skin_tone_beard:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧔🏿‍♂️',
				'keywords' => ['uc13'],
			],
			'1f9d3' => [
				'name' => \XF::phrase('emoji.older_adult'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_adult:',
				'shortname_alternates' => [':older_person:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d3-1f3fb', '1f9d3-1f3fc', '1f9d3-1f3fd', '1f9d3-1f3fe', '1f9d3-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧓',
				'keywords' => ['uc10'],
			],
			'1f9d3-1f3fb' => [
				'name' => \XF::phrase('emoji.older_adult_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_adult_tone1:',
				'shortname_alternates' => [':older_adult_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧓🏻',
				'keywords' => ['gender-neutral', 'light skin tone', 'old', 'uc10'],
			],
			'1f9d3-1f3fc' => [
				'name' => \XF::phrase('emoji.older_adult_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_adult_tone2:',
				'shortname_alternates' => [':older_adult_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧓🏼',
				'keywords' => ['gender-neutral', 'medium-light skin tone', 'old', 'uc10'],
			],
			'1f9d3-1f3fd' => [
				'name' => \XF::phrase('emoji.older_adult_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_adult_tone3:',
				'shortname_alternates' => [':older_adult_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧓🏽',
				'keywords' => ['gender-neutral', 'medium skin tone', 'old', 'uc10'],
			],
			'1f9d3-1f3fe' => [
				'name' => \XF::phrase('emoji.older_adult_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_adult_tone4:',
				'shortname_alternates' => [':older_adult_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧓🏾',
				'keywords' => ['gender-neutral', 'medium-dark skin tone', 'old', 'uc10'],
			],
			'1f9d3-1f3ff' => [
				'name' => \XF::phrase('emoji.older_adult_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_adult_tone5:',
				'shortname_alternates' => [':older_adult_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧓🏿',
				'keywords' => ['dark skin tone', 'gender-neutral', 'old', 'uc10'],
			],
			'1f475' => [
				'name' => \XF::phrase('emoji.older_woman'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_woman:',
				'shortname_alternates' => [':grandma:', ':old_woman:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f475-1f3fb', '1f475-1f3fc', '1f475-1f3fd', '1f475-1f3fe', '1f475-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👵',
				'keywords' => ['old', 'woman', 'uc6'],
			],
			'1f475-1f3fb' => [
				'name' => \XF::phrase('emoji.older_woman_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_woman_tone1:',
				'shortname_alternates' => [':grandma_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👵🏻',
				'keywords' => ['light skin tone', 'old', 'woman', 'uc8'],
			],
			'1f475-1f3fc' => [
				'name' => \XF::phrase('emoji.older_woman_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_woman_tone2:',
				'shortname_alternates' => [':grandma_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👵🏼',
				'keywords' => ['medium-light skin tone', 'old', 'woman', 'uc8'],
			],
			'1f475-1f3fd' => [
				'name' => \XF::phrase('emoji.older_woman_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_woman_tone3:',
				'shortname_alternates' => [':grandma_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👵🏽',
				'keywords' => ['medium skin tone', 'old', 'woman', 'uc8'],
			],
			'1f475-1f3fe' => [
				'name' => \XF::phrase('emoji.older_woman_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_woman_tone4:',
				'shortname_alternates' => [':grandma_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👵🏾',
				'keywords' => ['medium-dark skin tone', 'old', 'woman', 'uc8'],
			],
			'1f475-1f3ff' => [
				'name' => \XF::phrase('emoji.older_woman_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_woman_tone5:',
				'shortname_alternates' => [':grandma_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👵🏿',
				'keywords' => ['dark skin tone', 'old', 'woman', 'uc8'],
			],
			'1f474' => [
				'name' => \XF::phrase('emoji.older_man'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_man:',
				'shortname_alternates' => [':old_man:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f474-1f3fb', '1f474-1f3fc', '1f474-1f3fd', '1f474-1f3fe', '1f474-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👴',
				'keywords' => ['man', 'old', 'uc6'],
			],
			'1f474-1f3fb' => [
				'name' => \XF::phrase('emoji.older_man_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_man_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👴🏻',
				'keywords' => ['light skin tone', 'man', 'old', 'uc8'],
			],
			'1f474-1f3fc' => [
				'name' => \XF::phrase('emoji.older_man_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_man_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👴🏼',
				'keywords' => ['man', 'medium-light skin tone', 'old', 'uc8'],
			],
			'1f474-1f3fd' => [
				'name' => \XF::phrase('emoji.older_man_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_man_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👴🏽',
				'keywords' => ['man', 'medium skin tone', 'old', 'uc8'],
			],
			'1f474-1f3fe' => [
				'name' => \XF::phrase('emoji.older_man_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_man_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👴🏾',
				'keywords' => ['man', 'medium-dark skin tone', 'old', 'uc8'],
			],
			'1f474-1f3ff' => [
				'name' => \XF::phrase('emoji.older_man_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':older_man_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👴🏿',
				'keywords' => ['dark skin tone', 'man', 'old', 'uc8'],
			],
			'1f472' => [
				'name' => \XF::phrase('emoji.man_with_chinese_cap'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_chinese_cap:',
				'shortname_alternates' => [':man_with_gua_pi_mao:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f472-1f3fb', '1f472-1f3fc', '1f472-1f3fd', '1f472-1f3fe', '1f472-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👲',
				'keywords' => ['gua pi mao', 'hat', 'man', 'uc6'],
			],
			'1f472-1f3fb' => [
				'name' => \XF::phrase('emoji.man_with_chinese_cap_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_chinese_cap_tone1:',
				'shortname_alternates' => [':man_with_gua_pi_mao_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👲🏻',
				'keywords' => ['gua pi mao', 'hat', 'light skin tone', 'man', 'uc8'],
			],
			'1f472-1f3fc' => [
				'name' => \XF::phrase('emoji.man_with_chinese_cap_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_chinese_cap_tone2:',
				'shortname_alternates' => [':man_with_gua_pi_mao_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👲🏼',
				'keywords' => ['gua pi mao', 'hat', 'man', 'medium-light skin tone', 'uc8'],
			],
			'1f472-1f3fd' => [
				'name' => \XF::phrase('emoji.man_with_chinese_cap_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_chinese_cap_tone3:',
				'shortname_alternates' => [':man_with_gua_pi_mao_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👲🏽',
				'keywords' => ['gua pi mao', 'hat', 'man', 'medium skin tone', 'uc8'],
			],
			'1f472-1f3fe' => [
				'name' => \XF::phrase('emoji.man_with_chinese_cap_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_chinese_cap_tone4:',
				'shortname_alternates' => [':man_with_gua_pi_mao_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👲🏾',
				'keywords' => ['gua pi mao', 'hat', 'man', 'medium-dark skin tone', 'uc8'],
			],
			'1f472-1f3ff' => [
				'name' => \XF::phrase('emoji.man_with_chinese_cap_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_chinese_cap_tone5:',
				'shortname_alternates' => [':man_with_gua_pi_mao_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👲🏿',
				'keywords' => ['dark skin tone', 'gua pi mao', 'hat', 'man', 'uc8'],
			],
			'1f473' => [
				'name' => \XF::phrase('emoji.person_wearing_turban'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_wearing_turban:',
				'shortname_alternates' => [':man_with_turban:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f473-1f3fb', '1f473-1f3fc', '1f473-1f3fd', '1f473-1f3fe', '1f473-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f473-2642', '1f473-2640'],
				'unicode' => '👳',
				'keywords' => ['turban', 'uc6'],
			],
			'1f473-1f3fb' => [
				'name' => \XF::phrase('emoji.person_wearing_turban_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_wearing_turban_tone1:',
				'shortname_alternates' => [':man_with_turban_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f473-1f3fb-2642', '1f473-1f3fb-2640'],
				'unicode' => '👳🏻',
				'keywords' => ['light skin tone', 'turban', 'uc8'],
			],
			'1f473-1f3fc' => [
				'name' => \XF::phrase('emoji.person_wearing_turban_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_wearing_turban_tone2:',
				'shortname_alternates' => [':man_with_turban_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f473-1f3fc-2642', '1f473-1f3fc-2640'],
				'unicode' => '👳🏼',
				'keywords' => ['medium-light skin tone', 'turban', 'uc8'],
			],
			'1f473-1f3fd' => [
				'name' => \XF::phrase('emoji.person_wearing_turban_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_wearing_turban_tone3:',
				'shortname_alternates' => [':man_with_turban_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f473-1f3fd-2642', '1f473-1f3fd-2640'],
				'unicode' => '👳🏽',
				'keywords' => ['medium skin tone', 'turban', 'uc8'],
			],
			'1f473-1f3fe' => [
				'name' => \XF::phrase('emoji.person_wearing_turban_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_wearing_turban_tone4:',
				'shortname_alternates' => [':man_with_turban_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f473-1f3fe-2642', '1f473-1f3fe-2640'],
				'unicode' => '👳🏾',
				'keywords' => ['medium-dark skin tone', 'turban', 'uc8'],
			],
			'1f473-1f3ff' => [
				'name' => \XF::phrase('emoji.person_wearing_turban_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_wearing_turban_tone5:',
				'shortname_alternates' => [':man_with_turban_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f473-1f3ff-2642', '1f473-1f3ff-2640'],
				'unicode' => '👳🏿',
				'keywords' => ['dark skin tone', 'turban', 'uc8'],
			],
			'1f473-2640' => [
				'name' => \XF::phrase('emoji.woman_wearing_turban'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_wearing_turban:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f473-1f3ff-2640', '1f473-1f3fe-2640', '1f473-1f3fd-2640', '1f473-1f3fc-2640', '1f473-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👳‍♀️',
				'keywords' => ['turban', 'woman', 'uc6'],
			],
			'1f473-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_wearing_turban_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_wearing_turban_tone1:',
				'shortname_alternates' => [':woman_wearing_turban_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👳🏻‍♀️',
				'keywords' => ['light skin tone', 'turban', 'woman', 'uc8'],
			],
			'1f473-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_wearing_turban_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_wearing_turban_tone2:',
				'shortname_alternates' => [':woman_wearing_turban_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👳🏼‍♀️',
				'keywords' => ['medium-light skin tone', 'turban', 'woman', 'uc8'],
			],
			'1f473-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_wearing_turban_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_wearing_turban_tone3:',
				'shortname_alternates' => [':woman_wearing_turban_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👳🏽‍♀️',
				'keywords' => ['medium skin tone', 'turban', 'woman', 'uc8'],
			],
			'1f473-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_wearing_turban_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_wearing_turban_tone4:',
				'shortname_alternates' => [':woman_wearing_turban_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👳🏾‍♀️',
				'keywords' => ['medium-dark skin tone', 'turban', 'woman', 'uc8'],
			],
			'1f473-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_wearing_turban_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_wearing_turban_tone5:',
				'shortname_alternates' => [':woman_wearing_turban_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👳🏿‍♀️',
				'keywords' => ['dark skin tone', 'turban', 'woman', 'uc8'],
			],
			'1f473-2642' => [
				'name' => \XF::phrase('emoji.man_wearing_turban'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_wearing_turban:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f473-1f3ff-2642', '1f473-1f3fe-2642', '1f473-1f3fd-2642', '1f473-1f3fc-2642', '1f473-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👳‍♂️',
				'keywords' => ['man', 'turban', 'uc6'],
			],
			'1f473-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_wearing_turban_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_wearing_turban_tone1:',
				'shortname_alternates' => [':man_wearing_turban_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👳🏻‍♂️',
				'keywords' => ['light skin tone', 'man', 'turban', 'uc8'],
			],
			'1f473-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_wearing_turban_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_wearing_turban_tone2:',
				'shortname_alternates' => [':man_wearing_turban_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👳🏼‍♂️',
				'keywords' => ['man', 'medium-light skin tone', 'turban', 'uc8'],
			],
			'1f473-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_wearing_turban_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_wearing_turban_tone3:',
				'shortname_alternates' => [':man_wearing_turban_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👳🏽‍♂️',
				'keywords' => ['man', 'medium skin tone', 'turban', 'uc8'],
			],
			'1f473-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_wearing_turban_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_wearing_turban_tone4:',
				'shortname_alternates' => [':man_wearing_turban_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👳🏾‍♂️',
				'keywords' => ['man', 'medium-dark skin tone', 'turban', 'uc8'],
			],
			'1f473-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_wearing_turban_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_wearing_turban_tone5:',
				'shortname_alternates' => [':man_wearing_turban_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👳🏿‍♂️',
				'keywords' => ['dark skin tone', 'man', 'turban', 'uc8'],
			],
			'1f9d5' => [
				'name' => \XF::phrase('emoji.woman_with_headscarf'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_headscarf:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d5-1f3fb', '1f9d5-1f3fc', '1f9d5-1f3fd', '1f9d5-1f3fe', '1f9d5-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧕',
				'keywords' => ['uc10'],
			],
			'1f9d5-1f3fb' => [
				'name' => \XF::phrase('emoji.woman_with_headscarf_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_headscarf_tone1:',
				'shortname_alternates' => [':woman_with_headscarf_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧕🏻',
				'keywords' => ['headscarf', 'hijab', 'light skin tone', 'mantilla', 'tichel', 'uc10'],
			],
			'1f9d5-1f3fc' => [
				'name' => \XF::phrase('emoji.woman_with_headscarf_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_headscarf_tone2:',
				'shortname_alternates' => [':woman_with_headscarf_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧕🏼',
				'keywords' => ['headscarf', 'hijab', 'mantilla', 'medium-light skin tone', 'tichel', 'uc10'],
			],
			'1f9d5-1f3fd' => [
				'name' => \XF::phrase('emoji.woman_with_headscarf_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_headscarf_tone3:',
				'shortname_alternates' => [':woman_with_headscarf_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧕🏽',
				'keywords' => ['headscarf', 'hijab', 'mantilla', 'medium skin tone', 'tichel', 'uc10'],
			],
			'1f9d5-1f3fe' => [
				'name' => \XF::phrase('emoji.woman_with_headscarf_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_headscarf_tone4:',
				'shortname_alternates' => [':woman_with_headscarf_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧕🏾',
				'keywords' => ['headscarf', 'hijab', 'mantilla', 'medium-dark skin tone', 'tichel', 'uc10'],
			],
			'1f9d5-1f3ff' => [
				'name' => \XF::phrase('emoji.woman_with_headscarf_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_headscarf_tone5:',
				'shortname_alternates' => [':woman_with_headscarf_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧕🏿',
				'keywords' => ['dark skin tone', 'headscarf', 'hijab', 'mantilla', 'tichel', 'uc10'],
			],
			'1f46e' => [
				'name' => \XF::phrase('emoji.police_officer'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':police_officer:',
				'shortname_alternates' => [':cop:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f46e-1f3fb', '1f46e-1f3fc', '1f46e-1f3fd', '1f46e-1f3fe', '1f46e-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f46e-2642', '1f46e-2640'],
				'unicode' => '👮',
				'keywords' => ['cop', 'officer', 'police', 'uc6'],
			],
			'1f46e-1f3fb' => [
				'name' => \XF::phrase('emoji.police_officer_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':police_officer_tone1:',
				'shortname_alternates' => [':cop_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f46e-1f3fb-2642', '1f46e-1f3fb-2640'],
				'unicode' => '👮🏻',
				'keywords' => ['cop', 'light skin tone', 'officer', 'police', 'uc8'],
			],
			'1f46e-1f3fc' => [
				'name' => \XF::phrase('emoji.police_officer_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':police_officer_tone2:',
				'shortname_alternates' => [':cop_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f46e-1f3fc-2642', '1f46e-1f3fc-2640'],
				'unicode' => '👮🏼',
				'keywords' => ['cop', 'medium-light skin tone', 'officer', 'police', 'uc8'],
			],
			'1f46e-1f3fd' => [
				'name' => \XF::phrase('emoji.police_officer_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':police_officer_tone3:',
				'shortname_alternates' => [':cop_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f46e-1f3fd-2642', '1f46e-1f3fd-2640'],
				'unicode' => '👮🏽',
				'keywords' => ['cop', 'medium skin tone', 'officer', 'police', 'uc8'],
			],
			'1f46e-1f3fe' => [
				'name' => \XF::phrase('emoji.police_officer_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':police_officer_tone4:',
				'shortname_alternates' => [':cop_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f46e-1f3fe-2642', '1f46e-1f3fe-2640'],
				'unicode' => '👮🏾',
				'keywords' => ['cop', 'medium-dark skin tone', 'officer', 'police', 'uc8'],
			],
			'1f46e-1f3ff' => [
				'name' => \XF::phrase('emoji.police_officer_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':police_officer_tone5:',
				'shortname_alternates' => [':cop_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f46e-1f3ff-2642', '1f46e-1f3ff-2640'],
				'unicode' => '👮🏿',
				'keywords' => ['cop', 'dark skin tone', 'officer', 'police', 'uc8'],
			],
			'1f46e-2640' => [
				'name' => \XF::phrase('emoji.woman_police_officer'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_police_officer:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f46e-1f3ff-2640', '1f46e-1f3fe-2640', '1f46e-1f3fd-2640', '1f46e-1f3fc-2640', '1f46e-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👮‍♀️',
				'keywords' => ['cop', 'officer', 'police', 'woman', 'uc6'],
			],
			'1f46e-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_police_officer_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_police_officer_tone1:',
				'shortname_alternates' => [':woman_police_officer_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👮🏻‍♀️',
				'keywords' => ['cop', 'light skin tone', 'officer', 'police', 'woman', 'uc8'],
			],
			'1f46e-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_police_officer_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_police_officer_tone2:',
				'shortname_alternates' => [':woman_police_officer_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👮🏼‍♀️',
				'keywords' => ['cop', 'medium-light skin tone', 'officer', 'police', 'woman', 'uc8'],
			],
			'1f46e-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_police_officer_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_police_officer_tone3:',
				'shortname_alternates' => [':woman_police_officer_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👮🏽‍♀️',
				'keywords' => ['cop', 'medium skin tone', 'officer', 'police', 'woman', 'uc8'],
			],
			'1f46e-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_police_officer_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_police_officer_tone4:',
				'shortname_alternates' => [':woman_police_officer_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👮🏾‍♀️',
				'keywords' => ['cop', 'medium-dark skin tone', 'officer', 'police', 'woman', 'uc8'],
			],
			'1f46e-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_police_officer_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_police_officer_tone5:',
				'shortname_alternates' => [':woman_police_officer_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👮🏿‍♀️',
				'keywords' => ['cop', 'dark skin tone', 'officer', 'police', 'woman', 'uc8'],
			],
			'1f46e-2642' => [
				'name' => \XF::phrase('emoji.man_police_officer'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_police_officer:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f46e-1f3ff-2642', '1f46e-1f3fe-2642', '1f46e-1f3fd-2642', '1f46e-1f3fc-2642', '1f46e-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👮‍♂️',
				'keywords' => ['cop', 'man', 'officer', 'police', 'uc6'],
			],
			'1f46e-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_police_officer_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_police_officer_tone1:',
				'shortname_alternates' => [':man_police_officer_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👮🏻‍♂️',
				'keywords' => ['cop', 'light skin tone', 'man', 'officer', 'police', 'uc8'],
			],
			'1f46e-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_police_officer_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_police_officer_tone2:',
				'shortname_alternates' => [':man_police_officer_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👮🏼‍♂️',
				'keywords' => ['cop', 'man', 'medium-light skin tone', 'officer', 'police', 'uc8'],
			],
			'1f46e-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_police_officer_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_police_officer_tone3:',
				'shortname_alternates' => [':man_police_officer_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👮🏽‍♂️',
				'keywords' => ['cop', 'man', 'medium skin tone', 'officer', 'police', 'uc8'],
			],
			'1f46e-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_police_officer_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_police_officer_tone4:',
				'shortname_alternates' => [':man_police_officer_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👮🏾‍♂️',
				'keywords' => ['cop', 'man', 'medium-dark skin tone', 'officer', 'police', 'uc8'],
			],
			'1f46e-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_police_officer_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_police_officer_tone5:',
				'shortname_alternates' => [':man_police_officer_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👮🏿‍♂️',
				'keywords' => ['cop', 'dark skin tone', 'man', 'officer', 'police', 'uc8'],
			],
			'1f477' => [
				'name' => \XF::phrase('emoji.construction_worker'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':construction_worker:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f477-1f3fb', '1f477-1f3fc', '1f477-1f3fd', '1f477-1f3fe', '1f477-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f477-2642', '1f477-2640'],
				'unicode' => '👷',
				'keywords' => ['construction', 'hat', 'worker', 'uc6'],
			],
			'1f477-1f3fb' => [
				'name' => \XF::phrase('emoji.construction_worker_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':construction_worker_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f477-1f3fb-2642', '1f477-1f3fb-2640'],
				'unicode' => '👷🏻',
				'keywords' => ['construction', 'hat', 'light skin tone', 'worker', 'uc8'],
			],
			'1f477-1f3fc' => [
				'name' => \XF::phrase('emoji.construction_worker_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':construction_worker_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f477-1f3fc-2642', '1f477-1f3fc-2640'],
				'unicode' => '👷🏼',
				'keywords' => ['construction', 'hat', 'medium-light skin tone', 'worker', 'uc8'],
			],
			'1f477-1f3fd' => [
				'name' => \XF::phrase('emoji.construction_worker_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':construction_worker_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f477-1f3fd-2642', '1f477-1f3fd-2640'],
				'unicode' => '👷🏽',
				'keywords' => ['construction', 'hat', 'medium skin tone', 'worker', 'uc8'],
			],
			'1f477-1f3fe' => [
				'name' => \XF::phrase('emoji.construction_worker_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':construction_worker_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f477-1f3fe-2642', '1f477-1f3fe-2640'],
				'unicode' => '👷🏾',
				'keywords' => ['construction', 'hat', 'medium-dark skin tone', 'worker', 'uc8'],
			],
			'1f477-1f3ff' => [
				'name' => \XF::phrase('emoji.construction_worker_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':construction_worker_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f477-1f3ff-2642', '1f477-1f3ff-2640'],
				'unicode' => '👷🏿',
				'keywords' => ['construction', 'dark skin tone', 'hat', 'worker', 'uc8'],
			],
			'1f477-2640' => [
				'name' => \XF::phrase('emoji.woman_construction_worker'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_construction_worker:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f477-1f3ff-2640', '1f477-1f3fe-2640', '1f477-1f3fd-2640', '1f477-1f3fc-2640', '1f477-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👷‍♀️',
				'keywords' => ['construction', 'woman', 'worker', 'uc6'],
			],
			'1f477-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_construction_worker_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_construction_worker_tone1:',
				'shortname_alternates' => [':woman_construction_worker_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👷🏻‍♀️',
				'keywords' => ['construction', 'light skin tone', 'woman', 'worker', 'uc8'],
			],
			'1f477-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_construction_worker_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_construction_worker_tone2:',
				'shortname_alternates' => [':woman_construction_worker_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👷🏼‍♀️',
				'keywords' => ['construction', 'medium-light skin tone', 'woman', 'worker', 'uc8'],
			],
			'1f477-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_construction_worker_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_construction_worker_tone3:',
				'shortname_alternates' => [':woman_construction_worker_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👷🏽‍♀️',
				'keywords' => ['construction', 'medium skin tone', 'woman', 'worker', 'uc8'],
			],
			'1f477-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_construction_worker_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_construction_worker_tone4:',
				'shortname_alternates' => [':woman_construction_worker_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👷🏾‍♀️',
				'keywords' => ['construction', 'medium-dark skin tone', 'woman', 'worker', 'uc8'],
			],
			'1f477-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_construction_worker_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_construction_worker_tone5:',
				'shortname_alternates' => [':woman_construction_worker_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👷🏿‍♀️',
				'keywords' => ['construction', 'dark skin tone', 'woman', 'worker', 'uc8'],
			],
			'1f477-2642' => [
				'name' => \XF::phrase('emoji.man_construction_worker'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_construction_worker:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f477-1f3ff-2642', '1f477-1f3fe-2642', '1f477-1f3fd-2642', '1f477-1f3fc-2642', '1f477-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👷‍♂️',
				'keywords' => ['construction', 'man', 'worker', 'uc6'],
			],
			'1f477-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_construction_worker_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_construction_worker_tone1:',
				'shortname_alternates' => [':man_construction_worker_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👷🏻‍♂️',
				'keywords' => ['construction', 'light skin tone', 'man', 'worker', 'uc8'],
			],
			'1f477-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_construction_worker_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_construction_worker_tone2:',
				'shortname_alternates' => [':man_construction_worker_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👷🏼‍♂️',
				'keywords' => ['construction', 'man', 'medium-light skin tone', 'worker', 'uc8'],
			],
			'1f477-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_construction_worker_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_construction_worker_tone3:',
				'shortname_alternates' => [':man_construction_worker_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👷🏽‍♂️',
				'keywords' => ['construction', 'man', 'medium skin tone', 'worker', 'uc8'],
			],
			'1f477-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_construction_worker_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_construction_worker_tone4:',
				'shortname_alternates' => [':man_construction_worker_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👷🏾‍♂️',
				'keywords' => ['construction', 'man', 'medium-dark skin tone', 'worker', 'uc8'],
			],
			'1f477-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_construction_worker_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_construction_worker_tone5:',
				'shortname_alternates' => [':man_construction_worker_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👷🏿‍♂️',
				'keywords' => ['construction', 'dark skin tone', 'man', 'worker', 'uc8'],
			],
			'1f482' => [
				'name' => \XF::phrase('emoji.guard'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':guard:',
				'shortname_alternates' => [':guardsman:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f482-1f3fb', '1f482-1f3fc', '1f482-1f3fd', '1f482-1f3fe', '1f482-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f482-2642', '1f482-2640'],
				'unicode' => '💂',
				'keywords' => ['guard', 'uc6'],
			],
			'1f482-1f3fb' => [
				'name' => \XF::phrase('emoji.guard_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':guard_tone1:',
				'shortname_alternates' => [':guardsman_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f482-1f3fb-2642', '1f482-1f3fb-2640'],
				'unicode' => '💂🏻',
				'keywords' => ['guard', 'light skin tone', 'uc8'],
			],
			'1f482-1f3fc' => [
				'name' => \XF::phrase('emoji.guard_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':guard_tone2:',
				'shortname_alternates' => [':guardsman_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f482-1f3fc-2642', '1f482-1f3fc-2640'],
				'unicode' => '💂🏼',
				'keywords' => ['guard', 'medium-light skin tone', 'uc8'],
			],
			'1f482-1f3fd' => [
				'name' => \XF::phrase('emoji.guard_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':guard_tone3:',
				'shortname_alternates' => [':guardsman_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f482-1f3fd-2642', '1f482-1f3fd-2640'],
				'unicode' => '💂🏽',
				'keywords' => ['guard', 'medium skin tone', 'uc8'],
			],
			'1f482-1f3fe' => [
				'name' => \XF::phrase('emoji.guard_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':guard_tone4:',
				'shortname_alternates' => [':guardsman_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f482-1f3fe-2642', '1f482-1f3fe-2640'],
				'unicode' => '💂🏾',
				'keywords' => ['guard', 'medium-dark skin tone', 'uc8'],
			],
			'1f482-1f3ff' => [
				'name' => \XF::phrase('emoji.guard_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':guard_tone5:',
				'shortname_alternates' => [':guardsman_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f482-1f3ff-2642', '1f482-1f3ff-2640'],
				'unicode' => '💂🏿',
				'keywords' => ['dark skin tone', 'guard', 'uc8'],
			],
			'1f482-2640' => [
				'name' => \XF::phrase('emoji.woman_guard'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_guard:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f482-1f3ff-2640', '1f482-1f3fe-2640', '1f482-1f3fd-2640', '1f482-1f3fc-2640', '1f482-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '💂‍♀️',
				'keywords' => ['guard', 'woman', 'uc6'],
			],
			'1f482-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_guard_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_guard_tone1:',
				'shortname_alternates' => [':woman_guard_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '💂🏻‍♀️',
				'keywords' => ['guard', 'light skin tone', 'woman', 'uc8'],
			],
			'1f482-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_guard_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_guard_tone2:',
				'shortname_alternates' => [':woman_guard_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '💂🏼‍♀️',
				'keywords' => ['guard', 'medium-light skin tone', 'woman', 'uc8'],
			],
			'1f482-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_guard_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_guard_tone3:',
				'shortname_alternates' => [':woman_guard_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '💂🏽‍♀️',
				'keywords' => ['guard', 'medium skin tone', 'woman', 'uc8'],
			],
			'1f482-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_guard_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_guard_tone4:',
				'shortname_alternates' => [':woman_guard_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '💂🏾‍♀️',
				'keywords' => ['guard', 'medium-dark skin tone', 'woman', 'uc8'],
			],
			'1f482-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_guard_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_guard_tone5:',
				'shortname_alternates' => [':woman_guard_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '💂🏿‍♀️',
				'keywords' => ['dark skin tone', 'guard', 'woman', 'uc8'],
			],
			'1f482-2642' => [
				'name' => \XF::phrase('emoji.man_guard'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_guard:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f482-1f3ff-2642', '1f482-1f3fe-2642', '1f482-1f3fd-2642', '1f482-1f3fc-2642', '1f482-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '💂‍♂️',
				'keywords' => ['guard', 'man', 'uc6'],
			],
			'1f482-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_guard_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_guard_tone1:',
				'shortname_alternates' => [':man_guard_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '💂🏻‍♂️',
				'keywords' => ['guard', 'light skin tone', 'man', 'uc8'],
			],
			'1f482-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_guard_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_guard_tone2:',
				'shortname_alternates' => [':man_guard_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '💂🏼‍♂️',
				'keywords' => ['guard', 'man', 'medium-light skin tone', 'uc8'],
			],
			'1f482-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_guard_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_guard_tone3:',
				'shortname_alternates' => [':man_guard_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '💂🏽‍♂️',
				'keywords' => ['guard', 'man', 'medium skin tone', 'uc8'],
			],
			'1f482-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_guard_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_guard_tone4:',
				'shortname_alternates' => [':man_guard_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '💂🏾‍♂️',
				'keywords' => ['guard', 'man', 'medium-dark skin tone', 'uc8'],
			],
			'1f482-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_guard_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_guard_tone5:',
				'shortname_alternates' => [':man_guard_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '💂🏿‍♂️',
				'keywords' => ['dark skin tone', 'guard', 'man', 'uc8'],
			],
			'1f575' => [
				'name' => \XF::phrase('emoji.detective'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':detective:',
				'shortname_alternates' => [':spy:', ':sleuth_or_spy:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f575-1f3fb', '1f575-1f3fc', '1f575-1f3fd', '1f575-1f3fe', '1f575-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f575-2642', '1f575-2640'],
				'unicode' => '🕵️',
				'keywords' => ['detective', 'sleuth', 'spy', 'uc7'],
			],
			'1f575-1f3fb' => [
				'name' => \XF::phrase('emoji.detective_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':detective_tone1:',
				'shortname_alternates' => [':spy_tone1:', ':sleuth_or_spy_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f575-1f3fb-2642', '1f575-1f3fb-2640'],
				'unicode' => '🕵🏻',
				'keywords' => ['detective', 'light skin tone', 'sleuth', 'spy', 'uc8'],
			],
			'1f575-1f3fc' => [
				'name' => \XF::phrase('emoji.detective_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':detective_tone2:',
				'shortname_alternates' => [':spy_tone2:', ':sleuth_or_spy_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f575-1f3fc-2642', '1f575-1f3fc-2640'],
				'unicode' => '🕵🏼',
				'keywords' => ['detective', 'medium-light skin tone', 'sleuth', 'spy', 'uc8'],
			],
			'1f575-1f3fd' => [
				'name' => \XF::phrase('emoji.detective_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':detective_tone3:',
				'shortname_alternates' => [':spy_tone3:', ':sleuth_or_spy_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f575-1f3fd-2642', '1f575-1f3fd-2640'],
				'unicode' => '🕵🏽',
				'keywords' => ['detective', 'medium skin tone', 'sleuth', 'spy', 'uc8'],
			],
			'1f575-1f3fe' => [
				'name' => \XF::phrase('emoji.detective_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':detective_tone4:',
				'shortname_alternates' => [':spy_tone4:', ':sleuth_or_spy_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f575-1f3fe-2642', '1f575-1f3fe-2640'],
				'unicode' => '🕵🏾',
				'keywords' => ['detective', 'medium-dark skin tone', 'sleuth', 'spy', 'uc8'],
			],
			'1f575-1f3ff' => [
				'name' => \XF::phrase('emoji.detective_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':detective_tone5:',
				'shortname_alternates' => [':spy_tone5:', ':sleuth_or_spy_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f575-1f3ff-2642', '1f575-1f3ff-2640'],
				'unicode' => '🕵🏿',
				'keywords' => ['dark skin tone', 'detective', 'sleuth', 'spy', 'uc8'],
			],
			'1f575-2640' => [
				'name' => \XF::phrase('emoji.woman_detective'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_detective:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f575-1f3ff-2640', '1f575-1f3fe-2640', '1f575-1f3fd-2640', '1f575-1f3fc-2640', '1f575-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🕵️‍♀️',
				'keywords' => ['detective', 'sleuth', 'spy', 'woman', 'uc7'],
			],
			'1f575-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_detective_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_detective_tone1:',
				'shortname_alternates' => [':woman_detective_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🕵🏻‍♀️',
				'keywords' => ['detective', 'light skin tone', 'sleuth', 'spy', 'woman', 'uc8'],
			],
			'1f575-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_detective_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_detective_tone2:',
				'shortname_alternates' => [':woman_detective_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🕵🏼‍♀️',
				'keywords' => ['detective', 'medium-light skin tone', 'sleuth', 'spy', 'woman', 'uc8'],
			],
			'1f575-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_detective_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_detective_tone3:',
				'shortname_alternates' => [':woman_detective_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🕵🏽‍♀️',
				'keywords' => ['detective', 'medium skin tone', 'sleuth', 'spy', 'woman', 'uc8'],
			],
			'1f575-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_detective_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_detective_tone4:',
				'shortname_alternates' => [':woman_detective_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🕵🏾‍♀️',
				'keywords' => ['detective', 'medium-dark skin tone', 'sleuth', 'spy', 'woman', 'uc8'],
			],
			'1f575-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_detective_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_detective_tone5:',
				'shortname_alternates' => [':woman_detective_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🕵🏿‍♀️',
				'keywords' => ['dark skin tone', 'detective', 'sleuth', 'spy', 'woman', 'uc8'],
			],
			'1f575-2642' => [
				'name' => \XF::phrase('emoji.man_detective'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_detective:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f575-1f3ff-2642', '1f575-1f3fe-2642', '1f575-1f3fd-2642', '1f575-1f3fc-2642', '1f575-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🕵️‍♂️',
				'keywords' => ['detective', 'man', 'sleuth', 'spy', 'uc7'],
			],
			'1f575-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_detective_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_detective_tone1:',
				'shortname_alternates' => [':man_detective_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🕵🏻‍♂️',
				'keywords' => ['detective', 'light skin tone', 'man', 'sleuth', 'spy', 'uc8'],
			],
			'1f575-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_detective_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_detective_tone2:',
				'shortname_alternates' => [':man_detective_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🕵🏼‍♂️',
				'keywords' => ['detective', 'man', 'medium-light skin tone', 'sleuth', 'spy', 'uc8'],
			],
			'1f575-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_detective_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_detective_tone3:',
				'shortname_alternates' => [':man_detective_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🕵🏽‍♂️',
				'keywords' => ['detective', 'man', 'medium skin tone', 'sleuth', 'spy', 'uc8'],
			],
			'1f575-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_detective_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_detective_tone4:',
				'shortname_alternates' => [':man_detective_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🕵🏾‍♂️',
				'keywords' => ['detective', 'man', 'medium-dark skin tone', 'sleuth', 'spy', 'uc8'],
			],
			'1f575-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_detective_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_detective_tone5:',
				'shortname_alternates' => [':man_detective_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🕵🏿‍♂️',
				'keywords' => ['dark skin tone', 'detective', 'man', 'sleuth', 'spy', 'uc8'],
			],
			'1f9d1-2695' => [
				'name' => \XF::phrase('emoji.health_worker'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':health_worker:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-2695', '1f9d1-1f3fc-2695', '1f9d1-1f3fd-2695', '1f9d1-1f3fe-2695', '1f9d1-1f3ff-2695'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑‍⚕️',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-2695' => [
				'name' => \XF::phrase('emoji.health_worker_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':health_worker_tone1:',
				'shortname_alternates' => [':health_worker_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍⚕️',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-2695' => [
				'name' => \XF::phrase('emoji.health_worker_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':health_worker_tone2:',
				'shortname_alternates' => [':health_worker_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍⚕️',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-2695' => [
				'name' => \XF::phrase('emoji.health_worker_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':health_worker_tone3:',
				'shortname_alternates' => [':health_worker_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍⚕️',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-2695' => [
				'name' => \XF::phrase('emoji.health_worker_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':health_worker_tone4:',
				'shortname_alternates' => [':health_worker_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍⚕️',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-2695' => [
				'name' => \XF::phrase('emoji.health_worker_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':health_worker_tone5:',
				'shortname_alternates' => [':health_worker_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍⚕️',
				'keywords' => ['uc12'],
			],
			'1f469-2695' => [
				'name' => \XF::phrase('emoji.woman_health_worker'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_health_worker:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3ff-2695', '1f469-1f3fe-2695', '1f469-1f3fd-2695', '1f469-1f3fc-2695', '1f469-1f3fb-2695'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩‍⚕️',
				'keywords' => ['doctor', 'healthcare', 'nurse', 'therapist', 'woman', 'uc6'],
			],
			'1f469-1f3fb-2695' => [
				'name' => \XF::phrase('emoji.woman_health_worker_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_health_worker_tone1:',
				'shortname_alternates' => [':woman_health_worker_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻‍⚕️',
				'keywords' => ['doctor', 'healthcare', 'light skin tone', 'nurse', 'therapist', 'woman', 'uc8'],
			],
			'1f469-1f3fc-2695' => [
				'name' => \XF::phrase('emoji.woman_health_worker_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_health_worker_tone2:',
				'shortname_alternates' => [':woman_health_worker_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼‍⚕️',
				'keywords' => ['doctor', 'healthcare', 'medium-light skin tone', 'nurse', 'therapist', 'woman', 'uc8'],
			],
			'1f469-1f3fd-2695' => [
				'name' => \XF::phrase('emoji.woman_health_worker_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_health_worker_tone3:',
				'shortname_alternates' => [':woman_health_worker_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏽‍⚕️',
				'keywords' => ['doctor', 'healthcare', 'medium skin tone', 'nurse', 'therapist', 'woman', 'uc8'],
			],
			'1f469-1f3fe-2695' => [
				'name' => \XF::phrase('emoji.woman_health_worker_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_health_worker_tone4:',
				'shortname_alternates' => [':woman_health_worker_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏾‍⚕️',
				'keywords' => ['doctor', 'healthcare', 'medium-dark skin tone', 'nurse', 'therapist', 'woman', 'uc8'],
			],
			'1f469-1f3ff-2695' => [
				'name' => \XF::phrase('emoji.woman_health_worker_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_health_worker_tone5:',
				'shortname_alternates' => [':woman_health_worker_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏿‍⚕️',
				'keywords' => ['dark skin tone', 'doctor', 'healthcare', 'nurse', 'therapist', 'woman', 'uc8'],
			],
			'1f468-2695' => [
				'name' => \XF::phrase('emoji.man_health_worker'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_health_worker:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3ff-2695', '1f468-1f3fe-2695', '1f468-1f3fd-2695', '1f468-1f3fc-2695', '1f468-1f3fb-2695'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨‍⚕️',
				'keywords' => ['doctor', 'healthcare', 'man', 'nurse', 'therapist', 'uc6'],
			],
			'1f468-1f3fb-2695' => [
				'name' => \XF::phrase('emoji.man_health_worker_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_health_worker_tone1:',
				'shortname_alternates' => [':man_health_worker_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏻‍⚕️',
				'keywords' => ['doctor', 'healthcare', 'light skin tone', 'man', 'nurse', 'therapist', 'uc8'],
			],
			'1f468-1f3fc-2695' => [
				'name' => \XF::phrase('emoji.man_health_worker_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_health_worker_tone2:',
				'shortname_alternates' => [':man_health_worker_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏼‍⚕️',
				'keywords' => ['doctor', 'healthcare', 'man', 'medium-light skin tone', 'nurse', 'therapist', 'uc8'],
			],
			'1f468-1f3fd-2695' => [
				'name' => \XF::phrase('emoji.man_health_worker_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_health_worker_tone3:',
				'shortname_alternates' => [':man_health_worker_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏽‍⚕️',
				'keywords' => ['doctor', 'healthcare', 'man', 'medium skin tone', 'nurse', 'therapist', 'uc8'],
			],
			'1f468-1f3fe-2695' => [
				'name' => \XF::phrase('emoji.man_health_worker_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_health_worker_tone4:',
				'shortname_alternates' => [':man_health_worker_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏾‍⚕️',
				'keywords' => ['doctor', 'healthcare', 'man', 'medium-dark skin tone', 'nurse', 'therapist', 'uc8'],
			],
			'1f468-1f3ff-2695' => [
				'name' => \XF::phrase('emoji.man_health_worker_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_health_worker_tone5:',
				'shortname_alternates' => [':man_health_worker_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏿‍⚕️',
				'keywords' => ['dark skin tone', 'doctor', 'healthcare', 'man', 'nurse', 'therapist', 'uc8'],
			],
			'1f9d1-1f33e' => [
				'name' => \XF::phrase('emoji.farmer'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':farmer:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f33e', '1f9d1-1f3fc-1f33e', '1f9d1-1f3fd-1f33e', '1f9d1-1f3fe-1f33e', '1f9d1-1f3ff-1f33e'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑‍🌾',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f33e' => [
				'name' => \XF::phrase('emoji.farmer_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':farmer_tone1:',
				'shortname_alternates' => [':farmer_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍🌾',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f33e' => [
				'name' => \XF::phrase('emoji.farmer_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':farmer_tone2:',
				'shortname_alternates' => [':farmer_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍🌾',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f33e' => [
				'name' => \XF::phrase('emoji.farmer_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':farmer_tone3:',
				'shortname_alternates' => [':farmer_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍🌾',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f33e' => [
				'name' => \XF::phrase('emoji.farmer_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':farmer_tone4:',
				'shortname_alternates' => [':farmer_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍🌾',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f33e' => [
				'name' => \XF::phrase('emoji.farmer_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':farmer_tone5:',
				'shortname_alternates' => [':farmer_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍🌾',
				'keywords' => ['uc12'],
			],
			'1f469-1f33e' => [
				'name' => \XF::phrase('emoji.woman_farmer'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_farmer:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3ff-1f33e', '1f469-1f3fe-1f33e', '1f469-1f3fd-1f33e', '1f469-1f3fc-1f33e', '1f469-1f3fb-1f33e'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩‍🌾',
				'keywords' => ['farmer', 'gardener', 'rancher', 'woman', 'uc6'],
			],
			'1f469-1f3fb-1f33e' => [
				'name' => \XF::phrase('emoji.woman_farmer_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_farmer_tone1:',
				'shortname_alternates' => [':woman_farmer_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻‍🌾',
				'keywords' => ['farmer', 'gardener', 'light skin tone', 'rancher', 'woman', 'uc8'],
			],
			'1f469-1f3fc-1f33e' => [
				'name' => \XF::phrase('emoji.woman_farmer_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_farmer_tone2:',
				'shortname_alternates' => [':woman_farmer_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼‍🌾',
				'keywords' => ['farmer', 'gardener', 'medium-light skin tone', 'rancher', 'woman', 'uc8'],
			],
			'1f469-1f3fd-1f33e' => [
				'name' => \XF::phrase('emoji.woman_farmer_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_farmer_tone3:',
				'shortname_alternates' => [':woman_farmer_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏽‍🌾',
				'keywords' => ['farmer', 'gardener', 'medium skin tone', 'rancher', 'woman', 'uc8'],
			],
			'1f469-1f3fe-1f33e' => [
				'name' => \XF::phrase('emoji.woman_farmer_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_farmer_tone4:',
				'shortname_alternates' => [':woman_farmer_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏾‍🌾',
				'keywords' => ['farmer', 'gardener', 'medium-dark skin tone', 'rancher', 'woman', 'uc8'],
			],
			'1f469-1f3ff-1f33e' => [
				'name' => \XF::phrase('emoji.woman_farmer_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_farmer_tone5:',
				'shortname_alternates' => [':woman_farmer_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏿‍🌾',
				'keywords' => ['dark skin tone', 'farmer', 'gardener', 'rancher', 'woman', 'uc8'],
			],
			'1f468-1f33e' => [
				'name' => \XF::phrase('emoji.man_farmer'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_farmer:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3ff-1f33e', '1f468-1f3fe-1f33e', '1f468-1f3fd-1f33e', '1f468-1f3fc-1f33e', '1f468-1f3fb-1f33e'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨‍🌾',
				'keywords' => ['farmer', 'gardener', 'man', 'rancher', 'uc6'],
			],
			'1f468-1f3fb-1f33e' => [
				'name' => \XF::phrase('emoji.man_farmer_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_farmer_tone1:',
				'shortname_alternates' => [':man_farmer_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏻‍🌾',
				'keywords' => ['farmer', 'gardener', 'light skin tone', 'man', 'rancher', 'uc8'],
			],
			'1f468-1f3fc-1f33e' => [
				'name' => \XF::phrase('emoji.man_farmer_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_farmer_tone2:',
				'shortname_alternates' => [':man_farmer_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏼‍🌾',
				'keywords' => ['farmer', 'gardener', 'man', 'medium-light skin tone', 'rancher', 'uc8'],
			],
			'1f468-1f3fd-1f33e' => [
				'name' => \XF::phrase('emoji.man_farmer_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_farmer_tone3:',
				'shortname_alternates' => [':man_farmer_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏽‍🌾',
				'keywords' => ['farmer', 'gardener', 'man', 'medium skin tone', 'rancher', 'uc8'],
			],
			'1f468-1f3fe-1f33e' => [
				'name' => \XF::phrase('emoji.man_farmer_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_farmer_tone4:',
				'shortname_alternates' => [':man_farmer_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏾‍🌾',
				'keywords' => ['farmer', 'gardener', 'man', 'medium-dark skin tone', 'rancher', 'uc8'],
			],
			'1f468-1f3ff-1f33e' => [
				'name' => \XF::phrase('emoji.man_farmer_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_farmer_tone5:',
				'shortname_alternates' => [':man_farmer_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏿‍🌾',
				'keywords' => ['dark skin tone', 'farmer', 'gardener', 'man', 'rancher', 'uc8'],
			],
			'1f9d1-1f373' => [
				'name' => \XF::phrase('emoji.cook'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':cook:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f373', '1f9d1-1f3fc-1f373', '1f9d1-1f3fd-1f373', '1f9d1-1f3fe-1f373', '1f9d1-1f3ff-1f373'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑‍🍳',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f373' => [
				'name' => \XF::phrase('emoji.cook_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':cook_tone1:',
				'shortname_alternates' => [':cook_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍🍳',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f373' => [
				'name' => \XF::phrase('emoji.cook_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':cook_tone2:',
				'shortname_alternates' => [':cook_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍🍳',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f373' => [
				'name' => \XF::phrase('emoji.cook_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':cook_tone3:',
				'shortname_alternates' => [':cook_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍🍳',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f373' => [
				'name' => \XF::phrase('emoji.cook_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':cook_tone4:',
				'shortname_alternates' => [':cook_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍🍳',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f373' => [
				'name' => \XF::phrase('emoji.cook_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':cook_tone5:',
				'shortname_alternates' => [':cook_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍🍳',
				'keywords' => ['uc12'],
			],
			'1f469-1f373' => [
				'name' => \XF::phrase('emoji.woman_cook'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_cook:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3ff-1f373', '1f469-1f3fe-1f373', '1f469-1f3fd-1f373', '1f469-1f3fc-1f373', '1f469-1f3fb-1f373'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩‍🍳',
				'keywords' => ['chef', 'cook', 'woman', 'uc6'],
			],
			'1f469-1f3fb-1f373' => [
				'name' => \XF::phrase('emoji.woman_cook_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_cook_tone1:',
				'shortname_alternates' => [':woman_cook_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻‍🍳',
				'keywords' => ['chef', 'cook', 'light skin tone', 'woman', 'uc8'],
			],
			'1f469-1f3fc-1f373' => [
				'name' => \XF::phrase('emoji.woman_cook_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_cook_tone2:',
				'shortname_alternates' => [':woman_cook_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼‍🍳',
				'keywords' => ['chef', 'cook', 'medium-light skin tone', 'woman', 'uc8'],
			],
			'1f469-1f3fd-1f373' => [
				'name' => \XF::phrase('emoji.woman_cook_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_cook_tone3:',
				'shortname_alternates' => [':woman_cook_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏽‍🍳',
				'keywords' => ['chef', 'cook', 'medium skin tone', 'woman', 'uc8'],
			],
			'1f469-1f3fe-1f373' => [
				'name' => \XF::phrase('emoji.woman_cook_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_cook_tone4:',
				'shortname_alternates' => [':woman_cook_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏾‍🍳',
				'keywords' => ['chef', 'cook', 'medium-dark skin tone', 'woman', 'uc8'],
			],
			'1f469-1f3ff-1f373' => [
				'name' => \XF::phrase('emoji.woman_cook_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_cook_tone5:',
				'shortname_alternates' => [':woman_cook_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏿‍🍳',
				'keywords' => ['chef', 'cook', 'dark skin tone', 'woman', 'uc8'],
			],
			'1f468-1f373' => [
				'name' => \XF::phrase('emoji.man_cook'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_cook:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3ff-1f373', '1f468-1f3fe-1f373', '1f468-1f3fd-1f373', '1f468-1f3fc-1f373', '1f468-1f3fb-1f373'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨‍🍳',
				'keywords' => ['chef', 'cook', 'man', 'uc6'],
			],
			'1f468-1f3fb-1f373' => [
				'name' => \XF::phrase('emoji.man_cook_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_cook_tone1:',
				'shortname_alternates' => [':man_cook_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏻‍🍳',
				'keywords' => ['chef', 'cook', 'light skin tone', 'man', 'uc8'],
			],
			'1f468-1f3fc-1f373' => [
				'name' => \XF::phrase('emoji.man_cook_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_cook_tone2:',
				'shortname_alternates' => [':man_cook_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏼‍🍳',
				'keywords' => ['chef', 'cook', 'man', 'medium-light skin tone', 'uc8'],
			],
			'1f468-1f3fd-1f373' => [
				'name' => \XF::phrase('emoji.man_cook_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_cook_tone3:',
				'shortname_alternates' => [':man_cook_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏽‍🍳',
				'keywords' => ['chef', 'cook', 'man', 'medium skin tone', 'uc8'],
			],
			'1f468-1f3fe-1f373' => [
				'name' => \XF::phrase('emoji.man_cook_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_cook_tone4:',
				'shortname_alternates' => [':man_cook_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏾‍🍳',
				'keywords' => ['chef', 'cook', 'man', 'medium-dark skin tone', 'uc8'],
			],
			'1f468-1f3ff-1f373' => [
				'name' => \XF::phrase('emoji.man_cook_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_cook_tone5:',
				'shortname_alternates' => [':man_cook_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏿‍🍳',
				'keywords' => ['chef', 'cook', 'dark skin tone', 'man', 'uc8'],
			],
			'1f9d1-1f393' => [
				'name' => \XF::phrase('emoji.student'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':student:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f393', '1f9d1-1f3fc-1f393', '1f9d1-1f3fd-1f393', '1f9d1-1f3fe-1f393', '1f9d1-1f3ff-1f393'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑‍🎓',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f393' => [
				'name' => \XF::phrase('emoji.student_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':student_tone1:',
				'shortname_alternates' => [':student_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍🎓',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f393' => [
				'name' => \XF::phrase('emoji.student_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':student_tone2:',
				'shortname_alternates' => [':student_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍🎓',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f393' => [
				'name' => \XF::phrase('emoji.student_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':student_tone3:',
				'shortname_alternates' => [':student_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍🎓',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f393' => [
				'name' => \XF::phrase('emoji.student_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':student_tone4:',
				'shortname_alternates' => [':student_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍🎓',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f393' => [
				'name' => \XF::phrase('emoji.student_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':student_tone5:',
				'shortname_alternates' => [':student_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍🎓',
				'keywords' => ['uc12'],
			],
			'1f469-1f393' => [
				'name' => \XF::phrase('emoji.woman_student'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_student:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3ff-1f393', '1f469-1f3fe-1f393', '1f469-1f3fd-1f393', '1f469-1f3fc-1f393', '1f469-1f3fb-1f393'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩‍🎓',
				'keywords' => ['graduate', 'student', 'woman', 'uc6'],
			],
			'1f469-1f3fb-1f393' => [
				'name' => \XF::phrase('emoji.woman_student_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_student_tone1:',
				'shortname_alternates' => [':woman_student_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻‍🎓',
				'keywords' => ['graduate', 'light skin tone', 'student', 'woman', 'uc8'],
			],
			'1f469-1f3fc-1f393' => [
				'name' => \XF::phrase('emoji.woman_student_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_student_tone2:',
				'shortname_alternates' => [':woman_student_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼‍🎓',
				'keywords' => ['graduate', 'medium-light skin tone', 'student', 'woman', 'uc8'],
			],
			'1f469-1f3fd-1f393' => [
				'name' => \XF::phrase('emoji.woman_student_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_student_tone3:',
				'shortname_alternates' => [':woman_student_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏽‍🎓',
				'keywords' => ['graduate', 'medium skin tone', 'student', 'woman', 'uc8'],
			],
			'1f469-1f3fe-1f393' => [
				'name' => \XF::phrase('emoji.woman_student_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_student_tone4:',
				'shortname_alternates' => [':woman_student_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏾‍🎓',
				'keywords' => ['graduate', 'medium-dark skin tone', 'student', 'woman', 'uc8'],
			],
			'1f469-1f3ff-1f393' => [
				'name' => \XF::phrase('emoji.woman_student_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_student_tone5:',
				'shortname_alternates' => [':woman_student_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏿‍🎓',
				'keywords' => ['dark skin tone', 'graduate', 'student', 'woman', 'uc8'],
			],
			'1f468-1f393' => [
				'name' => \XF::phrase('emoji.man_student'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_student:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3ff-1f393', '1f468-1f3fe-1f393', '1f468-1f3fd-1f393', '1f468-1f3fc-1f393', '1f468-1f3fb-1f393'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨‍🎓',
				'keywords' => ['graduate', 'man', 'student', 'uc6'],
			],
			'1f468-1f3fb-1f393' => [
				'name' => \XF::phrase('emoji.man_student_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_student_tone1:',
				'shortname_alternates' => [':man_student_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏻‍🎓',
				'keywords' => ['graduate', 'light skin tone', 'man', 'student', 'uc8'],
			],
			'1f468-1f3fc-1f393' => [
				'name' => \XF::phrase('emoji.man_student_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_student_tone2:',
				'shortname_alternates' => [':man_student_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏼‍🎓',
				'keywords' => ['graduate', 'man', 'medium-light skin tone', 'student', 'uc8'],
			],
			'1f468-1f3fd-1f393' => [
				'name' => \XF::phrase('emoji.man_student_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_student_tone3:',
				'shortname_alternates' => [':man_student_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏽‍🎓',
				'keywords' => ['graduate', 'man', 'medium skin tone', 'student', 'uc8'],
			],
			'1f468-1f3fe-1f393' => [
				'name' => \XF::phrase('emoji.man_student_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_student_tone4:',
				'shortname_alternates' => [':man_student_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏾‍🎓',
				'keywords' => ['graduate', 'man', 'medium-dark skin tone', 'student', 'uc8'],
			],
			'1f468-1f3ff-1f393' => [
				'name' => \XF::phrase('emoji.man_student_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_student_tone5:',
				'shortname_alternates' => [':man_student_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏿‍🎓',
				'keywords' => ['dark skin tone', 'graduate', 'man', 'student', 'uc8'],
			],
			'1f9d1-1f3a4' => [
				'name' => \XF::phrase('emoji.singer'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':singer:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f3a4', '1f9d1-1f3fc-1f3a4', '1f9d1-1f3fd-1f3a4', '1f9d1-1f3fe-1f3a4', '1f9d1-1f3ff-1f3a4'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑‍🎤',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f3a4' => [
				'name' => \XF::phrase('emoji.singer_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':singer_tone1:',
				'shortname_alternates' => [':singer_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍🎤',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f3a4' => [
				'name' => \XF::phrase('emoji.singer_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':singer_tone2:',
				'shortname_alternates' => [':singer_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍🎤',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f3a4' => [
				'name' => \XF::phrase('emoji.singer_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':singer_tone3:',
				'shortname_alternates' => [':singer_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍🎤',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f3a4' => [
				'name' => \XF::phrase('emoji.singer_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':singer_tone4:',
				'shortname_alternates' => [':singer_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍🎤',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f3a4' => [
				'name' => \XF::phrase('emoji.singer_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':singer_tone5:',
				'shortname_alternates' => [':singer_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍🎤',
				'keywords' => ['uc12'],
			],
			'1f469-1f3a4' => [
				'name' => \XF::phrase('emoji.woman_singer'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_singer:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3ff-1f3a4', '1f469-1f3fe-1f3a4', '1f469-1f3fd-1f3a4', '1f469-1f3fc-1f3a4', '1f469-1f3fb-1f3a4'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩‍🎤',
				'keywords' => ['actor', 'entertainer', 'rock', 'singer', 'star', 'woman', 'uc6'],
			],
			'1f469-1f3fb-1f3a4' => [
				'name' => \XF::phrase('emoji.woman_singer_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_singer_tone1:',
				'shortname_alternates' => [':woman_singer_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻‍🎤',
				'keywords' => ['actor', 'entertainer', 'light skin tone', 'rock', 'singer', 'star', 'woman', 'uc8'],
			],
			'1f469-1f3fc-1f3a4' => [
				'name' => \XF::phrase('emoji.woman_singer_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_singer_tone2:',
				'shortname_alternates' => [':woman_singer_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼‍🎤',
				'keywords' => ['actor', 'entertainer', 'medium-light skin tone', 'rock', 'singer', 'star', 'woman', 'uc8'],
			],
			'1f469-1f3fd-1f3a4' => [
				'name' => \XF::phrase('emoji.woman_singer_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_singer_tone3:',
				'shortname_alternates' => [':woman_singer_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏽‍🎤',
				'keywords' => ['actor', 'entertainer', 'medium skin tone', 'rock', 'singer', 'star', 'woman', 'uc8'],
			],
			'1f469-1f3fe-1f3a4' => [
				'name' => \XF::phrase('emoji.woman_singer_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_singer_tone4:',
				'shortname_alternates' => [':woman_singer_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏾‍🎤',
				'keywords' => ['actor', 'entertainer', 'medium-dark skin tone', 'rock', 'singer', 'star', 'woman', 'uc8'],
			],
			'1f469-1f3ff-1f3a4' => [
				'name' => \XF::phrase('emoji.woman_singer_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_singer_tone5:',
				'shortname_alternates' => [':woman_singer_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏿‍🎤',
				'keywords' => ['actor', 'dark skin tone', 'entertainer', 'rock', 'singer', 'star', 'woman', 'uc8'],
			],
			'1f468-1f3a4' => [
				'name' => \XF::phrase('emoji.man_singer'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_singer:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3ff-1f3a4', '1f468-1f3fe-1f3a4', '1f468-1f3fd-1f3a4', '1f468-1f3fc-1f3a4', '1f468-1f3fb-1f3a4'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨‍🎤',
				'keywords' => ['actor', 'entertainer', 'man', 'rock', 'singer', 'star', 'uc6'],
			],
			'1f468-1f3fb-1f3a4' => [
				'name' => \XF::phrase('emoji.man_singer_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_singer_tone1:',
				'shortname_alternates' => [':man_singer_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏻‍🎤',
				'keywords' => ['actor', 'entertainer', 'light skin tone', 'man', 'rock', 'singer', 'star', 'uc8'],
			],
			'1f468-1f3fc-1f3a4' => [
				'name' => \XF::phrase('emoji.man_singer_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_singer_tone2:',
				'shortname_alternates' => [':man_singer_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏼‍🎤',
				'keywords' => ['actor', 'entertainer', 'man', 'medium-light skin tone', 'rock', 'singer', 'star', 'uc8'],
			],
			'1f468-1f3fd-1f3a4' => [
				'name' => \XF::phrase('emoji.man_singer_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_singer_tone3:',
				'shortname_alternates' => [':man_singer_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏽‍🎤',
				'keywords' => ['actor', 'entertainer', 'man', 'medium skin tone', 'rock', 'singer', 'star', 'uc8'],
			],
			'1f468-1f3fe-1f3a4' => [
				'name' => \XF::phrase('emoji.man_singer_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_singer_tone4:',
				'shortname_alternates' => [':man_singer_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏾‍🎤',
				'keywords' => ['actor', 'entertainer', 'man', 'medium-dark skin tone', 'rock', 'singer', 'star', 'uc8'],
			],
			'1f468-1f3ff-1f3a4' => [
				'name' => \XF::phrase('emoji.man_singer_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_singer_tone5:',
				'shortname_alternates' => [':man_singer_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏿‍🎤',
				'keywords' => ['actor', 'dark skin tone', 'entertainer', 'man', 'rock', 'singer', 'star', 'uc8'],
			],
			'1f9d1-1f3eb' => [
				'name' => \XF::phrase('emoji.teacher'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':teacher:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f3eb', '1f9d1-1f3fc-1f3eb', '1f9d1-1f3fd-1f3eb', '1f9d1-1f3fe-1f3eb', '1f9d1-1f3ff-1f3eb'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑‍🏫',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f3eb' => [
				'name' => \XF::phrase('emoji.teacher_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':teacher_tone1:',
				'shortname_alternates' => [':teacher_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍🏫',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f3eb' => [
				'name' => \XF::phrase('emoji.teacher_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':teacher_tone2:',
				'shortname_alternates' => [':teacher_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍🏫',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f3eb' => [
				'name' => \XF::phrase('emoji.teacher_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':teacher_tone3:',
				'shortname_alternates' => [':teacher_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍🏫',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f3eb' => [
				'name' => \XF::phrase('emoji.teacher_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':teacher_tone4:',
				'shortname_alternates' => [':teacher_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍🏫',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f3eb' => [
				'name' => \XF::phrase('emoji.teacher_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':teacher_tone5:',
				'shortname_alternates' => [':teacher_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍🏫',
				'keywords' => ['uc12'],
			],
			'1f469-1f3eb' => [
				'name' => \XF::phrase('emoji.woman_teacher'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_teacher:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3ff-1f3eb', '1f469-1f3fe-1f3eb', '1f469-1f3fd-1f3eb', '1f469-1f3fc-1f3eb', '1f469-1f3fb-1f3eb'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩‍🏫',
				'keywords' => ['instructor', 'professor', 'teacher', 'woman', 'uc6'],
			],
			'1f469-1f3fb-1f3eb' => [
				'name' => \XF::phrase('emoji.woman_teacher_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_teacher_tone1:',
				'shortname_alternates' => [':woman_teacher_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻‍🏫',
				'keywords' => ['instructor', 'light skin tone', 'professor', 'teacher', 'woman', 'uc8'],
			],
			'1f469-1f3fc-1f3eb' => [
				'name' => \XF::phrase('emoji.woman_teacher_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_teacher_tone2:',
				'shortname_alternates' => [':woman_teacher_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼‍🏫',
				'keywords' => ['instructor', 'medium-light skin tone', 'professor', 'teacher', 'woman', 'uc8'],
			],
			'1f469-1f3fd-1f3eb' => [
				'name' => \XF::phrase('emoji.woman_teacher_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_teacher_tone3:',
				'shortname_alternates' => [':woman_teacher_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏽‍🏫',
				'keywords' => ['instructor', 'medium skin tone', 'professor', 'teacher', 'woman', 'uc8'],
			],
			'1f469-1f3fe-1f3eb' => [
				'name' => \XF::phrase('emoji.woman_teacher_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_teacher_tone4:',
				'shortname_alternates' => [':woman_teacher_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏾‍🏫',
				'keywords' => ['instructor', 'medium-dark skin tone', 'professor', 'teacher', 'woman', 'uc8'],
			],
			'1f469-1f3ff-1f3eb' => [
				'name' => \XF::phrase('emoji.woman_teacher_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_teacher_tone5:',
				'shortname_alternates' => [':woman_teacher_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏿‍🏫',
				'keywords' => ['dark skin tone', 'instructor', 'professor', 'teacher', 'woman', 'uc8'],
			],
			'1f468-1f3eb' => [
				'name' => \XF::phrase('emoji.man_teacher'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_teacher:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3ff-1f3eb', '1f468-1f3fe-1f3eb', '1f468-1f3fd-1f3eb', '1f468-1f3fc-1f3eb', '1f468-1f3fb-1f3eb'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨‍🏫',
				'keywords' => ['instructor', 'man', 'professor', 'teacher', 'uc6'],
			],
			'1f468-1f3fb-1f3eb' => [
				'name' => \XF::phrase('emoji.man_teacher_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_teacher_tone1:',
				'shortname_alternates' => [':man_teacher_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏻‍🏫',
				'keywords' => ['instructor', 'light skin tone', 'man', 'professor', 'teacher', 'uc8'],
			],
			'1f468-1f3fc-1f3eb' => [
				'name' => \XF::phrase('emoji.man_teacher_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_teacher_tone2:',
				'shortname_alternates' => [':man_teacher_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏼‍🏫',
				'keywords' => ['instructor', 'man', 'medium-light skin tone', 'professor', 'teacher', 'uc8'],
			],
			'1f468-1f3fd-1f3eb' => [
				'name' => \XF::phrase('emoji.man_teacher_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_teacher_tone3:',
				'shortname_alternates' => [':man_teacher_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏽‍🏫',
				'keywords' => ['instructor', 'man', 'medium skin tone', 'professor', 'teacher', 'uc8'],
			],
			'1f468-1f3fe-1f3eb' => [
				'name' => \XF::phrase('emoji.man_teacher_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_teacher_tone4:',
				'shortname_alternates' => [':man_teacher_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏾‍🏫',
				'keywords' => ['instructor', 'man', 'medium-dark skin tone', 'professor', 'teacher', 'uc8'],
			],
			'1f468-1f3ff-1f3eb' => [
				'name' => \XF::phrase('emoji.man_teacher_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_teacher_tone5:',
				'shortname_alternates' => [':man_teacher_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏿‍🏫',
				'keywords' => ['dark skin tone', 'instructor', 'man', 'professor', 'teacher', 'uc8'],
			],
			'1f9d1-1f3ed' => [
				'name' => \XF::phrase('emoji.factory_worker'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':factory_worker:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f3ed', '1f9d1-1f3fc-1f3ed', '1f9d1-1f3fd-1f3ed', '1f9d1-1f3fe-1f3ed', '1f9d1-1f3ff-1f3ed'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑‍🏭',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f3ed' => [
				'name' => \XF::phrase('emoji.factory_worker_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':factory_worker_tone1:',
				'shortname_alternates' => [':factory_worker_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍🏭',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f3ed' => [
				'name' => \XF::phrase('emoji.factory_worker_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':factory_worker_tone2:',
				'shortname_alternates' => [':factory_worker_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍🏭',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f3ed' => [
				'name' => \XF::phrase('emoji.factory_worker_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':factory_worker_tone3:',
				'shortname_alternates' => [':factory_worker_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍🏭',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f3ed' => [
				'name' => \XF::phrase('emoji.factory_worker_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':factory_worker_tone4:',
				'shortname_alternates' => [':factory_worker_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍🏭',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f3ed' => [
				'name' => \XF::phrase('emoji.factory_worker_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':factory_worker_tone5:',
				'shortname_alternates' => [':factory_worker_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍🏭',
				'keywords' => ['uc12'],
			],
			'1f469-1f3ed' => [
				'name' => \XF::phrase('emoji.woman_factory_worker'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_factory_worker:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3ff-1f3ed', '1f469-1f3fe-1f3ed', '1f469-1f3fd-1f3ed', '1f469-1f3fc-1f3ed', '1f469-1f3fb-1f3ed'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩‍🏭',
				'keywords' => ['assembly', 'factory', 'industrial', 'woman', 'worker', 'uc6'],
			],
			'1f469-1f3fb-1f3ed' => [
				'name' => \XF::phrase('emoji.woman_factory_worker_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_factory_worker_tone1:',
				'shortname_alternates' => [':woman_factory_worker_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻‍🏭',
				'keywords' => ['assembly', 'factory', 'industrial', 'light skin tone', 'woman', 'worker', 'uc8'],
			],
			'1f469-1f3fc-1f3ed' => [
				'name' => \XF::phrase('emoji.woman_factory_worker_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_factory_worker_tone2:',
				'shortname_alternates' => [':woman_factory_worker_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼‍🏭',
				'keywords' => ['assembly', 'factory', 'industrial', 'medium-light skin tone', 'woman', 'worker', 'uc8'],
			],
			'1f469-1f3fd-1f3ed' => [
				'name' => \XF::phrase('emoji.woman_factory_worker_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_factory_worker_tone3:',
				'shortname_alternates' => [':woman_factory_worker_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏽‍🏭',
				'keywords' => ['assembly', 'factory', 'industrial', 'medium skin tone', 'woman', 'worker', 'uc8'],
			],
			'1f469-1f3fe-1f3ed' => [
				'name' => \XF::phrase('emoji.woman_factory_worker_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_factory_worker_tone4:',
				'shortname_alternates' => [':woman_factory_worker_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏾‍🏭',
				'keywords' => ['assembly', 'factory', 'industrial', 'medium-dark skin tone', 'woman', 'worker', 'uc8'],
			],
			'1f469-1f3ff-1f3ed' => [
				'name' => \XF::phrase('emoji.woman_factory_worker_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_factory_worker_tone5:',
				'shortname_alternates' => [':woman_factory_worker_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏿‍🏭',
				'keywords' => ['assembly', 'dark skin tone', 'factory', 'industrial', 'woman', 'worker', 'uc8'],
			],
			'1f468-1f3ed' => [
				'name' => \XF::phrase('emoji.man_factory_worker'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_factory_worker:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3ff-1f3ed', '1f468-1f3fe-1f3ed', '1f468-1f3fd-1f3ed', '1f468-1f3fc-1f3ed', '1f468-1f3fb-1f3ed'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨‍🏭',
				'keywords' => ['assembly', 'factory', 'industrial', 'man', 'worker', 'uc6'],
			],
			'1f468-1f3fb-1f3ed' => [
				'name' => \XF::phrase('emoji.man_factory_worker_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_factory_worker_tone1:',
				'shortname_alternates' => [':man_factory_worker_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏻‍🏭',
				'keywords' => ['assembly', 'factory', 'industrial', 'light skin tone', 'man', 'worker', 'uc8'],
			],
			'1f468-1f3fc-1f3ed' => [
				'name' => \XF::phrase('emoji.man_factory_worker_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_factory_worker_tone2:',
				'shortname_alternates' => [':man_factory_worker_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏼‍🏭',
				'keywords' => ['assembly', 'factory', 'industrial', 'man', 'medium-light skin tone', 'worker', 'uc8'],
			],
			'1f468-1f3fd-1f3ed' => [
				'name' => \XF::phrase('emoji.man_factory_worker_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_factory_worker_tone3:',
				'shortname_alternates' => [':man_factory_worker_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏽‍🏭',
				'keywords' => ['assembly', 'factory', 'industrial', 'man', 'medium skin tone', 'worker', 'uc8'],
			],
			'1f468-1f3fe-1f3ed' => [
				'name' => \XF::phrase('emoji.man_factory_worker_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_factory_worker_tone4:',
				'shortname_alternates' => [':man_factory_worker_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏾‍🏭',
				'keywords' => ['assembly', 'factory', 'industrial', 'man', 'medium-dark skin tone', 'worker', 'uc8'],
			],
			'1f468-1f3ff-1f3ed' => [
				'name' => \XF::phrase('emoji.man_factory_worker_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_factory_worker_tone5:',
				'shortname_alternates' => [':man_factory_worker_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏿‍🏭',
				'keywords' => ['assembly', 'dark skin tone', 'factory', 'industrial', 'man', 'worker', 'uc8'],
			],
			'1f9d1-1f4bb' => [
				'name' => \XF::phrase('emoji.technologist'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':technologist:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f4bb', '1f9d1-1f3fc-1f4bb', '1f9d1-1f3fd-1f4bb', '1f9d1-1f3fe-1f4bb', '1f9d1-1f3ff-1f4bb'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑‍💻',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f4bb' => [
				'name' => \XF::phrase('emoji.technologist_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':technologist_tone1:',
				'shortname_alternates' => [':technologist_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍💻',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f4bb' => [
				'name' => \XF::phrase('emoji.technologist_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':technologist_tone2:',
				'shortname_alternates' => [':technologist_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍💻',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f4bb' => [
				'name' => \XF::phrase('emoji.technologist_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':technologist_tone3:',
				'shortname_alternates' => [':technologist_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍💻',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f4bb' => [
				'name' => \XF::phrase('emoji.technologist_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':technologist_tone4:',
				'shortname_alternates' => [':technologist_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍💻',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f4bb' => [
				'name' => \XF::phrase('emoji.technologist_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':technologist_tone5:',
				'shortname_alternates' => [':technologist_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍💻',
				'keywords' => ['uc12'],
			],
			'1f469-1f4bb' => [
				'name' => \XF::phrase('emoji.woman_technologist'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_technologist:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3ff-1f4bb', '1f469-1f3fe-1f4bb', '1f469-1f3fd-1f4bb', '1f469-1f3fc-1f4bb', '1f469-1f3fb-1f4bb'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩‍💻',
				'keywords' => ['coder', 'developer', 'inventor', 'software', 'technologist', 'woman', 'uc6'],
			],
			'1f469-1f3fb-1f4bb' => [
				'name' => \XF::phrase('emoji.woman_technologist_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_technologist_tone1:',
				'shortname_alternates' => [':woman_technologist_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻‍💻',
				'keywords' => ['coder', 'developer', 'inventor', 'light skin tone', 'software', 'technologist', 'woman', 'uc8'],
			],
			'1f469-1f3fc-1f4bb' => [
				'name' => \XF::phrase('emoji.woman_technologist_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_technologist_tone2:',
				'shortname_alternates' => [':woman_technologist_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼‍💻',
				'keywords' => ['coder', 'developer', 'inventor', 'medium-light skin tone', 'software', 'technologist', 'woman', 'uc8'],
			],
			'1f469-1f3fd-1f4bb' => [
				'name' => \XF::phrase('emoji.woman_technologist_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_technologist_tone3:',
				'shortname_alternates' => [':woman_technologist_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏽‍💻',
				'keywords' => ['coder', 'developer', 'inventor', 'medium skin tone', 'software', 'technologist', 'woman', 'uc8'],
			],
			'1f469-1f3fe-1f4bb' => [
				'name' => \XF::phrase('emoji.woman_technologist_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_technologist_tone4:',
				'shortname_alternates' => [':woman_technologist_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏾‍💻',
				'keywords' => ['coder', 'developer', 'inventor', 'medium-dark skin tone', 'software', 'technologist', 'woman', 'uc8'],
			],
			'1f469-1f3ff-1f4bb' => [
				'name' => \XF::phrase('emoji.woman_technologist_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_technologist_tone5:',
				'shortname_alternates' => [':woman_technologist_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏿‍💻',
				'keywords' => ['coder', 'dark skin tone', 'developer', 'inventor', 'software', 'technologist', 'woman', 'uc8'],
			],
			'1f468-1f4bb' => [
				'name' => \XF::phrase('emoji.man_technologist'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_technologist:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3ff-1f4bb', '1f468-1f3fe-1f4bb', '1f468-1f3fd-1f4bb', '1f468-1f3fc-1f4bb', '1f468-1f3fb-1f4bb'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨‍💻',
				'keywords' => ['coder', 'developer', 'inventor', 'man', 'software', 'technologist', 'uc6'],
			],
			'1f468-1f3fb-1f4bb' => [
				'name' => \XF::phrase('emoji.man_technologist_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_technologist_tone1:',
				'shortname_alternates' => [':man_technologist_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏻‍💻',
				'keywords' => ['coder', 'developer', 'inventor', 'light skin tone', 'man', 'software', 'technologist', 'uc8'],
			],
			'1f468-1f3fc-1f4bb' => [
				'name' => \XF::phrase('emoji.man_technologist_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_technologist_tone2:',
				'shortname_alternates' => [':man_technologist_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏼‍💻',
				'keywords' => ['coder', 'developer', 'inventor', 'man', 'medium-light skin tone', 'software', 'technologist', 'uc8'],
			],
			'1f468-1f3fd-1f4bb' => [
				'name' => \XF::phrase('emoji.man_technologist_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_technologist_tone3:',
				'shortname_alternates' => [':man_technologist_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏽‍💻',
				'keywords' => ['coder', 'developer', 'inventor', 'man', 'medium skin tone', 'software', 'technologist', 'uc8'],
			],
			'1f468-1f3fe-1f4bb' => [
				'name' => \XF::phrase('emoji.man_technologist_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_technologist_tone4:',
				'shortname_alternates' => [':man_technologist_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏾‍💻',
				'keywords' => ['coder', 'developer', 'inventor', 'man', 'medium-dark skin tone', 'software', 'technologist', 'uc8'],
			],
			'1f468-1f3ff-1f4bb' => [
				'name' => \XF::phrase('emoji.man_technologist_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_technologist_tone5:',
				'shortname_alternates' => [':man_technologist_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏿‍💻',
				'keywords' => ['coder', 'dark skin tone', 'developer', 'inventor', 'man', 'software', 'technologist', 'uc8'],
			],
			'1f9d1-1f4bc' => [
				'name' => \XF::phrase('emoji.office_worker'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':office_worker:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f4bc', '1f9d1-1f3fc-1f4bc', '1f9d1-1f3fd-1f4bc', '1f9d1-1f3fe-1f4bc', '1f9d1-1f3ff-1f4bc'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑‍💼',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f4bc' => [
				'name' => \XF::phrase('emoji.office_worker_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':office_worker_tone1:',
				'shortname_alternates' => [':office_worker_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍💼',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f4bc' => [
				'name' => \XF::phrase('emoji.office_worker_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':office_worker_tone2:',
				'shortname_alternates' => [':office_worker_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍💼',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f4bc' => [
				'name' => \XF::phrase('emoji.office_worker_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':office_worker_tone3:',
				'shortname_alternates' => [':office_worker_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍💼',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f4bc' => [
				'name' => \XF::phrase('emoji.office_worker_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':office_worker_tone4:',
				'shortname_alternates' => [':office_worker_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍💼',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f4bc' => [
				'name' => \XF::phrase('emoji.office_worker_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':office_worker_tone5:',
				'shortname_alternates' => [':office_worker_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍💼',
				'keywords' => ['uc12'],
			],
			'1f469-1f4bc' => [
				'name' => \XF::phrase('emoji.woman_office_worker'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_office_worker:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3ff-1f4bc', '1f469-1f3fe-1f4bc', '1f469-1f3fd-1f4bc', '1f469-1f3fc-1f4bc', '1f469-1f3fb-1f4bc'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩‍💼',
				'keywords' => ['architect', 'business', 'manager', 'office', 'white-collar', 'woman', 'uc6'],
			],
			'1f469-1f3fb-1f4bc' => [
				'name' => \XF::phrase('emoji.woman_office_worker_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_office_worker_tone1:',
				'shortname_alternates' => [':woman_office_worker_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻‍💼',
				'keywords' => ['architect', 'business', 'light skin tone', 'manager', 'office', 'white-collar', 'woman', 'uc8'],
			],
			'1f469-1f3fc-1f4bc' => [
				'name' => \XF::phrase('emoji.woman_office_worker_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_office_worker_tone2:',
				'shortname_alternates' => [':woman_office_worker_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼‍💼',
				'keywords' => ['architect', 'business', 'manager', 'medium-light skin tone', 'office', 'white-collar', 'woman', 'uc8'],
			],
			'1f469-1f3fd-1f4bc' => [
				'name' => \XF::phrase('emoji.woman_office_worker_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_office_worker_tone3:',
				'shortname_alternates' => [':woman_office_worker_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏽‍💼',
				'keywords' => ['architect', 'business', 'manager', 'medium skin tone', 'office', 'white-collar', 'woman', 'uc8'],
			],
			'1f469-1f3fe-1f4bc' => [
				'name' => \XF::phrase('emoji.woman_office_worker_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_office_worker_tone4:',
				'shortname_alternates' => [':woman_office_worker_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏾‍💼',
				'keywords' => ['architect', 'business', 'manager', 'medium-dark skin tone', 'office', 'white-collar', 'woman', 'uc8'],
			],
			'1f469-1f3ff-1f4bc' => [
				'name' => \XF::phrase('emoji.woman_office_worker_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_office_worker_tone5:',
				'shortname_alternates' => [':woman_office_worker_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏿‍💼',
				'keywords' => ['architect', 'business', 'dark skin tone', 'manager', 'office', 'white-collar', 'woman', 'uc8'],
			],
			'1f468-1f4bc' => [
				'name' => \XF::phrase('emoji.man_office_worker'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_office_worker:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3ff-1f4bc', '1f468-1f3fe-1f4bc', '1f468-1f3fd-1f4bc', '1f468-1f3fc-1f4bc', '1f468-1f3fb-1f4bc'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨‍💼',
				'keywords' => ['architect', 'business', 'man', 'manager', 'office', 'white-collar', 'uc6'],
			],
			'1f468-1f3fb-1f4bc' => [
				'name' => \XF::phrase('emoji.man_office_worker_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_office_worker_tone1:',
				'shortname_alternates' => [':man_office_worker_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏻‍💼',
				'keywords' => ['architect', 'business', 'light skin tone', 'man', 'manager', 'office', 'white-collar', 'uc8'],
			],
			'1f468-1f3fc-1f4bc' => [
				'name' => \XF::phrase('emoji.man_office_worker_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_office_worker_tone2:',
				'shortname_alternates' => [':man_office_worker_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏼‍💼',
				'keywords' => ['architect', 'business', 'man', 'manager', 'medium-light skin tone', 'office', 'white-collar', 'uc8'],
			],
			'1f468-1f3fd-1f4bc' => [
				'name' => \XF::phrase('emoji.man_office_worker_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_office_worker_tone3:',
				'shortname_alternates' => [':man_office_worker_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏽‍💼',
				'keywords' => ['architect', 'business', 'man', 'manager', 'medium skin tone', 'office', 'white-collar', 'uc8'],
			],
			'1f468-1f3fe-1f4bc' => [
				'name' => \XF::phrase('emoji.man_office_worker_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_office_worker_tone4:',
				'shortname_alternates' => [':man_office_worker_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏾‍💼',
				'keywords' => ['architect', 'business', 'man', 'manager', 'medium-dark skin tone', 'office', 'white-collar', 'uc8'],
			],
			'1f468-1f3ff-1f4bc' => [
				'name' => \XF::phrase('emoji.man_office_worker_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_office_worker_tone5:',
				'shortname_alternates' => [':man_office_worker_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏿‍💼',
				'keywords' => ['architect', 'business', 'dark skin tone', 'man', 'manager', 'office', 'white-collar', 'uc8'],
			],
			'1f9d1-1f527' => [
				'name' => \XF::phrase('emoji.mechanic'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mechanic:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f527', '1f9d1-1f3fc-1f527', '1f9d1-1f3fd-1f527', '1f9d1-1f3fe-1f527', '1f9d1-1f3ff-1f527'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑‍🔧',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f527' => [
				'name' => \XF::phrase('emoji.mechanic_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mechanic_tone1:',
				'shortname_alternates' => [':mechanic_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍🔧',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f527' => [
				'name' => \XF::phrase('emoji.mechanic_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mechanic_tone2:',
				'shortname_alternates' => [':mechanic_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍🔧',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f527' => [
				'name' => \XF::phrase('emoji.mechanic_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mechanic_tone3:',
				'shortname_alternates' => [':mechanic_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍🔧',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f527' => [
				'name' => \XF::phrase('emoji.mechanic_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mechanic_tone4:',
				'shortname_alternates' => [':mechanic_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍🔧',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f527' => [
				'name' => \XF::phrase('emoji.mechanic_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mechanic_tone5:',
				'shortname_alternates' => [':mechanic_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍🔧',
				'keywords' => ['uc12'],
			],
			'1f469-1f527' => [
				'name' => \XF::phrase('emoji.woman_mechanic'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mechanic:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3ff-1f527', '1f469-1f3fe-1f527', '1f469-1f3fd-1f527', '1f469-1f3fc-1f527', '1f469-1f3fb-1f527'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩‍🔧',
				'keywords' => ['electrician', 'mechanic', 'plumber', 'tradesperson', 'woman', 'uc6'],
			],
			'1f469-1f3fb-1f527' => [
				'name' => \XF::phrase('emoji.woman_mechanic_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mechanic_tone1:',
				'shortname_alternates' => [':woman_mechanic_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻‍🔧',
				'keywords' => ['electrician', 'light skin tone', 'mechanic', 'plumber', 'tradesperson', 'woman', 'uc8'],
			],
			'1f469-1f3fc-1f527' => [
				'name' => \XF::phrase('emoji.woman_mechanic_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mechanic_tone2:',
				'shortname_alternates' => [':woman_mechanic_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼‍🔧',
				'keywords' => ['electrician', 'mechanic', 'medium-light skin tone', 'plumber', 'tradesperson', 'woman', 'uc8'],
			],
			'1f469-1f3fd-1f527' => [
				'name' => \XF::phrase('emoji.woman_mechanic_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mechanic_tone3:',
				'shortname_alternates' => [':woman_mechanic_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏽‍🔧',
				'keywords' => ['electrician', 'mechanic', 'medium skin tone', 'plumber', 'tradesperson', 'woman', 'uc8'],
			],
			'1f469-1f3fe-1f527' => [
				'name' => \XF::phrase('emoji.woman_mechanic_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mechanic_tone4:',
				'shortname_alternates' => [':woman_mechanic_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏾‍🔧',
				'keywords' => ['electrician', 'mechanic', 'medium-dark skin tone', 'plumber', 'tradesperson', 'woman', 'uc8'],
			],
			'1f469-1f3ff-1f527' => [
				'name' => \XF::phrase('emoji.woman_mechanic_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mechanic_tone5:',
				'shortname_alternates' => [':woman_mechanic_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏿‍🔧',
				'keywords' => ['dark skin tone', 'electrician', 'mechanic', 'plumber', 'tradesperson', 'woman', 'uc8'],
			],
			'1f468-1f527' => [
				'name' => \XF::phrase('emoji.man_mechanic'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mechanic:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3ff-1f527', '1f468-1f3fe-1f527', '1f468-1f3fd-1f527', '1f468-1f3fc-1f527', '1f468-1f3fb-1f527'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨‍🔧',
				'keywords' => ['electrician', 'man', 'mechanic', 'plumber', 'tradesperson', 'uc6'],
			],
			'1f468-1f3fb-1f527' => [
				'name' => \XF::phrase('emoji.man_mechanic_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mechanic_tone1:',
				'shortname_alternates' => [':man_mechanic_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏻‍🔧',
				'keywords' => ['electrician', 'light skin tone', 'man', 'mechanic', 'plumber', 'tradesperson', 'uc8'],
			],
			'1f468-1f3fc-1f527' => [
				'name' => \XF::phrase('emoji.man_mechanic_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mechanic_tone2:',
				'shortname_alternates' => [':man_mechanic_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏼‍🔧',
				'keywords' => ['electrician', 'man', 'mechanic', 'medium-light skin tone', 'plumber', 'tradesperson', 'uc8'],
			],
			'1f468-1f3fd-1f527' => [
				'name' => \XF::phrase('emoji.man_mechanic_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mechanic_tone3:',
				'shortname_alternates' => [':man_mechanic_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏽‍🔧',
				'keywords' => ['electrician', 'man', 'mechanic', 'medium skin tone', 'plumber', 'tradesperson', 'uc8'],
			],
			'1f468-1f3fe-1f527' => [
				'name' => \XF::phrase('emoji.man_mechanic_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mechanic_tone4:',
				'shortname_alternates' => [':man_mechanic_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏾‍🔧',
				'keywords' => ['electrician', 'man', 'mechanic', 'medium-dark skin tone', 'plumber', 'tradesperson', 'uc8'],
			],
			'1f468-1f3ff-1f527' => [
				'name' => \XF::phrase('emoji.man_mechanic_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mechanic_tone5:',
				'shortname_alternates' => [':man_mechanic_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏿‍🔧',
				'keywords' => ['dark skin tone', 'electrician', 'man', 'mechanic', 'plumber', 'tradesperson', 'uc8'],
			],
			'1f9d1-1f52c' => [
				'name' => \XF::phrase('emoji.scientist'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':scientist:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f52c', '1f9d1-1f3fc-1f52c', '1f9d1-1f3fd-1f52c', '1f9d1-1f3fe-1f52c', '1f9d1-1f3ff-1f52c'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑‍🔬',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f52c' => [
				'name' => \XF::phrase('emoji.scientist_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':scientist_tone1:',
				'shortname_alternates' => [':scientist_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍🔬',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f52c' => [
				'name' => \XF::phrase('emoji.scientist_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':scientist_tone2:',
				'shortname_alternates' => [':scientist_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍🔬',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f52c' => [
				'name' => \XF::phrase('emoji.scientist_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':scientist_tone3:',
				'shortname_alternates' => [':scientist_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍🔬',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f52c' => [
				'name' => \XF::phrase('emoji.scientist_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':scientist_tone4:',
				'shortname_alternates' => [':scientist_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍🔬',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f52c' => [
				'name' => \XF::phrase('emoji.scientist_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':scientist_tone5:',
				'shortname_alternates' => [':scientist_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍🔬',
				'keywords' => ['uc12'],
			],
			'1f469-1f52c' => [
				'name' => \XF::phrase('emoji.woman_scientist'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_scientist:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3ff-1f52c', '1f469-1f3fe-1f52c', '1f469-1f3fd-1f52c', '1f469-1f3fc-1f52c', '1f469-1f3fb-1f52c'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩‍🔬',
				'keywords' => ['biologist', 'chemist', 'engineer', 'mathematician', 'physicist', 'scientist', 'woman', 'uc6'],
			],
			'1f469-1f3fb-1f52c' => [
				'name' => \XF::phrase('emoji.woman_scientist_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_scientist_tone1:',
				'shortname_alternates' => [':woman_scientist_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻‍🔬',
				'keywords' => ['biologist', 'chemist', 'engineer', 'light skin tone', 'mathematician', 'physicist', 'scientist', 'woman', 'uc8'],
			],
			'1f469-1f3fc-1f52c' => [
				'name' => \XF::phrase('emoji.woman_scientist_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_scientist_tone2:',
				'shortname_alternates' => [':woman_scientist_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼‍🔬',
				'keywords' => ['biologist', 'chemist', 'engineer', 'mathematician', 'medium-light skin tone', 'physicist', 'scientist', 'woman', 'uc8'],
			],
			'1f469-1f3fd-1f52c' => [
				'name' => \XF::phrase('emoji.woman_scientist_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_scientist_tone3:',
				'shortname_alternates' => [':woman_scientist_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏽‍🔬',
				'keywords' => ['biologist', 'chemist', 'engineer', 'mathematician', 'medium skin tone', 'physicist', 'scientist', 'woman', 'uc8'],
			],
			'1f469-1f3fe-1f52c' => [
				'name' => \XF::phrase('emoji.woman_scientist_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_scientist_tone4:',
				'shortname_alternates' => [':woman_scientist_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏾‍🔬',
				'keywords' => ['biologist', 'chemist', 'engineer', 'mathematician', 'medium-dark skin tone', 'physicist', 'scientist', 'woman', 'uc8'],
			],
			'1f469-1f3ff-1f52c' => [
				'name' => \XF::phrase('emoji.woman_scientist_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_scientist_tone5:',
				'shortname_alternates' => [':woman_scientist_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏿‍🔬',
				'keywords' => ['biologist', 'chemist', 'dark skin tone', 'engineer', 'mathematician', 'physicist', 'scientist', 'woman', 'uc8'],
			],
			'1f468-1f52c' => [
				'name' => \XF::phrase('emoji.man_scientist'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_scientist:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3ff-1f52c', '1f468-1f3fe-1f52c', '1f468-1f3fd-1f52c', '1f468-1f3fc-1f52c', '1f468-1f3fb-1f52c'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨‍🔬',
				'keywords' => ['biologist', 'chemist', 'engineer', 'man', 'mathematician', 'physicist', 'scientist', 'uc6'],
			],
			'1f468-1f3fb-1f52c' => [
				'name' => \XF::phrase('emoji.man_scientist_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_scientist_tone1:',
				'shortname_alternates' => [':man_scientist_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏻‍🔬',
				'keywords' => ['biologist', 'chemist', 'engineer', 'light skin tone', 'man', 'mathematician', 'physicist', 'scientist', 'uc8'],
			],
			'1f468-1f3fc-1f52c' => [
				'name' => \XF::phrase('emoji.man_scientist_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_scientist_tone2:',
				'shortname_alternates' => [':man_scientist_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏼‍🔬',
				'keywords' => ['biologist', 'chemist', 'engineer', 'man', 'mathematician', 'medium-light skin tone', 'physicist', 'scientist', 'uc8'],
			],
			'1f468-1f3fd-1f52c' => [
				'name' => \XF::phrase('emoji.man_scientist_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_scientist_tone3:',
				'shortname_alternates' => [':man_scientist_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏽‍🔬',
				'keywords' => ['biologist', 'chemist', 'engineer', 'man', 'mathematician', 'medium skin tone', 'physicist', 'scientist', 'uc8'],
			],
			'1f468-1f3fe-1f52c' => [
				'name' => \XF::phrase('emoji.man_scientist_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_scientist_tone4:',
				'shortname_alternates' => [':man_scientist_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏾‍🔬',
				'keywords' => ['biologist', 'chemist', 'engineer', 'man', 'mathematician', 'medium-dark skin tone', 'physicist', 'scientist', 'uc8'],
			],
			'1f468-1f3ff-1f52c' => [
				'name' => \XF::phrase('emoji.man_scientist_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_scientist_tone5:',
				'shortname_alternates' => [':man_scientist_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏿‍🔬',
				'keywords' => ['biologist', 'chemist', 'dark skin tone', 'engineer', 'man', 'mathematician', 'physicist', 'scientist', 'uc8'],
			],
			'1f9d1-1f3a8' => [
				'name' => \XF::phrase('emoji.artist'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':artist:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f3a8', '1f9d1-1f3fc-1f3a8', '1f9d1-1f3fd-1f3a8', '1f9d1-1f3fe-1f3a8', '1f9d1-1f3ff-1f3a8'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑‍🎨',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f3a8' => [
				'name' => \XF::phrase('emoji.artist_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':artist_tone1:',
				'shortname_alternates' => [':artist_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍🎨',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f3a8' => [
				'name' => \XF::phrase('emoji.artist_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':artist_tone2:',
				'shortname_alternates' => [':artist_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍🎨',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f3a8' => [
				'name' => \XF::phrase('emoji.artist_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':artist_tone3:',
				'shortname_alternates' => [':artist_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍🎨',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f3a8' => [
				'name' => \XF::phrase('emoji.artist_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':artist_tone4:',
				'shortname_alternates' => [':artist_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍🎨',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f3a8' => [
				'name' => \XF::phrase('emoji.artist_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':artist_tone5:',
				'shortname_alternates' => [':artist_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍🎨',
				'keywords' => ['uc12'],
			],
			'1f469-1f3a8' => [
				'name' => \XF::phrase('emoji.woman_artist'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_artist:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3fb-1f3a8', '1f469-1f3fc-1f3a8', '1f469-1f3fd-1f3a8', '1f469-1f3fe-1f3a8', '1f469-1f3ff-1f3a8'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩‍🎨',
				'keywords' => ['artist', 'palette', 'woman', 'uc6'],
			],
			'1f469-1f3fb-1f3a8' => [
				'name' => \XF::phrase('emoji.woman_artist_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_artist_tone1:',
				'shortname_alternates' => [':woman_artist_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻‍🎨',
				'keywords' => ['artist', 'light skin tone', 'palette', 'woman', 'uc8'],
			],
			'1f469-1f3fc-1f3a8' => [
				'name' => \XF::phrase('emoji.woman_artist_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_artist_tone2:',
				'shortname_alternates' => [':woman_artist_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼‍🎨',
				'keywords' => ['artist', 'medium-light skin tone', 'palette', 'woman', 'uc8'],
			],
			'1f469-1f3fd-1f3a8' => [
				'name' => \XF::phrase('emoji.woman_artist_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_artist_tone3:',
				'shortname_alternates' => [':woman_artist_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏽‍🎨',
				'keywords' => ['artist', 'medium skin tone', 'palette', 'woman', 'uc8'],
			],
			'1f469-1f3fe-1f3a8' => [
				'name' => \XF::phrase('emoji.woman_artist_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_artist_tone4:',
				'shortname_alternates' => [':woman_artist_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏾‍🎨',
				'keywords' => ['artist', 'medium-dark skin tone', 'palette', 'woman', 'uc8'],
			],
			'1f469-1f3ff-1f3a8' => [
				'name' => \XF::phrase('emoji.woman_artist_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_artist_tone5:',
				'shortname_alternates' => [':woman_artist_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏿‍🎨',
				'keywords' => ['artist', 'dark skin tone', 'palette', 'woman', 'uc8'],
			],
			'1f468-1f3a8' => [
				'name' => \XF::phrase('emoji.man_artist'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_artist:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3fb-1f3a8', '1f468-1f3fc-1f3a8', '1f468-1f3fd-1f3a8', '1f468-1f3fe-1f3a8', '1f468-1f3ff-1f3a8'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨‍🎨',
				'keywords' => ['artist', 'man', 'palette', 'uc6'],
			],
			'1f468-1f3fb-1f3a8' => [
				'name' => \XF::phrase('emoji.man_artist_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_artist_tone1:',
				'shortname_alternates' => [':man_artist_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏻‍🎨',
				'keywords' => ['artist', 'light skin tone', 'man', 'palette', 'uc8'],
			],
			'1f468-1f3fc-1f3a8' => [
				'name' => \XF::phrase('emoji.man_artist_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_artist_tone2:',
				'shortname_alternates' => [':man_artist_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏼‍🎨',
				'keywords' => ['artist', 'man', 'medium-light skin tone', 'palette', 'uc8'],
			],
			'1f468-1f3fd-1f3a8' => [
				'name' => \XF::phrase('emoji.man_artist_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_artist_tone3:',
				'shortname_alternates' => [':man_artist_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏽‍🎨',
				'keywords' => ['artist', 'man', 'medium skin tone', 'palette', 'uc8'],
			],
			'1f468-1f3fe-1f3a8' => [
				'name' => \XF::phrase('emoji.man_artist_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_artist_tone4:',
				'shortname_alternates' => [':man_artist_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏾‍🎨',
				'keywords' => ['artist', 'man', 'medium-dark skin tone', 'palette', 'uc8'],
			],
			'1f468-1f3ff-1f3a8' => [
				'name' => \XF::phrase('emoji.man_artist_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_artist_tone5:',
				'shortname_alternates' => [':man_artist_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏿‍🎨',
				'keywords' => ['artist', 'dark skin tone', 'man', 'palette', 'uc8'],
			],
			'1f9d1-1f692' => [
				'name' => \XF::phrase('emoji.firefighter'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':firefighter:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f692', '1f9d1-1f3fc-1f692', '1f9d1-1f3fd-1f692', '1f9d1-1f3fe-1f692', '1f9d1-1f3ff-1f692'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑‍🚒',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f692' => [
				'name' => \XF::phrase('emoji.firefighter_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':firefighter_tone1:',
				'shortname_alternates' => [':firefighter_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍🚒',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f692' => [
				'name' => \XF::phrase('emoji.firefighter_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':firefighter_tone2:',
				'shortname_alternates' => [':firefighter_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍🚒',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f692' => [
				'name' => \XF::phrase('emoji.firefighter_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':firefighter_tone3:',
				'shortname_alternates' => [':firefighter_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍🚒',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f692' => [
				'name' => \XF::phrase('emoji.firefighter_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':firefighter_tone4:',
				'shortname_alternates' => [':firefighter_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍🚒',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f692' => [
				'name' => \XF::phrase('emoji.firefighter_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':firefighter_tone5:',
				'shortname_alternates' => [':firefighter_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍🚒',
				'keywords' => ['uc12'],
			],
			'1f469-1f692' => [
				'name' => \XF::phrase('emoji.woman_firefighter'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_firefighter:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3fb-1f692', '1f469-1f3fc-1f692', '1f469-1f3fd-1f692', '1f469-1f3fe-1f692', '1f469-1f3ff-1f692'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩‍🚒',
				'keywords' => ['firefighter', 'firetruck', 'woman', 'uc6'],
			],
			'1f469-1f3fb-1f692' => [
				'name' => \XF::phrase('emoji.woman_firefighter_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_firefighter_tone1:',
				'shortname_alternates' => [':woman_firefighter_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻‍🚒',
				'keywords' => ['firefighter', 'firetruck', 'light skin tone', 'woman', 'uc8'],
			],
			'1f469-1f3fc-1f692' => [
				'name' => \XF::phrase('emoji.woman_firefighter_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_firefighter_tone2:',
				'shortname_alternates' => [':woman_firefighter_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼‍🚒',
				'keywords' => ['firefighter', 'firetruck', 'medium-light skin tone', 'woman', 'uc8'],
			],
			'1f469-1f3fd-1f692' => [
				'name' => \XF::phrase('emoji.woman_firefighter_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_firefighter_tone3:',
				'shortname_alternates' => [':woman_firefighter_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏽‍🚒',
				'keywords' => ['firefighter', 'firetruck', 'medium skin tone', 'woman', 'uc8'],
			],
			'1f469-1f3fe-1f692' => [
				'name' => \XF::phrase('emoji.woman_firefighter_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_firefighter_tone4:',
				'shortname_alternates' => [':woman_firefighter_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏾‍🚒',
				'keywords' => ['firefighter', 'firetruck', 'medium-dark skin tone', 'woman', 'uc8'],
			],
			'1f469-1f3ff-1f692' => [
				'name' => \XF::phrase('emoji.woman_firefighter_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_firefighter_tone5:',
				'shortname_alternates' => [':woman_firefighter_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏿‍🚒',
				'keywords' => ['dark skin tone', 'firefighter', 'firetruck', 'woman', 'uc8'],
			],
			'1f468-1f692' => [
				'name' => \XF::phrase('emoji.man_firefighter'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_firefighter:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3fb-1f692', '1f468-1f3fc-1f692', '1f468-1f3fd-1f692', '1f468-1f3fe-1f692', '1f468-1f3ff-1f692'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨‍🚒',
				'keywords' => ['firefighter', 'firetruck', 'man', 'uc6'],
			],
			'1f468-1f3fb-1f692' => [
				'name' => \XF::phrase('emoji.man_firefighter_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_firefighter_tone1:',
				'shortname_alternates' => [':man_firefighter_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏻‍🚒',
				'keywords' => ['firefighter', 'firetruck', 'light skin tone', 'man', 'uc8'],
			],
			'1f468-1f3fc-1f692' => [
				'name' => \XF::phrase('emoji.man_firefighter_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_firefighter_tone2:',
				'shortname_alternates' => [':man_firefighter_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏼‍🚒',
				'keywords' => ['firefighter', 'firetruck', 'man', 'medium-light skin tone', 'uc8'],
			],
			'1f468-1f3fd-1f692' => [
				'name' => \XF::phrase('emoji.man_firefighter_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_firefighter_tone3:',
				'shortname_alternates' => [':man_firefighter_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏽‍🚒',
				'keywords' => ['firefighter', 'firetruck', 'man', 'medium skin tone', 'uc8'],
			],
			'1f468-1f3fe-1f692' => [
				'name' => \XF::phrase('emoji.man_firefighter_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_firefighter_tone4:',
				'shortname_alternates' => [':man_firefighter_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏾‍🚒',
				'keywords' => ['firefighter', 'firetruck', 'man', 'medium-dark skin tone', 'uc8'],
			],
			'1f468-1f3ff-1f692' => [
				'name' => \XF::phrase('emoji.man_firefighter_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_firefighter_tone5:',
				'shortname_alternates' => [':man_firefighter_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏿‍🚒',
				'keywords' => ['dark skin tone', 'firefighter', 'firetruck', 'man', 'uc8'],
			],
			'1f9d1-2708' => [
				'name' => \XF::phrase('emoji.pilot'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pilot:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-2708', '1f9d1-1f3fc-2708', '1f9d1-1f3fd-2708', '1f9d1-1f3fe-2708', '1f9d1-1f3ff-2708'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑‍✈️',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-2708' => [
				'name' => \XF::phrase('emoji.pilot_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pilot_tone1:',
				'shortname_alternates' => [':pilot_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍✈️',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-2708' => [
				'name' => \XF::phrase('emoji.pilot_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pilot_tone2:',
				'shortname_alternates' => [':pilot_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍✈️',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-2708' => [
				'name' => \XF::phrase('emoji.pilot_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pilot_tone3:',
				'shortname_alternates' => [':pilot_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍✈️',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-2708' => [
				'name' => \XF::phrase('emoji.pilot_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pilot_tone4:',
				'shortname_alternates' => [':pilot_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍✈️',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-2708' => [
				'name' => \XF::phrase('emoji.pilot_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pilot_tone5:',
				'shortname_alternates' => [':pilot_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍✈️',
				'keywords' => ['uc12'],
			],
			'1f469-2708' => [
				'name' => \XF::phrase('emoji.woman_pilot'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pilot:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3fb-2708', '1f469-1f3fc-2708', '1f469-1f3fd-2708', '1f469-1f3fe-2708', '1f469-1f3ff-2708'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩‍✈️',
				'keywords' => ['pilot', 'plane', 'woman', 'uc6'],
			],
			'1f469-1f3fb-2708' => [
				'name' => \XF::phrase('emoji.woman_pilot_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pilot_tone1:',
				'shortname_alternates' => [':woman_pilot_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻‍✈️',
				'keywords' => ['light skin tone', 'pilot', 'plane', 'woman', 'uc8'],
			],
			'1f469-1f3fc-2708' => [
				'name' => \XF::phrase('emoji.woman_pilot_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pilot_tone2:',
				'shortname_alternates' => [':woman_pilot_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼‍✈️',
				'keywords' => ['medium-light skin tone', 'pilot', 'plane', 'woman', 'uc8'],
			],
			'1f469-1f3fd-2708' => [
				'name' => \XF::phrase('emoji.woman_pilot_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pilot_tone3:',
				'shortname_alternates' => [':woman_pilot_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏽‍✈️',
				'keywords' => ['medium skin tone', 'pilot', 'plane', 'woman', 'uc8'],
			],
			'1f469-1f3fe-2708' => [
				'name' => \XF::phrase('emoji.woman_pilot_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pilot_tone4:',
				'shortname_alternates' => [':woman_pilot_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏾‍✈️',
				'keywords' => ['medium-dark skin tone', 'pilot', 'plane', 'woman', 'uc8'],
			],
			'1f469-1f3ff-2708' => [
				'name' => \XF::phrase('emoji.woman_pilot_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pilot_tone5:',
				'shortname_alternates' => [':woman_pilot_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏿‍✈️',
				'keywords' => ['dark skin tone', 'pilot', 'plane', 'woman', 'uc8'],
			],
			'1f468-2708' => [
				'name' => \XF::phrase('emoji.man_pilot'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pilot:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3fb-2708', '1f468-1f3fc-2708', '1f468-1f3fd-2708', '1f468-1f3fe-2708', '1f468-1f3ff-2708'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨‍✈️',
				'keywords' => ['man', 'pilot', 'plane', 'uc6'],
			],
			'1f468-1f3fb-2708' => [
				'name' => \XF::phrase('emoji.man_pilot_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pilot_tone1:',
				'shortname_alternates' => [':man_pilot_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏻‍✈️',
				'keywords' => ['light skin tone', 'man', 'pilot', 'plane', 'uc8'],
			],
			'1f468-1f3fc-2708' => [
				'name' => \XF::phrase('emoji.man_pilot_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pilot_tone2:',
				'shortname_alternates' => [':man_pilot_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏼‍✈️',
				'keywords' => ['man', 'medium-light skin tone', 'pilot', 'plane', 'uc8'],
			],
			'1f468-1f3fd-2708' => [
				'name' => \XF::phrase('emoji.man_pilot_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pilot_tone3:',
				'shortname_alternates' => [':man_pilot_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏽‍✈️',
				'keywords' => ['man', 'medium skin tone', 'pilot', 'plane', 'uc8'],
			],
			'1f468-1f3fe-2708' => [
				'name' => \XF::phrase('emoji.man_pilot_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pilot_tone4:',
				'shortname_alternates' => [':man_pilot_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏾‍✈️',
				'keywords' => ['man', 'medium-dark skin tone', 'pilot', 'plane', 'uc8'],
			],
			'1f468-1f3ff-2708' => [
				'name' => \XF::phrase('emoji.man_pilot_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pilot_tone5:',
				'shortname_alternates' => [':man_pilot_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏿‍✈️',
				'keywords' => ['dark skin tone', 'man', 'pilot', 'plane', 'uc8'],
			],
			'1f9d1-1f680' => [
				'name' => \XF::phrase('emoji.astronaut'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':astronaut:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f680', '1f9d1-1f3fc-1f680', '1f9d1-1f3fd-1f680', '1f9d1-1f3fe-1f680', '1f9d1-1f3ff-1f680'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑‍🚀',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f680' => [
				'name' => \XF::phrase('emoji.astronaut_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':astronaut_tone1:',
				'shortname_alternates' => [':astronaut_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍🚀',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f680' => [
				'name' => \XF::phrase('emoji.astronaut_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':astronaut_tone2:',
				'shortname_alternates' => [':astronaut_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍🚀',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f680' => [
				'name' => \XF::phrase('emoji.astronaut_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':astronaut_tone3:',
				'shortname_alternates' => [':astronaut_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍🚀',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f680' => [
				'name' => \XF::phrase('emoji.astronaut_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':astronaut_tone4:',
				'shortname_alternates' => [':astronaut_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍🚀',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f680' => [
				'name' => \XF::phrase('emoji.astronaut_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':astronaut_tone5:',
				'shortname_alternates' => [':astronaut_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍🚀',
				'keywords' => ['uc12'],
			],
			'1f469-1f680' => [
				'name' => \XF::phrase('emoji.woman_astronaut'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_astronaut:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3fb-1f680', '1f469-1f3fc-1f680', '1f469-1f3fd-1f680', '1f469-1f3fe-1f680', '1f469-1f3ff-1f680'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩‍🚀',
				'keywords' => ['astronaut', 'rocket', 'woman', 'uc6'],
			],
			'1f469-1f3fb-1f680' => [
				'name' => \XF::phrase('emoji.woman_astronaut_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_astronaut_tone1:',
				'shortname_alternates' => [':woman_astronaut_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻‍🚀',
				'keywords' => ['astronaut', 'light skin tone', 'rocket', 'woman', 'uc8'],
			],
			'1f469-1f3fc-1f680' => [
				'name' => \XF::phrase('emoji.woman_astronaut_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_astronaut_tone2:',
				'shortname_alternates' => [':woman_astronaut_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼‍🚀',
				'keywords' => ['astronaut', 'medium-light skin tone', 'rocket', 'woman', 'uc8'],
			],
			'1f469-1f3fd-1f680' => [
				'name' => \XF::phrase('emoji.woman_astronaut_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_astronaut_tone3:',
				'shortname_alternates' => [':woman_astronaut_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏽‍🚀',
				'keywords' => ['astronaut', 'medium skin tone', 'rocket', 'woman', 'uc8'],
			],
			'1f469-1f3fe-1f680' => [
				'name' => \XF::phrase('emoji.woman_astronaut_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_astronaut_tone4:',
				'shortname_alternates' => [':woman_astronaut_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏾‍🚀',
				'keywords' => ['astronaut', 'medium-dark skin tone', 'rocket', 'woman', 'uc8'],
			],
			'1f469-1f3ff-1f680' => [
				'name' => \XF::phrase('emoji.woman_astronaut_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_astronaut_tone5:',
				'shortname_alternates' => [':woman_astronaut_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏿‍🚀',
				'keywords' => ['astronaut', 'dark skin tone', 'rocket', 'woman', 'uc8'],
			],
			'1f468-1f680' => [
				'name' => \XF::phrase('emoji.man_astronaut'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_astronaut:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3fb-1f680', '1f468-1f3fc-1f680', '1f468-1f3fd-1f680', '1f468-1f3fe-1f680', '1f468-1f3ff-1f680'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨‍🚀',
				'keywords' => ['astronaut', 'man', 'rocket', 'uc6'],
			],
			'1f468-1f3fb-1f680' => [
				'name' => \XF::phrase('emoji.man_astronaut_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_astronaut_tone1:',
				'shortname_alternates' => [':man_astronaut_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏻‍🚀',
				'keywords' => ['astronaut', 'light skin tone', 'man', 'rocket', 'uc8'],
			],
			'1f468-1f3fc-1f680' => [
				'name' => \XF::phrase('emoji.man_astronaut_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_astronaut_tone2:',
				'shortname_alternates' => [':man_astronaut_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏼‍🚀',
				'keywords' => ['astronaut', 'man', 'medium-light skin tone', 'rocket', 'uc8'],
			],
			'1f468-1f3fd-1f680' => [
				'name' => \XF::phrase('emoji.man_astronaut_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_astronaut_tone3:',
				'shortname_alternates' => [':man_astronaut_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏽‍🚀',
				'keywords' => ['astronaut', 'man', 'medium skin tone', 'rocket', 'uc8'],
			],
			'1f468-1f3fe-1f680' => [
				'name' => \XF::phrase('emoji.man_astronaut_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_astronaut_tone4:',
				'shortname_alternates' => [':man_astronaut_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏾‍🚀',
				'keywords' => ['astronaut', 'man', 'medium-dark skin tone', 'rocket', 'uc8'],
			],
			'1f468-1f3ff-1f680' => [
				'name' => \XF::phrase('emoji.man_astronaut_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_astronaut_tone5:',
				'shortname_alternates' => [':man_astronaut_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏿‍🚀',
				'keywords' => ['astronaut', 'dark skin tone', 'man', 'rocket', 'uc8'],
			],
			'1f9d1-2696' => [
				'name' => \XF::phrase('emoji.judge'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':judge:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-2696', '1f9d1-1f3fc-2696', '1f9d1-1f3fd-2696', '1f9d1-1f3fe-2696', '1f9d1-1f3ff-2696'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑‍⚖️',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-2696' => [
				'name' => \XF::phrase('emoji.judge_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':judge_tone1:',
				'shortname_alternates' => [':judge_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍⚖️',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-2696' => [
				'name' => \XF::phrase('emoji.judge_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':judge_tone2:',
				'shortname_alternates' => [':judge_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍⚖️',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-2696' => [
				'name' => \XF::phrase('emoji.judge_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':judge_tone3:',
				'shortname_alternates' => [':judge_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍⚖️',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-2696' => [
				'name' => \XF::phrase('emoji.judge_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':judge_tone4:',
				'shortname_alternates' => [':judge_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍⚖️',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-2696' => [
				'name' => \XF::phrase('emoji.judge_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':judge_tone5:',
				'shortname_alternates' => [':judge_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍⚖️',
				'keywords' => ['uc12'],
			],
			'1f469-2696' => [
				'name' => \XF::phrase('emoji.woman_judge'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_judge:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3fb-2696', '1f469-1f3fc-2696', '1f469-1f3fd-2696', '1f469-1f3fe-2696', '1f469-1f3ff-2696'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩‍⚖️',
				'keywords' => ['judge', 'scales', 'woman', 'uc6'],
			],
			'1f469-1f3fb-2696' => [
				'name' => \XF::phrase('emoji.woman_judge_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_judge_tone1:',
				'shortname_alternates' => [':woman_judge_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻‍⚖️',
				'keywords' => ['judge', 'light skin tone', 'scales', 'woman', 'uc8'],
			],
			'1f469-1f3fc-2696' => [
				'name' => \XF::phrase('emoji.woman_judge_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_judge_tone2:',
				'shortname_alternates' => [':woman_judge_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼‍⚖️',
				'keywords' => ['judge', 'medium-light skin tone', 'scales', 'woman', 'uc8'],
			],
			'1f469-1f3fd-2696' => [
				'name' => \XF::phrase('emoji.woman_judge_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_judge_tone3:',
				'shortname_alternates' => [':woman_judge_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏽‍⚖️',
				'keywords' => ['judge', 'medium skin tone', 'scales', 'woman', 'uc8'],
			],
			'1f469-1f3fe-2696' => [
				'name' => \XF::phrase('emoji.woman_judge_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_judge_tone4:',
				'shortname_alternates' => [':woman_judge_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏾‍⚖️',
				'keywords' => ['judge', 'medium-dark skin tone', 'scales', 'woman', 'uc8'],
			],
			'1f469-1f3ff-2696' => [
				'name' => \XF::phrase('emoji.woman_judge_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_judge_tone5:',
				'shortname_alternates' => [':woman_judge_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏿‍⚖️',
				'keywords' => ['dark skin tone', 'judge', 'scales', 'woman', 'uc8'],
			],
			'1f468-2696' => [
				'name' => \XF::phrase('emoji.man_judge'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_judge:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3fb-2696', '1f468-1f3fc-2696', '1f468-1f3fd-2696', '1f468-1f3fe-2696', '1f468-1f3ff-2696'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨‍⚖️',
				'keywords' => ['justice', 'man', 'scales', 'uc6'],
			],
			'1f468-1f3fb-2696' => [
				'name' => \XF::phrase('emoji.man_judge_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_judge_tone1:',
				'shortname_alternates' => [':man_judge_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏻‍⚖️',
				'keywords' => ['justice', 'light skin tone', 'man', 'scales', 'uc8'],
			],
			'1f468-1f3fc-2696' => [
				'name' => \XF::phrase('emoji.man_judge_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_judge_tone2:',
				'shortname_alternates' => [':man_judge_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏼‍⚖️',
				'keywords' => ['justice', 'man', 'medium-light skin tone', 'scales', 'uc8'],
			],
			'1f468-1f3fd-2696' => [
				'name' => \XF::phrase('emoji.man_judge_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_judge_tone3:',
				'shortname_alternates' => [':man_judge_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏽‍⚖️',
				'keywords' => ['justice', 'man', 'medium skin tone', 'scales', 'uc8'],
			],
			'1f468-1f3fe-2696' => [
				'name' => \XF::phrase('emoji.man_judge_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_judge_tone4:',
				'shortname_alternates' => [':man_judge_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏾‍⚖️',
				'keywords' => ['justice', 'man', 'medium-dark skin tone', 'scales', 'uc8'],
			],
			'1f468-1f3ff-2696' => [
				'name' => \XF::phrase('emoji.man_judge_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_judge_tone5:',
				'shortname_alternates' => [':man_judge_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏿‍⚖️',
				'keywords' => ['dark skin tone', 'justice', 'man', 'scales', 'uc8'],
			],
			'1f470' => [
				'name' => \XF::phrase('emoji.person_with_veil'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_with_veil:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f470-1f3fb', '1f470-1f3fc', '1f470-1f3fd', '1f470-1f3fe', '1f470-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f470-2642', '1f470-2640'],
				'unicode' => '👰',
				'keywords' => ['person', 'veil', 'wedding', 'uc6'],
			],
			'1f470-1f3fb' => [
				'name' => \XF::phrase('emoji.person_with_veil_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_with_veil_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f470-1f3fb-2642', '1f470-1f3fb-2640'],
				'unicode' => '👰🏻',
				'keywords' => ['person', 'light skin tone', 'veil', 'wedding', 'uc8'],
			],
			'1f470-1f3fc' => [
				'name' => \XF::phrase('emoji.person_with_veil_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_with_veil_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f470-1f3fc-2642', '1f470-1f3fc-2640'],
				'unicode' => '👰🏼',
				'keywords' => ['person', 'medium-light skin tone', 'veil', 'wedding', 'uc8'],
			],
			'1f470-1f3fd' => [
				'name' => \XF::phrase('emoji.person_with_veil_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_with_veil_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f470-1f3fd-2642', '1f470-1f3fd-2640'],
				'unicode' => '👰🏽',
				'keywords' => ['person', 'medium skin tone', 'veil', 'wedding', 'uc8'],
			],
			'1f470-1f3fe' => [
				'name' => \XF::phrase('emoji.person_with_veil_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_with_veil_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f470-1f3fe-2642', '1f470-1f3fe-2640'],
				'unicode' => '👰🏾',
				'keywords' => ['person', 'medium-dark skin tone', 'veil', 'wedding', 'uc8'],
			],
			'1f470-1f3ff' => [
				'name' => \XF::phrase('emoji.person_with_veil_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_with_veil_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f470-1f3ff-2642', '1f470-1f3ff-2640'],
				'unicode' => '👰🏿',
				'keywords' => ['person', 'dark skin tone', 'veil', 'wedding', 'uc8'],
			],
			'1f470-2640' => [
				'name' => \XF::phrase('emoji.woman_with_veil'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_veil:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f470-1f3fb-2640', '1f470-1f3fc-2640', '1f470-1f3fd-2640', '1f470-1f3fe-2640', '1f470-1f3ff-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👰‍♀️',
				'keywords' => ['uc13'],
			],
			'1f470-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_with_veil_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_veil_tone1:',
				'shortname_alternates' => [':woman_with_veil_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👰🏻‍♀️',
				'keywords' => ['uc13'],
			],
			'1f470-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_with_veil_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_veil_tone2:',
				'shortname_alternates' => [':woman_with_veil_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👰🏼‍♀️',
				'keywords' => ['uc13'],
			],
			'1f470-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_with_veil_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_veil_tone3:',
				'shortname_alternates' => [':woman_with_veil_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👰🏽‍♀️',
				'keywords' => ['uc13'],
			],
			'1f470-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_with_veil_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_veil_tone4:',
				'shortname_alternates' => [':woman_with_veil_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👰🏾‍♀️',
				'keywords' => ['uc13'],
			],
			'1f470-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_with_veil_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_veil_tone5:',
				'shortname_alternates' => [':woman_with_veil_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👰🏿‍♀️',
				'keywords' => ['uc13'],
			],
			'1f470-2642' => [
				'name' => \XF::phrase('emoji.man_with_veil'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_veil:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f470-1f3fb-2642', '1f470-1f3fc-2642', '1f470-1f3fd-2642', '1f470-1f3fe-2642', '1f470-1f3ff-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👰‍♂️',
				'keywords' => ['uc13'],
			],
			'1f470-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_with_veil_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_veil_tone1:',
				'shortname_alternates' => [':man_with_veil_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👰🏻‍♂️',
				'keywords' => ['uc13'],
			],
			'1f470-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_with_veil_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_veil_tone2:',
				'shortname_alternates' => [':man_with_veil_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👰🏼‍♂️',
				'keywords' => ['uc13'],
			],
			'1f470-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_with_veil_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_veil_tone3:',
				'shortname_alternates' => [':man_with_veil_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👰🏽‍♂️',
				'keywords' => ['uc13'],
			],
			'1f470-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_with_veil_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_veil_tone4:',
				'shortname_alternates' => [':man_with_veil_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👰🏾‍♂️',
				'keywords' => ['uc13'],
			],
			'1f470-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_with_veil_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_veil_tone5:',
				'shortname_alternates' => [':man_with_veil_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👰🏿‍♂️',
				'keywords' => ['uc13'],
			],
			'1f935' => [
				'name' => \XF::phrase('emoji.person_in_tuxedo'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_tuxedo:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f935-1f3fb', '1f935-1f3fc', '1f935-1f3fd', '1f935-1f3fe', '1f935-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f935-2642', '1f935-2640'],
				'unicode' => '🤵',
				'keywords' => ['person', 'tuxedo', 'uc9'],
			],
			'1f935-1f3fb' => [
				'name' => \XF::phrase('emoji.person_in_tuxedo_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_tuxedo_tone1:',
				'shortname_alternates' => [':tuxedo_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f935-1f3fb-2642', '1f935-1f3fb-2640'],
				'unicode' => '🤵🏻',
				'keywords' => ['light skin tone', 'person', 'tuxedo', 'uc9'],
			],
			'1f935-1f3fc' => [
				'name' => \XF::phrase('emoji.person_in_tuxedo_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_tuxedo_tone2:',
				'shortname_alternates' => [':tuxedo_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f935-1f3fc-2642', '1f935-1f3fc-2640'],
				'unicode' => '🤵🏼',
				'keywords' => ['person', 'medium-light skin tone', 'tuxedo', 'uc9'],
			],
			'1f935-1f3fd' => [
				'name' => \XF::phrase('emoji.person_in_tuxedo_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_tuxedo_tone3:',
				'shortname_alternates' => [':tuxedo_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f935-1f3fd-2642', '1f935-1f3fd-2640'],
				'unicode' => '🤵🏽',
				'keywords' => ['person', 'medium skin tone', 'tuxedo', 'uc9'],
			],
			'1f935-1f3fe' => [
				'name' => \XF::phrase('emoji.person_in_tuxedo_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_tuxedo_tone4:',
				'shortname_alternates' => [':tuxedo_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f935-1f3fe-2642', '1f935-1f3fe-2640'],
				'unicode' => '🤵🏾',
				'keywords' => ['person', 'medium-dark skin tone', 'tuxedo', 'uc9'],
			],
			'1f935-1f3ff' => [
				'name' => \XF::phrase('emoji.person_in_tuxedo_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_tuxedo_tone5:',
				'shortname_alternates' => [':tuxedo_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f935-1f3ff-2642', '1f935-1f3ff-2640'],
				'unicode' => '🤵🏿',
				'keywords' => ['dark skin tone', 'person', 'tuxedo', 'uc9'],
			],
			'1f935-2640' => [
				'name' => \XF::phrase('emoji.woman_in_tuxedo'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_tuxedo:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f935-1f3fb-2640', '1f935-1f3fc-2640', '1f935-1f3fd-2640', '1f935-1f3fe-2640', '1f935-1f3ff-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🤵‍♀️',
				'keywords' => ['uc13'],
			],
			'1f935-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_in_tuxedo_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_tuxedo_tone1:',
				'shortname_alternates' => [':woman_in_tuxedo_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🤵🏻‍♀️',
				'keywords' => ['uc13'],
			],
			'1f935-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_in_tuxedo_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_tuxedo_tone2:',
				'shortname_alternates' => [':woman_in_tuxedo_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🤵🏼‍♀️',
				'keywords' => ['uc13'],
			],
			'1f935-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_in_tuxedo_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_tuxedo_tone3:',
				'shortname_alternates' => [':woman_in_tuxedo_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🤵🏽‍♀️',
				'keywords' => ['uc13'],
			],
			'1f935-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_in_tuxedo_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_tuxedo_tone4:',
				'shortname_alternates' => [':woman_in_tuxedo_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🤵🏾‍♀️',
				'keywords' => ['uc13'],
			],
			'1f935-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_in_tuxedo_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_tuxedo_tone5:',
				'shortname_alternates' => [':woman_in_tuxedo_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🤵🏿‍♀️',
				'keywords' => ['uc13'],
			],
			'1f935-2642' => [
				'name' => \XF::phrase('emoji.man_in_tuxedo'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_tuxedo:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f935-1f3fb-2642', '1f935-1f3fc-2642', '1f935-1f3fd-2642', '1f935-1f3fe-2642', '1f935-1f3ff-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🤵‍♂️',
				'keywords' => ['uc13'],
			],
			'1f935-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_in_tuxedo_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_tuxedo_tone1:',
				'shortname_alternates' => [':man_in_tuxedo_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🤵🏻‍♂️',
				'keywords' => ['uc13'],
			],
			'1f935-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_in_tuxedo_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_tuxedo_tone2:',
				'shortname_alternates' => [':man_in_tuxedo_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🤵🏼‍♂️',
				'keywords' => ['uc13'],
			],
			'1f935-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_in_tuxedo_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_tuxedo_tone3:',
				'shortname_alternates' => [':man_in_tuxedo_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🤵🏽‍♂️',
				'keywords' => ['uc13'],
			],
			'1f935-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_in_tuxedo_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_tuxedo_tone4:',
				'shortname_alternates' => [':man_in_tuxedo_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🤵🏾‍♂️',
				'keywords' => ['uc13'],
			],
			'1f935-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_in_tuxedo_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_tuxedo_tone5:',
				'shortname_alternates' => [':man_in_tuxedo_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🤵🏿‍♂️',
				'keywords' => ['uc13'],
			],
			'1fac5' => [
				'name' => \XF::phrase('emoji.person_with_crown'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_with_crown:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1fac5-1f3fb', '1fac5-1f3fc', '1fac5-1f3fd', '1fac5-1f3fe', '1fac5-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫅',
				'keywords' => ['uc14'],
			],
			'1fac5-1f3fb' => [
				'name' => \XF::phrase('emoji.person_with_crown_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_with_crown_tone1:',
				'shortname_alternates' => [':person_with_crown_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫅🏻',
				'keywords' => ['uc14'],
			],
			'1fac5-1f3fc' => [
				'name' => \XF::phrase('emoji.person_with_crown_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_with_crown_tone2:',
				'shortname_alternates' => [':person_with_crown_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫅🏼',
				'keywords' => ['uc14'],
			],
			'1fac5-1f3fd' => [
				'name' => \XF::phrase('emoji.person_with_crown_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_with_crown_tone3:',
				'shortname_alternates' => [':person_with_crown_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫅🏽',
				'keywords' => ['uc14'],
			],
			'1fac5-1f3fe' => [
				'name' => \XF::phrase('emoji.person_with_crown_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_with_crown_tone4:',
				'shortname_alternates' => [':person_with_crown_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫅🏾',
				'keywords' => ['uc14'],
			],
			'1fac5-1f3ff' => [
				'name' => \XF::phrase('emoji.person_with_crown_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_with_crown_tone5:',
				'shortname_alternates' => [':person_with_crown_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫅🏿',
				'keywords' => ['uc14'],
			],
			'1f478' => [
				'name' => \XF::phrase('emoji.princess'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':princess:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f478-1f3fb', '1f478-1f3fc', '1f478-1f3fd', '1f478-1f3fe', '1f478-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👸',
				'keywords' => ['fairy tale', 'fantasy', 'uc6'],
			],
			'1f478-1f3fb' => [
				'name' => \XF::phrase('emoji.princess_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':princess_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👸🏻',
				'keywords' => ['fairy tale', 'fantasy', 'light skin tone', 'uc8'],
			],
			'1f478-1f3fc' => [
				'name' => \XF::phrase('emoji.princess_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':princess_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👸🏼',
				'keywords' => ['fairy tale', 'fantasy', 'medium-light skin tone', 'uc8'],
			],
			'1f478-1f3fd' => [
				'name' => \XF::phrase('emoji.princess_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':princess_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👸🏽',
				'keywords' => ['fairy tale', 'fantasy', 'medium skin tone', 'uc8'],
			],
			'1f478-1f3fe' => [
				'name' => \XF::phrase('emoji.princess_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':princess_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👸🏾',
				'keywords' => ['fairy tale', 'fantasy', 'medium-dark skin tone', 'uc8'],
			],
			'1f478-1f3ff' => [
				'name' => \XF::phrase('emoji.princess_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':princess_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👸🏿',
				'keywords' => ['dark skin tone', 'fairy tale', 'fantasy', 'uc8'],
			],
			'1f934' => [
				'name' => \XF::phrase('emoji.prince'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':prince:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f934-1f3fb', '1f934-1f3fc', '1f934-1f3fd', '1f934-1f3fe', '1f934-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤴',
				'keywords' => ['prince', 'uc9'],
			],
			'1f934-1f3fb' => [
				'name' => \XF::phrase('emoji.prince_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':prince_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤴🏻',
				'keywords' => ['light skin tone', 'prince', 'uc9'],
			],
			'1f934-1f3fc' => [
				'name' => \XF::phrase('emoji.prince_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':prince_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤴🏼',
				'keywords' => ['medium-light skin tone', 'prince', 'uc9'],
			],
			'1f934-1f3fd' => [
				'name' => \XF::phrase('emoji.prince_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':prince_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤴🏽',
				'keywords' => ['medium skin tone', 'prince', 'uc9'],
			],
			'1f934-1f3fe' => [
				'name' => \XF::phrase('emoji.prince_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':prince_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤴🏾',
				'keywords' => ['medium-dark skin tone', 'prince', 'uc9'],
			],
			'1f934-1f3ff' => [
				'name' => \XF::phrase('emoji.prince_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':prince_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤴🏿',
				'keywords' => ['dark skin tone', 'prince', 'uc9'],
			],
			'1f9b8' => [
				'name' => \XF::phrase('emoji.superhero'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':superhero:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9b8-1f3fb', '1f9b8-1f3fc', '1f9b8-1f3fd', '1f9b8-1f3fe', '1f9b8-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f9b8-2640', '1f9b8-2642'],
				'unicode' => '🦸',
				'keywords' => ['uc11'],
			],
			'1f9b8-1f3fb' => [
				'name' => \XF::phrase('emoji.superhero_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':superhero_tone1:',
				'shortname_alternates' => [':superhero_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9b8-1f3fb-2640', '1f9b8-1f3fb-2642'],
				'unicode' => '🦸🏻',
				'keywords' => ['uc11'],
			],
			'1f9b8-1f3fc' => [
				'name' => \XF::phrase('emoji.superhero_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':superhero_tone2:',
				'shortname_alternates' => [':superhero_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9b8-1f3fc-2640', '1f9b8-1f3fc-2642'],
				'unicode' => '🦸🏼',
				'keywords' => ['uc11'],
			],
			'1f9b8-1f3fd' => [
				'name' => \XF::phrase('emoji.superhero_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':superhero_tone3:',
				'shortname_alternates' => [':superhero_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9b8-1f3fd-2640', '1f9b8-1f3fd-2642'],
				'unicode' => '🦸🏽',
				'keywords' => ['uc11'],
			],
			'1f9b8-1f3fe' => [
				'name' => \XF::phrase('emoji.superhero_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':superhero_tone4:',
				'shortname_alternates' => [':superhero_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9b8-1f3fe-2640', '1f9b8-1f3fe-2642'],
				'unicode' => '🦸🏾',
				'keywords' => ['uc11'],
			],
			'1f9b8-1f3ff' => [
				'name' => \XF::phrase('emoji.superhero_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':superhero_tone5:',
				'shortname_alternates' => [':superhero_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9b8-1f3ff-2640', '1f9b8-1f3ff-2642'],
				'unicode' => '🦸🏿',
				'keywords' => ['uc11'],
			],
			'1f9b8-2640' => [
				'name' => \XF::phrase('emoji.woman_superhero'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_superhero:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9b8-1f3fb-2640', '1f9b8-1f3fc-2640', '1f9b8-1f3fd-2640', '1f9b8-1f3fe-2640', '1f9b8-1f3ff-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🦸‍♀️',
				'keywords' => ['uc11'],
			],
			'1f9b8-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_superhero_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_superhero_tone1:',
				'shortname_alternates' => [':woman_superhero_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🦸🏻‍♀️',
				'keywords' => ['uc11'],
			],
			'1f9b8-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_superhero_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_superhero_tone2:',
				'shortname_alternates' => [':woman_superhero_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🦸🏼‍♀️',
				'keywords' => ['uc11'],
			],
			'1f9b8-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_superhero_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_superhero_tone3:',
				'shortname_alternates' => [':woman_superhero_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🦸🏽‍♀️',
				'keywords' => ['uc11'],
			],
			'1f9b8-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_superhero_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_superhero_tone4:',
				'shortname_alternates' => [':woman_superhero_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🦸🏾‍♀️',
				'keywords' => ['uc11'],
			],
			'1f9b8-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_superhero_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_superhero_tone5:',
				'shortname_alternates' => [':woman_superhero_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🦸🏿‍♀️',
				'keywords' => ['uc11'],
			],
			'1f9b8-2642' => [
				'name' => \XF::phrase('emoji.man_superhero'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_superhero:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9b8-1f3fb-2642', '1f9b8-1f3fc-2642', '1f9b8-1f3fd-2642', '1f9b8-1f3fe-2642', '1f9b8-1f3ff-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🦸‍♂️',
				'keywords' => ['uc11'],
			],
			'1f9b8-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_superhero_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_superhero_tone1:',
				'shortname_alternates' => [':man_superhero_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🦸🏻‍♂️',
				'keywords' => ['uc11'],
			],
			'1f9b8-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_superhero_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_superhero_tone2:',
				'shortname_alternates' => [':man_superhero_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🦸🏼‍♂️',
				'keywords' => ['uc11'],
			],
			'1f9b8-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_superhero_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_superhero_tone3:',
				'shortname_alternates' => [':man_superhero_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🦸🏽‍♂️',
				'keywords' => ['uc11'],
			],
			'1f9b8-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_superhero_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_superhero_tone4:',
				'shortname_alternates' => [':man_superhero_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🦸🏾‍♂️',
				'keywords' => ['uc11'],
			],
			'1f9b8-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_superhero_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_superhero_tone5:',
				'shortname_alternates' => [':man_superhero_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🦸🏿‍♂️',
				'keywords' => ['uc11'],
			],
			'1f9b9' => [
				'name' => \XF::phrase('emoji.supervillain'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':supervillain:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9b9-1f3fb', '1f9b9-1f3fc', '1f9b9-1f3fd', '1f9b9-1f3fe', '1f9b9-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f9b9-2640', '1f9b9-2642'],
				'unicode' => '🦹',
				'keywords' => ['uc11'],
			],
			'1f9b9-1f3fb' => [
				'name' => \XF::phrase('emoji.supervillain_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':supervillain_tone1:',
				'shortname_alternates' => [':supervillain_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9b9-1f3fb-2640', '1f9b9-1f3fb-2642'],
				'unicode' => '🦹🏻',
				'keywords' => ['uc11'],
			],
			'1f9b9-1f3fc' => [
				'name' => \XF::phrase('emoji.supervillain_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':supervillain_tone2:',
				'shortname_alternates' => [':supervillain_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9b9-1f3fc-2640', '1f9b9-1f3fc-2642'],
				'unicode' => '🦹🏼',
				'keywords' => ['uc11'],
			],
			'1f9b9-1f3fd' => [
				'name' => \XF::phrase('emoji.supervillain_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':supervillain_tone3:',
				'shortname_alternates' => [':supervillain_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9b9-1f3fd-2640', '1f9b9-1f3fd-2642'],
				'unicode' => '🦹🏽',
				'keywords' => ['uc11'],
			],
			'1f9b9-1f3fe' => [
				'name' => \XF::phrase('emoji.supervillain_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':supervillain_tone4:',
				'shortname_alternates' => [':supervillain_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9b9-1f3fe-2640', '1f9b9-1f3fe-2642'],
				'unicode' => '🦹🏾',
				'keywords' => ['uc11'],
			],
			'1f9b9-1f3ff' => [
				'name' => \XF::phrase('emoji.supervillain_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':supervillain_tone5:',
				'shortname_alternates' => [':supervillain_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9b9-1f3ff-2640', '1f9b9-1f3ff-2642'],
				'unicode' => '🦹🏿',
				'keywords' => ['uc11'],
			],
			'1f9b9-2640' => [
				'name' => \XF::phrase('emoji.woman_supervillain'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_supervillain:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9b9-1f3fb-2640', '1f9b9-1f3fc-2640', '1f9b9-1f3fd-2640', '1f9b9-1f3fe-2640', '1f9b9-1f3ff-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🦹‍♀️',
				'keywords' => ['uc11'],
			],
			'1f9b9-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_supervillain_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_supervillain_tone1:',
				'shortname_alternates' => [':woman_supervillain_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🦹🏻‍♀️',
				'keywords' => ['uc11'],
			],
			'1f9b9-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_supervillain_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_supervillain_tone2:',
				'shortname_alternates' => [':woman_supervillain_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🦹🏼‍♀️',
				'keywords' => ['uc11'],
			],
			'1f9b9-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_supervillain_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_supervillain_tone3:',
				'shortname_alternates' => [':woman_supervillain_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🦹🏽‍♀️',
				'keywords' => ['uc11'],
			],
			'1f9b9-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_supervillain_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_supervillain_tone4:',
				'shortname_alternates' => [':woman_supervillain_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🦹🏾‍♀️',
				'keywords' => ['uc11'],
			],
			'1f9b9-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_supervillain_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_supervillain_tone5:',
				'shortname_alternates' => [':woman_supervillain_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🦹🏿‍♀️',
				'keywords' => ['uc11'],
			],
			'1f9b9-2642' => [
				'name' => \XF::phrase('emoji.man_supervillain'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_supervillain:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9b9-1f3fb-2642', '1f9b9-1f3fc-2642', '1f9b9-1f3fd-2642', '1f9b9-1f3fe-2642', '1f9b9-1f3ff-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🦹‍♂️',
				'keywords' => ['uc11'],
			],
			'1f9b9-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_supervillain_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_supervillain_tone1:',
				'shortname_alternates' => [':man_supervillain_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🦹🏻‍♂️',
				'keywords' => ['uc11'],
			],
			'1f9b9-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_supervillain_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_supervillain_tone2:',
				'shortname_alternates' => [':man_supervillain_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🦹🏼‍♂️',
				'keywords' => ['uc11'],
			],
			'1f9b9-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_supervillain_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_supervillain_tone3:',
				'shortname_alternates' => [':man_supervillain_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🦹🏽‍♂️',
				'keywords' => ['uc11'],
			],
			'1f9b9-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_supervillain_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_supervillain_tone4:',
				'shortname_alternates' => [':man_supervillain_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🦹🏾‍♂️',
				'keywords' => ['uc11'],
			],
			'1f9b9-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_supervillain_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_supervillain_tone5:',
				'shortname_alternates' => [':man_supervillain_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🦹🏿‍♂️',
				'keywords' => ['uc11'],
			],
			'1f977' => [
				'name' => \XF::phrase('emoji.ninja'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ninja:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f977-1f3fb', '1f977-1f3fc', '1f977-1f3fd', '1f977-1f3fe', '1f977-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🥷',
				'keywords' => ['uc13'],
			],
			'1f977-1f3fb' => [
				'name' => \XF::phrase('emoji.ninja_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ninja_tone1:',
				'shortname_alternates' => [':ninja_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🥷🏻',
				'keywords' => ['uc13'],
			],
			'1f977-1f3fc' => [
				'name' => \XF::phrase('emoji.ninja_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ninja_tone2:',
				'shortname_alternates' => [':ninja_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🥷🏼',
				'keywords' => ['uc13'],
			],
			'1f977-1f3fd' => [
				'name' => \XF::phrase('emoji.ninja_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ninja_tone3:',
				'shortname_alternates' => [':ninja_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🥷🏽',
				'keywords' => ['uc13'],
			],
			'1f977-1f3fe' => [
				'name' => \XF::phrase('emoji.ninja_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ninja_tone4:',
				'shortname_alternates' => [':ninja_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🥷🏾',
				'keywords' => ['uc13'],
			],
			'1f977-1f3ff' => [
				'name' => \XF::phrase('emoji.ninja_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':ninja_tone5:',
				'shortname_alternates' => [':ninja_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🥷🏿',
				'keywords' => ['uc13'],
			],
			'1f9d1-1f384' => [
				'name' => \XF::phrase('emoji.mx_claus'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mx_claus:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f384', '1f9d1-1f3fc-1f384', '1f9d1-1f3fd-1f384', '1f9d1-1f3fe-1f384', '1f9d1-1f3ff-1f384'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑‍🎄',
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3fb-1f384' => [
				'name' => \XF::phrase('emoji.mx_claus_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mx_claus_tone1:',
				'shortname_alternates' => [':mx_claus_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍🎄',
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3fc-1f384' => [
				'name' => \XF::phrase('emoji.mx_claus_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mx_claus_tone2:',
				'shortname_alternates' => [':mx_claus_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍🎄',
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3fd-1f384' => [
				'name' => \XF::phrase('emoji.mx_claus_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mx_claus_tone3:',
				'shortname_alternates' => [':mx_claus_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍🎄',
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3fe-1f384' => [
				'name' => \XF::phrase('emoji.mx_claus_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mx_claus_tone4:',
				'shortname_alternates' => [':mx_claus_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍🎄',
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3ff-1f384' => [
				'name' => \XF::phrase('emoji.mx_claus_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mx_claus_tone5:',
				'shortname_alternates' => [':mx_claus_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍🎄',
				'keywords' => ['uc13'],
			],
			'1f936' => [
				'name' => \XF::phrase('emoji.mrs_claus'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mrs_claus:',
				'shortname_alternates' => [':mother_christmas:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f936-1f3fb', '1f936-1f3fc', '1f936-1f3fd', '1f936-1f3fe', '1f936-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤶',
				'keywords' => ['Christmas', 'Mrs.', 'celebration', 'claus', 'mother', 'uc9'],
			],
			'1f936-1f3fb' => [
				'name' => \XF::phrase('emoji.mrs_claus_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mrs_claus_tone1:',
				'shortname_alternates' => [':mother_christmas_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤶🏻',
				'keywords' => ['Christmas', 'Mrs.', 'celebration', 'claus', 'light skin tone', 'mother', 'uc9'],
			],
			'1f936-1f3fc' => [
				'name' => \XF::phrase('emoji.mrs_claus_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mrs_claus_tone2:',
				'shortname_alternates' => [':mother_christmas_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤶🏼',
				'keywords' => ['Christmas', 'Mrs.', 'celebration', 'claus', 'medium-light skin tone', 'mother', 'uc9'],
			],
			'1f936-1f3fd' => [
				'name' => \XF::phrase('emoji.mrs_claus_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mrs_claus_tone3:',
				'shortname_alternates' => [':mother_christmas_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤶🏽',
				'keywords' => ['Christmas', 'Mrs.', 'celebration', 'claus', 'medium skin tone', 'mother', 'uc9'],
			],
			'1f936-1f3fe' => [
				'name' => \XF::phrase('emoji.mrs_claus_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mrs_claus_tone4:',
				'shortname_alternates' => [':mother_christmas_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤶🏾',
				'keywords' => ['Christmas', 'Mrs.', 'celebration', 'claus', 'medium-dark skin tone', 'mother', 'uc9'],
			],
			'1f936-1f3ff' => [
				'name' => \XF::phrase('emoji.mrs_claus_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mrs_claus_tone5:',
				'shortname_alternates' => [':mother_christmas_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤶🏿',
				'keywords' => ['Christmas', 'Mrs.', 'celebration', 'claus', 'dark skin tone', 'mother', 'uc9'],
			],
			'1f385' => [
				'name' => \XF::phrase('emoji.santa'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':santa:',
				'shortname_alternates' => [':santa_claus:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f385-1f3fb', '1f385-1f3fc', '1f385-1f3fd', '1f385-1f3fe', '1f385-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🎅',
				'keywords' => ['Christmas', 'celebration', 'claus', 'father', 'santa', 'uc6'],
			],
			'1f385-1f3fb' => [
				'name' => \XF::phrase('emoji.santa_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':santa_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🎅🏻',
				'keywords' => ['Christmas', 'celebration', 'claus', 'father', 'light skin tone', 'santa', 'uc8'],
			],
			'1f385-1f3fc' => [
				'name' => \XF::phrase('emoji.santa_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':santa_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🎅🏼',
				'keywords' => ['Christmas', 'celebration', 'claus', 'father', 'medium-light skin tone', 'santa', 'uc8'],
			],
			'1f385-1f3fd' => [
				'name' => \XF::phrase('emoji.santa_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':santa_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🎅🏽',
				'keywords' => ['Christmas', 'celebration', 'claus', 'father', 'medium skin tone', 'santa', 'uc8'],
			],
			'1f385-1f3fe' => [
				'name' => \XF::phrase('emoji.santa_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':santa_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🎅🏾',
				'keywords' => ['Christmas', 'celebration', 'claus', 'father', 'medium-dark skin tone', 'santa', 'uc8'],
			],
			'1f385-1f3ff' => [
				'name' => \XF::phrase('emoji.santa_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':santa_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🎅🏿',
				'keywords' => ['Christmas', 'celebration', 'claus', 'dark skin tone', 'father', 'santa', 'uc8'],
			],
			'1f9d9' => [
				'name' => \XF::phrase('emoji.mage'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mage:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d9-1f3fb', '1f9d9-1f3fc', '1f9d9-1f3fd', '1f9d9-1f3fe', '1f9d9-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f9d9-2640', '1f9d9-2642'],
				'unicode' => '🧙',
				'keywords' => ['sorcerer', 'sorceress', 'witch', 'wizard', 'uc10'],
			],
			'1f9d9-1f3fb' => [
				'name' => \XF::phrase('emoji.mage_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mage_tone1:',
				'shortname_alternates' => [':mage_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9d9-1f3fb-2640', '1f9d9-1f3fb-2642'],
				'unicode' => '🧙🏻',
				'keywords' => ['light skin tone', 'sorcerer', 'sorceress', 'witch', 'wizard', 'uc10'],
			],
			'1f9d9-1f3fc' => [
				'name' => \XF::phrase('emoji.mage_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mage_tone2:',
				'shortname_alternates' => [':mage_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9d9-1f3fc-2640', '1f9d9-1f3fc-2642'],
				'unicode' => '🧙🏼',
				'keywords' => ['medium-light skin tone', 'sorcerer', 'sorceress', 'witch', 'wizard', 'uc10'],
			],
			'1f9d9-1f3fd' => [
				'name' => \XF::phrase('emoji.mage_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mage_tone3:',
				'shortname_alternates' => [':mage_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9d9-1f3fd-2640', '1f9d9-1f3fd-2642'],
				'unicode' => '🧙🏽',
				'keywords' => ['medium skin tone', 'sorcerer', 'sorceress', 'witch', 'wizard', 'uc10'],
			],
			'1f9d9-1f3fe' => [
				'name' => \XF::phrase('emoji.mage_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mage_tone4:',
				'shortname_alternates' => [':mage_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9d9-1f3fe-2640', '1f9d9-1f3fe-2642'],
				'unicode' => '🧙🏾',
				'keywords' => ['medium-dark skin tone', 'sorcerer', 'sorceress', 'witch', 'wizard', 'uc10'],
			],
			'1f9d9-1f3ff' => [
				'name' => \XF::phrase('emoji.mage_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mage_tone5:',
				'shortname_alternates' => [':mage_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9d9-1f3ff-2640', '1f9d9-1f3ff-2642'],
				'unicode' => '🧙🏿',
				'keywords' => ['dark skin tone', 'sorcerer', 'sorceress', 'witch', 'wizard', 'uc10'],
			],
			'1f9d9-2640' => [
				'name' => \XF::phrase('emoji.woman_mage'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mage:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d9-1f3fb-2640', '1f9d9-1f3fc-2640', '1f9d9-1f3fd-2640', '1f9d9-1f3fe-2640', '1f9d9-1f3ff-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧙‍♀️',
				'keywords' => ['sorceress', 'witch', 'uc10'],
			],
			'1f9d9-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_mage_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mage_tone1:',
				'shortname_alternates' => [':woman_mage_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧙🏻‍♀️',
				'keywords' => ['light skin tone', 'sorceress', 'witch', 'uc10'],
			],
			'1f9d9-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_mage_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mage_tone2:',
				'shortname_alternates' => [':woman_mage_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧙🏼‍♀️',
				'keywords' => ['medium-light skin tone', 'sorceress', 'witch', 'uc10'],
			],
			'1f9d9-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_mage_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mage_tone3:',
				'shortname_alternates' => [':woman_mage_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧙🏽‍♀️',
				'keywords' => ['medium skin tone', 'sorceress', 'witch', 'uc10'],
			],
			'1f9d9-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_mage_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mage_tone4:',
				'shortname_alternates' => [':woman_mage_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧙🏾‍♀️',
				'keywords' => ['medium-dark skin tone', 'sorceress', 'witch', 'uc10'],
			],
			'1f9d9-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_mage_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_mage_tone5:',
				'shortname_alternates' => [':woman_mage_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧙🏿‍♀️',
				'keywords' => ['dark skin tone', 'sorceress', 'witch', 'uc10'],
			],
			'1f9d9-2642' => [
				'name' => \XF::phrase('emoji.man_mage'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mage:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d9-1f3fb-2642', '1f9d9-1f3fc-2642', '1f9d9-1f3fd-2642', '1f9d9-1f3fe-2642', '1f9d9-1f3ff-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧙‍♂️',
				'keywords' => ['sorcerer', 'wizard', 'uc10'],
			],
			'1f9d9-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_mage_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mage_tone1:',
				'shortname_alternates' => [':man_mage_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧙🏻‍♂️',
				'keywords' => ['light skin tone', 'sorcerer', 'wizard', 'uc10'],
			],
			'1f9d9-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_mage_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mage_tone2:',
				'shortname_alternates' => [':man_mage_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧙🏼‍♂️',
				'keywords' => ['medium-light skin tone', 'sorcerer', 'wizard', 'uc10'],
			],
			'1f9d9-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_mage_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mage_tone3:',
				'shortname_alternates' => [':man_mage_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧙🏽‍♂️',
				'keywords' => ['medium skin tone', 'sorcerer', 'wizard', 'uc10'],
			],
			'1f9d9-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_mage_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mage_tone4:',
				'shortname_alternates' => [':man_mage_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧙🏾‍♂️',
				'keywords' => ['medium-dark skin tone', 'sorcerer', 'wizard', 'uc10'],
			],
			'1f9d9-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_mage_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_mage_tone5:',
				'shortname_alternates' => [':man_mage_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧙🏿‍♂️',
				'keywords' => ['dark skin tone', 'sorcerer', 'wizard', 'uc10'],
			],
			'1f9dd' => [
				'name' => \XF::phrase('emoji.elf'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':elf:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9dd-1f3fb', '1f9dd-1f3fc', '1f9dd-1f3fd', '1f9dd-1f3fe', '1f9dd-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f9dd-2640', '1f9dd-2642'],
				'unicode' => '🧝',
				'keywords' => ['uc10'],
			],
			'1f9dd-1f3fb' => [
				'name' => \XF::phrase('emoji.elf_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':elf_tone1:',
				'shortname_alternates' => [':elf_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9dd-1f3fb-2640', '1f9dd-1f3fb-2642'],
				'unicode' => '🧝🏻',
				'keywords' => ['light skin tone', 'magical', 'uc10'],
			],
			'1f9dd-1f3fc' => [
				'name' => \XF::phrase('emoji.elf_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':elf_tone2:',
				'shortname_alternates' => [':elf_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9dd-1f3fc-2640', '1f9dd-1f3fc-2642'],
				'unicode' => '🧝🏼',
				'keywords' => ['magical', 'medium-light skin tone', 'uc10'],
			],
			'1f9dd-1f3fd' => [
				'name' => \XF::phrase('emoji.elf_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':elf_tone3:',
				'shortname_alternates' => [':elf_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9dd-1f3fd-2640', '1f9dd-1f3fd-2642'],
				'unicode' => '🧝🏽',
				'keywords' => ['magical', 'medium skin tone', 'uc10'],
			],
			'1f9dd-1f3fe' => [
				'name' => \XF::phrase('emoji.elf_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':elf_tone4:',
				'shortname_alternates' => [':elf_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9dd-1f3fe-2640', '1f9dd-1f3fe-2642'],
				'unicode' => '🧝🏾',
				'keywords' => ['magical', 'medium-dark skin tone', 'uc10'],
			],
			'1f9dd-1f3ff' => [
				'name' => \XF::phrase('emoji.elf_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':elf_tone5:',
				'shortname_alternates' => [':elf_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9dd-1f3ff-2640', '1f9dd-1f3ff-2642'],
				'unicode' => '🧝🏿',
				'keywords' => ['dark skin tone', 'magical', 'uc10'],
			],
			'1f9dd-2640' => [
				'name' => \XF::phrase('emoji.woman_elf'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_elf:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9dd-1f3fb-2640', '1f9dd-1f3fc-2640', '1f9dd-1f3fd-2640', '1f9dd-1f3fe-2640', '1f9dd-1f3ff-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧝‍♀️',
				'keywords' => ['magical', 'uc10'],
			],
			'1f9dd-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_elf_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_elf_tone1:',
				'shortname_alternates' => [':woman_elf_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧝🏻‍♀️',
				'keywords' => ['light skin tone', 'magical', 'uc10'],
			],
			'1f9dd-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_elf_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_elf_tone2:',
				'shortname_alternates' => [':woman_elf_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧝🏼‍♀️',
				'keywords' => ['magical', 'medium-light skin tone', 'uc10'],
			],
			'1f9dd-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_elf_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_elf_tone3:',
				'shortname_alternates' => [':woman_elf_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧝🏽‍♀️',
				'keywords' => ['magical', 'medium skin tone', 'uc10'],
			],
			'1f9dd-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_elf_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_elf_tone4:',
				'shortname_alternates' => [':woman_elf_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧝🏾‍♀️',
				'keywords' => ['magical', 'medium-dark skin tone', 'uc10'],
			],
			'1f9dd-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_elf_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_elf_tone5:',
				'shortname_alternates' => [':woman_elf_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧝🏿‍♀️',
				'keywords' => ['dark skin tone', 'magical', 'uc10'],
			],
			'1f9dd-2642' => [
				'name' => \XF::phrase('emoji.man_elf'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_elf:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9dd-1f3fb-2642', '1f9dd-1f3fc-2642', '1f9dd-1f3fd-2642', '1f9dd-1f3fe-2642', '1f9dd-1f3ff-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧝‍♂️',
				'keywords' => ['magical', 'uc10'],
			],
			'1f9dd-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_elf_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_elf_tone1:',
				'shortname_alternates' => [':man_elf_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧝🏻‍♂️',
				'keywords' => ['light skin tone', 'magical', 'uc10'],
			],
			'1f9dd-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_elf_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_elf_tone2:',
				'shortname_alternates' => [':man_elf_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧝🏼‍♂️',
				'keywords' => ['magical', 'medium-light skin tone', 'uc10'],
			],
			'1f9dd-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_elf_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_elf_tone3:',
				'shortname_alternates' => [':man_elf_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧝🏽‍♂️',
				'keywords' => ['magical', 'medium skin tone', 'uc10'],
			],
			'1f9dd-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_elf_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_elf_tone4:',
				'shortname_alternates' => [':man_elf_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧝🏾‍♂️',
				'keywords' => ['magical', 'medium-dark skin tone', 'uc10'],
			],
			'1f9dd-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_elf_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_elf_tone5:',
				'shortname_alternates' => [':man_elf_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧝🏿‍♂️',
				'keywords' => ['dark skin tone', 'magical', 'uc10'],
			],
			'1f9cc' => [
				'name' => \XF::phrase('emoji.troll'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':troll:',
				'shortname_alternates' => [],
				'humanform' => '0',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧌',
				'keywords' => ['uc14'],
			],
			'1f9db' => [
				'name' => \XF::phrase('emoji.vampire'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vampire:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9db-1f3fb', '1f9db-1f3fc', '1f9db-1f3fd', '1f9db-1f3fe', '1f9db-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f9db-2640', '1f9db-2642'],
				'unicode' => '🧛',
				'keywords' => ['Dracula', 'undead', 'uc10'],
			],
			'1f9db-1f3fb' => [
				'name' => \XF::phrase('emoji.vampire_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vampire_tone1:',
				'shortname_alternates' => [':vampire_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9db-1f3fb-2640', '1f9db-1f3fb-2642'],
				'unicode' => '🧛🏻',
				'keywords' => ['Dracula', 'light skin tone', 'undead', 'uc10'],
			],
			'1f9db-1f3fc' => [
				'name' => \XF::phrase('emoji.vampire_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vampire_tone2:',
				'shortname_alternates' => [':vampire_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9db-1f3fc-2640', '1f9db-1f3fc-2642'],
				'unicode' => '🧛🏼',
				'keywords' => ['Dracula', 'medium-light skin tone', 'undead', 'uc10'],
			],
			'1f9db-1f3fd' => [
				'name' => \XF::phrase('emoji.vampire_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vampire_tone3:',
				'shortname_alternates' => [':vampire_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9db-1f3fd-2640', '1f9db-1f3fd-2642'],
				'unicode' => '🧛🏽',
				'keywords' => ['Dracula', 'medium skin tone', 'undead', 'uc10'],
			],
			'1f9db-1f3fe' => [
				'name' => \XF::phrase('emoji.vampire_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vampire_tone4:',
				'shortname_alternates' => [':vampire_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9db-1f3fe-2640', '1f9db-1f3fe-2642'],
				'unicode' => '🧛🏾',
				'keywords' => ['Dracula', 'medium-dark skin tone', 'undead', 'uc10'],
			],
			'1f9db-1f3ff' => [
				'name' => \XF::phrase('emoji.vampire_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':vampire_tone5:',
				'shortname_alternates' => [':vampire_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9db-1f3ff-2640', '1f9db-1f3ff-2642'],
				'unicode' => '🧛🏿',
				'keywords' => ['Dracula', 'dark skin tone', 'undead', 'uc10'],
			],
			'1f9db-2640' => [
				'name' => \XF::phrase('emoji.woman_vampire'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_vampire:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9db-1f3fb-2640', '1f9db-1f3fc-2640', '1f9db-1f3fd-2640', '1f9db-1f3fe-2640', '1f9db-1f3ff-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧛‍♀️',
				'keywords' => ['undead', 'uc10'],
			],
			'1f9db-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_vampire_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_vampire_tone1:',
				'shortname_alternates' => [':woman_vampire_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧛🏻‍♀️',
				'keywords' => ['light skin tone', 'undead', 'uc10'],
			],
			'1f9db-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_vampire_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_vampire_tone2:',
				'shortname_alternates' => [':woman_vampire_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧛🏼‍♀️',
				'keywords' => ['medium-light skin tone', 'undead', 'uc10'],
			],
			'1f9db-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_vampire_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_vampire_tone3:',
				'shortname_alternates' => [':woman_vampire_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧛🏽‍♀️',
				'keywords' => ['medium skin tone', 'undead', 'uc10'],
			],
			'1f9db-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_vampire_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_vampire_tone4:',
				'shortname_alternates' => [':woman_vampire_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧛🏾‍♀️',
				'keywords' => ['medium-dark skin tone', 'undead', 'uc10'],
			],
			'1f9db-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_vampire_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_vampire_tone5:',
				'shortname_alternates' => [':woman_vampire_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧛🏿‍♀️',
				'keywords' => ['dark skin tone', 'undead', 'uc10'],
			],
			'1f9db-2642' => [
				'name' => \XF::phrase('emoji.man_vampire'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_vampire:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9db-1f3fb-2642', '1f9db-1f3fc-2642', '1f9db-1f3fd-2642', '1f9db-1f3fe-2642', '1f9db-1f3ff-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧛‍♂️',
				'keywords' => ['Dracula', 'undead', 'uc10'],
			],
			'1f9db-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_vampire_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_vampire_tone1:',
				'shortname_alternates' => [':man_vampire_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧛🏻‍♂️',
				'keywords' => ['Dracula', 'light skin tone', 'undead', 'uc10'],
			],
			'1f9db-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_vampire_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_vampire_tone2:',
				'shortname_alternates' => [':man_vampire_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧛🏼‍♂️',
				'keywords' => ['Dracula', 'medium-light skin tone', 'undead', 'uc10'],
			],
			'1f9db-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_vampire_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_vampire_tone3:',
				'shortname_alternates' => [':man_vampire_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧛🏽‍♂️',
				'keywords' => ['Dracula', 'medium skin tone', 'undead', 'uc10'],
			],
			'1f9db-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_vampire_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_vampire_tone4:',
				'shortname_alternates' => [':man_vampire_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧛🏾‍♂️',
				'keywords' => ['Dracula', 'medium-dark skin tone', 'undead', 'uc10'],
			],
			'1f9db-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_vampire_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_vampire_tone5:',
				'shortname_alternates' => [':man_vampire_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧛🏿‍♂️',
				'keywords' => ['Dracula', 'dark skin tone', 'undead', 'uc10'],
			],
			'1f9df' => [
				'name' => \XF::phrase('emoji.zombie'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':zombie:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9df-2640', '1f9df-2642'],
				'unicode' => '🧟',
				'keywords' => ['uc10'],
			],
			'1f9df-2640' => [
				'name' => \XF::phrase('emoji.woman_zombie'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_zombie:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧟‍♀️',
				'keywords' => ['undead', 'walking dead', 'uc10'],
			],
			'1f9df-2642' => [
				'name' => \XF::phrase('emoji.man_zombie'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_zombie:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧟‍♂️',
				'keywords' => ['undead', 'walking dead', 'uc10'],
			],
			'1f9de' => [
				'name' => \XF::phrase('emoji.genie'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':genie:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9de-2640', '1f9de-2642'],
				'unicode' => '🧞',
				'keywords' => ['uc10'],
			],
			'1f9de-2640' => [
				'name' => \XF::phrase('emoji.woman_genie'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_genie:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧞‍♀️',
				'keywords' => ['djinn', 'uc10'],
			],
			'1f9de-2642' => [
				'name' => \XF::phrase('emoji.man_genie'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_genie:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧞‍♂️',
				'keywords' => ['djinn', 'uc10'],
			],
			'1f9dc' => [
				'name' => \XF::phrase('emoji.merperson'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merperson:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9dc-1f3fb', '1f9dc-1f3fc', '1f9dc-1f3fd', '1f9dc-1f3fe', '1f9dc-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f9dc-2640', '1f9dc-2642'],
				'unicode' => '🧜',
				'keywords' => ['mermaid', 'merman', 'merwoman', 'uc10'],
			],
			'1f9dc-1f3fb' => [
				'name' => \XF::phrase('emoji.merperson_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merperson_tone1:',
				'shortname_alternates' => [':merperson_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9dc-1f3fb-2640', '1f9dc-1f3fb-2642'],
				'unicode' => '🧜🏻',
				'keywords' => ['light skin tone', 'mermaid', 'merman', 'merwoman', 'uc10'],
			],
			'1f9dc-1f3fc' => [
				'name' => \XF::phrase('emoji.merperson_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merperson_tone2:',
				'shortname_alternates' => [':merperson_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9dc-1f3fc-2640', '1f9dc-1f3fc-2642'],
				'unicode' => '🧜🏼',
				'keywords' => ['medium-light skin tone', 'mermaid', 'merman', 'merwoman', 'uc10'],
			],
			'1f9dc-1f3fd' => [
				'name' => \XF::phrase('emoji.merperson_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merperson_tone3:',
				'shortname_alternates' => [':merperson_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9dc-1f3fd-2640', '1f9dc-1f3fd-2642'],
				'unicode' => '🧜🏽',
				'keywords' => ['medium skin tone', 'mermaid', 'merman', 'merwoman', 'uc10'],
			],
			'1f9dc-1f3fe' => [
				'name' => \XF::phrase('emoji.merperson_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merperson_tone4:',
				'shortname_alternates' => [':merperson_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9dc-1f3fe-2640', '1f9dc-1f3fe-2642'],
				'unicode' => '🧜🏾',
				'keywords' => ['medium-dark skin tone', 'mermaid', 'merman', 'merwoman', 'uc10'],
			],
			'1f9dc-1f3ff' => [
				'name' => \XF::phrase('emoji.merperson_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merperson_tone5:',
				'shortname_alternates' => [':merperson_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9dc-1f3ff-2640', '1f9dc-1f3ff-2642'],
				'unicode' => '🧜🏿',
				'keywords' => ['dark skin tone', 'mermaid', 'merman', 'merwoman', 'uc10'],
			],
			'1f9dc-2640' => [
				'name' => \XF::phrase('emoji.mermaid'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mermaid:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9dc-1f3fb-2640', '1f9dc-1f3fc-2640', '1f9dc-1f3fd-2640', '1f9dc-1f3fe-2640', '1f9dc-1f3ff-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧜‍♀️',
				'keywords' => ['merwoman', 'uc10'],
			],
			'1f9dc-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.mermaid_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mermaid_tone1:',
				'shortname_alternates' => [':mermaid_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧜🏻‍♀️',
				'keywords' => ['light skin tone', 'merwoman', 'uc10'],
			],
			'1f9dc-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.mermaid_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mermaid_tone2:',
				'shortname_alternates' => [':mermaid_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧜🏼‍♀️',
				'keywords' => ['medium-light skin tone', 'merwoman', 'uc10'],
			],
			'1f9dc-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.mermaid_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mermaid_tone3:',
				'shortname_alternates' => [':mermaid_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧜🏽‍♀️',
				'keywords' => ['medium skin tone', 'merwoman', 'uc10'],
			],
			'1f9dc-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.mermaid_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mermaid_tone4:',
				'shortname_alternates' => [':mermaid_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧜🏾‍♀️',
				'keywords' => ['medium-dark skin tone', 'merwoman', 'uc10'],
			],
			'1f9dc-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.mermaid_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':mermaid_tone5:',
				'shortname_alternates' => [':mermaid_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧜🏿‍♀️',
				'keywords' => ['dark skin tone', 'merwoman', 'uc10'],
			],
			'1f9dc-2642' => [
				'name' => \XF::phrase('emoji.merman'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merman:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9dc-1f3fb-2642', '1f9dc-1f3fc-2642', '1f9dc-1f3fd-2642', '1f9dc-1f3fe-2642', '1f9dc-1f3ff-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧜‍♂️',
				'keywords' => ['Triton', 'uc10'],
			],
			'1f9dc-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.merman_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merman_tone1:',
				'shortname_alternates' => [':merman_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧜🏻‍♂️',
				'keywords' => ['Triton', 'light skin tone', 'uc10'],
			],
			'1f9dc-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.merman_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merman_tone2:',
				'shortname_alternates' => [':merman_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧜🏼‍♂️',
				'keywords' => ['Triton', 'medium-light skin tone', 'uc10'],
			],
			'1f9dc-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.merman_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merman_tone3:',
				'shortname_alternates' => [':merman_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧜🏽‍♂️',
				'keywords' => ['Triton', 'medium skin tone', 'uc10'],
			],
			'1f9dc-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.merman_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merman_tone4:',
				'shortname_alternates' => [':merman_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧜🏾‍♂️',
				'keywords' => ['Triton', 'medium-dark skin tone', 'uc10'],
			],
			'1f9dc-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.merman_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':merman_tone5:',
				'shortname_alternates' => [':merman_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧜🏿‍♂️',
				'keywords' => ['Triton', 'dark skin tone', 'uc10'],
			],
			'1f9da' => [
				'name' => \XF::phrase('emoji.fairy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fairy:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9da-1f3fb', '1f9da-1f3fc', '1f9da-1f3fd', '1f9da-1f3fe', '1f9da-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f9da-2640', '1f9da-2642'],
				'unicode' => '🧚',
				'keywords' => ['Oberon', 'Puck', 'Titania', 'uc10'],
			],
			'1f9da-1f3fb' => [
				'name' => \XF::phrase('emoji.fairy_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fairy_tone1:',
				'shortname_alternates' => [':fairy_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9da-1f3fb-2640', '1f9da-1f3fb-2642'],
				'unicode' => '🧚🏻',
				'keywords' => ['Oberon', 'Puck', 'Titania', 'light skin tone', 'uc10'],
			],
			'1f9da-1f3fc' => [
				'name' => \XF::phrase('emoji.fairy_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fairy_tone2:',
				'shortname_alternates' => [':fairy_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9da-1f3fc-2640', '1f9da-1f3fc-2642'],
				'unicode' => '🧚🏼',
				'keywords' => ['Oberon', 'Puck', 'Titania', 'medium-light skin tone', 'uc10'],
			],
			'1f9da-1f3fd' => [
				'name' => \XF::phrase('emoji.fairy_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fairy_tone3:',
				'shortname_alternates' => [':fairy_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9da-1f3fd-2640', '1f9da-1f3fd-2642'],
				'unicode' => '🧚🏽',
				'keywords' => ['Oberon', 'Puck', 'Titania', 'medium skin tone', 'uc10'],
			],
			'1f9da-1f3fe' => [
				'name' => \XF::phrase('emoji.fairy_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fairy_tone4:',
				'shortname_alternates' => [':fairy_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9da-1f3fe-2640', '1f9da-1f3fe-2642'],
				'unicode' => '🧚🏾',
				'keywords' => ['Oberon', 'Puck', 'Titania', 'medium-dark skin tone', 'uc10'],
			],
			'1f9da-1f3ff' => [
				'name' => \XF::phrase('emoji.fairy_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':fairy_tone5:',
				'shortname_alternates' => [':fairy_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9da-1f3ff-2640', '1f9da-1f3ff-2642'],
				'unicode' => '🧚🏿',
				'keywords' => ['Oberon', 'Puck', 'Titania', 'dark skin tone', 'uc10'],
			],
			'1f9da-2640' => [
				'name' => \XF::phrase('emoji.woman_fairy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_fairy:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9da-1f3fb-2640', '1f9da-1f3fc-2640', '1f9da-1f3fd-2640', '1f9da-1f3fe-2640', '1f9da-1f3ff-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧚‍♀️',
				'keywords' => ['Titania', 'uc10'],
			],
			'1f9da-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_fairy_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_fairy_tone1:',
				'shortname_alternates' => [':woman_fairy_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧚🏻‍♀️',
				'keywords' => ['Titania', 'light skin tone', 'uc10'],
			],
			'1f9da-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_fairy_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_fairy_tone2:',
				'shortname_alternates' => [':woman_fairy_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧚🏼‍♀️',
				'keywords' => ['Titania', 'medium-light skin tone', 'uc10'],
			],
			'1f9da-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_fairy_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_fairy_tone3:',
				'shortname_alternates' => [':woman_fairy_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧚🏽‍♀️',
				'keywords' => ['Titania', 'medium skin tone', 'uc10'],
			],
			'1f9da-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_fairy_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_fairy_tone4:',
				'shortname_alternates' => [':woman_fairy_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧚🏾‍♀️',
				'keywords' => ['Titania', 'medium-dark skin tone', 'uc10'],
			],
			'1f9da-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_fairy_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_fairy_tone5:',
				'shortname_alternates' => [':woman_fairy_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧚🏿‍♀️',
				'keywords' => ['Titania', 'dark skin tone', 'uc10'],
			],
			'1f9da-2642' => [
				'name' => \XF::phrase('emoji.man_fairy'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_fairy:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9da-1f3fb-2642', '1f9da-1f3fc-2642', '1f9da-1f3fd-2642', '1f9da-1f3fe-2642', '1f9da-1f3ff-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧚‍♂️',
				'keywords' => ['Oberon', 'Puck', 'uc10'],
			],
			'1f9da-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_fairy_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_fairy_tone1:',
				'shortname_alternates' => [':man_fairy_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧚🏻‍♂️',
				'keywords' => ['Oberon', 'Puck', 'light skin tone', 'uc10'],
			],
			'1f9da-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_fairy_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_fairy_tone2:',
				'shortname_alternates' => [':man_fairy_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧚🏼‍♂️',
				'keywords' => ['Oberon', 'Puck', 'medium-light skin tone', 'uc10'],
			],
			'1f9da-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_fairy_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_fairy_tone3:',
				'shortname_alternates' => [':man_fairy_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧚🏽‍♂️',
				'keywords' => ['Oberon', 'Puck', 'medium skin tone', 'uc10'],
			],
			'1f9da-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_fairy_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_fairy_tone4:',
				'shortname_alternates' => [':man_fairy_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧚🏾‍♂️',
				'keywords' => ['Oberon', 'Puck', 'medium-dark skin tone', 'uc10'],
			],
			'1f9da-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_fairy_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_fairy_tone5:',
				'shortname_alternates' => [':man_fairy_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧚🏿‍♂️',
				'keywords' => ['Oberon', 'Puck', 'dark skin tone', 'uc10'],
			],
			'1f47c' => [
				'name' => \XF::phrase('emoji.angel'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':angel:',
				'shortname_alternates' => [':baby_angel:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f47c-1f3fb', '1f47c-1f3fc', '1f47c-1f3fd', '1f47c-1f3fe', '1f47c-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👼',
				'keywords' => ['angel', 'baby', 'face', 'fairy tale', 'fantasy', 'uc6'],
			],
			'1f47c-1f3fb' => [
				'name' => \XF::phrase('emoji.angel_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':angel_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👼🏻',
				'keywords' => ['angel', 'baby', 'face', 'fairy tale', 'fantasy', 'light skin tone', 'uc8'],
			],
			'1f47c-1f3fc' => [
				'name' => \XF::phrase('emoji.angel_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':angel_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👼🏼',
				'keywords' => ['angel', 'baby', 'face', 'fairy tale', 'fantasy', 'medium-light skin tone', 'uc8'],
			],
			'1f47c-1f3fd' => [
				'name' => \XF::phrase('emoji.angel_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':angel_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👼🏽',
				'keywords' => ['angel', 'baby', 'face', 'fairy tale', 'fantasy', 'medium skin tone', 'uc8'],
			],
			'1f47c-1f3fe' => [
				'name' => \XF::phrase('emoji.angel_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':angel_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👼🏾',
				'keywords' => ['angel', 'baby', 'face', 'fairy tale', 'fantasy', 'medium-dark skin tone', 'uc8'],
			],
			'1f47c-1f3ff' => [
				'name' => \XF::phrase('emoji.angel_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':angel_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👼🏿',
				'keywords' => ['angel', 'baby', 'dark skin tone', 'face', 'fairy tale', 'fantasy', 'uc8'],
			],
			'1fac4' => [
				'name' => \XF::phrase('emoji.pregnant_person'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pregnant_person:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1fac4-1f3fb', '1fac4-1f3fc', '1fac4-1f3fd', '1fac4-1f3fe', '1fac4-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫄',
				'keywords' => ['uc14'],
			],
			'1fac4-1f3fb' => [
				'name' => \XF::phrase('emoji.pregnant_person_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pregnant_person_tone1:',
				'shortname_alternates' => [':pregnant_person_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫄🏻',
				'keywords' => ['uc14'],
			],
			'1fac4-1f3fc' => [
				'name' => \XF::phrase('emoji.pregnant_person_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pregnant_person_tone2:',
				'shortname_alternates' => [':pregnant_person_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫄🏼',
				'keywords' => ['uc14'],
			],
			'1fac4-1f3fd' => [
				'name' => \XF::phrase('emoji.pregnant_person_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pregnant_person_tone3:',
				'shortname_alternates' => [':pregnant_person_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫄🏽',
				'keywords' => ['uc14'],
			],
			'1fac4-1f3fe' => [
				'name' => \XF::phrase('emoji.pregnant_person_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pregnant_person_tone4:',
				'shortname_alternates' => [':pregnant_person_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫄🏾',
				'keywords' => ['uc14'],
			],
			'1fac4-1f3ff' => [
				'name' => \XF::phrase('emoji.pregnant_person_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pregnant_person_tone5:',
				'shortname_alternates' => [':pregnant_person_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫄🏿',
				'keywords' => ['uc14'],
			],
			'1f930' => [
				'name' => \XF::phrase('emoji.pregnant_woman'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pregnant_woman:',
				'shortname_alternates' => [':expecting_woman:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f930-1f3fb', '1f930-1f3fc', '1f930-1f3fd', '1f930-1f3fe', '1f930-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤰',
				'keywords' => ['pregnant', 'woman', 'uc9'],
			],
			'1f930-1f3fb' => [
				'name' => \XF::phrase('emoji.pregnant_woman_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pregnant_woman_tone1:',
				'shortname_alternates' => [':expecting_woman_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤰🏻',
				'keywords' => ['light skin tone', 'pregnant', 'woman', 'uc9'],
			],
			'1f930-1f3fc' => [
				'name' => \XF::phrase('emoji.pregnant_woman_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pregnant_woman_tone2:',
				'shortname_alternates' => [':expecting_woman_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤰🏼',
				'keywords' => ['medium-light skin tone', 'pregnant', 'woman', 'uc9'],
			],
			'1f930-1f3fd' => [
				'name' => \XF::phrase('emoji.pregnant_woman_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pregnant_woman_tone3:',
				'shortname_alternates' => [':expecting_woman_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤰🏽',
				'keywords' => ['medium skin tone', 'pregnant', 'woman', 'uc9'],
			],
			'1f930-1f3fe' => [
				'name' => \XF::phrase('emoji.pregnant_woman_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pregnant_woman_tone4:',
				'shortname_alternates' => [':expecting_woman_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤰🏾',
				'keywords' => ['medium-dark skin tone', 'pregnant', 'woman', 'uc9'],
			],
			'1f930-1f3ff' => [
				'name' => \XF::phrase('emoji.pregnant_woman_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pregnant_woman_tone5:',
				'shortname_alternates' => [':expecting_woman_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤰🏿',
				'keywords' => ['dark skin tone', 'pregnant', 'woman', 'uc9'],
			],
			'1fac3' => [
				'name' => \XF::phrase('emoji.pregnant_man'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pregnant_man:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1fac3-1f3fb', '1fac3-1f3fc', '1fac3-1f3fd', '1fac3-1f3fe', '1fac3-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫃',
				'keywords' => ['uc14'],
			],
			'1fac3-1f3fb' => [
				'name' => \XF::phrase('emoji.pregnant_man_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pregnant_man_tone1:',
				'shortname_alternates' => [':pregnant_man_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫃🏻',
				'keywords' => ['uc14'],
			],
			'1fac3-1f3fc' => [
				'name' => \XF::phrase('emoji.pregnant_man_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pregnant_man_tone2:',
				'shortname_alternates' => [':pregnant_man_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫃🏼',
				'keywords' => ['uc14'],
			],
			'1fac3-1f3fd' => [
				'name' => \XF::phrase('emoji.pregnant_man_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pregnant_man_tone3:',
				'shortname_alternates' => [':pregnant_man_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫃🏽',
				'keywords' => ['uc14'],
			],
			'1fac3-1f3fe' => [
				'name' => \XF::phrase('emoji.pregnant_man_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pregnant_man_tone4:',
				'shortname_alternates' => [':pregnant_man_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫃🏾',
				'keywords' => ['uc14'],
			],
			'1fac3-1f3ff' => [
				'name' => \XF::phrase('emoji.pregnant_man_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':pregnant_man_tone5:',
				'shortname_alternates' => [':pregnant_man_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🫃🏿',
				'keywords' => ['uc14'],
			],
			'1f931' => [
				'name' => \XF::phrase('emoji.breast_feeding'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':breast_feeding:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f931-1f3fb', '1f931-1f3fc', '1f931-1f3fd', '1f931-1f3fe', '1f931-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤱',
				'keywords' => ['baby', 'breast', 'nursing', 'uc10'],
			],
			'1f931-1f3fb' => [
				'name' => \XF::phrase('emoji.breast_feeding_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':breast_feeding_tone1:',
				'shortname_alternates' => [':breast_feeding_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤱🏻',
				'keywords' => ['baby', 'breast', 'light skin tone', 'nursing', 'uc10'],
			],
			'1f931-1f3fc' => [
				'name' => \XF::phrase('emoji.breast_feeding_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':breast_feeding_tone2:',
				'shortname_alternates' => [':breast_feeding_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤱🏼',
				'keywords' => ['baby', 'breast', 'medium-light skin tone', 'nursing', 'uc10'],
			],
			'1f931-1f3fd' => [
				'name' => \XF::phrase('emoji.breast_feeding_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':breast_feeding_tone3:',
				'shortname_alternates' => [':breast_feeding_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤱🏽',
				'keywords' => ['baby', 'breast', 'medium skin tone', 'nursing', 'uc10'],
			],
			'1f931-1f3fe' => [
				'name' => \XF::phrase('emoji.breast_feeding_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':breast_feeding_tone4:',
				'shortname_alternates' => [':breast_feeding_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤱🏾',
				'keywords' => ['baby', 'breast', 'medium-dark skin tone', 'nursing', 'uc10'],
			],
			'1f931-1f3ff' => [
				'name' => \XF::phrase('emoji.breast_feeding_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':breast_feeding_tone5:',
				'shortname_alternates' => [':breast_feeding_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤱🏿',
				'keywords' => ['baby', 'breast', 'dark skin tone', 'nursing', 'uc10'],
			],
			'1f9d1-1f37c' => [
				'name' => \XF::phrase('emoji.person_feeding_baby'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_feeding_baby:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f37c', '1f9d1-1f3fc-1f37c', '1f9d1-1f3fd-1f37c', '1f9d1-1f3fe-1f37c', '1f9d1-1f3ff-1f37c'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑‍🍼',
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3fb-1f37c' => [
				'name' => \XF::phrase('emoji.person_feeding_baby_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_feeding_baby_tone1:',
				'shortname_alternates' => [':person_feeding_baby_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍🍼',
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3fc-1f37c' => [
				'name' => \XF::phrase('emoji.person_feeding_baby_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_feeding_baby_tone2:',
				'shortname_alternates' => [':person_feeding_baby_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍🍼',
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3fd-1f37c' => [
				'name' => \XF::phrase('emoji.person_feeding_baby_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_feeding_baby_tone3:',
				'shortname_alternates' => [':person_feeding_baby_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍🍼',
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3fe-1f37c' => [
				'name' => \XF::phrase('emoji.person_feeding_baby_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_feeding_baby_tone4:',
				'shortname_alternates' => [':person_feeding_baby_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍🍼',
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3ff-1f37c' => [
				'name' => \XF::phrase('emoji.person_feeding_baby_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_feeding_baby_tone5:',
				'shortname_alternates' => [':person_feeding_baby_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍🍼',
				'keywords' => ['uc13'],
			],
			'1f469-1f37c' => [
				'name' => \XF::phrase('emoji.woman_feeding_baby'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_feeding_baby:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3fb-1f37c', '1f469-1f3fc-1f37c', '1f469-1f3fd-1f37c', '1f469-1f3fe-1f37c', '1f469-1f3ff-1f37c'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩‍🍼',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fb-1f37c' => [
				'name' => \XF::phrase('emoji.woman_feeding_baby_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_feeding_baby_tone1:',
				'shortname_alternates' => [':woman_feeding_baby_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻‍🍼',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fc-1f37c' => [
				'name' => \XF::phrase('emoji.woman_feeding_baby_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_feeding_baby_tone2:',
				'shortname_alternates' => [':woman_feeding_baby_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼‍🍼',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fd-1f37c' => [
				'name' => \XF::phrase('emoji.woman_feeding_baby_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_feeding_baby_tone3:',
				'shortname_alternates' => [':woman_feeding_baby_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏽‍🍼',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fe-1f37c' => [
				'name' => \XF::phrase('emoji.woman_feeding_baby_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_feeding_baby_tone4:',
				'shortname_alternates' => [':woman_feeding_baby_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏾‍🍼',
				'keywords' => ['uc13'],
			],
			'1f469-1f3ff-1f37c' => [
				'name' => \XF::phrase('emoji.woman_feeding_baby_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_feeding_baby_tone5:',
				'shortname_alternates' => [':woman_feeding_baby_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏿‍🍼',
				'keywords' => ['uc13'],
			],
			'1f468-1f37c' => [
				'name' => \XF::phrase('emoji.man_feeding_baby'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_feeding_baby:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3fb-1f37c', '1f468-1f3fc-1f37c', '1f468-1f3fd-1f37c', '1f468-1f3fe-1f37c', '1f468-1f3ff-1f37c'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨‍🍼',
				'keywords' => ['uc13'],
			],
			'1f468-1f3fb-1f37c' => [
				'name' => \XF::phrase('emoji.man_feeding_baby_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_feeding_baby_tone1:',
				'shortname_alternates' => [':man_feeding_baby_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏻‍🍼',
				'keywords' => ['uc13'],
			],
			'1f468-1f3fc-1f37c' => [
				'name' => \XF::phrase('emoji.man_feeding_baby_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_feeding_baby_tone2:',
				'shortname_alternates' => [':man_feeding_baby_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏼‍🍼',
				'keywords' => ['uc13'],
			],
			'1f468-1f3fd-1f37c' => [
				'name' => \XF::phrase('emoji.man_feeding_baby_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_feeding_baby_tone3:',
				'shortname_alternates' => [':man_feeding_baby_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏽‍🍼',
				'keywords' => ['uc13'],
			],
			'1f468-1f3fe-1f37c' => [
				'name' => \XF::phrase('emoji.man_feeding_baby_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_feeding_baby_tone4:',
				'shortname_alternates' => [':man_feeding_baby_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏾‍🍼',
				'keywords' => ['uc13'],
			],
			'1f468-1f3ff-1f37c' => [
				'name' => \XF::phrase('emoji.man_feeding_baby_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_feeding_baby_tone5:',
				'shortname_alternates' => [':man_feeding_baby_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏿‍🍼',
				'keywords' => ['uc13'],
			],
			'1f647' => [
				'name' => \XF::phrase('emoji.person_bowing'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_bowing:',
				'shortname_alternates' => [':bow:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f647-1f3fb', '1f647-1f3fc', '1f647-1f3fd', '1f647-1f3fe', '1f647-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f647-2642', '1f647-2640'],
				'unicode' => '🙇',
				'keywords' => ['apology', 'bow', 'gesture', 'sorry', 'uc6'],
			],
			'1f647-1f3fb' => [
				'name' => \XF::phrase('emoji.person_bowing_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_bowing_tone1:',
				'shortname_alternates' => [':bow_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f647-1f3fb-2642', '1f647-1f3fb-2640'],
				'unicode' => '🙇🏻',
				'keywords' => ['apology', 'bow', 'gesture', 'light skin tone', 'sorry', 'uc8'],
			],
			'1f647-1f3fc' => [
				'name' => \XF::phrase('emoji.person_bowing_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_bowing_tone2:',
				'shortname_alternates' => [':bow_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f647-1f3fc-2642', '1f647-1f3fc-2640'],
				'unicode' => '🙇🏼',
				'keywords' => ['apology', 'bow', 'gesture', 'medium-light skin tone', 'sorry', 'uc8'],
			],
			'1f647-1f3fd' => [
				'name' => \XF::phrase('emoji.person_bowing_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_bowing_tone3:',
				'shortname_alternates' => [':bow_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f647-1f3fd-2642', '1f647-1f3fd-2640'],
				'unicode' => '🙇🏽',
				'keywords' => ['apology', 'bow', 'gesture', 'medium skin tone', 'sorry', 'uc8'],
			],
			'1f647-1f3fe' => [
				'name' => \XF::phrase('emoji.person_bowing_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_bowing_tone4:',
				'shortname_alternates' => [':bow_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f647-1f3fe-2642', '1f647-1f3fe-2640'],
				'unicode' => '🙇🏾',
				'keywords' => ['apology', 'bow', 'gesture', 'medium-dark skin tone', 'sorry', 'uc8'],
			],
			'1f647-1f3ff' => [
				'name' => \XF::phrase('emoji.person_bowing_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_bowing_tone5:',
				'shortname_alternates' => [':bow_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f647-1f3ff-2642', '1f647-1f3ff-2640'],
				'unicode' => '🙇🏿',
				'keywords' => ['apology', 'bow', 'dark skin tone', 'gesture', 'sorry', 'uc8'],
			],
			'1f647-2640' => [
				'name' => \XF::phrase('emoji.woman_bowing'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bowing:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f647-1f3ff-2640', '1f647-1f3fe-2640', '1f647-1f3fd-2640', '1f647-1f3fc-2640', '1f647-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙇‍♀️',
				'keywords' => ['apology', 'bowing', 'favor', 'gesture', 'sorry', 'woman', 'uc6'],
			],
			'1f647-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_bowing_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bowing_tone1:',
				'shortname_alternates' => [':woman_bowing_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙇🏻‍♀️',
				'keywords' => ['apology', 'bowing', 'favor', 'gesture', 'light skin tone', 'sorry', 'woman', 'uc8'],
			],
			'1f647-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_bowing_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bowing_tone2:',
				'shortname_alternates' => [':woman_bowing_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙇🏼‍♀️',
				'keywords' => ['apology', 'bowing', 'favor', 'gesture', 'medium-light skin tone', 'sorry', 'woman', 'uc8'],
			],
			'1f647-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_bowing_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bowing_tone3:',
				'shortname_alternates' => [':woman_bowing_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙇🏽‍♀️',
				'keywords' => ['apology', 'bowing', 'favor', 'gesture', 'medium skin tone', 'sorry', 'woman', 'uc8'],
			],
			'1f647-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_bowing_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bowing_tone4:',
				'shortname_alternates' => [':woman_bowing_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙇🏾‍♀️',
				'keywords' => ['apology', 'bowing', 'favor', 'gesture', 'medium-dark skin tone', 'sorry', 'woman', 'uc8'],
			],
			'1f647-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_bowing_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_bowing_tone5:',
				'shortname_alternates' => [':woman_bowing_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙇🏿‍♀️',
				'keywords' => ['apology', 'bowing', 'dark skin tone', 'favor', 'gesture', 'sorry', 'woman', 'uc8'],
			],
			'1f647-2642' => [
				'name' => \XF::phrase('emoji.man_bowing'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bowing:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f647-1f3ff-2642', '1f647-1f3fe-2642', '1f647-1f3fd-2642', '1f647-1f3fc-2642', '1f647-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙇‍♂️',
				'keywords' => ['apology', 'bowing', 'favor', 'gesture', 'man', 'sorry', 'uc6'],
			],
			'1f647-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_bowing_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bowing_tone1:',
				'shortname_alternates' => [':man_bowing_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙇🏻‍♂️',
				'keywords' => ['apology', 'bowing', 'favor', 'gesture', 'light skin tone', 'man', 'sorry', 'uc8'],
			],
			'1f647-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_bowing_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bowing_tone2:',
				'shortname_alternates' => [':man_bowing_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙇🏼‍♂️',
				'keywords' => ['apology', 'bowing', 'favor', 'gesture', 'man', 'medium-light skin tone', 'sorry', 'uc8'],
			],
			'1f647-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_bowing_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bowing_tone3:',
				'shortname_alternates' => [':man_bowing_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙇🏽‍♂️',
				'keywords' => ['apology', 'bowing', 'favor', 'gesture', 'man', 'medium skin tone', 'sorry', 'uc8'],
			],
			'1f647-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_bowing_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bowing_tone4:',
				'shortname_alternates' => [':man_bowing_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙇🏾‍♂️',
				'keywords' => ['apology', 'bowing', 'favor', 'gesture', 'man', 'medium-dark skin tone', 'sorry', 'uc8'],
			],
			'1f647-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_bowing_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_bowing_tone5:',
				'shortname_alternates' => [':man_bowing_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙇🏿‍♂️',
				'keywords' => ['apology', 'bowing', 'dark skin tone', 'favor', 'gesture', 'man', 'sorry', 'uc8'],
			],
			'1f481' => [
				'name' => \XF::phrase('emoji.person_tipping_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tipping_hand:',
				'shortname_alternates' => [':information_desk_person:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f481-1f3fb', '1f481-1f3fc', '1f481-1f3fd', '1f481-1f3fe', '1f481-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f481-2642', '1f481-2640'],
				'unicode' => '💁',
				'keywords' => ['hand', 'help', 'information', 'sassy', 'tipping', 'uc6'],
			],
			'1f481-1f3fb' => [
				'name' => \XF::phrase('emoji.person_tipping_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tipping_hand_tone1:',
				'shortname_alternates' => [':information_desk_person_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f481-1f3fb-2642', '1f481-1f3fb-2640'],
				'unicode' => '💁🏻',
				'keywords' => ['hand', 'help', 'information', 'light skin tone', 'sassy', 'tipping', 'uc8'],
			],
			'1f481-1f3fc' => [
				'name' => \XF::phrase('emoji.person_tipping_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tipping_hand_tone2:',
				'shortname_alternates' => [':information_desk_person_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f481-1f3fc-2642', '1f481-1f3fc-2640'],
				'unicode' => '💁🏼',
				'keywords' => ['hand', 'help', 'information', 'medium-light skin tone', 'sassy', 'tipping', 'uc8'],
			],
			'1f481-1f3fd' => [
				'name' => \XF::phrase('emoji.person_tipping_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tipping_hand_tone3:',
				'shortname_alternates' => [':information_desk_person_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f481-1f3fd-2642', '1f481-1f3fd-2640'],
				'unicode' => '💁🏽',
				'keywords' => ['hand', 'help', 'information', 'medium skin tone', 'sassy', 'tipping', 'uc8'],
			],
			'1f481-1f3fe' => [
				'name' => \XF::phrase('emoji.person_tipping_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tipping_hand_tone4:',
				'shortname_alternates' => [':information_desk_person_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f481-1f3fe-2642', '1f481-1f3fe-2640'],
				'unicode' => '💁🏾',
				'keywords' => ['hand', 'help', 'information', 'medium-dark skin tone', 'sassy', 'tipping', 'uc8'],
			],
			'1f481-1f3ff' => [
				'name' => \XF::phrase('emoji.person_tipping_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_tipping_hand_tone5:',
				'shortname_alternates' => [':information_desk_person_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f481-1f3ff-2642', '1f481-1f3ff-2640'],
				'unicode' => '💁🏿',
				'keywords' => ['dark skin tone', 'hand', 'help', 'information', 'sassy', 'tipping', 'uc8'],
			],
			'1f481-2640' => [
				'name' => \XF::phrase('emoji.woman_tipping_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tipping_hand:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f481-1f3ff-2640', '1f481-1f3fe-2640', '1f481-1f3fd-2640', '1f481-1f3fc-2640', '1f481-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '💁‍♀️',
				'keywords' => ['sassy', 'tipping hand', 'woman', 'uc6'],
			],
			'1f481-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_tipping_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tipping_hand_tone1:',
				'shortname_alternates' => [':woman_tipping_hand_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '💁🏻‍♀️',
				'keywords' => ['light skin tone', 'sassy', 'tipping hand', 'woman', 'uc8'],
			],
			'1f481-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_tipping_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tipping_hand_tone2:',
				'shortname_alternates' => [':woman_tipping_hand_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '💁🏼‍♀️',
				'keywords' => ['medium-light skin tone', 'sassy', 'tipping hand', 'woman', 'uc8'],
			],
			'1f481-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_tipping_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tipping_hand_tone3:',
				'shortname_alternates' => [':woman_tipping_hand_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '💁🏽‍♀️',
				'keywords' => ['medium skin tone', 'sassy', 'tipping hand', 'woman', 'uc8'],
			],
			'1f481-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_tipping_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tipping_hand_tone4:',
				'shortname_alternates' => [':woman_tipping_hand_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '💁🏾‍♀️',
				'keywords' => ['medium-dark skin tone', 'sassy', 'tipping hand', 'woman', 'uc8'],
			],
			'1f481-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_tipping_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_tipping_hand_tone5:',
				'shortname_alternates' => [':woman_tipping_hand_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '💁🏿‍♀️',
				'keywords' => ['dark skin tone', 'sassy', 'tipping hand', 'woman', 'uc8'],
			],
			'1f481-2642' => [
				'name' => \XF::phrase('emoji.man_tipping_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tipping_hand:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f481-1f3ff-2642', '1f481-1f3fe-2642', '1f481-1f3fd-2642', '1f481-1f3fc-2642', '1f481-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '💁‍♂️',
				'keywords' => ['man', 'sassy', 'tipping hand', 'uc6'],
			],
			'1f481-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_tipping_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tipping_hand_tone1:',
				'shortname_alternates' => [':man_tipping_hand_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '💁🏻‍♂️',
				'keywords' => ['light skin tone', 'man', 'sassy', 'tipping hand', 'uc8'],
			],
			'1f481-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_tipping_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tipping_hand_tone2:',
				'shortname_alternates' => [':man_tipping_hand_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '💁🏼‍♂️',
				'keywords' => ['man', 'medium-light skin tone', 'sassy', 'tipping hand', 'uc8'],
			],
			'1f481-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_tipping_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tipping_hand_tone3:',
				'shortname_alternates' => [':man_tipping_hand_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '💁🏽‍♂️',
				'keywords' => ['man', 'medium skin tone', 'sassy', 'tipping hand', 'uc8'],
			],
			'1f481-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_tipping_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tipping_hand_tone4:',
				'shortname_alternates' => [':man_tipping_hand_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '💁🏾‍♂️',
				'keywords' => ['man', 'medium-dark skin tone', 'sassy', 'tipping hand', 'uc8'],
			],
			'1f481-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_tipping_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_tipping_hand_tone5:',
				'shortname_alternates' => [':man_tipping_hand_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '💁🏿‍♂️',
				'keywords' => ['dark skin tone', 'man', 'sassy', 'tipping hand', 'uc8'],
			],
			'1f645' => [
				'name' => \XF::phrase('emoji.person_gesturing_no'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_no:',
				'shortname_alternates' => [':no_good:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f645-1f3fb', '1f645-1f3fc', '1f645-1f3fd', '1f645-1f3fe', '1f645-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f645-2642', '1f645-2640'],
				'unicode' => '🙅',
				'keywords' => ['forbidden', 'gesture', 'hand', 'no', 'not', 'prohibited', 'uc6'],
			],
			'1f645-1f3fb' => [
				'name' => \XF::phrase('emoji.person_gesturing_no_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_no_tone1:',
				'shortname_alternates' => [':no_good_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f645-1f3fb-2642', '1f645-1f3fb-2640'],
				'unicode' => '🙅🏻',
				'keywords' => ['forbidden', 'gesture', 'hand', 'light skin tone', 'no', 'not', 'prohibited', 'uc8'],
			],
			'1f645-1f3fc' => [
				'name' => \XF::phrase('emoji.person_gesturing_no_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_no_tone2:',
				'shortname_alternates' => [':no_good_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f645-1f3fc-2642', '1f645-1f3fc-2640'],
				'unicode' => '🙅🏼',
				'keywords' => ['forbidden', 'gesture', 'hand', 'medium-light skin tone', 'no', 'not', 'prohibited', 'uc8'],
			],
			'1f645-1f3fd' => [
				'name' => \XF::phrase('emoji.person_gesturing_no_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_no_tone3:',
				'shortname_alternates' => [':no_good_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f645-1f3fd-2642', '1f645-1f3fd-2640'],
				'unicode' => '🙅🏽',
				'keywords' => ['forbidden', 'gesture', 'hand', 'medium skin tone', 'no', 'not', 'prohibited', 'uc8'],
			],
			'1f645-1f3fe' => [
				'name' => \XF::phrase('emoji.person_gesturing_no_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_no_tone4:',
				'shortname_alternates' => [':no_good_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f645-1f3fe-2642', '1f645-1f3fe-2640'],
				'unicode' => '🙅🏾',
				'keywords' => ['forbidden', 'gesture', 'hand', 'medium-dark skin tone', 'no', 'not', 'prohibited', 'uc8'],
			],
			'1f645-1f3ff' => [
				'name' => \XF::phrase('emoji.person_gesturing_no_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_no_tone5:',
				'shortname_alternates' => [':no_good_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f645-1f3ff-2642', '1f645-1f3ff-2640'],
				'unicode' => '🙅🏿',
				'keywords' => ['dark skin tone', 'forbidden', 'gesture', 'hand', 'no', 'not', 'prohibited', 'uc8'],
			],
			'1f645-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_no'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_no:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f645-1f3ff-2640', '1f645-1f3fe-2640', '1f645-1f3fd-2640', '1f645-1f3fc-2640', '1f645-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙅‍♀️',
				'keywords' => ['forbidden', 'gesture', 'hand', 'no', 'prohibited', 'woman', 'uc6'],
			],
			'1f645-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_no_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_no_tone1:',
				'shortname_alternates' => [':woman_gesturing_no_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙅🏻‍♀️',
				'keywords' => ['forbidden', 'gesture', 'hand', 'light skin tone', 'no', 'prohibited', 'woman', 'uc8'],
			],
			'1f645-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_no_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_no_tone2:',
				'shortname_alternates' => [':woman_gesturing_no_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙅🏼‍♀️',
				'keywords' => ['forbidden', 'gesture', 'hand', 'medium-light skin tone', 'no', 'prohibited', 'woman', 'uc8'],
			],
			'1f645-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_no_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_no_tone3:',
				'shortname_alternates' => [':woman_gesturing_no_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙅🏽‍♀️',
				'keywords' => ['forbidden', 'gesture', 'hand', 'medium skin tone', 'no', 'prohibited', 'woman', 'uc8'],
			],
			'1f645-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_no_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_no_tone4:',
				'shortname_alternates' => [':woman_gesturing_no_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙅🏾‍♀️',
				'keywords' => ['forbidden', 'gesture', 'hand', 'medium-dark skin tone', 'no', 'prohibited', 'woman', 'uc8'],
			],
			'1f645-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_no_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_no_tone5:',
				'shortname_alternates' => [':woman_gesturing_no_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙅🏿‍♀️',
				'keywords' => ['dark skin tone', 'forbidden', 'gesture', 'hand', 'no', 'prohibited', 'woman', 'uc8'],
			],
			'1f645-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_no'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_no:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f645-1f3ff-2642', '1f645-1f3fe-2642', '1f645-1f3fd-2642', '1f645-1f3fc-2642', '1f645-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙅‍♂️',
				'keywords' => ['forbidden', 'gesture', 'hand', 'man', 'no', 'prohibited', 'uc6'],
			],
			'1f645-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_no_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_no_tone1:',
				'shortname_alternates' => [':man_gesturing_no_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙅🏻‍♂️',
				'keywords' => ['forbidden', 'gesture', 'hand', 'light skin tone', 'man', 'no', 'prohibited', 'uc8'],
			],
			'1f645-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_no_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_no_tone2:',
				'shortname_alternates' => [':man_gesturing_no_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙅🏼‍♂️',
				'keywords' => ['forbidden', 'gesture', 'hand', 'man', 'medium-light skin tone', 'no', 'prohibited', 'uc8'],
			],
			'1f645-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_no_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_no_tone3:',
				'shortname_alternates' => [':man_gesturing_no_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙅🏽‍♂️',
				'keywords' => ['forbidden', 'gesture', 'hand', 'man', 'medium skin tone', 'no', 'prohibited', 'uc8'],
			],
			'1f645-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_no_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_no_tone4:',
				'shortname_alternates' => [':man_gesturing_no_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙅🏾‍♂️',
				'keywords' => ['forbidden', 'gesture', 'hand', 'man', 'medium-dark skin tone', 'no', 'prohibited', 'uc8'],
			],
			'1f645-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_no_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_no_tone5:',
				'shortname_alternates' => [':man_gesturing_no_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙅🏿‍♂️',
				'keywords' => ['dark skin tone', 'forbidden', 'gesture', 'hand', 'man', 'no', 'prohibited', 'uc8'],
			],
			'1f646' => [
				'name' => \XF::phrase('emoji.person_gesturing_ok'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_ok:',
				'shortname_alternates' => [':ok_woman:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f646-1f3fb', '1f646-1f3fc', '1f646-1f3fd', '1f646-1f3fe', '1f646-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f646-2642', '1f646-2640'],
				'unicode' => '🙆',
				'keywords' => ['OK', 'gesture', 'hand', 'uc6'],
			],
			'1f646-1f3fb' => [
				'name' => \XF::phrase('emoji.person_gesturing_ok_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_ok_tone1:',
				'shortname_alternates' => [':ok_woman_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f646-1f3fb-2642', '1f646-1f3fb-2640'],
				'unicode' => '🙆🏻',
				'keywords' => ['OK', 'gesture', 'hand', 'light skin tone', 'uc8'],
			],
			'1f646-1f3fc' => [
				'name' => \XF::phrase('emoji.person_gesturing_ok_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_ok_tone2:',
				'shortname_alternates' => [':ok_woman_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f646-1f3fc-2642', '1f646-1f3fc-2640'],
				'unicode' => '🙆🏼',
				'keywords' => ['OK', 'gesture', 'hand', 'medium-light skin tone', 'uc8'],
			],
			'1f646-1f3fd' => [
				'name' => \XF::phrase('emoji.person_gesturing_ok_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_ok_tone3:',
				'shortname_alternates' => [':ok_woman_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f646-1f3fd-2642', '1f646-1f3fd-2640'],
				'unicode' => '🙆🏽',
				'keywords' => ['OK', 'gesture', 'hand', 'medium skin tone', 'uc8'],
			],
			'1f646-1f3fe' => [
				'name' => \XF::phrase('emoji.person_gesturing_ok_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_ok_tone4:',
				'shortname_alternates' => [':ok_woman_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f646-1f3fe-2642', '1f646-1f3fe-2640'],
				'unicode' => '🙆🏾',
				'keywords' => ['OK', 'gesture', 'hand', 'medium-dark skin tone', 'uc8'],
			],
			'1f646-1f3ff' => [
				'name' => \XF::phrase('emoji.person_gesturing_ok_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_gesturing_ok_tone5:',
				'shortname_alternates' => [':ok_woman_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f646-1f3ff-2642', '1f646-1f3ff-2640'],
				'unicode' => '🙆🏿',
				'keywords' => ['OK', 'dark skin tone', 'gesture', 'hand', 'uc8'],
			],
			'1f646-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_ok'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_ok:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f646-1f3ff-2640', '1f646-1f3fe-2640', '1f646-1f3fd-2640', '1f646-1f3fc-2640', '1f646-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙆‍♀️',
				'keywords' => ['OK', 'gesture', 'hand', 'woman', 'uc6'],
			],
			'1f646-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_ok_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_ok_tone1:',
				'shortname_alternates' => [':woman_gesturing_ok_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙆🏻‍♀️',
				'keywords' => ['OK', 'gesture', 'hand', 'light skin tone', 'woman', 'uc8'],
			],
			'1f646-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_ok_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_ok_tone2:',
				'shortname_alternates' => [':woman_gesturing_ok_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙆🏼‍♀️',
				'keywords' => ['OK', 'gesture', 'hand', 'medium-light skin tone', 'woman', 'uc8'],
			],
			'1f646-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_ok_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_ok_tone3:',
				'shortname_alternates' => [':woman_gesturing_ok_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙆🏽‍♀️',
				'keywords' => ['OK', 'gesture', 'hand', 'medium skin tone', 'woman', 'uc8'],
			],
			'1f646-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_ok_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_ok_tone4:',
				'shortname_alternates' => [':woman_gesturing_ok_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙆🏾‍♀️',
				'keywords' => ['OK', 'gesture', 'hand', 'medium-dark skin tone', 'woman', 'uc8'],
			],
			'1f646-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_gesturing_ok_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_gesturing_ok_tone5:',
				'shortname_alternates' => [':woman_gesturing_ok_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙆🏿‍♀️',
				'keywords' => ['OK', 'dark skin tone', 'gesture', 'hand', 'woman', 'uc8'],
			],
			'1f646-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_ok'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_ok:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f646-1f3ff-2642', '1f646-1f3fe-2642', '1f646-1f3fd-2642', '1f646-1f3fc-2642', '1f646-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙆‍♂️',
				'keywords' => ['OK', 'gesture', 'hand', 'man', 'uc6'],
			],
			'1f646-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_ok_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_ok_tone1:',
				'shortname_alternates' => [':man_gesturing_ok_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙆🏻‍♂️',
				'keywords' => ['OK', 'gesture', 'hand', 'light skin tone', 'man', 'uc8'],
			],
			'1f646-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_ok_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_ok_tone2:',
				'shortname_alternates' => [':man_gesturing_ok_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙆🏼‍♂️',
				'keywords' => ['OK', 'gesture', 'hand', 'man', 'medium-light skin tone', 'uc8'],
			],
			'1f646-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_ok_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_ok_tone3:',
				'shortname_alternates' => [':man_gesturing_ok_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙆🏽‍♂️',
				'keywords' => ['OK', 'gesture', 'hand', 'man', 'medium skin tone', 'uc8'],
			],
			'1f646-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_ok_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_ok_tone4:',
				'shortname_alternates' => [':man_gesturing_ok_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙆🏾‍♂️',
				'keywords' => ['OK', 'gesture', 'hand', 'man', 'medium-dark skin tone', 'uc8'],
			],
			'1f646-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_gesturing_ok_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_gesturing_ok_tone5:',
				'shortname_alternates' => [':man_gesturing_ok_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙆🏿‍♂️',
				'keywords' => ['OK', 'dark skin tone', 'gesture', 'hand', 'man', 'uc8'],
			],
			'1f64b' => [
				'name' => \XF::phrase('emoji.person_raising_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_raising_hand:',
				'shortname_alternates' => [':raising_hand:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f64b-1f3fb', '1f64b-1f3fc', '1f64b-1f3fd', '1f64b-1f3fe', '1f64b-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f64b-2642', '1f64b-2640'],
				'unicode' => '🙋',
				'keywords' => ['gesture', 'hand', 'happy', 'raised', 'uc6'],
			],
			'1f64b-1f3fb' => [
				'name' => \XF::phrase('emoji.person_raising_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_raising_hand_tone1:',
				'shortname_alternates' => [':raising_hand_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f64b-1f3fb-2642', '1f64b-1f3fb-2640'],
				'unicode' => '🙋🏻',
				'keywords' => ['gesture', 'hand', 'happy', 'light skin tone', 'raised', 'uc8'],
			],
			'1f64b-1f3fc' => [
				'name' => \XF::phrase('emoji.person_raising_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_raising_hand_tone2:',
				'shortname_alternates' => [':raising_hand_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f64b-1f3fc-2642', '1f64b-1f3fc-2640'],
				'unicode' => '🙋🏼',
				'keywords' => ['gesture', 'hand', 'happy', 'medium-light skin tone', 'raised', 'uc8'],
			],
			'1f64b-1f3fd' => [
				'name' => \XF::phrase('emoji.person_raising_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_raising_hand_tone3:',
				'shortname_alternates' => [':raising_hand_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f64b-1f3fd-2642', '1f64b-1f3fd-2640'],
				'unicode' => '🙋🏽',
				'keywords' => ['gesture', 'hand', 'happy', 'medium skin tone', 'raised', 'uc8'],
			],
			'1f64b-1f3fe' => [
				'name' => \XF::phrase('emoji.person_raising_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_raising_hand_tone4:',
				'shortname_alternates' => [':raising_hand_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f64b-1f3fe-2642', '1f64b-1f3fe-2640'],
				'unicode' => '🙋🏾',
				'keywords' => ['gesture', 'hand', 'happy', 'medium-dark skin tone', 'raised', 'uc8'],
			],
			'1f64b-1f3ff' => [
				'name' => \XF::phrase('emoji.person_raising_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_raising_hand_tone5:',
				'shortname_alternates' => [':raising_hand_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f64b-1f3ff-2642', '1f64b-1f3ff-2640'],
				'unicode' => '🙋🏿',
				'keywords' => ['dark skin tone', 'gesture', 'hand', 'happy', 'raised', 'uc8'],
			],
			'1f64b-2640' => [
				'name' => \XF::phrase('emoji.woman_raising_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_raising_hand:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f64b-1f3ff-2640', '1f64b-1f3fe-2640', '1f64b-1f3fd-2640', '1f64b-1f3fc-2640', '1f64b-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙋‍♀️',
				'keywords' => ['gesture', 'raising hand', 'woman', 'uc6'],
			],
			'1f64b-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_raising_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_raising_hand_tone1:',
				'shortname_alternates' => [':woman_raising_hand_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙋🏻‍♀️',
				'keywords' => ['gesture', 'light skin tone', 'raising hand', 'woman', 'uc8'],
			],
			'1f64b-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_raising_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_raising_hand_tone2:',
				'shortname_alternates' => [':woman_raising_hand_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙋🏼‍♀️',
				'keywords' => ['gesture', 'medium-light skin tone', 'raising hand', 'woman', 'uc8'],
			],
			'1f64b-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_raising_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_raising_hand_tone3:',
				'shortname_alternates' => [':woman_raising_hand_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙋🏽‍♀️',
				'keywords' => ['gesture', 'medium skin tone', 'raising hand', 'woman', 'uc8'],
			],
			'1f64b-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_raising_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_raising_hand_tone4:',
				'shortname_alternates' => [':woman_raising_hand_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙋🏾‍♀️',
				'keywords' => ['gesture', 'medium-dark skin tone', 'raising hand', 'woman', 'uc8'],
			],
			'1f64b-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_raising_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_raising_hand_tone5:',
				'shortname_alternates' => [':woman_raising_hand_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙋🏿‍♀️',
				'keywords' => ['dark skin tone', 'gesture', 'raising hand', 'woman', 'uc8'],
			],
			'1f64b-2642' => [
				'name' => \XF::phrase('emoji.man_raising_hand'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_raising_hand:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f64b-1f3ff-2642', '1f64b-1f3fe-2642', '1f64b-1f3fd-2642', '1f64b-1f3fc-2642', '1f64b-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙋‍♂️',
				'keywords' => ['gesture', 'man', 'raising hand', 'uc6'],
			],
			'1f64b-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_raising_hand_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_raising_hand_tone1:',
				'shortname_alternates' => [':man_raising_hand_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙋🏻‍♂️',
				'keywords' => ['gesture', 'light skin tone', 'man', 'raising hand', 'uc8'],
			],
			'1f64b-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_raising_hand_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_raising_hand_tone2:',
				'shortname_alternates' => [':man_raising_hand_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙋🏼‍♂️',
				'keywords' => ['gesture', 'man', 'medium-light skin tone', 'raising hand', 'uc8'],
			],
			'1f64b-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_raising_hand_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_raising_hand_tone3:',
				'shortname_alternates' => [':man_raising_hand_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙋🏽‍♂️',
				'keywords' => ['gesture', 'man', 'medium skin tone', 'raising hand', 'uc8'],
			],
			'1f64b-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_raising_hand_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_raising_hand_tone4:',
				'shortname_alternates' => [':man_raising_hand_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙋🏾‍♂️',
				'keywords' => ['gesture', 'man', 'medium-dark skin tone', 'raising hand', 'uc8'],
			],
			'1f64b-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_raising_hand_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_raising_hand_tone5:',
				'shortname_alternates' => [':man_raising_hand_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙋🏿‍♂️',
				'keywords' => ['dark skin tone', 'gesture', 'man', 'raising hand', 'uc8'],
			],
			'1f9cf' => [
				'name' => \XF::phrase('emoji.deaf_person'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_person:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9cf-1f3fb', '1f9cf-1f3fc', '1f9cf-1f3fd', '1f9cf-1f3fe', '1f9cf-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f9cf-2640', '1f9cf-2642'],
				'unicode' => '🧏',
				'keywords' => ['uc12'],
			],
			'1f9cf-1f3fb' => [
				'name' => \XF::phrase('emoji.deaf_person_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_person_tone1:',
				'shortname_alternates' => [':deaf_person_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9cf-1f3fb-2640', '1f9cf-1f3fb-2642'],
				'unicode' => '🧏🏻',
				'keywords' => ['uc12'],
			],
			'1f9cf-1f3fc' => [
				'name' => \XF::phrase('emoji.deaf_person_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_person_tone2:',
				'shortname_alternates' => [':deaf_person_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9cf-1f3fc-2640', '1f9cf-1f3fc-2642'],
				'unicode' => '🧏🏼',
				'keywords' => ['uc12'],
			],
			'1f9cf-1f3fd' => [
				'name' => \XF::phrase('emoji.deaf_person_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_person_tone3:',
				'shortname_alternates' => [':deaf_person_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9cf-1f3fd-2640', '1f9cf-1f3fd-2642'],
				'unicode' => '🧏🏽',
				'keywords' => ['uc12'],
			],
			'1f9cf-1f3fe' => [
				'name' => \XF::phrase('emoji.deaf_person_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_person_tone4:',
				'shortname_alternates' => [':deaf_person_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9cf-1f3fe-2640', '1f9cf-1f3fe-2642'],
				'unicode' => '🧏🏾',
				'keywords' => ['uc12'],
			],
			'1f9cf-1f3ff' => [
				'name' => \XF::phrase('emoji.deaf_person_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_person_tone5:',
				'shortname_alternates' => [':deaf_person_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9cf-1f3ff-2640', '1f9cf-1f3ff-2642'],
				'unicode' => '🧏🏿',
				'keywords' => ['uc12'],
			],
			'1f9cf-2640' => [
				'name' => \XF::phrase('emoji.deaf_woman'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_woman:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9cf-1f3fb-2640', '1f9cf-1f3fc-2640', '1f9cf-1f3fd-2640', '1f9cf-1f3fe-2640', '1f9cf-1f3ff-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧏‍♀️',
				'keywords' => ['uc12'],
			],
			'1f9cf-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.deaf_woman_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_woman_tone1:',
				'shortname_alternates' => [':deaf_woman_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧏🏻‍♀️',
				'keywords' => ['uc12'],
			],
			'1f9cf-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.deaf_woman_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_woman_tone2:',
				'shortname_alternates' => [':deaf_woman_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧏🏼‍♀️',
				'keywords' => ['uc12'],
			],
			'1f9cf-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.deaf_woman_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_woman_tone3:',
				'shortname_alternates' => [':deaf_woman_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧏🏽‍♀️',
				'keywords' => ['uc12'],
			],
			'1f9cf-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.deaf_woman_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_woman_tone4:',
				'shortname_alternates' => [':deaf_woman_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧏🏾‍♀️',
				'keywords' => ['uc12'],
			],
			'1f9cf-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.deaf_woman_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_woman_tone5:',
				'shortname_alternates' => [':deaf_woman_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧏🏿‍♀️',
				'keywords' => ['uc12'],
			],
			'1f9cf-2642' => [
				'name' => \XF::phrase('emoji.deaf_man'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_man:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9cf-1f3fb-2642', '1f9cf-1f3fc-2642', '1f9cf-1f3fd-2642', '1f9cf-1f3fe-2642', '1f9cf-1f3ff-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧏‍♂️',
				'keywords' => ['uc12'],
			],
			'1f9cf-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.deaf_man_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_man_tone1:',
				'shortname_alternates' => [':deaf_man_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧏🏻‍♂️',
				'keywords' => ['uc12'],
			],
			'1f9cf-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.deaf_man_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_man_tone2:',
				'shortname_alternates' => [':deaf_man_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧏🏼‍♂️',
				'keywords' => ['uc12'],
			],
			'1f9cf-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.deaf_man_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_man_tone3:',
				'shortname_alternates' => [':deaf_man_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧏🏽‍♂️',
				'keywords' => ['uc12'],
			],
			'1f9cf-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.deaf_man_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_man_tone4:',
				'shortname_alternates' => [':deaf_man_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧏🏾‍♂️',
				'keywords' => ['uc12'],
			],
			'1f9cf-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.deaf_man_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':deaf_man_tone5:',
				'shortname_alternates' => [':deaf_man_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧏🏿‍♂️',
				'keywords' => ['uc12'],
			],
			'1f926' => [
				'name' => \XF::phrase('emoji.person_facepalming'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_facepalming:',
				'shortname_alternates' => [':face_palm:', ':facepalm:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f926-1f3fb', '1f926-1f3fc', '1f926-1f3fd', '1f926-1f3fe', '1f926-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f926-2642', '1f926-2640'],
				'unicode' => '🤦',
				'keywords' => ['disbelief', 'exasperation', 'face', 'palm', 'uc9'],
			],
			'1f926-1f3fb' => [
				'name' => \XF::phrase('emoji.person_facepalming_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_facepalming_tone1:',
				'shortname_alternates' => [':face_palm_tone1:', ':facepalm_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f926-1f3fb-2642', '1f926-1f3fb-2640'],
				'unicode' => '🤦🏻',
				'keywords' => ['disbelief', 'exasperation', 'face', 'light skin tone', 'palm', 'uc9'],
			],
			'1f926-1f3fc' => [
				'name' => \XF::phrase('emoji.person_facepalming_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_facepalming_tone2:',
				'shortname_alternates' => [':face_palm_tone2:', ':facepalm_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f926-1f3fc-2642', '1f926-1f3fc-2640'],
				'unicode' => '🤦🏼',
				'keywords' => ['disbelief', 'exasperation', 'face', 'medium-light skin tone', 'palm', 'uc9'],
			],
			'1f926-1f3fd' => [
				'name' => \XF::phrase('emoji.person_facepalming_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_facepalming_tone3:',
				'shortname_alternates' => [':face_palm_tone3:', ':facepalm_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f926-1f3fd-2642', '1f926-1f3fd-2640'],
				'unicode' => '🤦🏽',
				'keywords' => ['disbelief', 'exasperation', 'face', 'medium skin tone', 'palm', 'uc9'],
			],
			'1f926-1f3fe' => [
				'name' => \XF::phrase('emoji.person_facepalming_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_facepalming_tone4:',
				'shortname_alternates' => [':face_palm_tone4:', ':facepalm_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f926-1f3fe-2642', '1f926-1f3fe-2640'],
				'unicode' => '🤦🏾',
				'keywords' => ['disbelief', 'exasperation', 'face', 'medium-dark skin tone', 'palm', 'uc9'],
			],
			'1f926-1f3ff' => [
				'name' => \XF::phrase('emoji.person_facepalming_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_facepalming_tone5:',
				'shortname_alternates' => [':face_palm_tone5:', ':facepalm_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f926-1f3ff-2642', '1f926-1f3ff-2640'],
				'unicode' => '🤦🏿',
				'keywords' => ['dark skin tone', 'disbelief', 'exasperation', 'face', 'palm', 'uc9'],
			],
			'1f926-2640' => [
				'name' => \XF::phrase('emoji.woman_facepalming'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_facepalming:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f926-1f3ff-2640', '1f926-1f3fe-2640', '1f926-1f3fd-2640', '1f926-1f3fc-2640', '1f926-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🤦‍♀️',
				'keywords' => ['disbelief', 'exasperation', 'facepalm', 'woman', 'uc9'],
			],
			'1f926-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_facepalming_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_facepalming_tone1:',
				'shortname_alternates' => [':woman_facepalming_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🤦🏻‍♀️',
				'keywords' => ['disbelief', 'exasperation', 'facepalm', 'light skin tone', 'woman', 'uc9'],
			],
			'1f926-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_facepalming_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_facepalming_tone2:',
				'shortname_alternates' => [':woman_facepalming_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🤦🏼‍♀️',
				'keywords' => ['disbelief', 'exasperation', 'facepalm', 'medium-light skin tone', 'woman', 'uc9'],
			],
			'1f926-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_facepalming_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_facepalming_tone3:',
				'shortname_alternates' => [':woman_facepalming_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🤦🏽‍♀️',
				'keywords' => ['disbelief', 'exasperation', 'facepalm', 'medium skin tone', 'woman', 'uc9'],
			],
			'1f926-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_facepalming_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_facepalming_tone4:',
				'shortname_alternates' => [':woman_facepalming_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🤦🏾‍♀️',
				'keywords' => ['disbelief', 'exasperation', 'facepalm', 'medium-dark skin tone', 'woman', 'uc9'],
			],
			'1f926-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_facepalming_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_facepalming_tone5:',
				'shortname_alternates' => [':woman_facepalming_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🤦🏿‍♀️',
				'keywords' => ['dark skin tone', 'disbelief', 'exasperation', 'facepalm', 'woman', 'uc9'],
			],
			'1f926-2642' => [
				'name' => \XF::phrase('emoji.man_facepalming'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_facepalming:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f926-1f3ff-2642', '1f926-1f3fe-2642', '1f926-1f3fd-2642', '1f926-1f3fc-2642', '1f926-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🤦‍♂️',
				'keywords' => ['disbelief', 'exasperation', 'facepalm', 'man', 'uc9'],
			],
			'1f926-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_facepalming_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_facepalming_tone1:',
				'shortname_alternates' => [':man_facepalming_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🤦🏻‍♂️',
				'keywords' => ['disbelief', 'exasperation', 'facepalm', 'light skin tone', 'man', 'uc9'],
			],
			'1f926-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_facepalming_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_facepalming_tone2:',
				'shortname_alternates' => [':man_facepalming_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🤦🏼‍♂️',
				'keywords' => ['disbelief', 'exasperation', 'facepalm', 'man', 'medium-light skin tone', 'uc9'],
			],
			'1f926-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_facepalming_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_facepalming_tone3:',
				'shortname_alternates' => [':man_facepalming_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🤦🏽‍♂️',
				'keywords' => ['disbelief', 'exasperation', 'facepalm', 'man', 'medium skin tone', 'uc9'],
			],
			'1f926-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_facepalming_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_facepalming_tone4:',
				'shortname_alternates' => [':man_facepalming_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🤦🏾‍♂️',
				'keywords' => ['disbelief', 'exasperation', 'facepalm', 'man', 'medium-dark skin tone', 'uc9'],
			],
			'1f926-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_facepalming_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_facepalming_tone5:',
				'shortname_alternates' => [':man_facepalming_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🤦🏿‍♂️',
				'keywords' => ['dark skin tone', 'disbelief', 'exasperation', 'facepalm', 'man', 'uc9'],
			],
			'1f937' => [
				'name' => \XF::phrase('emoji.person_shrugging'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_shrugging:',
				'shortname_alternates' => [':shrug:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f937-1f3fb', '1f937-1f3fc', '1f937-1f3fd', '1f937-1f3fe', '1f937-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f937-2642', '1f937-2640'],
				'unicode' => '🤷',
				'keywords' => ['doubt', 'ignorance', 'indifference', 'shrug', 'uc9'],
			],
			'1f937-1f3fb' => [
				'name' => \XF::phrase('emoji.person_shrugging_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_shrugging_tone1:',
				'shortname_alternates' => [':shrug_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f937-1f3fb-2642', '1f937-1f3fb-2640'],
				'unicode' => '🤷🏻',
				'keywords' => ['doubt', 'ignorance', 'indifference', 'light skin tone', 'shrug', 'uc9'],
			],
			'1f937-1f3fc' => [
				'name' => \XF::phrase('emoji.person_shrugging_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_shrugging_tone2:',
				'shortname_alternates' => [':shrug_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f937-1f3fc-2642', '1f937-1f3fc-2640'],
				'unicode' => '🤷🏼',
				'keywords' => ['doubt', 'ignorance', 'indifference', 'medium-light skin tone', 'shrug', 'uc9'],
			],
			'1f937-1f3fd' => [
				'name' => \XF::phrase('emoji.person_shrugging_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_shrugging_tone3:',
				'shortname_alternates' => [':shrug_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f937-1f3fd-2642', '1f937-1f3fd-2640'],
				'unicode' => '🤷🏽',
				'keywords' => ['doubt', 'ignorance', 'indifference', 'medium skin tone', 'shrug', 'uc9'],
			],
			'1f937-1f3fe' => [
				'name' => \XF::phrase('emoji.person_shrugging_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_shrugging_tone4:',
				'shortname_alternates' => [':shrug_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f937-1f3fe-2642', '1f937-1f3fe-2640'],
				'unicode' => '🤷🏾',
				'keywords' => ['doubt', 'ignorance', 'indifference', 'medium-dark skin tone', 'shrug', 'uc9'],
			],
			'1f937-1f3ff' => [
				'name' => \XF::phrase('emoji.person_shrugging_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_shrugging_tone5:',
				'shortname_alternates' => [':shrug_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f937-1f3ff-2642', '1f937-1f3ff-2640'],
				'unicode' => '🤷🏿',
				'keywords' => ['dark skin tone', 'doubt', 'ignorance', 'indifference', 'shrug', 'uc9'],
			],
			'1f937-2640' => [
				'name' => \XF::phrase('emoji.woman_shrugging'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_shrugging:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f937-1f3ff-2640', '1f937-1f3fe-2640', '1f937-1f3fd-2640', '1f937-1f3fc-2640', '1f937-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🤷‍♀️',
				'keywords' => ['doubt', 'ignorance', 'indifference', 'shrug', 'woman', 'uc9'],
			],
			'1f937-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_shrugging_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_shrugging_tone1:',
				'shortname_alternates' => [':woman_shrugging_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🤷🏻‍♀️',
				'keywords' => ['doubt', 'ignorance', 'indifference', 'light skin tone', 'shrug', 'woman', 'uc9'],
			],
			'1f937-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_shrugging_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_shrugging_tone2:',
				'shortname_alternates' => [':woman_shrugging_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🤷🏼‍♀️',
				'keywords' => ['doubt', 'ignorance', 'indifference', 'medium-light skin tone', 'shrug', 'woman', 'uc9'],
			],
			'1f937-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_shrugging_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_shrugging_tone3:',
				'shortname_alternates' => [':woman_shrugging_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🤷🏽‍♀️',
				'keywords' => ['doubt', 'ignorance', 'indifference', 'medium skin tone', 'shrug', 'woman', 'uc9'],
			],
			'1f937-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_shrugging_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_shrugging_tone4:',
				'shortname_alternates' => [':woman_shrugging_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🤷🏾‍♀️',
				'keywords' => ['doubt', 'ignorance', 'indifference', 'medium-dark skin tone', 'shrug', 'woman', 'uc9'],
			],
			'1f937-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_shrugging_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_shrugging_tone5:',
				'shortname_alternates' => [':woman_shrugging_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🤷🏿‍♀️',
				'keywords' => ['dark skin tone', 'doubt', 'ignorance', 'indifference', 'shrug', 'woman', 'uc9'],
			],
			'1f937-2642' => [
				'name' => \XF::phrase('emoji.man_shrugging'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_shrugging:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f937-1f3ff-2642', '1f937-1f3fe-2642', '1f937-1f3fd-2642', '1f937-1f3fc-2642', '1f937-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🤷‍♂️',
				'keywords' => ['doubt', 'ignorance', 'indifference', 'man', 'shrug', 'uc9'],
			],
			'1f937-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_shrugging_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_shrugging_tone1:',
				'shortname_alternates' => [':man_shrugging_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🤷🏻‍♂️',
				'keywords' => ['doubt', 'ignorance', 'indifference', 'light skin tone', 'man', 'shrug', 'uc9'],
			],
			'1f937-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_shrugging_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_shrugging_tone2:',
				'shortname_alternates' => [':man_shrugging_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🤷🏼‍♂️',
				'keywords' => ['doubt', 'ignorance', 'indifference', 'man', 'medium-light skin tone', 'shrug', 'uc9'],
			],
			'1f937-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_shrugging_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_shrugging_tone3:',
				'shortname_alternates' => [':man_shrugging_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🤷🏽‍♂️',
				'keywords' => ['doubt', 'ignorance', 'indifference', 'man', 'medium skin tone', 'shrug', 'uc9'],
			],
			'1f937-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_shrugging_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_shrugging_tone4:',
				'shortname_alternates' => [':man_shrugging_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🤷🏾‍♂️',
				'keywords' => ['doubt', 'ignorance', 'indifference', 'man', 'medium-dark skin tone', 'shrug', 'uc9'],
			],
			'1f937-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_shrugging_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_shrugging_tone5:',
				'shortname_alternates' => [':man_shrugging_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🤷🏿‍♂️',
				'keywords' => ['dark skin tone', 'doubt', 'ignorance', 'indifference', 'man', 'shrug', 'uc9'],
			],
			'1f64e' => [
				'name' => \XF::phrase('emoji.person_pouting'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_pouting:',
				'shortname_alternates' => [':person_with_pouting_face:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f64e-1f3fb', '1f64e-1f3fc', '1f64e-1f3fd', '1f64e-1f3fe', '1f64e-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f64e-2642', '1f64e-2640'],
				'unicode' => '🙎',
				'keywords' => ['gesture', 'pouting', 'uc6'],
			],
			'1f64e-1f3fb' => [
				'name' => \XF::phrase('emoji.person_pouting_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_pouting_tone1:',
				'shortname_alternates' => [':person_with_pouting_face_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f64e-1f3fb-2642', '1f64e-1f3fb-2640'],
				'unicode' => '🙎🏻',
				'keywords' => ['gesture', 'light skin tone', 'pouting', 'uc8'],
			],
			'1f64e-1f3fc' => [
				'name' => \XF::phrase('emoji.person_pouting_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_pouting_tone2:',
				'shortname_alternates' => [':person_with_pouting_face_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f64e-1f3fc-2642', '1f64e-1f3fc-2640'],
				'unicode' => '🙎🏼',
				'keywords' => ['gesture', 'medium-light skin tone', 'pouting', 'uc8'],
			],
			'1f64e-1f3fd' => [
				'name' => \XF::phrase('emoji.person_pouting_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_pouting_tone3:',
				'shortname_alternates' => [':person_with_pouting_face_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f64e-1f3fd-2642', '1f64e-1f3fd-2640'],
				'unicode' => '🙎🏽',
				'keywords' => ['gesture', 'medium skin tone', 'pouting', 'uc8'],
			],
			'1f64e-1f3fe' => [
				'name' => \XF::phrase('emoji.person_pouting_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_pouting_tone4:',
				'shortname_alternates' => [':person_with_pouting_face_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f64e-1f3fe-2642', '1f64e-1f3fe-2640'],
				'unicode' => '🙎🏾',
				'keywords' => ['gesture', 'medium-dark skin tone', 'pouting', 'uc8'],
			],
			'1f64e-1f3ff' => [
				'name' => \XF::phrase('emoji.person_pouting_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_pouting_tone5:',
				'shortname_alternates' => [':person_with_pouting_face_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f64e-1f3ff-2642', '1f64e-1f3ff-2640'],
				'unicode' => '🙎🏿',
				'keywords' => ['dark skin tone', 'gesture', 'pouting', 'uc8'],
			],
			'1f64e-2640' => [
				'name' => \XF::phrase('emoji.woman_pouting'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pouting:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f64e-1f3ff-2640', '1f64e-1f3fe-2640', '1f64e-1f3fd-2640', '1f64e-1f3fc-2640', '1f64e-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙎‍♀️',
				'keywords' => ['gesture', 'pouting', 'woman', 'uc6'],
			],
			'1f64e-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_pouting_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pouting_tone1:',
				'shortname_alternates' => [':woman_pouting_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙎🏻‍♀️',
				'keywords' => ['gesture', 'light skin tone', 'pouting', 'woman', 'uc8'],
			],
			'1f64e-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_pouting_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pouting_tone2:',
				'shortname_alternates' => [':woman_pouting_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙎🏼‍♀️',
				'keywords' => ['gesture', 'medium-light skin tone', 'pouting', 'woman', 'uc8'],
			],
			'1f64e-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_pouting_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pouting_tone3:',
				'shortname_alternates' => [':woman_pouting_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙎🏽‍♀️',
				'keywords' => ['gesture', 'medium skin tone', 'pouting', 'woman', 'uc8'],
			],
			'1f64e-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_pouting_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pouting_tone4:',
				'shortname_alternates' => [':woman_pouting_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙎🏾‍♀️',
				'keywords' => ['gesture', 'medium-dark skin tone', 'pouting', 'woman', 'uc8'],
			],
			'1f64e-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_pouting_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_pouting_tone5:',
				'shortname_alternates' => [':woman_pouting_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙎🏿‍♀️',
				'keywords' => ['dark skin tone', 'gesture', 'pouting', 'woman', 'uc8'],
			],
			'1f64e-2642' => [
				'name' => \XF::phrase('emoji.man_pouting'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pouting:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f64e-1f3ff-2642', '1f64e-1f3fe-2642', '1f64e-1f3fd-2642', '1f64e-1f3fc-2642', '1f64e-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙎‍♂️',
				'keywords' => ['gesture', 'man', 'pouting', 'uc6'],
			],
			'1f64e-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_pouting_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pouting_tone1:',
				'shortname_alternates' => [':man_pouting_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙎🏻‍♂️',
				'keywords' => ['gesture', 'light skin tone', 'man', 'pouting', 'uc8'],
			],
			'1f64e-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_pouting_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pouting_tone2:',
				'shortname_alternates' => [':man_pouting_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙎🏼‍♂️',
				'keywords' => ['gesture', 'man', 'medium-light skin tone', 'pouting', 'uc8'],
			],
			'1f64e-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_pouting_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pouting_tone3:',
				'shortname_alternates' => [':man_pouting_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙎🏽‍♂️',
				'keywords' => ['gesture', 'man', 'medium skin tone', 'pouting', 'uc8'],
			],
			'1f64e-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_pouting_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pouting_tone4:',
				'shortname_alternates' => [':man_pouting_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙎🏾‍♂️',
				'keywords' => ['gesture', 'man', 'medium-dark skin tone', 'pouting', 'uc8'],
			],
			'1f64e-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_pouting_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_pouting_tone5:',
				'shortname_alternates' => [':man_pouting_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙎🏿‍♂️',
				'keywords' => ['dark skin tone', 'gesture', 'man', 'pouting', 'uc8'],
			],
			'1f64d' => [
				'name' => \XF::phrase('emoji.person_frowning'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_frowning:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f64d-1f3fb', '1f64d-1f3fc', '1f64d-1f3fd', '1f64d-1f3fe', '1f64d-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f64d-2642', '1f64d-2640'],
				'unicode' => '🙍',
				'keywords' => ['frown', 'gesture', 'uc6'],
			],
			'1f64d-1f3fb' => [
				'name' => \XF::phrase('emoji.person_frowning_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_frowning_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f64d-1f3fb-2642', '1f64d-1f3fb-2640'],
				'unicode' => '🙍🏻',
				'keywords' => ['frown', 'gesture', 'light skin tone', 'uc8'],
			],
			'1f64d-1f3fc' => [
				'name' => \XF::phrase('emoji.person_frowning_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_frowning_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f64d-1f3fc-2642', '1f64d-1f3fc-2640'],
				'unicode' => '🙍🏼',
				'keywords' => ['frown', 'gesture', 'medium-light skin tone', 'uc8'],
			],
			'1f64d-1f3fd' => [
				'name' => \XF::phrase('emoji.person_frowning_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_frowning_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f64d-1f3fd-2642', '1f64d-1f3fd-2640'],
				'unicode' => '🙍🏽',
				'keywords' => ['frown', 'gesture', 'medium skin tone', 'uc8'],
			],
			'1f64d-1f3fe' => [
				'name' => \XF::phrase('emoji.person_frowning_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_frowning_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f64d-1f3fe-2642', '1f64d-1f3fe-2640'],
				'unicode' => '🙍🏾',
				'keywords' => ['frown', 'gesture', 'medium-dark skin tone', 'uc8'],
			],
			'1f64d-1f3ff' => [
				'name' => \XF::phrase('emoji.person_frowning_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_frowning_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f64d-1f3ff-2642', '1f64d-1f3ff-2640'],
				'unicode' => '🙍🏿',
				'keywords' => ['dark skin tone', 'frown', 'gesture', 'uc8'],
			],
			'1f64d-2640' => [
				'name' => \XF::phrase('emoji.woman_frowning'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_frowning:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f64d-1f3ff-2640', '1f64d-1f3fe-2640', '1f64d-1f3fd-2640', '1f64d-1f3fc-2640', '1f64d-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙍‍♀️',
				'keywords' => ['frowning', 'gesture', 'woman', 'uc6'],
			],
			'1f64d-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_frowning_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_frowning_tone1:',
				'shortname_alternates' => [':woman_frowning_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙍🏻‍♀️',
				'keywords' => ['frowning', 'gesture', 'light skin tone', 'woman', 'uc8'],
			],
			'1f64d-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_frowning_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_frowning_tone2:',
				'shortname_alternates' => [':woman_frowning_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙍🏼‍♀️',
				'keywords' => ['frowning', 'gesture', 'medium-light skin tone', 'woman', 'uc8'],
			],
			'1f64d-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_frowning_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_frowning_tone3:',
				'shortname_alternates' => [':woman_frowning_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙍🏽‍♀️',
				'keywords' => ['frowning', 'gesture', 'medium skin tone', 'woman', 'uc8'],
			],
			'1f64d-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_frowning_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_frowning_tone4:',
				'shortname_alternates' => [':woman_frowning_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙍🏾‍♀️',
				'keywords' => ['frowning', 'gesture', 'medium-dark skin tone', 'woman', 'uc8'],
			],
			'1f64d-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_frowning_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_frowning_tone5:',
				'shortname_alternates' => [':woman_frowning_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🙍🏿‍♀️',
				'keywords' => ['dark skin tone', 'frowning', 'gesture', 'woman', 'uc8'],
			],
			'1f64d-2642' => [
				'name' => \XF::phrase('emoji.man_frowning'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_frowning:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f64d-1f3ff-2642', '1f64d-1f3fe-2642', '1f64d-1f3fd-2642', '1f64d-1f3fc-2642', '1f64d-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙍‍♂️',
				'keywords' => ['frowning', 'gesture', 'man', 'uc6'],
			],
			'1f64d-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_frowning_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_frowning_tone1:',
				'shortname_alternates' => [':man_frowning_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙍🏻‍♂️',
				'keywords' => ['frowning', 'gesture', 'light skin tone', 'man', 'uc8'],
			],
			'1f64d-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_frowning_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_frowning_tone2:',
				'shortname_alternates' => [':man_frowning_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙍🏼‍♂️',
				'keywords' => ['frowning', 'gesture', 'man', 'medium-light skin tone', 'uc8'],
			],
			'1f64d-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_frowning_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_frowning_tone3:',
				'shortname_alternates' => [':man_frowning_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙍🏽‍♂️',
				'keywords' => ['frowning', 'gesture', 'man', 'medium skin tone', 'uc8'],
			],
			'1f64d-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_frowning_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_frowning_tone4:',
				'shortname_alternates' => [':man_frowning_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙍🏾‍♂️',
				'keywords' => ['frowning', 'gesture', 'man', 'medium-dark skin tone', 'uc8'],
			],
			'1f64d-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_frowning_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_frowning_tone5:',
				'shortname_alternates' => [':man_frowning_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🙍🏿‍♂️',
				'keywords' => ['dark skin tone', 'frowning', 'gesture', 'man', 'uc8'],
			],
			'1f487' => [
				'name' => \XF::phrase('emoji.person_getting_haircut'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_haircut:',
				'shortname_alternates' => [':haircut:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f487-1f3fb', '1f487-1f3fc', '1f487-1f3fd', '1f487-1f3fe', '1f487-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f487-2642', '1f487-2640'],
				'unicode' => '💇',
				'keywords' => ['barber', 'beauty', 'haircut', 'parlor', 'uc6'],
			],
			'1f487-1f3fb' => [
				'name' => \XF::phrase('emoji.person_getting_haircut_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_haircut_tone1:',
				'shortname_alternates' => [':haircut_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f487-1f3fb-2642', '1f487-1f3fb-2640'],
				'unicode' => '💇🏻',
				'keywords' => ['barber', 'beauty', 'haircut', 'light skin tone', 'parlor', 'uc8'],
			],
			'1f487-1f3fc' => [
				'name' => \XF::phrase('emoji.person_getting_haircut_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_haircut_tone2:',
				'shortname_alternates' => [':haircut_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f487-1f3fc-2642', '1f487-1f3fc-2640'],
				'unicode' => '💇🏼',
				'keywords' => ['barber', 'beauty', 'haircut', 'medium-light skin tone', 'parlor', 'uc8'],
			],
			'1f487-1f3fd' => [
				'name' => \XF::phrase('emoji.person_getting_haircut_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_haircut_tone3:',
				'shortname_alternates' => [':haircut_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f487-1f3fd-2642', '1f487-1f3fd-2640'],
				'unicode' => '💇🏽',
				'keywords' => ['barber', 'beauty', 'haircut', 'medium skin tone', 'parlor', 'uc8'],
			],
			'1f487-1f3fe' => [
				'name' => \XF::phrase('emoji.person_getting_haircut_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_haircut_tone4:',
				'shortname_alternates' => [':haircut_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f487-1f3fe-2642', '1f487-1f3fe-2640'],
				'unicode' => '💇🏾',
				'keywords' => ['barber', 'beauty', 'haircut', 'medium-dark skin tone', 'parlor', 'uc8'],
			],
			'1f487-1f3ff' => [
				'name' => \XF::phrase('emoji.person_getting_haircut_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_haircut_tone5:',
				'shortname_alternates' => [':haircut_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f487-1f3ff-2642', '1f487-1f3ff-2640'],
				'unicode' => '💇🏿',
				'keywords' => ['barber', 'beauty', 'dark skin tone', 'haircut', 'parlor', 'uc8'],
			],
			'1f487-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_haircut'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_haircut:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f487-1f3ff-2640', '1f487-1f3fe-2640', '1f487-1f3fd-2640', '1f487-1f3fc-2640', '1f487-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '💇‍♀️',
				'keywords' => ['haircut', 'woman', 'uc6'],
			],
			'1f487-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_haircut_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_haircut_tone1:',
				'shortname_alternates' => [':woman_getting_haircut_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '💇🏻‍♀️',
				'keywords' => ['haircut', 'light skin tone', 'woman', 'uc8'],
			],
			'1f487-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_haircut_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_haircut_tone2:',
				'shortname_alternates' => [':woman_getting_haircut_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '💇🏼‍♀️',
				'keywords' => ['haircut', 'medium-light skin tone', 'woman', 'uc8'],
			],
			'1f487-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_haircut_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_haircut_tone3:',
				'shortname_alternates' => [':woman_getting_haircut_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '💇🏽‍♀️',
				'keywords' => ['haircut', 'medium skin tone', 'woman', 'uc8'],
			],
			'1f487-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_haircut_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_haircut_tone4:',
				'shortname_alternates' => [':woman_getting_haircut_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '💇🏾‍♀️',
				'keywords' => ['haircut', 'medium-dark skin tone', 'woman', 'uc8'],
			],
			'1f487-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_haircut_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_haircut_tone5:',
				'shortname_alternates' => [':woman_getting_haircut_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '💇🏿‍♀️',
				'keywords' => ['dark skin tone', 'haircut', 'woman', 'uc8'],
			],
			'1f487-2642' => [
				'name' => \XF::phrase('emoji.man_getting_haircut'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_haircut:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f487-1f3ff-2642', '1f487-1f3fe-2642', '1f487-1f3fd-2642', '1f487-1f3fc-2642', '1f487-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '💇‍♂️',
				'keywords' => ['haircut', 'man', 'uc6'],
			],
			'1f487-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_getting_haircut_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_haircut_tone1:',
				'shortname_alternates' => [':man_getting_haircut_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '💇🏻‍♂️',
				'keywords' => ['haircut', 'light skin tone', 'man', 'uc8'],
			],
			'1f487-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_getting_haircut_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_haircut_tone2:',
				'shortname_alternates' => [':man_getting_haircut_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '💇🏼‍♂️',
				'keywords' => ['haircut', 'man', 'medium-light skin tone', 'uc8'],
			],
			'1f487-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_getting_haircut_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_haircut_tone3:',
				'shortname_alternates' => [':man_getting_haircut_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '💇🏽‍♂️',
				'keywords' => ['haircut', 'man', 'medium skin tone', 'uc8'],
			],
			'1f487-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_getting_haircut_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_haircut_tone4:',
				'shortname_alternates' => [':man_getting_haircut_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '💇🏾‍♂️',
				'keywords' => ['haircut', 'man', 'medium-dark skin tone', 'uc8'],
			],
			'1f487-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_getting_haircut_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_haircut_tone5:',
				'shortname_alternates' => [':man_getting_haircut_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '💇🏿‍♂️',
				'keywords' => ['dark skin tone', 'haircut', 'man', 'uc8'],
			],
			'1f486' => [
				'name' => \XF::phrase('emoji.person_getting_massage'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_massage:',
				'shortname_alternates' => [':massage:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f486-1f3fb', '1f486-1f3fc', '1f486-1f3fd', '1f486-1f3fe', '1f486-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f486-2642', '1f486-2640'],
				'unicode' => '💆',
				'keywords' => ['face', 'massage', 'salon', 'uc6'],
			],
			'1f486-1f3fb' => [
				'name' => \XF::phrase('emoji.person_getting_massage_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_massage_tone1:',
				'shortname_alternates' => [':massage_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f486-1f3fb-2642', '1f486-1f3fb-2640'],
				'unicode' => '💆🏻',
				'keywords' => ['face', 'light skin tone', 'massage', 'salon', 'uc8'],
			],
			'1f486-1f3fc' => [
				'name' => \XF::phrase('emoji.person_getting_massage_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_massage_tone2:',
				'shortname_alternates' => [':massage_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f486-1f3fc-2642', '1f486-1f3fc-2640'],
				'unicode' => '💆🏼',
				'keywords' => ['face', 'massage', 'medium-light skin tone', 'salon', 'uc8'],
			],
			'1f486-1f3fd' => [
				'name' => \XF::phrase('emoji.person_getting_massage_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_massage_tone3:',
				'shortname_alternates' => [':massage_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f486-1f3fd-2642', '1f486-1f3fd-2640'],
				'unicode' => '💆🏽',
				'keywords' => ['face', 'massage', 'medium skin tone', 'salon', 'uc8'],
			],
			'1f486-1f3fe' => [
				'name' => \XF::phrase('emoji.person_getting_massage_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_massage_tone4:',
				'shortname_alternates' => [':massage_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f486-1f3fe-2642', '1f486-1f3fe-2640'],
				'unicode' => '💆🏾',
				'keywords' => ['face', 'massage', 'medium-dark skin tone', 'salon', 'uc8'],
			],
			'1f486-1f3ff' => [
				'name' => \XF::phrase('emoji.person_getting_massage_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_getting_massage_tone5:',
				'shortname_alternates' => [':massage_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f486-1f3ff-2642', '1f486-1f3ff-2640'],
				'unicode' => '💆🏿',
				'keywords' => ['dark skin tone', 'face', 'massage', 'salon', 'uc8'],
			],
			'1f486-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_face_massage'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_face_massage:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f486-1f3ff-2640', '1f486-1f3fe-2640', '1f486-1f3fd-2640', '1f486-1f3fc-2640', '1f486-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '💆‍♀️',
				'keywords' => ['face', 'massage', 'woman', 'uc6'],
			],
			'1f486-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_face_massage_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_face_massage_tone1:',
				'shortname_alternates' => [':woman_getting_face_massage_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '💆🏻‍♀️',
				'keywords' => ['face', 'light skin tone', 'massage', 'woman', 'uc8'],
			],
			'1f486-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_face_massage_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_face_massage_tone2:',
				'shortname_alternates' => [':woman_getting_face_massage_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '💆🏼‍♀️',
				'keywords' => ['face', 'massage', 'medium-light skin tone', 'woman', 'uc8'],
			],
			'1f486-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_face_massage_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_face_massage_tone3:',
				'shortname_alternates' => [':woman_getting_face_massage_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '💆🏽‍♀️',
				'keywords' => ['face', 'massage', 'medium skin tone', 'woman', 'uc8'],
			],
			'1f486-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_face_massage_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_face_massage_tone4:',
				'shortname_alternates' => [':woman_getting_face_massage_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '💆🏾‍♀️',
				'keywords' => ['face', 'massage', 'medium-dark skin tone', 'woman', 'uc8'],
			],
			'1f486-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_getting_face_massage_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_getting_face_massage_tone5:',
				'shortname_alternates' => [':woman_getting_face_massage_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '💆🏿‍♀️',
				'keywords' => ['dark skin tone', 'face', 'massage', 'woman', 'uc8'],
			],
			'1f486-2642' => [
				'name' => \XF::phrase('emoji.man_getting_face_massage'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_face_massage:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f486-1f3ff-2642', '1f486-1f3fe-2642', '1f486-1f3fd-2642', '1f486-1f3fc-2642', '1f486-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '💆‍♂️',
				'keywords' => ['face', 'man', 'massage', 'uc6'],
			],
			'1f486-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_getting_face_massage_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_face_massage_tone1:',
				'shortname_alternates' => [':man_getting_face_massage_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '💆🏻‍♂️',
				'keywords' => ['face', 'light skin tone', 'man', 'massage', 'uc8'],
			],
			'1f486-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_getting_face_massage_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_face_massage_tone2:',
				'shortname_alternates' => [':man_getting_face_massage_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '💆🏼‍♂️',
				'keywords' => ['face', 'man', 'massage', 'medium-light skin tone', 'uc8'],
			],
			'1f486-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_getting_face_massage_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_face_massage_tone3:',
				'shortname_alternates' => [':man_getting_face_massage_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '💆🏽‍♂️',
				'keywords' => ['face', 'man', 'massage', 'medium skin tone', 'uc8'],
			],
			'1f486-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_getting_face_massage_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_face_massage_tone4:',
				'shortname_alternates' => [':man_getting_face_massage_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '💆🏾‍♂️',
				'keywords' => ['face', 'man', 'massage', 'medium-dark skin tone', 'uc8'],
			],
			'1f486-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_getting_face_massage_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_getting_face_massage_tone5:',
				'shortname_alternates' => [':man_getting_face_massage_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '💆🏿‍♂️',
				'keywords' => ['dark skin tone', 'face', 'man', 'massage', 'uc8'],
			],
			'1f9d6' => [
				'name' => \XF::phrase('emoji.person_in_steamy_room'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_steamy_room:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d6-1f3fb', '1f9d6-1f3fc', '1f9d6-1f3fd', '1f9d6-1f3fe', '1f9d6-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f9d6-2640', '1f9d6-2642'],
				'unicode' => '🧖',
				'keywords' => ['uc10'],
			],
			'1f9d6-1f3fb' => [
				'name' => \XF::phrase('emoji.person_in_steamy_room_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_steamy_room_tone1:',
				'shortname_alternates' => [':person_in_steamy_room_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9d6-1f3fb-2640', '1f9d6-1f3fb-2642'],
				'unicode' => '🧖🏻',
				'keywords' => ['light skin tone', 'sauna', 'steam room', 'uc10'],
			],
			'1f9d6-1f3fc' => [
				'name' => \XF::phrase('emoji.person_in_steamy_room_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_steamy_room_tone2:',
				'shortname_alternates' => [':person_in_steamy_room_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9d6-1f3fc-2640', '1f9d6-1f3fc-2642'],
				'unicode' => '🧖🏼',
				'keywords' => ['medium-light skin tone', 'sauna', 'steam room', 'uc10'],
			],
			'1f9d6-1f3fd' => [
				'name' => \XF::phrase('emoji.person_in_steamy_room_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_steamy_room_tone3:',
				'shortname_alternates' => [':person_in_steamy_room_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9d6-1f3fd-2640', '1f9d6-1f3fd-2642'],
				'unicode' => '🧖🏽',
				'keywords' => ['medium skin tone', 'sauna', 'steam room', 'uc10'],
			],
			'1f9d6-1f3fe' => [
				'name' => \XF::phrase('emoji.person_in_steamy_room_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_steamy_room_tone4:',
				'shortname_alternates' => [':person_in_steamy_room_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9d6-1f3fe-2640', '1f9d6-1f3fe-2642'],
				'unicode' => '🧖🏾',
				'keywords' => ['medium-dark skin tone', 'sauna', 'steam room', 'uc10'],
			],
			'1f9d6-1f3ff' => [
				'name' => \XF::phrase('emoji.person_in_steamy_room_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_steamy_room_tone5:',
				'shortname_alternates' => [':person_in_steamy_room_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9d6-1f3ff-2640', '1f9d6-1f3ff-2642'],
				'unicode' => '🧖🏿',
				'keywords' => ['dark skin tone', 'sauna', 'steam room', 'uc10'],
			],
			'1f9d6-2640' => [
				'name' => \XF::phrase('emoji.woman_in_steamy_room'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_steamy_room:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d6-1f3fb-2640', '1f9d6-1f3fc-2640', '1f9d6-1f3fd-2640', '1f9d6-1f3fe-2640', '1f9d6-1f3ff-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧖‍♀️',
				'keywords' => ['sauna', 'steam room', 'uc10'],
			],
			'1f9d6-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_in_steamy_room_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_steamy_room_tone1:',
				'shortname_alternates' => [':woman_in_steamy_room_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧖🏻‍♀️',
				'keywords' => ['light skin tone', 'sauna', 'steam room', 'uc10'],
			],
			'1f9d6-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_in_steamy_room_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_steamy_room_tone2:',
				'shortname_alternates' => [':woman_in_steamy_room_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧖🏼‍♀️',
				'keywords' => ['medium-light skin tone', 'sauna', 'steam room', 'uc10'],
			],
			'1f9d6-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_in_steamy_room_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_steamy_room_tone3:',
				'shortname_alternates' => [':woman_in_steamy_room_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧖🏽‍♀️',
				'keywords' => ['medium skin tone', 'sauna', 'steam room', 'uc10'],
			],
			'1f9d6-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_in_steamy_room_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_steamy_room_tone4:',
				'shortname_alternates' => [':woman_in_steamy_room_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧖🏾‍♀️',
				'keywords' => ['medium-dark skin tone', 'sauna', 'steam room', 'uc10'],
			],
			'1f9d6-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_in_steamy_room_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_steamy_room_tone5:',
				'shortname_alternates' => [':woman_in_steamy_room_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧖🏿‍♀️',
				'keywords' => ['dark skin tone', 'sauna', 'steam room', 'uc10'],
			],
			'1f9d6-2642' => [
				'name' => \XF::phrase('emoji.man_in_steamy_room'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_steamy_room:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d6-1f3fb-2642', '1f9d6-1f3fc-2642', '1f9d6-1f3fd-2642', '1f9d6-1f3fe-2642', '1f9d6-1f3ff-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧖‍♂️',
				'keywords' => ['sauna', 'steam room', 'uc10'],
			],
			'1f9d6-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_in_steamy_room_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_steamy_room_tone1:',
				'shortname_alternates' => [':man_in_steamy_room_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧖🏻‍♂️',
				'keywords' => ['light skin tone', 'sauna', 'steam room', 'uc10'],
			],
			'1f9d6-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_in_steamy_room_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_steamy_room_tone2:',
				'shortname_alternates' => [':man_in_steamy_room_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧖🏼‍♂️',
				'keywords' => ['medium-light skin tone', 'sauna', 'steam room', 'uc10'],
			],
			'1f9d6-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_in_steamy_room_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_steamy_room_tone3:',
				'shortname_alternates' => [':man_in_steamy_room_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧖🏽‍♂️',
				'keywords' => ['medium skin tone', 'sauna', 'steam room', 'uc10'],
			],
			'1f9d6-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_in_steamy_room_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_steamy_room_tone4:',
				'shortname_alternates' => [':man_in_steamy_room_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧖🏾‍♂️',
				'keywords' => ['medium-dark skin tone', 'sauna', 'steam room', 'uc10'],
			],
			'1f9d6-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_in_steamy_room_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_steamy_room_tone5:',
				'shortname_alternates' => [':man_in_steamy_room_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧖🏿‍♂️',
				'keywords' => ['dark skin tone', 'sauna', 'steam room', 'uc10'],
			],
			'1f485' => [
				'name' => \XF::phrase('emoji.nail_care'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nail_care:',
				'shortname_alternates' => [':nail_polish:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f485-1f3fb', '1f485-1f3fc', '1f485-1f3fd', '1f485-1f3fe', '1f485-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '💅',
				'keywords' => ['care', 'cosmetics', 'manicure', 'nail', 'polish', 'uc6'],
			],
			'1f485-1f3fb' => [
				'name' => \XF::phrase('emoji.nail_care_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nail_care_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '💅🏻',
				'keywords' => ['care', 'cosmetics', 'light skin tone', 'manicure', 'nail', 'polish', 'uc8'],
			],
			'1f485-1f3fc' => [
				'name' => \XF::phrase('emoji.nail_care_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nail_care_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '💅🏼',
				'keywords' => ['care', 'cosmetics', 'manicure', 'medium-light skin tone', 'nail', 'polish', 'uc8'],
			],
			'1f485-1f3fd' => [
				'name' => \XF::phrase('emoji.nail_care_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nail_care_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '💅🏽',
				'keywords' => ['care', 'cosmetics', 'manicure', 'medium skin tone', 'nail', 'polish', 'uc8'],
			],
			'1f485-1f3fe' => [
				'name' => \XF::phrase('emoji.nail_care_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nail_care_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '💅🏾',
				'keywords' => ['care', 'cosmetics', 'manicure', 'medium-dark skin tone', 'nail', 'polish', 'uc8'],
			],
			'1f485-1f3ff' => [
				'name' => \XF::phrase('emoji.nail_care_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':nail_care_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '💅🏿',
				'keywords' => ['care', 'cosmetics', 'dark skin tone', 'manicure', 'nail', 'polish', 'uc8'],
			],
			'1f933' => [
				'name' => \XF::phrase('emoji.selfie'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':selfie:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f933-1f3fb', '1f933-1f3fc', '1f933-1f3fd', '1f933-1f3fe', '1f933-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤳',
				'keywords' => ['camera', 'phone', 'selfie', 'uc9'],
			],
			'1f933-1f3fb' => [
				'name' => \XF::phrase('emoji.selfie_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':selfie_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤳🏻',
				'keywords' => ['camera', 'light skin tone', 'phone', 'selfie', 'uc9'],
			],
			'1f933-1f3fc' => [
				'name' => \XF::phrase('emoji.selfie_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':selfie_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤳🏼',
				'keywords' => ['camera', 'medium-light skin tone', 'phone', 'selfie', 'uc9'],
			],
			'1f933-1f3fd' => [
				'name' => \XF::phrase('emoji.selfie_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':selfie_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤳🏽',
				'keywords' => ['camera', 'medium skin tone', 'phone', 'selfie', 'uc9'],
			],
			'1f933-1f3fe' => [
				'name' => \XF::phrase('emoji.selfie_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':selfie_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤳🏾',
				'keywords' => ['camera', 'medium-dark skin tone', 'phone', 'selfie', 'uc9'],
			],
			'1f933-1f3ff' => [
				'name' => \XF::phrase('emoji.selfie_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':selfie_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🤳🏿',
				'keywords' => ['camera', 'dark skin tone', 'phone', 'selfie', 'uc9'],
			],
			'1f483' => [
				'name' => \XF::phrase('emoji.dancer'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':dancer:',
				'shortname_alternates' => [':woman_dancing:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f483-1f3fb', '1f483-1f3fc', '1f483-1f3fd', '1f483-1f3fe', '1f483-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '💃',
				'keywords' => ['dancing', 'woman', 'uc6'],
			],
			'1f483-1f3fb' => [
				'name' => \XF::phrase('emoji.dancer_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':dancer_tone1:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '💃🏻',
				'keywords' => ['dancing', 'light skin tone', 'woman', 'uc8'],
			],
			'1f483-1f3fc' => [
				'name' => \XF::phrase('emoji.dancer_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':dancer_tone2:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '💃🏼',
				'keywords' => ['dancing', 'medium-light skin tone', 'woman', 'uc8'],
			],
			'1f483-1f3fd' => [
				'name' => \XF::phrase('emoji.dancer_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':dancer_tone3:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '💃🏽',
				'keywords' => ['dancing', 'medium skin tone', 'woman', 'uc8'],
			],
			'1f483-1f3fe' => [
				'name' => \XF::phrase('emoji.dancer_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':dancer_tone4:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '💃🏾',
				'keywords' => ['dancing', 'medium-dark skin tone', 'woman', 'uc8'],
			],
			'1f483-1f3ff' => [
				'name' => \XF::phrase('emoji.dancer_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':dancer_tone5:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '💃🏿',
				'keywords' => ['dancing', 'dark skin tone', 'woman', 'uc8'],
			],
			'1f57a' => [
				'name' => \XF::phrase('emoji.man_dancing'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_dancing:',
				'shortname_alternates' => [':male_dancer:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f57a-1f3fb', '1f57a-1f3fc', '1f57a-1f3fd', '1f57a-1f3fe', '1f57a-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🕺',
				'keywords' => ['dance', 'man', 'uc9'],
			],
			'1f57a-1f3fb' => [
				'name' => \XF::phrase('emoji.man_dancing_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_dancing_tone1:',
				'shortname_alternates' => [':male_dancer_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🕺🏻',
				'keywords' => ['dance', 'light skin tone', 'man', 'uc9'],
			],
			'1f57a-1f3fc' => [
				'name' => \XF::phrase('emoji.man_dancing_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_dancing_tone2:',
				'shortname_alternates' => [':male_dancer_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🕺🏼',
				'keywords' => ['dance', 'man', 'medium-light skin tone', 'uc9'],
			],
			'1f57a-1f3fd' => [
				'name' => \XF::phrase('emoji.man_dancing_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_dancing_tone3:',
				'shortname_alternates' => [':male_dancer_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🕺🏽',
				'keywords' => ['dance', 'man', 'medium skin tone', 'uc9'],
			],
			'1f57a-1f3ff' => [
				'name' => \XF::phrase('emoji.man_dancing_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_dancing_tone5:',
				'shortname_alternates' => [':male_dancer_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🕺🏿',
				'keywords' => ['dance', 'dark skin tone', 'man', 'uc9'],
			],
			'1f57a-1f3fe' => [
				'name' => \XF::phrase('emoji.man_dancing_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_dancing_tone4:',
				'shortname_alternates' => [':male_dancer_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🕺🏾',
				'keywords' => ['dance', 'man', 'medium-dark skin tone', 'uc9'],
			],
			'1f46f' => [
				'name' => \XF::phrase('emoji.people_with_bunny_ears_partying'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_with_bunny_ears_partying:',
				'shortname_alternates' => [':dancers:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f46f-2642', '1f46f-2640'],
				'unicode' => '👯',
				'keywords' => ['bunny ear', 'dancer', 'partying', 'uc6'],
			],
			'1f46f-2640' => [
				'name' => \XF::phrase('emoji.women_with_bunny_ears_partying'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_with_bunny_ears_partying:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👯‍♀️',
				'keywords' => ['bunny ear', 'dancer', 'partying', 'women', 'uc6'],
			],
			'1f46f-2642' => [
				'name' => \XF::phrase('emoji.men_with_bunny_ears_partying'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_with_bunny_ears_partying:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => '',
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👯‍♂️',
				'keywords' => ['bunny ear', 'dancer', 'men', 'partying', 'uc6'],
			],
			'1f574' => [
				'name' => \XF::phrase('emoji.levitate'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':levitate:',
				'shortname_alternates' => [':man_in_business_suit_levitating:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f574-1f3fb', '1f574-1f3fc', '1f574-1f3fd', '1f574-1f3fe', '1f574-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🕴️',
				'keywords' => ['business', 'man', 'suit', 'uc7'],
			],
			'1f574-1f3fb' => [
				'name' => \XF::phrase('emoji.levitate_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':levitate_tone1:',
				'shortname_alternates' => [':man_in_business_suit_levitating_tone1:', ':man_in_business_suit_levitating_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🕴🏻',
				'keywords' => ['business', 'light skin tone', 'man', 'suit', 'uc8'],
			],
			'1f574-1f3fc' => [
				'name' => \XF::phrase('emoji.levitate_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':levitate_tone2:',
				'shortname_alternates' => [':man_in_business_suit_levitating_tone2:', ':man_in_business_suit_levitating_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🕴🏼',
				'keywords' => ['business', 'man', 'medium-light skin tone', 'suit', 'uc8'],
			],
			'1f574-1f3fd' => [
				'name' => \XF::phrase('emoji.levitate_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':levitate_tone3:',
				'shortname_alternates' => [':man_in_business_suit_levitating_tone3:', ':man_in_business_suit_levitating_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🕴🏽',
				'keywords' => ['business', 'man', 'medium skin tone', 'suit', 'uc8'],
			],
			'1f574-1f3fe' => [
				'name' => \XF::phrase('emoji.levitate_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':levitate_tone4:',
				'shortname_alternates' => [':man_in_business_suit_levitating_tone4:', ':man_in_business_suit_levitating_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🕴🏾',
				'keywords' => ['business', 'man', 'medium-dark skin tone', 'suit', 'uc8'],
			],
			'1f574-1f3ff' => [
				'name' => \XF::phrase('emoji.levitate_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':levitate_tone5:',
				'shortname_alternates' => [':man_in_business_suit_levitating_tone5:', ':man_in_business_suit_levitating_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🕴🏿',
				'keywords' => ['business', 'dark skin tone', 'man', 'suit', 'uc8'],
			],
			'1f9d1-1f9bd' => [
				'name' => \XF::phrase('emoji.person_in_manual_wheelchair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_manual_wheelchair:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f9bd', '1f9d1-1f3fc-1f9bd', '1f9d1-1f3fd-1f9bd', '1f9d1-1f3fe-1f9bd', '1f9d1-1f3ff-1f9bd'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑‍🦽',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f9bd' => [
				'name' => \XF::phrase('emoji.person_in_manual_wheelchair_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_manual_wheelchair_tone1:',
				'shortname_alternates' => [':person_in_manual_wheelchair_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍🦽',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f9bd' => [
				'name' => \XF::phrase('emoji.person_in_manual_wheelchair_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_manual_wheelchair_tone2:',
				'shortname_alternates' => [':person_in_manual_wheelchair_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍🦽',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f9bd' => [
				'name' => \XF::phrase('emoji.person_in_manual_wheelchair_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_manual_wheelchair_tone3:',
				'shortname_alternates' => [':person_in_manual_wheelchair_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍🦽',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f9bd' => [
				'name' => \XF::phrase('emoji.person_in_manual_wheelchair_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_manual_wheelchair_tone4:',
				'shortname_alternates' => [':person_in_manual_wheelchair_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍🦽',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f9bd' => [
				'name' => \XF::phrase('emoji.person_in_manual_wheelchair_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_manual_wheelchair_tone5:',
				'shortname_alternates' => [':person_in_manual_wheelchair_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍🦽',
				'keywords' => ['uc12'],
			],
			'1f469-1f9bd' => [
				'name' => \XF::phrase('emoji.woman_in_manual_wheelchair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_manual_wheelchair:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3fb-1f9bd', '1f469-1f3fc-1f9bd', '1f469-1f3fd-1f9bd', '1f469-1f3fe-1f9bd', '1f469-1f3ff-1f9bd'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩‍🦽',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fb-1f9bd' => [
				'name' => \XF::phrase('emoji.woman_in_manual_wheelchair_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_manual_wheelchair_tone1:',
				'shortname_alternates' => [':woman_in_manual_wheelchair_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻‍🦽',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fc-1f9bd' => [
				'name' => \XF::phrase('emoji.woman_in_manual_wheelchair_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_manual_wheelchair_tone2:',
				'shortname_alternates' => [':woman_in_manual_wheelchair_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼‍🦽',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fd-1f9bd' => [
				'name' => \XF::phrase('emoji.woman_in_manual_wheelchair_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_manual_wheelchair_tone3:',
				'shortname_alternates' => [':woman_in_manual_wheelchair_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏽‍🦽',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fe-1f9bd' => [
				'name' => \XF::phrase('emoji.woman_in_manual_wheelchair_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_manual_wheelchair_tone4:',
				'shortname_alternates' => [':woman_in_manual_wheelchair_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏾‍🦽',
				'keywords' => ['uc12'],
			],
			'1f469-1f3ff-1f9bd' => [
				'name' => \XF::phrase('emoji.woman_in_manual_wheelchair_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_manual_wheelchair_tone5:',
				'shortname_alternates' => [':woman_in_manual_wheelchair_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏿‍🦽',
				'keywords' => ['uc12'],
			],
			'1f468-1f9bd' => [
				'name' => \XF::phrase('emoji.man_in_manual_wheelchair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_manual_wheelchair:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3fb-1f9bd', '1f468-1f3fc-1f9bd', '1f468-1f3fd-1f9bd', '1f468-1f3fe-1f9bd', '1f468-1f3ff-1f9bd'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨‍🦽',
				'keywords' => ['uc12'],
			],
			'1f468-1f3fb-1f9bd' => [
				'name' => \XF::phrase('emoji.man_in_manual_wheelchair_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_manual_wheelchair_tone1:',
				'shortname_alternates' => [':man_in_manual_wheelchair_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏻‍🦽',
				'keywords' => ['uc12'],
			],
			'1f468-1f3fc-1f9bd' => [
				'name' => \XF::phrase('emoji.man_in_manual_wheelchair_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_manual_wheelchair_tone2:',
				'shortname_alternates' => [':man_in_manual_wheelchair_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏼‍🦽',
				'keywords' => ['uc12'],
			],
			'1f468-1f3fd-1f9bd' => [
				'name' => \XF::phrase('emoji.man_in_manual_wheelchair_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_manual_wheelchair_tone3:',
				'shortname_alternates' => [':man_in_manual_wheelchair_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏽‍🦽',
				'keywords' => ['uc12'],
			],
			'1f468-1f3fe-1f9bd' => [
				'name' => \XF::phrase('emoji.man_in_manual_wheelchair_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_manual_wheelchair_tone4:',
				'shortname_alternates' => [':man_in_manual_wheelchair_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏾‍🦽',
				'keywords' => ['uc12'],
			],
			'1f468-1f3ff-1f9bd' => [
				'name' => \XF::phrase('emoji.man_in_manual_wheelchair_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_manual_wheelchair_tone5:',
				'shortname_alternates' => [':man_in_manual_wheelchair_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏿‍🦽',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f9bc' => [
				'name' => \XF::phrase('emoji.person_in_motorized_wheelchair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_motorized_wheelchair:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f9bc', '1f9d1-1f3fc-1f9bc', '1f9d1-1f3fd-1f9bc', '1f9d1-1f3fe-1f9bc', '1f9d1-1f3ff-1f9bc'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑‍🦼',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f9bc' => [
				'name' => \XF::phrase('emoji.person_in_motorized_wheelchair_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_motorized_wheelchair_tone1:',
				'shortname_alternates' => [':person_in_motorized_wheelchair_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍🦼',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f9bc' => [
				'name' => \XF::phrase('emoji.person_in_motorized_wheelchair_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_motorized_wheelchair_tone2:',
				'shortname_alternates' => [':person_in_motorized_wheelchair_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍🦼',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f9bc' => [
				'name' => \XF::phrase('emoji.person_in_motorized_wheelchair_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_motorized_wheelchair_tone3:',
				'shortname_alternates' => [':person_in_motorized_wheelchair_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍🦼',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f9bc' => [
				'name' => \XF::phrase('emoji.person_in_motorized_wheelchair_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_motorized_wheelchair_tone4:',
				'shortname_alternates' => [':person_in_motorized_wheelchair_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍🦼',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f9bc' => [
				'name' => \XF::phrase('emoji.person_in_motorized_wheelchair_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_in_motorized_wheelchair_tone5:',
				'shortname_alternates' => [':person_in_motorized_wheelchair_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍🦼',
				'keywords' => ['uc12'],
			],
			'1f469-1f9bc' => [
				'name' => \XF::phrase('emoji.woman_in_motorized_wheelchair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_motorized_wheelchair:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3fb-1f9bc', '1f469-1f3fc-1f9bc', '1f469-1f3fd-1f9bc', '1f469-1f3fe-1f9bc', '1f469-1f3ff-1f9bc'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩‍🦼',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fb-1f9bc' => [
				'name' => \XF::phrase('emoji.woman_in_motorized_wheelchair_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_motorized_wheelchair_tone1:',
				'shortname_alternates' => [':woman_in_motorized_wheelchair_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻‍🦼',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fc-1f9bc' => [
				'name' => \XF::phrase('emoji.woman_in_motorized_wheelchair_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_motorized_wheelchair_tone2:',
				'shortname_alternates' => [':woman_in_motorized_wheelchair_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼‍🦼',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fd-1f9bc' => [
				'name' => \XF::phrase('emoji.woman_in_motorized_wheelchair_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_motorized_wheelchair_tone3:',
				'shortname_alternates' => [':woman_in_motorized_wheelchair_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏽‍🦼',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fe-1f9bc' => [
				'name' => \XF::phrase('emoji.woman_in_motorized_wheelchair_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_motorized_wheelchair_tone4:',
				'shortname_alternates' => [':woman_in_motorized_wheelchair_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏾‍🦼',
				'keywords' => ['uc12'],
			],
			'1f469-1f3ff-1f9bc' => [
				'name' => \XF::phrase('emoji.woman_in_motorized_wheelchair_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_in_motorized_wheelchair_tone5:',
				'shortname_alternates' => [':woman_in_motorized_wheelchair_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏿‍🦼',
				'keywords' => ['uc12'],
			],
			'1f468-1f9bc' => [
				'name' => \XF::phrase('emoji.man_in_motorized_wheelchair'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_motorized_wheelchair:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3fb-1f9bc', '1f468-1f3fc-1f9bc', '1f468-1f3fd-1f9bc', '1f468-1f3fe-1f9bc', '1f468-1f3ff-1f9bc'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨‍🦼',
				'keywords' => ['uc12'],
			],
			'1f468-1f3fb-1f9bc' => [
				'name' => \XF::phrase('emoji.man_in_motorized_wheelchair_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_motorized_wheelchair_tone1:',
				'shortname_alternates' => [':man_in_motorized_wheelchair_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏻‍🦼',
				'keywords' => ['uc12'],
			],
			'1f468-1f3fc-1f9bc' => [
				'name' => \XF::phrase('emoji.man_in_motorized_wheelchair_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_motorized_wheelchair_tone2:',
				'shortname_alternates' => [':man_in_motorized_wheelchair_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏼‍🦼',
				'keywords' => ['uc12'],
			],
			'1f468-1f3fd-1f9bc' => [
				'name' => \XF::phrase('emoji.man_in_motorized_wheelchair_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_motorized_wheelchair_tone3:',
				'shortname_alternates' => [':man_in_motorized_wheelchair_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏽‍🦼',
				'keywords' => ['uc12'],
			],
			'1f468-1f3fe-1f9bc' => [
				'name' => \XF::phrase('emoji.man_in_motorized_wheelchair_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_motorized_wheelchair_tone4:',
				'shortname_alternates' => [':man_in_motorized_wheelchair_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏾‍🦼',
				'keywords' => ['uc12'],
			],
			'1f468-1f3ff-1f9bc' => [
				'name' => \XF::phrase('emoji.man_in_motorized_wheelchair_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_in_motorized_wheelchair_tone5:',
				'shortname_alternates' => [':man_in_motorized_wheelchair_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏿‍🦼',
				'keywords' => ['uc12'],
			],
			'1f6b6' => [
				'name' => \XF::phrase('emoji.person_walking'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_walking:',
				'shortname_alternates' => [':walking:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f6b6-1f3fb', '1f6b6-1f3fc', '1f6b6-1f3fd', '1f6b6-1f3fe', '1f6b6-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f6b6-2642', '1f6b6-2640'],
				'unicode' => '🚶',
				'keywords' => ['hike', 'walk', 'walking', 'uc6'],
			],
			'1f6b6-1f3fb' => [
				'name' => \XF::phrase('emoji.person_walking_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_walking_tone1:',
				'shortname_alternates' => [':walking_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f6b6-1f3fb-2642', '1f6b6-1f3fb-2640'],
				'unicode' => '🚶🏻',
				'keywords' => ['hike', 'light skin tone', 'walk', 'walking', 'uc8'],
			],
			'1f6b6-1f3fc' => [
				'name' => \XF::phrase('emoji.person_walking_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_walking_tone2:',
				'shortname_alternates' => [':walking_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f6b6-1f3fc-2642', '1f6b6-1f3fc-2640'],
				'unicode' => '🚶🏼',
				'keywords' => ['hike', 'medium-light skin tone', 'walk', 'walking', 'uc8'],
			],
			'1f6b6-1f3fd' => [
				'name' => \XF::phrase('emoji.person_walking_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_walking_tone3:',
				'shortname_alternates' => [':walking_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f6b6-1f3fd-2642', '1f6b6-1f3fd-2640'],
				'unicode' => '🚶🏽',
				'keywords' => ['hike', 'medium skin tone', 'walk', 'walking', 'uc8'],
			],
			'1f6b6-1f3fe' => [
				'name' => \XF::phrase('emoji.person_walking_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_walking_tone4:',
				'shortname_alternates' => [':walking_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f6b6-1f3fe-2642', '1f6b6-1f3fe-2640'],
				'unicode' => '🚶🏾',
				'keywords' => ['hike', 'medium-dark skin tone', 'walk', 'walking', 'uc8'],
			],
			'1f6b6-1f3ff' => [
				'name' => \XF::phrase('emoji.person_walking_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_walking_tone5:',
				'shortname_alternates' => [':walking_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f6b6-1f3ff-2642', '1f6b6-1f3ff-2640'],
				'unicode' => '🚶🏿',
				'keywords' => ['dark skin tone', 'hike', 'walk', 'walking', 'uc8'],
			],
			'1f6b6-2640' => [
				'name' => \XF::phrase('emoji.woman_walking'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_walking:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f6b6-1f3ff-2640', '1f6b6-1f3fe-2640', '1f6b6-1f3fd-2640', '1f6b6-1f3fc-2640', '1f6b6-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🚶‍♀️',
				'keywords' => ['hike', 'walk', 'woman', 'uc6'],
			],
			'1f6b6-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_walking_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_walking_tone1:',
				'shortname_alternates' => [':woman_walking_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🚶🏻‍♀️',
				'keywords' => ['hike', 'light skin tone', 'walk', 'woman', 'uc8'],
			],
			'1f6b6-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_walking_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_walking_tone2:',
				'shortname_alternates' => [':woman_walking_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🚶🏼‍♀️',
				'keywords' => ['hike', 'medium-light skin tone', 'walk', 'woman', 'uc8'],
			],
			'1f6b6-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_walking_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_walking_tone3:',
				'shortname_alternates' => [':woman_walking_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🚶🏽‍♀️',
				'keywords' => ['hike', 'medium skin tone', 'walk', 'woman', 'uc8'],
			],
			'1f6b6-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_walking_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_walking_tone4:',
				'shortname_alternates' => [':woman_walking_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🚶🏾‍♀️',
				'keywords' => ['hike', 'medium-dark skin tone', 'walk', 'woman', 'uc8'],
			],
			'1f6b6-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_walking_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_walking_tone5:',
				'shortname_alternates' => [':woman_walking_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🚶🏿‍♀️',
				'keywords' => ['dark skin tone', 'hike', 'walk', 'woman', 'uc8'],
			],
			'1f6b6-2642' => [
				'name' => \XF::phrase('emoji.man_walking'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_walking:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f6b6-1f3ff-2642', '1f6b6-1f3fe-2642', '1f6b6-1f3fd-2642', '1f6b6-1f3fc-2642', '1f6b6-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🚶‍♂️',
				'keywords' => ['hike', 'man', 'walk', 'uc6'],
			],
			'1f6b6-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_walking_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_walking_tone1:',
				'shortname_alternates' => [':man_walking_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🚶🏻‍♂️',
				'keywords' => ['hike', 'light skin tone', 'man', 'walk', 'uc8'],
			],
			'1f6b6-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_walking_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_walking_tone2:',
				'shortname_alternates' => [':man_walking_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🚶🏼‍♂️',
				'keywords' => ['hike', 'man', 'medium-light skin tone', 'walk', 'uc8'],
			],
			'1f6b6-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_walking_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_walking_tone3:',
				'shortname_alternates' => [':man_walking_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🚶🏽‍♂️',
				'keywords' => ['hike', 'man', 'medium skin tone', 'walk', 'uc8'],
			],
			'1f6b6-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_walking_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_walking_tone4:',
				'shortname_alternates' => [':man_walking_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🚶🏾‍♂️',
				'keywords' => ['hike', 'man', 'medium-dark skin tone', 'walk', 'uc8'],
			],
			'1f6b6-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_walking_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_walking_tone5:',
				'shortname_alternates' => [':man_walking_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🚶🏿‍♂️',
				'keywords' => ['dark skin tone', 'hike', 'man', 'walk', 'uc8'],
			],
			'1f9d1-1f9af' => [
				'name' => \XF::phrase('emoji.person_with_probing_cane'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_with_probing_cane:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f9af', '1f9d1-1f3fc-1f9af', '1f9d1-1f3fd-1f9af', '1f9d1-1f3fe-1f9af', '1f9d1-1f3ff-1f9af'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑‍🦯',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f9af' => [
				'name' => \XF::phrase('emoji.person_with_probing_cane_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_with_probing_cane_tone1:',
				'shortname_alternates' => [':person_with_probing_cane_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍🦯',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f9af' => [
				'name' => \XF::phrase('emoji.person_with_probing_cane_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_with_probing_cane_tone2:',
				'shortname_alternates' => [':person_with_probing_cane_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍🦯',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f9af' => [
				'name' => \XF::phrase('emoji.person_with_probing_cane_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_with_probing_cane_tone3:',
				'shortname_alternates' => [':person_with_probing_cane_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍🦯',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f9af' => [
				'name' => \XF::phrase('emoji.person_with_probing_cane_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_with_probing_cane_tone4:',
				'shortname_alternates' => [':person_with_probing_cane_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍🦯',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f9af' => [
				'name' => \XF::phrase('emoji.person_with_probing_cane_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_with_probing_cane_tone5:',
				'shortname_alternates' => [':person_with_probing_cane_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍🦯',
				'keywords' => ['uc12'],
			],
			'1f469-1f9af' => [
				'name' => \XF::phrase('emoji.woman_with_probing_cane'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_probing_cane:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3fb-1f9af', '1f469-1f3fc-1f9af', '1f469-1f3fd-1f9af', '1f469-1f3fe-1f9af', '1f469-1f3ff-1f9af'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩‍🦯',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fb-1f9af' => [
				'name' => \XF::phrase('emoji.woman_with_probing_cane_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_probing_cane_tone1:',
				'shortname_alternates' => [':woman_with_probing_cane_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻‍🦯',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fc-1f9af' => [
				'name' => \XF::phrase('emoji.woman_with_probing_cane_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_probing_cane_tone2:',
				'shortname_alternates' => [':woman_with_probing_cane_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼‍🦯',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fd-1f9af' => [
				'name' => \XF::phrase('emoji.woman_with_probing_cane_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_probing_cane_tone3:',
				'shortname_alternates' => [':woman_with_probing_cane_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏽‍🦯',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fe-1f9af' => [
				'name' => \XF::phrase('emoji.woman_with_probing_cane_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_probing_cane_tone4:',
				'shortname_alternates' => [':woman_with_probing_cane_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏾‍🦯',
				'keywords' => ['uc12'],
			],
			'1f469-1f3ff-1f9af' => [
				'name' => \XF::phrase('emoji.woman_with_probing_cane_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_with_probing_cane_tone5:',
				'shortname_alternates' => [':woman_with_probing_cane_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏿‍🦯',
				'keywords' => ['uc12'],
			],
			'1f468-1f9af' => [
				'name' => \XF::phrase('emoji.man_with_probing_cane'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_probing_cane:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f468-1f3fb-1f9af', '1f468-1f3fc-1f9af', '1f468-1f3fd-1f9af', '1f468-1f3fe-1f9af', '1f468-1f3ff-1f9af'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨‍🦯',
				'keywords' => ['uc12'],
			],
			'1f468-1f3fb-1f9af' => [
				'name' => \XF::phrase('emoji.man_with_probing_cane_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_probing_cane_tone1:',
				'shortname_alternates' => [':man_with_probing_cane_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏻‍🦯',
				'keywords' => ['uc12'],
			],
			'1f468-1f3fc-1f9af' => [
				'name' => \XF::phrase('emoji.man_with_probing_cane_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_probing_cane_tone2:',
				'shortname_alternates' => [':man_with_probing_cane_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏼‍🦯',
				'keywords' => ['uc12'],
			],
			'1f468-1f3fd-1f9af' => [
				'name' => \XF::phrase('emoji.man_with_probing_cane_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_probing_cane_tone3:',
				'shortname_alternates' => [':man_with_probing_cane_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏽‍🦯',
				'keywords' => ['uc12'],
			],
			'1f468-1f3fe-1f9af' => [
				'name' => \XF::phrase('emoji.man_with_probing_cane_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_probing_cane_tone4:',
				'shortname_alternates' => [':man_with_probing_cane_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏾‍🦯',
				'keywords' => ['uc12'],
			],
			'1f468-1f3ff-1f9af' => [
				'name' => \XF::phrase('emoji.man_with_probing_cane_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_with_probing_cane_tone5:',
				'shortname_alternates' => [':man_with_probing_cane_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏿‍🦯',
				'keywords' => ['uc12'],
			],
			'1f9ce' => [
				'name' => \XF::phrase('emoji.person_kneeling'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_kneeling:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9ce-1f3fb', '1f9ce-1f3fc', '1f9ce-1f3fd', '1f9ce-1f3fe', '1f9ce-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f9ce-2640', '1f9ce-2642'],
				'unicode' => '🧎',
				'keywords' => ['uc12'],
			],
			'1f9ce-1f3fb' => [
				'name' => \XF::phrase('emoji.person_kneeling_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_kneeling_tone1:',
				'shortname_alternates' => [':person_kneeling_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9ce-1f3fb-2640', '1f9ce-1f3fb-2642'],
				'unicode' => '🧎🏻',
				'keywords' => ['uc12'],
			],
			'1f9ce-1f3fc' => [
				'name' => \XF::phrase('emoji.person_kneeling_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_kneeling_tone2:',
				'shortname_alternates' => [':person_kneeling_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9ce-1f3fc-2640', '1f9ce-1f3fc-2642'],
				'unicode' => '🧎🏼',
				'keywords' => ['uc12'],
			],
			'1f9ce-1f3fd' => [
				'name' => \XF::phrase('emoji.person_kneeling_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_kneeling_tone3:',
				'shortname_alternates' => [':person_kneeling_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9ce-1f3fd-2640', '1f9ce-1f3fd-2642'],
				'unicode' => '🧎🏽',
				'keywords' => ['uc12'],
			],
			'1f9ce-1f3fe' => [
				'name' => \XF::phrase('emoji.person_kneeling_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_kneeling_tone4:',
				'shortname_alternates' => [':person_kneeling_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9ce-1f3fe-2640', '1f9ce-1f3fe-2642'],
				'unicode' => '🧎🏾',
				'keywords' => ['uc12'],
			],
			'1f9ce-1f3ff' => [
				'name' => \XF::phrase('emoji.person_kneeling_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_kneeling_tone5:',
				'shortname_alternates' => [':person_kneeling_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9ce-1f3ff-2640', '1f9ce-1f3ff-2642'],
				'unicode' => '🧎🏿',
				'keywords' => ['uc12'],
			],
			'1f9ce-2640' => [
				'name' => \XF::phrase('emoji.woman_kneeling'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_kneeling:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9ce-1f3fb-2640', '1f9ce-1f3fc-2640', '1f9ce-1f3fd-2640', '1f9ce-1f3fe-2640', '1f9ce-1f3ff-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧎‍♀️',
				'keywords' => ['uc12'],
			],
			'1f9ce-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_kneeling_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_kneeling_tone1:',
				'shortname_alternates' => [':woman_kneeling_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧎🏻‍♀️',
				'keywords' => ['uc12'],
			],
			'1f9ce-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_kneeling_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_kneeling_tone2:',
				'shortname_alternates' => [':woman_kneeling_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧎🏼‍♀️',
				'keywords' => ['uc12'],
			],
			'1f9ce-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_kneeling_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_kneeling_tone3:',
				'shortname_alternates' => [':woman_kneeling_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧎🏽‍♀️',
				'keywords' => ['uc12'],
			],
			'1f9ce-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_kneeling_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_kneeling_tone4:',
				'shortname_alternates' => [':woman_kneeling_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧎🏾‍♀️',
				'keywords' => ['uc12'],
			],
			'1f9ce-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_kneeling_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_kneeling_tone5:',
				'shortname_alternates' => [':woman_kneeling_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧎🏿‍♀️',
				'keywords' => ['uc12'],
			],
			'1f9ce-2642' => [
				'name' => \XF::phrase('emoji.man_kneeling'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_kneeling:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9ce-1f3fb-2642', '1f9ce-1f3fc-2642', '1f9ce-1f3fd-2642', '1f9ce-1f3fe-2642', '1f9ce-1f3ff-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧎‍♂️',
				'keywords' => ['uc12'],
			],
			'1f9ce-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_kneeling_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_kneeling_tone1:',
				'shortname_alternates' => [':man_kneeling_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧎🏻‍♂️',
				'keywords' => ['uc12'],
			],
			'1f9ce-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_kneeling_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_kneeling_tone2:',
				'shortname_alternates' => [':man_kneeling_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧎🏼‍♂️',
				'keywords' => ['uc12'],
			],
			'1f9ce-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_kneeling_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_kneeling_tone3:',
				'shortname_alternates' => [':man_kneeling_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧎🏽‍♂️',
				'keywords' => ['uc12'],
			],
			'1f9ce-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_kneeling_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_kneeling_tone4:',
				'shortname_alternates' => [':man_kneeling_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧎🏾‍♂️',
				'keywords' => ['uc12'],
			],
			'1f9ce-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_kneeling_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_kneeling_tone5:',
				'shortname_alternates' => [':man_kneeling_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧎🏿‍♂️',
				'keywords' => ['uc12'],
			],
			'1f3c3' => [
				'name' => \XF::phrase('emoji.person_running'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_running:',
				'shortname_alternates' => [':runner:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f3c3-1f3fb', '1f3c3-1f3fc', '1f3c3-1f3fd', '1f3c3-1f3fe', '1f3c3-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f3c3-2642', '1f3c3-2640'],
				'unicode' => '🏃',
				'keywords' => ['marathon', 'running', 'uc6'],
			],
			'1f3c3-1f3fb' => [
				'name' => \XF::phrase('emoji.person_running_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_running_tone1:',
				'shortname_alternates' => [':runner_tone1:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f3c3-1f3fb-2642', '1f3c3-1f3fb-2640'],
				'unicode' => '🏃🏻',
				'keywords' => ['light skin tone', 'marathon', 'running', 'uc8'],
			],
			'1f3c3-1f3fc' => [
				'name' => \XF::phrase('emoji.person_running_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_running_tone2:',
				'shortname_alternates' => [':runner_tone2:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f3c3-1f3fc-2642', '1f3c3-1f3fc-2640'],
				'unicode' => '🏃🏼',
				'keywords' => ['marathon', 'medium-light skin tone', 'running', 'uc8'],
			],
			'1f3c3-1f3fd' => [
				'name' => \XF::phrase('emoji.person_running_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_running_tone3:',
				'shortname_alternates' => [':runner_tone3:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f3c3-1f3fd-2642', '1f3c3-1f3fd-2640'],
				'unicode' => '🏃🏽',
				'keywords' => ['marathon', 'medium skin tone', 'running', 'uc8'],
			],
			'1f3c3-1f3fe' => [
				'name' => \XF::phrase('emoji.person_running_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_running_tone4:',
				'shortname_alternates' => [':runner_tone4:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f3c3-1f3fe-2642', '1f3c3-1f3fe-2640'],
				'unicode' => '🏃🏾',
				'keywords' => ['marathon', 'medium-dark skin tone', 'running', 'uc8'],
			],
			'1f3c3-1f3ff' => [
				'name' => \XF::phrase('emoji.person_running_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_running_tone5:',
				'shortname_alternates' => [':runner_tone5:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f3c3-1f3ff-2642', '1f3c3-1f3ff-2640'],
				'unicode' => '🏃🏿',
				'keywords' => ['dark skin tone', 'marathon', 'running', 'uc8'],
			],
			'1f3c3-2640' => [
				'name' => \XF::phrase('emoji.woman_running'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_running:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f3c3-1f3ff-2640', '1f3c3-1f3fe-2640', '1f3c3-1f3fd-2640', '1f3c3-1f3fc-2640', '1f3c3-1f3fb-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🏃‍♀️',
				'keywords' => ['marathon', 'racing', 'running', 'woman', 'uc6'],
			],
			'1f3c3-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_running_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_running_tone1:',
				'shortname_alternates' => [':woman_running_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🏃🏻‍♀️',
				'keywords' => ['light skin tone', 'marathon', 'racing', 'running', 'woman', 'uc8'],
			],
			'1f3c3-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_running_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_running_tone2:',
				'shortname_alternates' => [':woman_running_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🏃🏼‍♀️',
				'keywords' => ['marathon', 'medium-light skin tone', 'racing', 'running', 'woman', 'uc8'],
			],
			'1f3c3-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_running_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_running_tone3:',
				'shortname_alternates' => [':woman_running_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🏃🏽‍♀️',
				'keywords' => ['marathon', 'medium skin tone', 'racing', 'running', 'woman', 'uc8'],
			],
			'1f3c3-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_running_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_running_tone4:',
				'shortname_alternates' => [':woman_running_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🏃🏾‍♀️',
				'keywords' => ['marathon', 'medium-dark skin tone', 'racing', 'running', 'woman', 'uc8'],
			],
			'1f3c3-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_running_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_running_tone5:',
				'shortname_alternates' => [':woman_running_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🏃🏿‍♀️',
				'keywords' => ['dark skin tone', 'marathon', 'racing', 'running', 'woman', 'uc8'],
			],
			'1f3c3-2642' => [
				'name' => \XF::phrase('emoji.man_running'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_running:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f3c3-1f3ff-2642', '1f3c3-1f3fe-2642', '1f3c3-1f3fd-2642', '1f3c3-1f3fc-2642', '1f3c3-1f3fb-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🏃‍♂️',
				'keywords' => ['man', 'marathon', 'racing', 'running', 'uc6'],
			],
			'1f3c3-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_running_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_running_tone1:',
				'shortname_alternates' => [':man_running_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🏃🏻‍♂️',
				'keywords' => ['light skin tone', 'man', 'marathon', 'racing', 'running', 'uc8'],
			],
			'1f3c3-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_running_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_running_tone2:',
				'shortname_alternates' => [':man_running_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🏃🏼‍♂️',
				'keywords' => ['man', 'marathon', 'medium-light skin tone', 'racing', 'running', 'uc8'],
			],
			'1f3c3-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_running_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_running_tone3:',
				'shortname_alternates' => [':man_running_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🏃🏽‍♂️',
				'keywords' => ['man', 'marathon', 'medium skin tone', 'racing', 'running', 'uc8'],
			],
			'1f3c3-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_running_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_running_tone4:',
				'shortname_alternates' => [':man_running_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🏃🏾‍♂️',
				'keywords' => ['man', 'marathon', 'medium-dark skin tone', 'racing', 'running', 'uc8'],
			],
			'1f3c3-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_running_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_running_tone5:',
				'shortname_alternates' => [':man_running_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🏃🏿‍♂️',
				'keywords' => ['dark skin tone', 'man', 'marathon', 'racing', 'running', 'uc8'],
			],
			'1f9cd' => [
				'name' => \XF::phrase('emoji.person_standing'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_standing:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9cd-1f3fb', '1f9cd-1f3fc', '1f9cd-1f3fd', '1f9cd-1f3fe', '1f9cd-1f3ff'],
				'gender' => [],
				'gender_children' => ['1f9cd-2640', '1f9cd-2642'],
				'unicode' => '🧍',
				'keywords' => ['uc12'],
			],
			'1f9cd-1f3fb' => [
				'name' => \XF::phrase('emoji.person_standing_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_standing_tone1:',
				'shortname_alternates' => [':person_standing_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9cd-1f3fb-2640', '1f9cd-1f3fb-2642'],
				'unicode' => '🧍🏻',
				'keywords' => ['uc12'],
			],
			'1f9cd-1f3fc' => [
				'name' => \XF::phrase('emoji.person_standing_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_standing_tone2:',
				'shortname_alternates' => [':person_standing_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9cd-1f3fc-2640', '1f9cd-1f3fc-2642'],
				'unicode' => '🧍🏼',
				'keywords' => ['uc12'],
			],
			'1f9cd-1f3fd' => [
				'name' => \XF::phrase('emoji.person_standing_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_standing_tone3:',
				'shortname_alternates' => [':person_standing_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9cd-1f3fd-2640', '1f9cd-1f3fd-2642'],
				'unicode' => '🧍🏽',
				'keywords' => ['uc12'],
			],
			'1f9cd-1f3fe' => [
				'name' => \XF::phrase('emoji.person_standing_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_standing_tone4:',
				'shortname_alternates' => [':person_standing_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9cd-1f3fe-2640', '1f9cd-1f3fe-2642'],
				'unicode' => '🧍🏾',
				'keywords' => ['uc12'],
			],
			'1f9cd-1f3ff' => [
				'name' => \XF::phrase('emoji.person_standing_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':person_standing_tone5:',
				'shortname_alternates' => [':person_standing_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => ['1f9cd-1f3ff-2640', '1f9cd-1f3ff-2642'],
				'unicode' => '🧍🏿',
				'keywords' => ['uc12'],
			],
			'1f9cd-2640' => [
				'name' => \XF::phrase('emoji.woman_standing'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_standing:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9cd-1f3fb-2640', '1f9cd-1f3fc-2640', '1f9cd-1f3fd-2640', '1f9cd-1f3fe-2640', '1f9cd-1f3ff-2640'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧍‍♀️',
				'keywords' => ['uc12'],
			],
			'1f9cd-1f3fb-2640' => [
				'name' => \XF::phrase('emoji.woman_standing_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_standing_tone1:',
				'shortname_alternates' => [':woman_standing_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧍🏻‍♀️',
				'keywords' => ['uc12'],
			],
			'1f9cd-1f3fc-2640' => [
				'name' => \XF::phrase('emoji.woman_standing_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_standing_tone2:',
				'shortname_alternates' => [':woman_standing_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧍🏼‍♀️',
				'keywords' => ['uc12'],
			],
			'1f9cd-1f3fd-2640' => [
				'name' => \XF::phrase('emoji.woman_standing_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_standing_tone3:',
				'shortname_alternates' => [':woman_standing_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧍🏽‍♀️',
				'keywords' => ['uc12'],
			],
			'1f9cd-1f3fe-2640' => [
				'name' => \XF::phrase('emoji.woman_standing_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_standing_tone4:',
				'shortname_alternates' => [':woman_standing_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧍🏾‍♀️',
				'keywords' => ['uc12'],
			],
			'1f9cd-1f3ff-2640' => [
				'name' => \XF::phrase('emoji.woman_standing_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_standing_tone5:',
				'shortname_alternates' => [':woman_standing_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '🧍🏿‍♀️',
				'keywords' => ['uc12'],
			],
			'1f9cd-2642' => [
				'name' => \XF::phrase('emoji.man_standing'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_standing:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9cd-1f3fb-2642', '1f9cd-1f3fc-2642', '1f9cd-1f3fd-2642', '1f9cd-1f3fe-2642', '1f9cd-1f3ff-2642'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧍‍♂️',
				'keywords' => ['uc12'],
			],
			'1f9cd-1f3fb-2642' => [
				'name' => \XF::phrase('emoji.man_standing_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_standing_tone1:',
				'shortname_alternates' => [':man_standing_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧍🏻‍♂️',
				'keywords' => ['uc12'],
			],
			'1f9cd-1f3fc-2642' => [
				'name' => \XF::phrase('emoji.man_standing_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_standing_tone2:',
				'shortname_alternates' => [':man_standing_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧍🏼‍♂️',
				'keywords' => ['uc12'],
			],
			'1f9cd-1f3fd-2642' => [
				'name' => \XF::phrase('emoji.man_standing_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_standing_tone3:',
				'shortname_alternates' => [':man_standing_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧍🏽‍♂️',
				'keywords' => ['uc12'],
			],
			'1f9cd-1f3fe-2642' => [
				'name' => \XF::phrase('emoji.man_standing_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_standing_tone4:',
				'shortname_alternates' => [':man_standing_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧍🏾‍♂️',
				'keywords' => ['uc12'],
			],
			'1f9cd-1f3ff-2642' => [
				'name' => \XF::phrase('emoji.man_standing_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':man_standing_tone5:',
				'shortname_alternates' => [':man_standing_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '🧍🏿‍♂️',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f91d-1f9d1' => [
				'name' => \XF::phrase('emoji.people_holding_hands'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f9d1-1f3fb-1f91d-1f9d1-1f3fb', '1f9d1-1f3fc-1f91d-1f9d1-1f3fb', '1f9d1-1f3fc-1f91d-1f9d1-1f3fc', '1f9d1-1f3fd-1f91d-1f9d1-1f3fb', '1f9d1-1f3fd-1f91d-1f9d1-1f3fc', '1f9d1-1f3fd-1f91d-1f9d1-1f3fd', '1f9d1-1f3fe-1f91d-1f9d1-1f3fb', '1f9d1-1f3fe-1f91d-1f9d1-1f3fd', '1f9d1-1f3fe-1f91d-1f9d1-1f3fe', '1f9d1-1f3ff-1f91d-1f9d1-1f3fb', '1f9d1-1f3ff-1f91d-1f9d1-1f3fc', '1f9d1-1f3ff-1f91d-1f9d1-1f3fd', '1f9d1-1f3ff-1f91d-1f9d1-1f3fe', '1f9d1-1f3ff-1f91d-1f9d1-1f3ff', '1f9d1-1f3fe-1f91d-1f9d1-1f3fc', '1f9d1-1f3fb-1f91d-1f9d1-1f3fc', '1f9d1-1f3fb-1f91d-1f9d1-1f3fd', '1f9d1-1f3fb-1f91d-1f9d1-1f3fe', '1f9d1-1f3fb-1f91d-1f9d1-1f3ff', '1f9d1-1f3fc-1f91d-1f9d1-1f3fd', '1f9d1-1f3fc-1f91d-1f9d1-1f3fe', '1f9d1-1f3fc-1f91d-1f9d1-1f3ff', '1f9d1-1f3fd-1f91d-1f9d1-1f3fe', '1f9d1-1f3fd-1f91d-1f9d1-1f3ff', '1f9d1-1f3fe-1f91d-1f9d1-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑‍🤝‍🧑',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f91d-1f9d1-1f3fb' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone1:',
				'shortname_alternates' => [':people_holding_hands_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍🤝‍🧑🏻',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f91d-1f9d1-1f3fc' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone1_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone1_tone2:',
				'shortname_alternates' => [':people_holding_hands_light_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍🤝‍🧑🏼',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f91d-1f9d1-1f3fd' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone1_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone1_tone3:',
				'shortname_alternates' => [':people_holding_hands_light_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍🤝‍🧑🏽',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f91d-1f9d1-1f3fe' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone1_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone1_tone4:',
				'shortname_alternates' => [':people_holding_hands_light_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍🤝‍🧑🏾',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fb-1f91d-1f9d1-1f3ff' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone1_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone1_tone5:',
				'shortname_alternates' => [':people_holding_hands_light_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍🤝‍🧑🏿',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f91d-1f9d1-1f3fb' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone2_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone2_tone1:',
				'shortname_alternates' => [':people_holding_hands_medium_light_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍🤝‍🧑🏻',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f91d-1f9d1-1f3fc' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone2:',
				'shortname_alternates' => [':people_holding_hands_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍🤝‍🧑🏼',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f91d-1f9d1-1f3fd' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone2_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone2_tone3:',
				'shortname_alternates' => [':people_holding_hands_medium_light_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍🤝‍🧑🏽',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f91d-1f9d1-1f3fe' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone2_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone2_tone4:',
				'shortname_alternates' => [':people_holding_hands_medium_light_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍🤝‍🧑🏾',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fc-1f91d-1f9d1-1f3ff' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone2_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone2_tone5:',
				'shortname_alternates' => [':people_holding_hands_medium_light_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍🤝‍🧑🏿',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f91d-1f9d1-1f3fb' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone3_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone3_tone1:',
				'shortname_alternates' => [':people_holding_hands_medium_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍🤝‍🧑🏻',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f91d-1f9d1-1f3fc' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone3_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone3_tone2:',
				'shortname_alternates' => [':people_holding_hands_medium_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍🤝‍🧑🏼',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f91d-1f9d1-1f3fd' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone3:',
				'shortname_alternates' => [':people_holding_hands_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍🤝‍🧑🏽',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f91d-1f9d1-1f3fe' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone3_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone3_tone4:',
				'shortname_alternates' => [':people_holding_hands_medium_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍🤝‍🧑🏾',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fd-1f91d-1f9d1-1f3ff' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone3_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone3_tone5:',
				'shortname_alternates' => [':people_holding_hands_medium_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍🤝‍🧑🏿',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f91d-1f9d1-1f3fb' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone4_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone4_tone1:',
				'shortname_alternates' => [':people_holding_hands_medium_dark_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍🤝‍🧑🏻',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f91d-1f9d1-1f3fc' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone4_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone4_tone2:',
				'shortname_alternates' => [':people_holding_hands_medium_dark_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍🤝‍🧑🏼',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f91d-1f9d1-1f3fd' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone4_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone4_tone3:',
				'shortname_alternates' => [':people_holding_hands_medium_dark_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍🤝‍🧑🏽',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f91d-1f9d1-1f3fe' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone4:',
				'shortname_alternates' => [':people_holding_hands_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍🤝‍🧑🏾',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3fe-1f91d-1f9d1-1f3ff' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone4_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone4_tone5:',
				'shortname_alternates' => [':people_holding_hands_medium_dark_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe', '1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍🤝‍🧑🏿',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f91d-1f9d1-1f3fb' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone5_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone5_tone1:',
				'shortname_alternates' => [':people_holding_hands_dark_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍🤝‍🧑🏻',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f91d-1f9d1-1f3fc' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone5_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone5_tone2:',
				'shortname_alternates' => [':people_holding_hands_dark_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍🤝‍🧑🏼',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f91d-1f9d1-1f3fd' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone5_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone5_tone3:',
				'shortname_alternates' => [':people_holding_hands_dark_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍🤝‍🧑🏽',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f91d-1f9d1-1f3fe' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone5_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone5_tone4:',
				'shortname_alternates' => [':people_holding_hands_dark_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe', '1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍🤝‍🧑🏾',
				'keywords' => ['uc12'],
			],
			'1f9d1-1f3ff-1f91d-1f9d1-1f3ff' => [
				'name' => \XF::phrase('emoji.people_holding_hands_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':people_holding_hands_tone5:',
				'shortname_alternates' => [':people_holding_hands_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍🤝‍🧑🏿',
				'keywords' => ['uc12'],
			],
			'1f46b' => [
				'name' => \XF::phrase('emoji.couple'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f46b-1f3fb', '1f46b-1f3fc', '1f46b-1f3fd', '1f46b-1f3fe', '1f46b-1f3ff', '1f469-1f3fb-1f91d-1f468-1f3fd', '1f469-1f3fb-1f91d-1f468-1f3ff', '1f469-1f3fd-1f91d-1f468-1f3ff', '1f469-1f3ff-1f91d-1f468-1f3fe', '1f469-1f3ff-1f91d-1f468-1f3fd', '1f469-1f3ff-1f91d-1f468-1f3fc', '1f469-1f3ff-1f91d-1f468-1f3fb', '1f469-1f3fe-1f91d-1f468-1f3ff', '1f469-1f3fe-1f91d-1f468-1f3fd', '1f469-1f3fe-1f91d-1f468-1f3fc', '1f469-1f3fe-1f91d-1f468-1f3fb', '1f469-1f3fd-1f91d-1f468-1f3fe', '1f469-1f3fd-1f91d-1f468-1f3fc', '1f469-1f3fd-1f91d-1f468-1f3fb', '1f469-1f3fc-1f91d-1f468-1f3ff', '1f469-1f3fc-1f91d-1f468-1f3fe', '1f469-1f3fc-1f91d-1f468-1f3fd', '1f469-1f3fc-1f91d-1f468-1f3fb', '1f469-1f3fb-1f91d-1f468-1f3fe', '1f469-1f3fb-1f91d-1f468-1f3fc'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👫',
				'keywords' => ['couple', 'hand', 'hold', 'man', 'woman', 'uc6'],
			],
			'1f46b-1f3fb' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone1:',
				'shortname_alternates' => [':woman_and_man_holding_hands_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👫🏻',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fb-1f91d-1f468-1f3fc' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone1_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone1_tone2:',
				'shortname_alternates' => [':woman_and_man_holding_hands_light_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏻‍🤝‍👨🏼',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fb-1f91d-1f468-1f3fd' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone1_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone1_tone3:',
				'shortname_alternates' => [':woman_and_man_holding_hands_light_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏻‍🤝‍👨🏽',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fb-1f91d-1f468-1f3fe' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone1_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone1_tone4:',
				'shortname_alternates' => [':woman_and_man_holding_hands_light_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏻‍🤝‍👨🏾',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fb-1f91d-1f468-1f3ff' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone1_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone1_tone5:',
				'shortname_alternates' => [':woman_and_man_holding_hands_light_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏻‍🤝‍👨🏿',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fc-1f91d-1f468-1f3fb' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone2_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone2_tone1:',
				'shortname_alternates' => [':woman_and_man_holding_hands_medium_light_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏼‍🤝‍👨🏻',
				'keywords' => ['uc12'],
			],
			'1f46b-1f3fc' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone2:',
				'shortname_alternates' => [':woman_and_man_holding_hands_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👫🏼',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fc-1f91d-1f468-1f3fd' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone2_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone2_tone3:',
				'shortname_alternates' => [':woman_and_man_holding_hands_medium_light_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏼‍🤝‍👨🏽',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fc-1f91d-1f468-1f3fe' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone2_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone2_tone4:',
				'shortname_alternates' => [':woman_and_man_holding_hands_medium_light_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏼‍🤝‍👨🏾',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fc-1f91d-1f468-1f3ff' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone2_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone2_tone5:',
				'shortname_alternates' => [':woman_and_man_holding_hands_medium_light_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏼‍🤝‍👨🏿',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fd-1f91d-1f468-1f3fb' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone3_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone3_tone1:',
				'shortname_alternates' => [':woman_and_man_holding_hands_medium_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏽‍🤝‍👨🏻',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fd-1f91d-1f468-1f3fc' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone3_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone3_tone2:',
				'shortname_alternates' => [':woman_and_man_holding_hands_medium_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏽‍🤝‍👨🏼',
				'keywords' => ['uc12'],
			],
			'1f46b-1f3fd' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone3:',
				'shortname_alternates' => [':woman_and_man_holding_hands_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👫🏽',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fd-1f91d-1f468-1f3fe' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone3_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone3_tone4:',
				'shortname_alternates' => [':woman_and_man_holding_hands_medium_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏽‍🤝‍👨🏾',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fd-1f91d-1f468-1f3ff' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone3_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone3_tone5:',
				'shortname_alternates' => [':woman_and_man_holding_hands_medium_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏽‍🤝‍👨🏿',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fe-1f91d-1f468-1f3fb' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone4_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone4_tone1:',
				'shortname_alternates' => [':woman_and_man_holding_hands_medium_dark_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏾‍🤝‍👨🏻',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fe-1f91d-1f468-1f3fc' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone4_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone4_tone2:',
				'shortname_alternates' => [':woman_and_man_holding_hands_medium_dark_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏾‍🤝‍👨🏼',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fe-1f91d-1f468-1f3fd' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone4_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone4_tone3:',
				'shortname_alternates' => [':woman_and_man_holding_hands_medium_dark_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏾‍🤝‍👨🏽',
				'keywords' => ['uc12'],
			],
			'1f46b-1f3fe' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone4:',
				'shortname_alternates' => [':woman_and_man_holding_hands_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👫🏾',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fe-1f91d-1f468-1f3ff' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone4_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone4_tone5:',
				'shortname_alternates' => [':woman_and_man_holding_hands_medium_dark_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏾‍🤝‍👨🏿',
				'keywords' => ['uc12'],
			],
			'1f469-1f3ff-1f91d-1f468-1f3fb' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone5_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone5_tone1:',
				'shortname_alternates' => [':woman_and_man_holding_hands_dark_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏿‍🤝‍👨🏻',
				'keywords' => ['uc12'],
			],
			'1f469-1f3ff-1f91d-1f468-1f3fc' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone5_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone5_tone2:',
				'shortname_alternates' => [':woman_and_man_holding_hands_dark_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏿‍🤝‍👨🏼',
				'keywords' => ['uc12'],
			],
			'1f469-1f3ff-1f91d-1f468-1f3fd' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone5_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone5_tone3:',
				'shortname_alternates' => [':woman_and_man_holding_hands_dark_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏿‍🤝‍👨🏽',
				'keywords' => ['uc12'],
			],
			'1f469-1f3ff-1f91d-1f468-1f3fe' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone5_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone5_tone4:',
				'shortname_alternates' => [':woman_and_man_holding_hands_dark_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏿‍🤝‍👨🏾',
				'keywords' => ['uc12'],
			],
			'1f46b-1f3ff' => [
				'name' => \XF::phrase('emoji.woman_and_man_holding_hands_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':woman_and_man_holding_hands_tone5:',
				'shortname_alternates' => [':woman_and_man_holding_hands_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '👫🏿',
				'keywords' => ['uc12'],
			],
			'1f46d' => [
				'name' => \XF::phrase('emoji.two_women_holding_hands'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':two_women_holding_hands:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f46d-1f3fb', '1f46d-1f3fc', '1f46d-1f3fd', '1f46d-1f3fe', '1f46d-1f3ff', '1f469-1f3fc-1f91d-1f469-1f3fb', '1f469-1f3fd-1f91d-1f469-1f3fb', '1f469-1f3fd-1f91d-1f469-1f3fc', '1f469-1f3fe-1f91d-1f469-1f3fb', '1f469-1f3fe-1f91d-1f469-1f3fd', '1f469-1f3ff-1f91d-1f469-1f3fb', '1f469-1f3ff-1f91d-1f469-1f3fc', '1f469-1f3ff-1f91d-1f469-1f3fd', '1f469-1f3ff-1f91d-1f469-1f3fe', '1f469-1f3fe-1f91d-1f469-1f3fc', '1f469-1f3fb-1f91d-1f469-1f3fc', '1f469-1f3fb-1f91d-1f469-1f3fd', '1f469-1f3fb-1f91d-1f469-1f3fe', '1f469-1f3fb-1f91d-1f469-1f3ff', '1f469-1f3fc-1f91d-1f469-1f3fd', '1f469-1f3fc-1f91d-1f469-1f3fe', '1f469-1f3fc-1f91d-1f469-1f3ff', '1f469-1f3fd-1f91d-1f469-1f3fe', '1f469-1f3fd-1f91d-1f469-1f3ff', '1f469-1f3fe-1f91d-1f469-1f3ff'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👭',
				'keywords' => ['couple', 'hand', 'hold', 'woman', 'uc6'],
			],
			'1f46d-1f3fb' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone1:',
				'shortname_alternates' => [':women_holding_hands_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👭🏻',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fb-1f91d-1f469-1f3fc' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone1_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone1_tone2:',
				'shortname_alternates' => [':women_holding_hands_light_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻‍🤝‍👩🏼',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fb-1f91d-1f469-1f3fd' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone1_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone1_tone3:',
				'shortname_alternates' => [':women_holding_hands_light_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻‍🤝‍👩🏽',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fb-1f91d-1f469-1f3fe' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone1_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone1_tone4:',
				'shortname_alternates' => [':women_holding_hands_light_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻‍🤝‍👩🏾',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fb-1f91d-1f469-1f3ff' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone1_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone1_tone5:',
				'shortname_alternates' => [':women_holding_hands_light_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻‍🤝‍👩🏿',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fc-1f91d-1f469-1f3fb' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone2_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone2_tone1:',
				'shortname_alternates' => [':women_holding_hands_medium_light_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼‍🤝‍👩🏻',
				'keywords' => ['uc12'],
			],
			'1f46d-1f3fc' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone2:',
				'shortname_alternates' => [':women_holding_hands_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👭🏼',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fc-1f91d-1f469-1f3fd' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone2_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone2_tone3:',
				'shortname_alternates' => [':women_holding_hands_medium_light_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼‍🤝‍👩🏽',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fc-1f91d-1f469-1f3fe' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone2_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone2_tone4:',
				'shortname_alternates' => [':women_holding_hands_medium_light_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼‍🤝‍👩🏾',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fc-1f91d-1f469-1f3ff' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone2_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone2_tone5:',
				'shortname_alternates' => [':women_holding_hands_medium_light_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼‍🤝‍👩🏿',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fd-1f91d-1f469-1f3fb' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone3_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone3_tone1:',
				'shortname_alternates' => [':women_holding_hands_medium_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏽‍🤝‍👩🏻',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fd-1f91d-1f469-1f3fc' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone3_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone3_tone2:',
				'shortname_alternates' => [':women_holding_hands_medium_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏽‍🤝‍👩🏼',
				'keywords' => ['uc12'],
			],
			'1f46d-1f3fd' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone3:',
				'shortname_alternates' => [':women_holding_hands_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👭🏽',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fd-1f91d-1f469-1f3fe' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone3_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone3_tone4:',
				'shortname_alternates' => [':women_holding_hands_medium_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏽‍🤝‍👩🏾',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fd-1f91d-1f469-1f3ff' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone3_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone3_tone5:',
				'shortname_alternates' => [':women_holding_hands_medium_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏽‍🤝‍👩🏿',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fe-1f91d-1f469-1f3fb' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone4_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone4_tone1:',
				'shortname_alternates' => [':women_holding_hands_medium_dark_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏾‍🤝‍👩🏻',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fe-1f91d-1f469-1f3fc' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone4_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone4_tone2:',
				'shortname_alternates' => [':women_holding_hands_medium_dark_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏾‍🤝‍👩🏼',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fe-1f91d-1f469-1f3fd' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone4_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone4_tone3:',
				'shortname_alternates' => [':women_holding_hands_medium_dark_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏾‍🤝‍👩🏽',
				'keywords' => ['uc12'],
			],
			'1f46d-1f3fe' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone4:',
				'shortname_alternates' => [':women_holding_hands_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👭🏾',
				'keywords' => ['uc12'],
			],
			'1f469-1f3fe-1f91d-1f469-1f3ff' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone4_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone4_tone5:',
				'shortname_alternates' => [':women_holding_hands_medium_dark_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏾‍🤝‍👩🏿',
				'keywords' => ['uc12'],
			],
			'1f469-1f3ff-1f91d-1f469-1f3fb' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone5_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone5_tone1:',
				'shortname_alternates' => [':women_holding_hands_dark_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏿‍🤝‍👩🏻',
				'keywords' => ['uc12'],
			],
			'1f469-1f3ff-1f91d-1f469-1f3fc' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone5_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone5_tone2:',
				'shortname_alternates' => [':women_holding_hands_dark_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏿‍🤝‍👩🏼',
				'keywords' => ['uc12'],
			],
			'1f469-1f3ff-1f91d-1f469-1f3fd' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone5_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone5_tone3:',
				'shortname_alternates' => [':women_holding_hands_dark_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏿‍🤝‍👩🏽',
				'keywords' => ['uc12'],
			],
			'1f469-1f3ff-1f91d-1f469-1f3fe' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone5_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone5_tone4:',
				'shortname_alternates' => [':women_holding_hands_dark_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏿‍🤝‍👩🏾',
				'keywords' => ['uc12'],
			],
			'1f46d-1f3ff' => [
				'name' => \XF::phrase('emoji.women_holding_hands_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':women_holding_hands_tone5:',
				'shortname_alternates' => [':women_holding_hands_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👭🏿',
				'keywords' => ['uc12'],
			],
			'1f46c' => [
				'name' => \XF::phrase('emoji.two_men_holding_hands'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':two_men_holding_hands:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f46c-1f3fb', '1f46c-1f3fc', '1f46c-1f3fd', '1f46c-1f3fe', '1f46c-1f3ff', '1f468-1f3fc-1f91d-1f468-1f3fb', '1f468-1f3fd-1f91d-1f468-1f3fb', '1f468-1f3fd-1f91d-1f468-1f3fc', '1f468-1f3fe-1f91d-1f468-1f3fb', '1f468-1f3fe-1f91d-1f468-1f3fd', '1f468-1f3ff-1f91d-1f468-1f3fb', '1f468-1f3ff-1f91d-1f468-1f3fc', '1f468-1f3ff-1f91d-1f468-1f3fd', '1f468-1f3ff-1f91d-1f468-1f3fe', '1f468-1f3fe-1f91d-1f468-1f3fc', '1f468-1f3fb-1f91d-1f468-1f3fc', '1f468-1f3fb-1f91d-1f468-1f3fd', '1f468-1f3fb-1f91d-1f468-1f3fe', '1f468-1f3fb-1f91d-1f468-1f3ff', '1f468-1f3fc-1f91d-1f468-1f3fd', '1f468-1f3fc-1f91d-1f468-1f3fe', '1f468-1f3fc-1f91d-1f468-1f3ff', '1f468-1f3fd-1f91d-1f468-1f3fe', '1f468-1f3fd-1f91d-1f468-1f3ff', '1f468-1f3fe-1f91d-1f468-1f3ff'],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👬',
				'keywords' => ['Gemini', 'couple', 'hand', 'hold', 'man', 'twins', 'zodiac', 'uc6'],
			],
			'1f46c-1f3fb' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone1:',
				'shortname_alternates' => [':men_holding_hands_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👬🏻',
				'keywords' => ['uc12'],
			],
			'1f468-1f3fb-1f91d-1f468-1f3fc' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone1_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone1_tone2:',
				'shortname_alternates' => [':men_holding_hands_light_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏻‍🤝‍👨🏼',
				'keywords' => ['uc12'],
			],
			'1f468-1f3fb-1f91d-1f468-1f3fd' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone1_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone1_tone3:',
				'shortname_alternates' => [':men_holding_hands_light_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏻‍🤝‍👨🏽',
				'keywords' => ['uc12'],
			],
			'1f468-1f3fb-1f91d-1f468-1f3fe' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone1_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone1_tone4:',
				'shortname_alternates' => [':men_holding_hands_light_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏻‍🤝‍👨🏾',
				'keywords' => ['uc12'],
			],
			'1f468-1f3fb-1f91d-1f468-1f3ff' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone1_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone1_tone5:',
				'shortname_alternates' => [':men_holding_hands_light_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏻‍🤝‍👨🏿',
				'keywords' => ['uc12'],
			],
			'1f468-1f3fc-1f91d-1f468-1f3fb' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone2_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone2_tone1:',
				'shortname_alternates' => [':men_holding_hands_medium_light_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏼‍🤝‍👨🏻',
				'keywords' => ['uc12'],
			],
			'1f46c-1f3fc' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone2:',
				'shortname_alternates' => [':men_holding_hands_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👬🏼',
				'keywords' => ['uc12'],
			],
			'1f468-1f3fc-1f91d-1f468-1f3fd' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone2_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone2_tone3:',
				'shortname_alternates' => [':men_holding_hands_medium_light_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏼‍🤝‍👨🏽',
				'keywords' => ['uc12'],
			],
			'1f468-1f3fc-1f91d-1f468-1f3fe' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone2_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone2_tone4:',
				'shortname_alternates' => [':men_holding_hands_medium_light_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏼‍🤝‍👨🏾',
				'keywords' => ['uc12'],
			],
			'1f468-1f3fc-1f91d-1f468-1f3ff' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone2_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone2_tone5:',
				'shortname_alternates' => [':men_holding_hands_medium_light_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏼‍🤝‍👨🏿',
				'keywords' => ['uc12'],
			],
			'1f468-1f3fd-1f91d-1f468-1f3fb' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone3_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone3_tone1:',
				'shortname_alternates' => [':men_holding_hands_medium_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏽‍🤝‍👨🏻',
				'keywords' => ['uc12'],
			],
			'1f468-1f3fd-1f91d-1f468-1f3fc' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone3_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone3_tone2:',
				'shortname_alternates' => [':men_holding_hands_medium_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏽‍🤝‍👨🏼',
				'keywords' => ['uc12'],
			],
			'1f46c-1f3fd' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone3:',
				'shortname_alternates' => [':men_holding_hands_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👬🏽',
				'keywords' => ['uc12'],
			],
			'1f468-1f3fd-1f91d-1f468-1f3fe' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone3_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone3_tone4:',
				'shortname_alternates' => [':men_holding_hands_medium_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏽‍🤝‍👨🏾',
				'keywords' => ['uc12'],
			],
			'1f468-1f3fd-1f91d-1f468-1f3ff' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone3_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone3_tone5:',
				'shortname_alternates' => [':men_holding_hands_medium_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏽‍🤝‍👨🏿',
				'keywords' => ['uc12'],
			],
			'1f468-1f3fe-1f91d-1f468-1f3fb' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone4_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone4_tone1:',
				'shortname_alternates' => [':men_holding_hands_medium_dark_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏾‍🤝‍👨🏻',
				'keywords' => ['uc12'],
			],
			'1f468-1f3fe-1f91d-1f468-1f3fc' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone4_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone4_tone2:',
				'shortname_alternates' => [':men_holding_hands_medium_dark_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏾‍🤝‍👨🏼',
				'keywords' => ['uc12'],
			],
			'1f468-1f3fe-1f91d-1f468-1f3fd' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone4_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone4_tone3:',
				'shortname_alternates' => [':men_holding_hands_medium_dark_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏾‍🤝‍👨🏽',
				'keywords' => ['uc12'],
			],
			'1f46c-1f3fe' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone4:',
				'shortname_alternates' => [':men_holding_hands_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👬🏾',
				'keywords' => ['uc12'],
			],
			'1f468-1f3fe-1f91d-1f468-1f3ff' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone4_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone4_tone5:',
				'shortname_alternates' => [':men_holding_hands_medium_dark_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏾‍🤝‍👨🏿',
				'keywords' => ['uc12'],
			],
			'1f468-1f3ff-1f91d-1f468-1f3fb' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone5_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone5_tone1:',
				'shortname_alternates' => [':men_holding_hands_dark_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏿‍🤝‍👨🏻',
				'keywords' => ['uc12'],
			],
			'1f468-1f3ff-1f91d-1f468-1f3fc' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone5_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone5_tone2:',
				'shortname_alternates' => [':men_holding_hands_dark_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏿‍🤝‍👨🏼',
				'keywords' => ['uc12'],
			],
			'1f468-1f3ff-1f91d-1f468-1f3fd' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone5_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone5_tone3:',
				'shortname_alternates' => [':men_holding_hands_dark_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏿‍🤝‍👨🏽',
				'keywords' => ['uc12'],
			],
			'1f468-1f3ff-1f91d-1f468-1f3fe' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone5_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone5_tone4:',
				'shortname_alternates' => [':men_holding_hands_dark_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👨🏿‍🤝‍👨🏾',
				'keywords' => ['uc12'],
			],
			'1f46c-1f3ff' => [
				'name' => \XF::phrase('emoji.men_holding_hands_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':men_holding_hands_tone5:',
				'shortname_alternates' => [':men_holding_hands_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2642'],
				'gender_children' => [],
				'unicode' => '👬🏿',
				'keywords' => ['uc12'],
			],
			'1f491' => [
				'name' => \XF::phrase('emoji.couple_with_heart'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f491-1f3fb', '1f491-1f3fc', '1f491-1f3fd', '1f491-1f3fe', '1f491-1f3ff'],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '💑',
				'keywords' => ['couple', 'love', 'uc6'],
			],
			'1f491-1f3fb' => [
				'name' => \XF::phrase('emoji.couple_with_heart_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_tone1:',
				'shortname_alternates' => [':couple_with_heart_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '💑🏻',
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3fb-2764-1f9d1-1f3fc' => [
				'name' => \XF::phrase('emoji.couple_with_heart_person_person_tone1_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_person_person_tone1_tone2:',
				'shortname_alternates' => [':couple_with_heart_person_person_light_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍❤️‍🧑🏼',
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3fb-2764-1f9d1-1f3fd' => [
				'name' => \XF::phrase('emoji.couple_with_heart_person_person_tone1_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_person_person_tone1_tone3:',
				'shortname_alternates' => [':couple_with_heart_person_person_light_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍❤️‍🧑🏽',
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3fb-2764-1f9d1-1f3fe' => [
				'name' => \XF::phrase('emoji.couple_with_heart_person_person_tone1_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_person_person_tone1_tone4:',
				'shortname_alternates' => [':couple_with_heart_person_person_light_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍❤️‍🧑🏾',
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3fb-2764-1f9d1-1f3ff' => [
				'name' => \XF::phrase('emoji.couple_with_heart_person_person_tone1_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_person_person_tone1_tone5:',
				'shortname_alternates' => [':couple_with_heart_person_person_light_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏻‍❤️‍🧑🏿',
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3fc-2764-1f9d1-1f3fb' => [
				'name' => \XF::phrase('emoji.couple_with_heart_person_person_tone2_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_person_person_tone2_tone1:',
				'shortname_alternates' => [':couple_with_heart_person_person_medium_light_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍❤️‍🧑🏻',
				'keywords' => ['uc13'],
			],
			'1f491-1f3fc' => [
				'name' => \XF::phrase('emoji.couple_with_heart_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_tone2:',
				'shortname_alternates' => [':couple_with_heart_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '💑🏼',
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3fc-2764-1f9d1-1f3fd' => [
				'name' => \XF::phrase('emoji.couple_with_heart_person_person_tone2_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_person_person_tone2_tone3:',
				'shortname_alternates' => [':couple_with_heart_person_person_medium_light_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍❤️‍🧑🏽',
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3fc-2764-1f9d1-1f3fe' => [
				'name' => \XF::phrase('emoji.couple_with_heart_person_person_tone2_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_person_person_tone2_tone4:',
				'shortname_alternates' => [':couple_with_heart_person_person_medium_light_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍❤️‍🧑🏾',
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3fc-2764-1f9d1-1f3ff' => [
				'name' => \XF::phrase('emoji.couple_with_heart_person_person_tone2_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_person_person_tone2_tone5:',
				'shortname_alternates' => [':couple_with_heart_person_person_medium_light_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏼‍❤️‍🧑🏿',
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3fd-2764-1f9d1-1f3fb' => [
				'name' => \XF::phrase('emoji.couple_with_heart_person_person_tone3_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_person_person_tone3_tone1:',
				'shortname_alternates' => [':couple_with_heart_person_person_medium_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍❤️‍🧑🏻',
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3fd-2764-1f9d1-1f3fc' => [
				'name' => \XF::phrase('emoji.couple_with_heart_person_person_tone3_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_person_person_tone3_tone2:',
				'shortname_alternates' => [':couple_with_heart_person_person_medium_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍❤️‍🧑🏼',
				'keywords' => ['uc13'],
			],
			'1f491-1f3fd' => [
				'name' => \XF::phrase('emoji.couple_with_heart_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_tone3:',
				'shortname_alternates' => [':couple_with_heart_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '💑🏽',
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3fd-2764-1f9d1-1f3fe' => [
				'name' => \XF::phrase('emoji.couple_with_heart_person_person_tone3_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_person_person_tone3_tone4:',
				'shortname_alternates' => [':couple_with_heart_person_person_medium_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍❤️‍🧑🏾',
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3fd-2764-1f9d1-1f3ff' => [
				'name' => \XF::phrase('emoji.couple_with_heart_person_person_tone3_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_person_person_tone3_tone5:',
				'shortname_alternates' => [':couple_with_heart_person_person_medium_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏽‍❤️‍🧑🏿',
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3fe-2764-1f9d1-1f3fb' => [
				'name' => \XF::phrase('emoji.couple_with_heart_person_person_tone4_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_person_person_tone4_tone1:',
				'shortname_alternates' => [':couple_with_heart_person_person_medium_dark_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍❤️‍🧑🏻',
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3fe-2764-1f9d1-1f3fc' => [
				'name' => \XF::phrase('emoji.couple_with_heart_person_person_tone4_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_person_person_tone4_tone2:',
				'shortname_alternates' => [':couple_with_heart_person_person_medium_dark_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍❤️‍🧑🏼',
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3fe-2764-1f9d1-1f3fd' => [
				'name' => \XF::phrase('emoji.couple_with_heart_person_person_tone4_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_person_person_tone4_tone3:',
				'shortname_alternates' => [':couple_with_heart_person_person_medium_dark_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍❤️‍🧑🏽',
				'keywords' => ['uc13'],
			],
			'1f491-1f3fe' => [
				'name' => \XF::phrase('emoji.couple_with_heart_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_tone4:',
				'shortname_alternates' => [':couple_with_heart_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '💑🏾',
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3fe-2764-1f9d1-1f3ff' => [
				'name' => \XF::phrase('emoji.couple_with_heart_person_person_tone4_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_person_person_tone4_tone5:',
				'shortname_alternates' => [':couple_with_heart_person_person_medium_dark_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe', '1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏾‍❤️‍🧑🏿',
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3ff-2764-1f9d1-1f3fb' => [
				'name' => \XF::phrase('emoji.couple_with_heart_person_person_tone5_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_person_person_tone5_tone1:',
				'shortname_alternates' => [':couple_with_heart_person_person_dark_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍❤️‍🧑🏻',
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3ff-2764-1f9d1-1f3fc' => [
				'name' => \XF::phrase('emoji.couple_with_heart_person_person_tone5_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_person_person_tone5_tone2:',
				'shortname_alternates' => [':couple_with_heart_person_person_dark_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍❤️‍🧑🏼',
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3ff-2764-1f9d1-1f3fd' => [
				'name' => \XF::phrase('emoji.couple_with_heart_person_person_tone5_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_person_person_tone5_tone3:',
				'shortname_alternates' => [':couple_with_heart_person_person_dark_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍❤️‍🧑🏽',
				'keywords' => ['uc13'],
			],
			'1f9d1-1f3ff-2764-1f9d1-1f3fe' => [
				'name' => \XF::phrase('emoji.couple_with_heart_person_person_tone5_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_person_person_tone5_tone4:',
				'shortname_alternates' => [':couple_with_heart_person_person_dark_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe', '1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '🧑🏿‍❤️‍🧑🏾',
				'keywords' => ['uc13'],
			],
			'1f491-1f3ff' => [
				'name' => \XF::phrase('emoji.couple_with_heart_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_tone5:',
				'shortname_alternates' => [':couple_with_heart_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => [],
				'gender_children' => [],
				'unicode' => '💑🏿',
				'keywords' => ['uc13'],
			],
			'1f469-2764-1f468' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_man'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_man:',
				'shortname_alternates' => [],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3fb-2764-1f468-1f3fb', '1f469-1f3fb-2764-1f468-1f3fc', '1f469-1f3fb-2764-1f468-1f3fd', '1f469-1f3fb-2764-1f468-1f3fe', '1f469-1f3fb-2764-1f468-1f3ff', '1f469-1f3fc-2764-1f468-1f3fb', '1f469-1f3fc-2764-1f468-1f3fc', '1f469-1f3fc-2764-1f468-1f3fd', '1f469-1f3fc-2764-1f468-1f3fe', '1f469-1f3fc-2764-1f468-1f3ff', '1f469-1f3fd-2764-1f468-1f3fb', '1f469-1f3fd-2764-1f468-1f3fc', '1f469-1f3fd-2764-1f468-1f3fd', '1f469-1f3fd-2764-1f468-1f3fe', '1f469-1f3fd-2764-1f468-1f3ff', '1f469-1f3fe-2764-1f468-1f3fb', '1f469-1f3fe-2764-1f468-1f3fc', '1f469-1f3fe-2764-1f468-1f3fd', '1f469-1f3fe-2764-1f468-1f3fe', '1f469-1f3fe-2764-1f468-1f3ff', '1f469-1f3ff-2764-1f468-1f3fb', '1f469-1f3ff-2764-1f468-1f3fc', '1f469-1f3ff-2764-1f468-1f3fd', '1f469-1f3ff-2764-1f468-1f3fe', '1f469-1f3ff-2764-1f468-1f3ff'],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩‍❤️‍👨',
				'keywords' => ['couple', 'love', 'man', 'woman', 'uc6'],
			],
			'1f469-1f3fb-2764-1f468-1f3fb' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_man_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_man_tone1:',
				'shortname_alternates' => [':couple_with_heart_woman_man_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏻‍❤️‍👨🏻',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fb-2764-1f468-1f3fc' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_man_tone1_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_man_tone1_tone2:',
				'shortname_alternates' => [':couple_with_heart_woman_man_light_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏻‍❤️‍👨🏼',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fb-2764-1f468-1f3fd' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_man_tone1_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_man_tone1_tone3:',
				'shortname_alternates' => [':couple_with_heart_woman_man_light_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏻‍❤️‍👨🏽',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fb-2764-1f468-1f3fe' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_man_tone1_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_man_tone1_tone4:',
				'shortname_alternates' => [':couple_with_heart_woman_man_light_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏻‍❤️‍👨🏾',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fb-2764-1f468-1f3ff' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_man_tone1_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_man_tone1_tone5:',
				'shortname_alternates' => [':couple_with_heart_woman_man_light_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏻‍❤️‍👨🏿',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fc-2764-1f468-1f3fb' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_man_tone2_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_man_tone2_tone1:',
				'shortname_alternates' => [':couple_with_heart_woman_man_medium_light_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏼‍❤️‍👨🏻',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fc-2764-1f468-1f3fc' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_man_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_man_tone2:',
				'shortname_alternates' => [':couple_with_heart_woman_man_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏼‍❤️‍👨🏼',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fc-2764-1f468-1f3fd' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_man_tone2_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_man_tone2_tone3:',
				'shortname_alternates' => [':couple_with_heart_woman_man_medium_light_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏼‍❤️‍👨🏽',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fc-2764-1f468-1f3fe' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_man_tone2_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_man_tone2_tone4:',
				'shortname_alternates' => [':couple_with_heart_woman_man_medium_light_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏼‍❤️‍👨🏾',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fc-2764-1f468-1f3ff' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_man_tone2_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_man_tone2_tone5:',
				'shortname_alternates' => [':couple_with_heart_woman_man_medium_light_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏼‍❤️‍👨🏿',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fd-2764-1f468-1f3fb' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_man_tone3_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_man_tone3_tone1:',
				'shortname_alternates' => [':couple_with_heart_woman_man_medium_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏽‍❤️‍👨🏻',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fd-2764-1f468-1f3fc' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_man_tone3_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_man_tone3_tone2:',
				'shortname_alternates' => [':couple_with_heart_woman_man_medium_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏽‍❤️‍👨🏼',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fd-2764-1f468-1f3fd' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_man_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_man_tone3:',
				'shortname_alternates' => [':couple_with_heart_woman_man_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏽‍❤️‍👨🏽',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fd-2764-1f468-1f3fe' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_man_tone3_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_man_tone3_tone4:',
				'shortname_alternates' => [':couple_with_heart_woman_man_medium_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏽‍❤️‍👨🏾',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fd-2764-1f468-1f3ff' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_man_tone3_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_man_tone3_tone5:',
				'shortname_alternates' => [':couple_with_heart_woman_man_medium_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏽‍❤️‍👨🏿',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fe-2764-1f468-1f3fb' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_man_tone4_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_man_tone4_tone1:',
				'shortname_alternates' => [':couple_with_heart_woman_man_medium_dark_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏾‍❤️‍👨🏻',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fe-2764-1f468-1f3fc' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_man_tone4_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_man_tone4_tone2:',
				'shortname_alternates' => [':couple_with_heart_woman_man_medium_dark_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏾‍❤️‍👨🏼',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fe-2764-1f468-1f3fd' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_man_tone4_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_man_tone4_tone3:',
				'shortname_alternates' => [':couple_with_heart_woman_man_medium_dark_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏾‍❤️‍👨🏽',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fe-2764-1f468-1f3fe' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_man_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_man_tone4:',
				'shortname_alternates' => [':couple_with_heart_woman_man_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏾‍❤️‍👨🏾',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fe-2764-1f468-1f3ff' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_man_tone4_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_man_tone4_tone5:',
				'shortname_alternates' => [':couple_with_heart_woman_man_medium_dark_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏾‍❤️‍👨🏿',
				'keywords' => ['uc13'],
			],
			'1f469-1f3ff-2764-1f468-1f3fb' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_man_tone5_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_man_tone5_tone1:',
				'shortname_alternates' => [':couple_with_heart_woman_man_dark_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏿‍❤️‍👨🏻',
				'keywords' => ['uc13'],
			],
			'1f469-1f3ff-2764-1f468-1f3fc' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_man_tone5_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_man_tone5_tone2:',
				'shortname_alternates' => [':couple_with_heart_woman_man_dark_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏿‍❤️‍👨🏼',
				'keywords' => ['uc13'],
			],
			'1f469-1f3ff-2764-1f468-1f3fd' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_man_tone5_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_man_tone5_tone3:',
				'shortname_alternates' => [':couple_with_heart_woman_man_dark_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏿‍❤️‍👨🏽',
				'keywords' => ['uc13'],
			],
			'1f469-1f3ff-2764-1f468-1f3fe' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_man_tone5_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_man_tone5_tone4:',
				'shortname_alternates' => [':couple_with_heart_woman_man_dark_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fe', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏿‍❤️‍👨🏾',
				'keywords' => ['uc13'],
			],
			'1f469-1f3ff-2764-1f468-1f3ff' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_man_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_man_tone5:',
				'shortname_alternates' => [':couple_with_heart_woman_man_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640', '2642'],
				'gender_children' => [],
				'unicode' => '👩🏿‍❤️‍👨🏿',
				'keywords' => ['uc13'],
			],
			'1f469-2764-1f469' => [
				'name' => \XF::phrase('emoji.couple_ww'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_ww:',
				'shortname_alternates' => [':couple_with_heart_ww:'],
				'humanform' => '1',
				'diversity_base' => '1',
				'diversity' => '',
				'diversity_children' => ['1f469-1f3fb-2764-1f469-1f3fb', '1f469-1f3fb-2764-1f469-1f3fc', '1f469-1f3fb-2764-1f469-1f3fd', '1f469-1f3fb-2764-1f469-1f3fe', '1f469-1f3fb-2764-1f469-1f3ff', '1f469-1f3fc-2764-1f469-1f3fb', '1f469-1f3fc-2764-1f469-1f3fc', '1f469-1f3fc-2764-1f469-1f3fd', '1f469-1f3fc-2764-1f469-1f3fe', '1f469-1f3fc-2764-1f469-1f3ff', '1f469-1f3fd-2764-1f469-1f3fb', '1f469-1f3fd-2764-1f469-1f3fc', '1f469-1f3fd-2764-1f469-1f3fd', '1f469-1f3fd-2764-1f469-1f3fe', '1f469-1f3fd-2764-1f469-1f3ff', '1f469-1f3fe-2764-1f469-1f3fb', '1f469-1f3fe-2764-1f469-1f3fc', '1f469-1f3fe-2764-1f469-1f3fd', '1f469-1f3fe-2764-1f469-1f3fe', '1f469-1f3fe-2764-1f469-1f3ff', '1f469-1f3ff-2764-1f469-1f3fb', '1f469-1f3ff-2764-1f469-1f3fc', '1f469-1f3ff-2764-1f469-1f3fd', '1f469-1f3ff-2764-1f469-1f3fe', '1f469-1f3ff-2764-1f469-1f3ff'],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩‍❤️‍👩',
				'keywords' => ['couple', 'love', 'woman', 'uc6'],
			],
			'1f469-1f3fb-2764-1f469-1f3fb' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_woman_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_woman_tone1:',
				'shortname_alternates' => [':couple_with_heart_woman_woman_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻‍❤️‍👩🏻',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fb-2764-1f469-1f3fc' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_woman_tone1_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_woman_tone1_tone2:',
				'shortname_alternates' => [':couple_with_heart_woman_woman_light_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻‍❤️‍👩🏼',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fb-2764-1f469-1f3fd' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_woman_tone1_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_woman_tone1_tone3:',
				'shortname_alternates' => [':couple_with_heart_woman_woman_light_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻‍❤️‍👩🏽',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fb-2764-1f469-1f3fe' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_woman_tone1_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_woman_tone1_tone4:',
				'shortname_alternates' => [':couple_with_heart_woman_woman_light_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻‍❤️‍👩🏾',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fb-2764-1f469-1f3ff' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_woman_tone1_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_woman_tone1_tone5:',
				'shortname_alternates' => [':couple_with_heart_woman_woman_light_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏻‍❤️‍👩🏿',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fc-2764-1f469-1f3fb' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_woman_tone2_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_woman_tone2_tone1:',
				'shortname_alternates' => [':couple_with_heart_woman_woman_medium_light_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼‍❤️‍👩🏻',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fc-2764-1f469-1f3fc' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_woman_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_woman_tone2:',
				'shortname_alternates' => [':couple_with_heart_woman_woman_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼‍❤️‍👩🏼',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fc-2764-1f469-1f3fd' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_woman_tone2_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_woman_tone2_tone3:',
				'shortname_alternates' => [':couple_with_heart_woman_woman_medium_light_skin_tone_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼‍❤️‍👩🏽',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fc-2764-1f469-1f3fe' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_woman_tone2_tone4'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_woman_tone2_tone4:',
				'shortname_alternates' => [':couple_with_heart_woman_woman_medium_light_skin_tone_medium_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fe'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼‍❤️‍👩🏾',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fc-2764-1f469-1f3ff' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_woman_tone2_tone5'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_woman_tone2_tone5:',
				'shortname_alternates' => [':couple_with_heart_woman_woman_medium_light_skin_tone_dark_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3ff'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏼‍❤️‍👩🏿',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fd-2764-1f469-1f3fb' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_woman_tone3_tone1'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_woman_tone3_tone1:',
				'shortname_alternates' => [':couple_with_heart_woman_woman_medium_skin_tone_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fb', '1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏽‍❤️‍👩🏻',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fd-2764-1f469-1f3fc' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_woman_tone3_tone2'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_woman_tone3_tone2:',
				'shortname_alternates' => [':couple_with_heart_woman_woman_medium_skin_tone_medium_light_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fc', '1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏽‍❤️‍👩🏼',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fd-2764-1f469-1f3fd' => [
				'name' => \XF::phrase('emoji.couple_with_heart_woman_woman_tone3'),
				'category_name' => \XF::phrase('emoji_category.people'),
				'category' => 'people',
				'shortname' => ':couple_with_heart_woman_woman_tone3:',
				'shortname_alternates' => [':couple_with_heart_woman_woman_medium_skin_tone:'],
				'humanform' => '1',
				'diversity_base' => '0',
				'diversity' => ['1f3fd'],
				'diversity_children' => [],
				'gender' => ['2640'],
				'gender_children' => [],
				'unicode' => '👩🏽‍❤️‍👩🏽',
				'keywords' => ['uc13'],
			],
			'1f469-1f3fd-2764-1f469-1f3fe' => [
				'name' => \XF::phrase('emoj